/*-----------------------------------------------------------------------------*
 * IPrmManagerCard.h                                                                *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2015 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IPrmManagerCard.h
 *
 * \brief Interface to use SDCard specific function of PrmManager
 *
 * PrmManager receives over current signals from USB HW. The prm signals are
 * used to trigger the mechanism to react on male function of a connector. E.g.
 * the VD_DeviceManager has to notify the clients about the MALFUNCTION and
 * OVER-CURRENT
 *
 * \version Initial Version
 * \version 10.10.2011, Koechling, Christian (Bosch), added to serve unit test

 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2020
 */

#ifndef __INTERFACE_PRM_MANAGER_SDCARD_H__
#define __INTERFACE_PRM_MANAGER_SDCARD_H__



/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/



/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class PrmManager
 */
class IPrmManagerCard
{
    public:

    
        /*!
         * \brief private destructor for singleton
         */
       virtual  ~IPrmManagerCard(){};

               /*!
         * \brief function triggered by diagnosis to get information about an inserted card - used for production tests - see
         *
         *
         * \param[IN] UUIDDeviceName e.g. AAM_dev_sda1
         *\param[OUT] CDeviceCard oCard
         *
         ** \return [int] TRUE ok, FALSE: interface not yet initialized
         */
       virtual  tBool bGetSDCardState(OUT CDeviceCard &oCard , IN tChar (&cUUIDDeviceName)[STRING_LENGTH]) const = 0;

   
};

#endif //__INTERFACE_PRM_MANAGER_SDCARD_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>
