/*-----------------------------------------------------------------------------*
 * IPrmManager.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IPrmManager.h
 *
 * \brief Implementation to open, read and close persistent configuration
 *
 * \version 05.03.2014, Koechling Christian (CM-AI/ECD1), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef INTERFACE_PRM_MANAGER_H
#define INTERFACE_PRM_MANAGER_H  
#include "Enums.h"

/*-----------------------------------------------------------------------------*
 * Class forward declaration                                                           *
 *-----------------------------------------------------------------------------*/
class IHUBHardwareSignalReader;


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class IPrmManager
 */

class IPrmManager
{
    public:

        /*!
         * \brief Default destructor
         */
        virtual ~IPrmManager(){};

        virtual tVoid SetInterface(IHUBHardwareSignalReader *pIHubHwSignalReader) = 0;
        virtual tVoid vFillDeviceSpeedinfo(TelematicsBoxSpeedAndPortInfo f_TelematicsBoxSpeedAndPortInfo[ARRAYSIZEFORUSB]) = 0;
        virtual  tVoid vsetDeviceSpeed(statetbl::tenDevManagerUSBHost eUsb,tBool bIsDevicePresent,tBool b_DeviceSpeed) = 0;
        virtual tVoid connectPRM(tBool bConnect) = 0;
        virtual tBool bInitUSBHardwareConnectors() const =0;
        virtual tBool bGetUSBHardwareConnector(IN tenDevManagerUSBHost eUSBConnectorNum,OUT tenSignalValue &eAvtivated) const = 0;
        virtual tBool bSetUSBHardwareConnector(IN tenDevManagerUSBHost eUSBConnectorNum,IN tBool bOn) const = 0;
#ifdef USE_FOURTH_USB_CONNECTOR
        virtual tVoid GetDiagnosisValues(CUSBDiagnosis &f_objUSBDiagnosisHUB1, CUSBDiagnosis &f_objUSBDiagnosisHUB2, CUSBDiagnosis &f_objUSBDiagnosisHUB3, CUSBDiagnosis &f_objUSBDiagnosisHUB4) const = 0;
#else
        virtual tVoid GetDiagnosisValues(CUSBDiagnosis &f_objUSBDiagnosisHUB1, CUSBDiagnosis &f_objUSBDiagnosisHUB2, CUSBDiagnosis &f_objUSBDiagnosisHUB3) const = 0;
#endif

};
// class IPrmManager

#endif // IPRM_MANAGER_H





////////////////////////////////////////////////////////////////////////////////
// <EOF>

