/*!!!!!!!!!!!!!!!!!!!!!!!!!!Code not used yet!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*Refactoring of UDEVManager is planned*/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!Code not used yet!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

/*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2016 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \fileIDeviceRecognized.h
 *
 * \brief Interface
 *
 * e.g. VD_DVM receives a CDROM mount via CCA-Interface from FC_DIAG. Mounts the CDROM (Mix mode) and triggers VD_DVM as ifplatform would have notified it
 *
 * \version Initial Version
 * \version 10.10.2011, Koechling, Christian (Bosch), added to serve unit test

 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2020
 */

#ifndef __DEVICERECOGNIZER_H__
#define __DEVICERECOGNIZER_H__

#include "Config.h"


extern "C"
{
#include <libudev.h>

#include <errno.h>
#include <libusb-1.0/libusb.h>
#include <libmtp.h>

}




/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * #defines                                                                  *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/



/*!
 * \class PrmManager
 */
class DeviceRecognizer: public IDeviceRecognizer
{
    public:

        DeviceRecognizer();

        /*!
         * \brief private destructor for singleton
         */
       virtual  ~DeviceRecognizer();

       virtual int FillCurrDevice(INOUT CDevice& f_oCurDevice, IN GENSTRING f_cDevNode,IN struct udev_device *f_pBaseUSBDev,IN struct udev *f_pUdev);

       virtual int DetectDevice(IN CGlobalEnumerations::DETECTION_Type enDetectionType, INOUT CDevice* f_pCurDevice);

    protected:

/*
        int FillCurrDeviceCDROMInternal(INOUT CDevice& f_oCurDevice, IN GENSTRING f_cDevNode,IN struct udev_device *f_pBaseUSBDev, IN struct udev *f_pUdev);
        int FillCurrDeviceSDCardInternal(INOUT CDevice& f_oCurDevice, IN GENSTRING f_cDevNode,IN struct udev_device *f_pBaseUSBDev, IN struct udev *f_pUdev);
        int FillCurrDeviceGeneral(         INOUT CDevice& f_oCurDevice, IN GENSTRING f_cDevNode,IN struct udev_device *f_pBaseUSBDev, struct udev_device *f_pParentHUBDev, IN GENSTRING f_cAction,GENSTRING &f_cParentHubSerial);
*/

        int DetectMTPDevice(INOUT CDevice* f_pCurDevice); //function used now in UDEV

        /*!
         * \brief Detect that connected device is IPOD/IPHONE devices.
         *
         * \param [in,out] f_pCurDevice pointer to current device
         *
         * \return DEVICEMANAGER_ERROR_NODEVICE in case of no device detetcted
         *         DEVICEMANAGER_DEVICE_DETECTED in case of device detected
         *         DEVICEMANAGER_ERROR_INVALID_PARAM in case f_pCurDevice is NULL
         */

        int DetectMACDevices(INOUT CDevice* f_pCurDevice) const;
/*
        int DetectHubDevices( const CDevice* f_pCurDevice,IN struct udev_device *f_pBaseUSBDev,IN struct udev *f_pUdev,INOUT GENSTRING &f_cParentHub1Node,INOUT GENSTRING &f_cParentHub2Node,vector<CGlobalEnumerations::HubDetails_t *> &f_vHubs, DVMLOCK &f_tableLock);
        int DetectBlockDevice(CDevice* f_pCurDevice);
        int DetectBlockDevice(CDevice* f_pCurDevice,CGlobalEnumerations::NOTIFICATION_Type enNotiType,GENSTRING f_cDevNode,struct udev_device  *f_pDev,IN struct udev_device *f_pBaseUSBDev,vector <GENSTRING> &f_cvSupportedFS);
*/




  /*!
    * \brief in gen3 device detection notification needs to be adjusted to serve new MTPControl
    * \return true if LIBMTP_Open_Raw_Device_Uncached is successful
    *        
    */
   tBool AdjustMTPDeviceNotification(OUT CDevice* f_pCurDevice,IN LIBMTP_raw_device_t *f_pMTPRawdevices) const;

#if 0
        /*helper used by functions above only*/
#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
        void  vMapFileSystemType(INOUT CDevice *f_pCurAvailDevInfo) const;
#endif
#ifdef USE_TOTAL_USED_FREE_SIZE
        tVoid FillStorageInfoSizeTUF(INOUT CDevice* f_pCurDevice);  
        tVoid GetSizeMSC(OUT GENSTRING& f_totalSize,OUT GENSTRING& f_usedSize,OUT GENSTRING &f_freeSize, IN GENSTRING f_mountPoint);
#endif
        int  GetParentSerialId(CDevice* f_pCurDevice,GENSTRING &f_cParentHubSerial,struct udev_device  *f_pParentHUBDev);
        int  CheckForValidPartition(CDevice* f_pCurDevice, vector <GENSTRING> &f_cvSupportedFS);
        int IsSupportedFS(GENSTRING f_cFSType,vector <GENSTRING> &f_cvSupportedFS);


        void  ParentHUBSwapping( const CDevice* f_pCurDevice);

        tVoid AddPartitionUUIDToSerialNumer(CDevice* f_pCurDevice) const;
     
        CGlobalEnumerations::HubDetails_t* IsHubAlreadyConnected(GENSTRING l_cSysName, vector<CGlobalEnumerations::HubDetails_t *> &f_vHubs);
        
        void  ParentHUBSwapping( const CDevice* f_pCurDevice, 
                                            GENSTRING &f_cParentUsb1Hub, 
                                            GENSTRING &f_cParentUsb2Hub ,
                                            int       &f_cParentHub1Port, 
                                            int       &f_cParentHub2Port, 
                                            GENSTRING &f_cParentHub1Node, 
                                            GENSTRING &f_cParentHub2Node);

#endif
};

#endif //__DEVICERECOGNIZER_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

