/*-----------------------------------------------------------------------------*
 * AutomounterAdapter.h                                                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen3                                                   *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*! 
 * \file AutomounterAdapter.h
 *
 * \brief new automounter provides a slightly different interface like the previously used mount.sh
 *         in /tmp/.automount a new structure for information can be found
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 * \version Initial Version 03.12.2013, Koechling, Christian (Bosch)
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2013-2020
 */

#ifndef __AUTOMOUNTERADAPTER_H__
#define __AUTOMOUNTERADAPTER_H__

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include "IAutomounterAdapter.h"

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace std;

/*-----------------------------------------------------------------------------*
 * Forward declaration                                                                  *
 *-----------------------------------------------------------------------------*/

//class AutomounterAdapter;
/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class AutomounterAdapter
 *
 * \brief class to hold the properties of the device
 */



class AutomounterAdapter: public IAutomounterAdapter
{

    public:


   /*!
         * \brief Constructor
         */
     AutomounterAdapter();

    /*!
         * \brief Destructor
         */
    virtual ~AutomounterAdapter();

    /*!
         * \brief after a new device has been notified this function is called to read from 'pathfilename' corresponding data' to fill f_CDevice - uses text interface of Automounter
         *
         * \param [in] f_pCDevice device to be copied
         */
    IAutomounterAdapter::tenResIAutomounterAdapt_Type FillDevice(OUT CDevice& device, IN  std::string strPathfilename);

    /*!
         * \brief after a new device has been notified this function is called to read from 'pathfilename' corresponding data' to fill f_CDevice - uses shared lib interface of automounter
         *
         * \param [in] f_device device to be copied
         */
    IAutomounterAdapter::tenResIAutomounterAdapt_Type FillDevice(OUT CDevice& f_device);


    // EXAMPLE:
    // IN    strAutomounterPartitionFileName: partition_dev_sda1.info
    // OUT strPathFileNameDevDB              : /dev/sda1
    IAutomounterAdapter::tenResIAutomounterAdapt_Type GetExtractBlockDevName(OUT std::string &strDevName, IN std::string strAutomounterPartitionFileName) const;

    int Initialize(tVoid);

    protected:
        AutomounterAdaptSharedLibIF mAutomounterAdaptSharedLibIF;
        AutomounterAdaptTextIF      mAutomounterAdaptTextIF;
        
       

};


#endif // __AUTOMOUNTERADAPTER_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

