/*-----------------------------------------------------------------------------*
 * VD_DeviceManager_main.h                                                     *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file  VD_DeviceManager_main.h
 *
 * \brief This file holds the inplementation for class VD_DeviceManager_main
 *
 * \version Initial Version
 * \version 05.08.2011, Koechling, Christian (Bosch), Interface VD_DeviceManager
 *          changed
 * \version 21.11.2011, Koechling, Christian (Bosch), cleanup includes and
 *          intermediate defines which marked bugfixes
 * \version 28.11.2011, Koechling, Christian (Bosch), cleanup - add headers
 * \version 12.12.2011, Koechling, Christian (Bosch), cleanup: EOL data hold by
 *          Info_tclDmEolConfSettings only
 * \version 06.01.2012, Koechling, Christian (Bosch), cleanup FATAL traces
 * \version 07.01.2012, Koechling, Christian (Bosch), process start function
 *          shifted to VD_DeviceManagerProcess. Now VD_deviceManager consists
 *          of devmgr_a (static lib) linked into vd_devicemanager-process
 * \version 30.07.2012, Koechling, Christian (Bosch), changed header to doxygen
 *          style and shifted information from .cpp to .h
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 * \version 13.08.2012, Negi, Sunder (MontaVista), no 'void' params for constructor
 * \version 15.08.2012, Fiebing, Lars (Bosch), enable Linux based simulation (LSIM)
 * \version 27.08.2012, Koechling, Christian (Bosch), trigger FillStorage fct. by PDT-diag  
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef _VD_DEVICEMANAGER_MAIN_H_
#define _VD_DEVICEMANAGER_MAIN_H_

#define VD_DEVICEMANAGER_TRACE_CHANNEL  TR_TTFIS_DEVICEMANAGER

/*-----------------------------------------------------------------------------*
 * includes                                                        *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
 
/*-----------------------------------------------------------------------------*
 * Forward declarations                                                        *
 *-----------------------------------------------------------------------------*/
class DiaglibHandlerGen3;
class WorkThread;
class CyclicDiagThread;
class DiaglibHandlerGen2;
class vd_devicemanager_tclClientHandler_Diaglog;
class vd_devicemanager_tclService_DeviceManager;
class VD_DeviceManager_clienthandler_VD_MediaManager;
class vd_devicemanager_clienthandler_SPI ;
class vd_devicemanager_clienthandler_SPM;

/*-----------------------------------------------------------------------------*
 * using namespaces                                                        *
 *-----------------------------------------------------------------------------*/
using namespace diaglib;

//#endif

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class vd_devicemanager_tclApp
 *
 * \see ahl_tclBaseOneThreadApp
 */
class vd_devicemanager_tclApp : public ahl_tclBaseOneThreadApp
{
    public:
 
    /*
         * \brief Get vd_devicemanager_tclApp manager object
         *
         * Provides the singleton vd_devicemanager_tclApp manager object. First invocation of
         * this function creates the object. Especially this object is called first in VD_DeviceManagerProcess.cpp
         *
         * \param [in] pStateTable used to give output of prmManager to as input to state table
         *
         * \return [PrmManager*] singleton object
         */
        static vd_devicemanager_tclApp *GetInstance();


        /*!
         * \brief Destroys the singleton object
         */
        static void  DestroyInstance();


        /*!
         * \brief Assignment Operator
         *
         * Will not be implemented. Avoids Lint Prio 3 warning: Info 1732: new
         * in constructor for class 'vd_devicemanager_tclApp'
         * which has no assignment operator.
         *
         * \note This is a technique to disable the assignment operator for this
         *       class. So if an attempt for the assignment is made compiler
         *       complains.
         */
        vd_devicemanager_tclApp& operator= (const vd_devicemanager_tclApp &oVD_DeviceManager);

        /*---------------------------------------------------------------------*
         * Overriding ahl_tclBaseOneThreadApp methods                          *
         *---------------------------------------------------------------------*/

        /*!
         * \brief CCA initialization function
         *
         * This function is called by the CCA framework before starting any CCA
         * message related communication action. As default this function always
         * returns TRUE. The user has to implement all his local application
         * initialization (create client and service handler, create worker
         * threads, allocate application memory,...).
         *
         * If returns TRUE, initialization could be successfully performed and
         * framework will register application, else, a reset of the system is
         * forced immediately.
         *
         * This function is the counterpart of vOnApplicationClose().
         *
         * \return [tBool] TRUE  = Application successfully initialized.
         *          FALSE = Application NOT successfully initialized.
         *
         * \see ahl_tclBaseOneThreadApp::bOnInit()
         */
        virtual tBool bOnInit();

        /*!
         * \brief CCA shutdown function
         *
         * This function is called by the CCA framework to indicate the
         * imminent shutdown of the application. The user has to implement
         * the de-initialization of all his local application data (destroy
         * client and service handler, destroy worker threads, free
         * application memory, ... ). After this function call the destructor
         * of this application will be called.
         *
         * This function is the counterpart of bOnInit().
         *
         *\see ahl_tclBaseOneThreadApp::vOnApplicationClose()
         */
        virtual tVoid vOnApplicationClose();

        /*!
         * \brief CCA timer expiration function
         *
         * This function is called by the CCA framework on the expiration of a
         * timer defined previously via function bStartTimer(). The expired timer
         * is forwarded to the respective service or client-handler via a call
         * of vProcessTimer().
         *
         * The function is called from this applications context and therefore no
         * inter-thread programming rules must be considered and the application
         * methods and/or member variables can be accessed without using the
         * static self reference 'm_poMainAppInstance'.
         *
         * \param [in] nTimerId Identifier of the expired timer.
         *
         * \see ahl_tclBaseOneThreadApp::vOnTimer().
         */
        virtual tVoid vOnTimer(tU16 nTimerId);

        /*!
         * \brief CCA method to load the last saved settings, if any
         *
         * This function is called by the CCA framework to trigger the loading
         * of last mode settings. The user has to load the previously stored
         * last mode settings from persistent memory.
         *
         * \see ahl_tclBaseOneThreadApp::vOnLoadSettings().
         */
        virtual tVoid vOnLoadSettings();

        /*!
         * \brief CCA method to save system settings on shutdown, if any
         *
         * This function is called by the CCA framework to trigger the storage
         * of last mode settings. The user has to store the last mode settings
         * to persistent memory.
         *
         * \see ahl_tclBaseOneThreadApp::vOnSaveSettings().
         */
        virtual tVoid vOnSaveSettings();

        /*!
         * \brief loopback processing function
         *
         * This function is called by the CCA framework if a message was  sent
         * from one if this applications services or from a callback-handler of
         * this application (so called self or loopback messages). The message
         * can be forwarded to the respective service via a call of
         * vOnLoopbackService(). If there is no service registered for this
         * message then the user has the option to directly evaluate the message
         * in the default block of this method's switch-clause.
         *
         * \param [in] u16ServiceID Identifier of the service from where the
         *             message was sent.
         * \param [in] poMessage Message object.
         *
         * \see ahl_tclBaseOneThreadApp::vOnLoopback().
         */
        virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

      

        /*---------------------------------------------------------------------*
            *   further functions *
            *---------------------------------------------------------------------*/

        /*! 
         * \brief Enabled/disabled diagnosis
         *
         * \param [in] bEnable TRUE means enable FALSE means disable
         */
        void diagEnable(tBool bEnable);


        /*!
         * \brief Get current diagnosis setting
         *
         * \return [tBool] whether diagnosis is enabled or not
         */
        tBool bGetDiagEnable() const;


        VD_DeviceManager_clienthandler_VD_MediaManager* GetMediaManagerClientHandlerInstance();


        using ahl_tclBaseOneThreadApp::vOnLoopback;

        /**< instance of the device manager service */
        vd_devicemanager_tclService_DeviceManager* m_poDeviceManager;

        /**< instance of the device manager worker thread */
        WorkThread* m_poWorkThread;

        /**< instance of the device manager Diagnosis thread which collecty cyclic data and forwards it to diaglog */
        CyclicDiagThread* m_poCyclicDiagThread;

        /**< instance of the device manager main application */
        static vd_devicemanager_tclApp* m_poMainAppInstance;

       tclServiceDiaglib* m_poDiagLibServiceGen; ///< Diaglib service
       DiaglibHandlerGen2 *m_poDmDiagLibHandlerGen2;
       DiaglibHandlerGen3* m_poDmDiagLibHandlerGen3;


        /**< diagnosis setting */
        tBool m_bCyclicDiagnosisEnabled;  //used for DTC - i.e. customer diagnosis i.e. after devices have been build into the car
 
        /**< holds HUB1 Diagnosis data */
        CUSBDiagnosis m_objUSBDignosisHUB1;

        /**< holds HUB2 Diagnosis data */
        CUSBDiagnosis m_objUSBDiagnosisHUB2;

        /**< Holds pointer to Diag client handler */
        vd_devicemanager_tclClientHandler_Diaglog* m_poClientHandlerDiaglog;


        /**< Holds pointer to Mediamanager client handler */
        VD_DeviceManager_clienthandler_VD_MediaManager *m_poClientHandlerMediaManager;

		/**< Holds pointer to client handler spm*/
        vd_devicemanager_clienthandler_SPM *m_poClientHandlerSPM;
        /**< Holds pointer to client handler spi*/
        vd_devicemanager_clienthandler_SPI *m_poClienthandler_SPI;

    private:

        // static member variable declared for singleton class
        //static vd_devicemanager_tclApp* m_poMainAppInstance; //is set above and I don't know why it is not originally prive
        //static StateTable       *m_pDeviceManagerMain;
        static DVMLOCK    m_singelton;

        /*!
         * \brief Default constructor - private since it belongs to a singleton
         *
         * \see ahl_tclBaseOneThreadApp::ahl_tclBaseOneThreadApp()
         */
        vd_devicemanager_tclApp();//lint !e1704 :  Constructor has private access specification - due to singleton construction

        /*!
         * \brief Destructor - private since it belongs to a singleton
         *
         *
         * \see vd_devicemanager_tclApp::~vd_devicemanager_tclApp()
         */
        virtual ~vd_devicemanager_tclApp();

        /*!
         * \brief Initializes all the resources handlers.
         *
         * \return Methods returns TRUE if all the handlers creation is
         *         successful otherwise FALSE
         */
        tBool vInitialize(tVoid);

        /*!
         * \brief Releases all the resources handlers.
         */
        tVoid vDeInitialize(tVoid);

        template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();

};

#endif //_VD_DEVICEMANAGER_MAIN_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>

