/*-----------------------------------------------------------------------------*
 * VD_DeviceManager_main.cpp                                                   *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManager_main.cpp
 *
 * \brief This file holds the definition for class vd_devicemanager_tclApp
 *
 * \version Initial Version
 * \version 05.08.2011, Koechling, Christian (Bosch), Interface VD_DeviceManager
 *          changed
 * \version 21.11.2011, Koechling, Christian (Bosch), cleanup includes and
 *          intermediate defines which marked bugfixes
 * \version 28.11.2011, Koechling, Christian (Bosch), cleanup - add headers
 * \version 12.12.2011, Koechling, Christian (Bosch), cleanup: EOL data hold by
 *          Info_tclDmEolConfSettings only
 * \version 06.01.2012, Koechling, Christian (Bosch), cleanup FATAL traces
 * \version 07.01.2012, Koechling, Christian (Bosch), process start function
 *          shifted to VD_DeviceManagerProcess. Now VD_deviceManager consists
 *          of devmgr_a (static lib) linked into vd_devicemanager-process
 * \version 30.07.2012, Koechling, Christian (Bosch), changed header to doxygen
 *          style and shifted information from .cpp to .h
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 * \version 15.08.2012, Fiebing, Lars (Bosch), enable Linux based simulation (LSIM)
 * \version 27.08.2012, Koechling, Christian (Bosch), trigger FillStorage fct. by PDT-diag
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_AILAHL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#define DIAGLIB_INCLUDE_IO_CONTROL
#define DIAGLIB_INCLUDE_DIAGNOSIS_DATA
#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;


#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"
#include "Diagnosis.h"

#include "WorkThread.h"
#include "CyclicDiagThread.h"

#include "diag/IDiagLibHandler.h"
#include "diag/DiagLibHandlerGen2.h"
#include "diag/DiagLibHandlerGen3.h"

#include "client/VD_DeviceManager_clienthandler_SPI.h"
#include "client/VD_DeviceManager_clienthandler_Diaglog.h"
#include "client/VD_DeviceManager_clienthandler_VD_MediaManager.h"
#include "client/VD_DeviceManager_clienthandler_SPM.h"


#include "service/VD_DeviceManager_service_DeviceManager.h"
#include "VD_DeviceManager_main.h"
#include "config/ConfigurationManager.h"
#include <unistd.h>



/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_APPLICATION
#include "trcGenProj/Header/VD_DeviceManager_main.cpp.trc.h"
#endif

#include "ETGTrace.h"

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/
#ifdef USE_SHIFT_CYCLICDIAGNOSIS
//shifted defines to config.h to have it at a central point in the code
#else
#define VD_DEVICEMANAGER_TIMER_ID 0
#define VD_DEVICEMANAGER_TIMER_TIME_UNTIL_FIRST_TICK 2000
#define VD_DEVICEMANAGER_TIMER_TICK_INTERVALL 2000

#define VD_CLIENTHANDLER_DIAGLOG_TIMER_ID 1
#define VD_CLIENTHANDLER_DIAGLOG_TIMER_TIME_UNTIL_FIRST_TICK 3000
#define VD_CLIENTHANDLER_DIAGLOG_TIMER_TICK_INTERVALL 1000
#endif


/*!
 * Static self reference to be used in function callbacks.
 */
//vd_devicemanager_tclApp* vd_devicemanager_tclApp::m_poMainAppInstance = NULL; who is using this why does it have to be public? Timer?
/*-----------------------------------------------------------------------------*
 * Singleton                                                                   *
 *-----------------------------------------------------------------------------*/
// static pointer used to ensure a single instance of vd_devicemanager_tclApp
vd_devicemanager_tclApp* vd_devicemanager_tclApp::m_poMainAppInstance = NULL;
DVMLOCK                  vd_devicemanager_tclApp::m_singelton;

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
vd_devicemanager_tclApp::vd_devicemanager_tclApp():ahl_tclBaseOneThreadApp()
{
    ETG_TRACE_USR4(("vd_devicemanager_tclApp() entered."));

    m_poDiagLibServiceGen    = NULL;
    m_poDmDiagLibHandlerGen2 = NULL;
    m_poDmDiagLibHandlerGen3 = NULL;
    m_poClientHandlerDiaglog = NULL;
    m_poClienthandler_SPI    = NULL;
    vd_devicemanager_tclApp::m_poMainAppInstance = this;

    m_poWorkThread       = NULL;
    m_poCyclicDiagThread = NULL;

    m_poClientHandlerMediaManager = NULL;
	
    m_poClientHandlerSPM          = NULL;
        

}

/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
vd_devicemanager_tclApp::~vd_devicemanager_tclApp()
{
    //Note: Shutdown is not implemented clean since at this point power has been switched off already
    ETG_TRACE_USR4(("~vd_devicemanager_tclApp() entered."));
    // to satiesfy Lint
    if( NULL != m_poDeviceManager )
    {
        vDeleteNoThrow( m_poDeviceManager );
        m_poDeviceManager = NULL;
    }

    if( NULL != m_poCyclicDiagThread )
    {
        vDeleteNoThrow( m_poCyclicDiagThread );
        m_poCyclicDiagThread = NULL;
    }

    if( NULL != m_poWorkThread )
    {
        vDeleteNoThrow( m_poWorkThread );
        m_poWorkThread = NULL;
    }

    if( NULL != m_poDmDiagLibHandlerGen2 )
    {
        vDeleteNoThrow( m_poDmDiagLibHandlerGen2 );
        m_poDmDiagLibHandlerGen2 = NULL;
    }
    if( NULL != m_poDmDiagLibHandlerGen3 )
    {
        vDeleteNoThrow( m_poDmDiagLibHandlerGen3 );
        m_poDmDiagLibHandlerGen3 = NULL;
    }
    if( NULL != m_poDiagLibServiceGen )
    {
        vDeleteNoThrow( m_poDiagLibServiceGen );
        m_poDiagLibServiceGen = NULL;
    }

    if( NULL != m_poClientHandlerDiaglog )
    {
        vDeleteNoThrow( m_poClientHandlerDiaglog );
        m_poClientHandlerDiaglog = NULL;
    }

    if( NULL != m_poClientHandlerSPM )
    {
        vDeleteNoThrow( m_poClientHandlerSPM );
        m_poClientHandlerSPM = NULL;
    }


    if( NULL != m_poClienthandler_SPI )
    {
        vDeleteNoThrow( m_poClienthandler_SPI );
        m_poClienthandler_SPI = NULL;
    }



    vd_devicemanager_tclApp::m_poMainAppInstance = NULL;
}

/*-----------------------------------------------------------------------------*
 * tBool bOnInit()                                                             *
 *-----------------------------------------------------------------------------*/
tBool vd_devicemanager_tclApp::bOnInit()
{
    ETG_TRACE_USR4(("bOnInit() entered."));

    tBool bSuccess = FALSE;

    if(TRUE==vInitialize())
    {
        bSuccess = TRUE;
    }

    ETG_TRACE_USR4(("bOnInit() exit."));

    return bSuccess;
}

/*-----------------------------------------------------------------------------*
 * tVoid vOnApplicationClose()                                                 *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclApp::vOnApplicationClose()
{
    ETG_TRACE_USR4(("vOnApplicationClose() entered."));

    //vUnplugTrace(VD_DEVICEMANAGER_TRACE_CHANNEL); /// Release the TTFis Channel //TTFISCMHander replaces this
    bStopTimer(VD_DEVICEMANAGER_TIMER_ID);

    vDeInitialize();

    ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*
//how below functions match to different SPM states transitions to 
1.	tBool vd_devicemanager_tclApp::bOnInit()                      "NULL" ' INITIALIZED
2.	tVoid vd_devicemanager_tclApp::vOnApplicationClose()   OFF ' "TERMINATED"  (wird typischerweise nicht durchlaufen, weil vorher der Strom weg ist)
3.	tVoid vd_devicemanager_tclApp::vOnLoadSettings()     [INITIALIZED oder OFF] ' NORMAL
4.	tVoid vd_devicemanager_tclApp::vOnSaveSettings()      [INITIALIZED oder NORMAL] ' OFF
*/
/*-----------------------------------------------------------------------------*
 * tVoid vOnLoadSettings()                                                     *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclApp::vOnLoadSettings()
{
    ETG_TRACE_USR4(("--->vOnLoadSettings() entered."));
#ifdef USE_SHIFT_CYCLICDIAGNOSIS
    //----------------------------------------------
    //enable cyclic diagnosis
    //----------------------------------------------
    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_CYCLIC_DIAGNOSIS))
    {
        FILE *l_pCyclicDiagDisableFile;
        l_pCyclicDiagDisableFile = fopen (CYLCIC_DIAGNOSIS_DISABLEFILE, "r");
        if (l_pCyclicDiagDisableFile)
        {
           ETG_TRACE_FATAL(("Found file %s: hence cyclic diagnosis is disabled",CYLCIC_DIAGNOSIS_DISABLEFILE));
           diagEnable(FALSE);   //lint !e1551 Warning 1551;Function may throw exception
           fclose(l_pCyclicDiagDisableFile);
        }
        else
        {
            diagEnable(TRUE);   //lint !e1551 Warning 1551;Function may throw exception
        }
    }
  
#endif
    ETG_TRACE_FATAL(("<--- vOnLoadSettings() exit."));
}

/*-----------------------------------------------------------------------------*
 * tVoid vOnSaveSettings()                                                     *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclApp::vOnSaveSettings()
{
#ifdef USE_SHIFT_CYCLICDIAGNOSIS
    diagEnable(FALSE);
    ETG_TRACE_USR4(("vOnSaveSettings() entered."));
#endif
}

/*-----------------------------------------------------------------------------*
 * void diagEnable(tBool bEnable)                                              *
 *-----------------------------------------------------------------------------*/
void vd_devicemanager_tclApp::diagEnable(tBool bEnable)
{
    ETG_TRACE_USR2(("diagEnable: 0x%x",bEnable));
    if(m_bCyclicDiagnosisEnabled != bEnable)
    {
        m_bCyclicDiagnosisEnabled = bEnable;
#ifdef USE_SHIFT_CYCLICDIAGNOSIS

        if(m_poCyclicDiagThread)
        {
            ETG_TRACE_ERR(("Enable diagnosis"));

            tU16 u16ObserveDTCInterval = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_observeDTC_INTERVALL);
            m_poCyclicDiagThread->SetTimeout(VD_CLIENTHANDLER_DIAGLOG_TIMER_TIME_UNTIL_FIRST_TICK_SEC,u16ObserveDTCInterval);
            m_poCyclicDiagThread->SetEnableCyclicDiag(bEnable);
        }
        else
        {
            ETG_TRACE_FATAL(("[ERROR]: diagEnable: m_poCyclicDiagThread not created yet"));
        }
#else //USE_SHIFT_CYCLICDIAGNOSIS
        if(TRUE==m_bCyclicDiagnosisEnabled)
        {
            ///@todo shift these to Config.h
            if (FALSE == bStartTimer( VD_CLIENTHANDLER_DIAGLOG_TIMER_ID,
                                      VD_CLIENTHANDLER_DIAGLOG_TIMER_TIME_UNTIL_FIRST_TICK,
                                      VD_CLIENTHANDLER_DIAGLOG_TIMER_TICK_INTERVALL))
            {
                ETG_TRACE_ERR(("bStartTimer VD_CLIENTHANDLER_DIAGLOG_TIMER_ID Failed"));
                DVM_NORMAL_M_ASSERT_ALWAYS();
            }
            else
            {
                ETG_TRACE_USR1(("ok:bStartTimer VD_CLIENTHANDLER_DIAGLOG_TIMER_ID"));
            }
        }
        else
        {
            if (FALSE == bStopTimer( VD_CLIENTHANDLER_DIAGLOG_TIMER_ID))
            {
                ETG_TRACE_FATAL(("ERROR: bStopTimer VD_CLIENTHANDLER_DIAGLOG_TIMER_ID Failed"));
                DVM_NORMAL_M_ASSERT_ALWAYS();
            }
            else
            {
                ETG_TRACE_COMP(("ok:StopTimer VD_CLIENTHANDLER_DIAGLOG_TIMER_ID STOPPED"));
            }
        }
#endif //USE_SHIFT_CYCLICDIAGNOSIS
    }
}


/*-----------------------------------------------------------------------------*
 * tBool bGetDiagEnable(tBool bEnable)                                         *
 *-----------------------------------------------------------------------------*/
tBool vd_devicemanager_tclApp::bGetDiagEnable() const
{
    return m_bCyclicDiagnosisEnabled;
}


/*-----------------------------------------------------------------------------*
 * tVoid vOnTimer(tU16 u16TimerId)                                             *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclApp::vOnTimer(tU16 u16TimerId)
{
    //    ETG_TRACE_USR4(("--->vOnTimer() entered."));

    switch(u16TimerId)
    {
    case VD_DEVICEMANAGER_TIMER_ID:
    {
        if (NULL != m_poDeviceManager)
        {
            ETG_TRACE_USR4(("Start m_poClientHandlerDiaglog->vProcessTimer(VD_DEVICEMANAGER_TIMER_ID)"));
            m_poDeviceManager->vProcessTimer(u16TimerId);
        }
        else
        {
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        break;
    }

#ifndef USE_SHIFT_CYCLICDIAGNOSIS
    case VD_CLIENTHANDLER_DIAGLOG_TIMER_ID:
    {
        if (NULL != m_poClientHandlerDiaglog)
        {
            ETG_TRACE_USR4(("Start m_poClientHandlerDiaglog->vProcessTimer(VD_CLIENTHANDLER_DIAGLOG_TIMER_ID)"));
            m_poClientHandlerDiaglog->vProcessTimer(u16TimerId);
        }
        else
        {
            //                ETG_TRACE_ERR(("Error m_poClientHandlerDiaglog==NULL"));
        }
        break;
    }
#endif
    default:
    {
    }
    }
    //    ETG_TRACE_USR4(("<--- vOnTimer() exit."));
}

/*-----------------------------------------------------------------------------*
 * tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage)         *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclApp::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
#ifndef USE_SUPPRESS_TRACES_LOOPBACK
    ETG_TRACE_USR4(("Begin: vOnLoopback()"));
#endif

    switch(u16ServiceID)
    {
        case CCA_C_U16_SRV_DEVICEMANAGER:
        {
            if(NULL != m_poDeviceManager)
            {
                m_poDeviceManager->vOnLoopbackService(poMessage);
            }
            else
            {
                DVM_NORMAL_M_ASSERT_ALWAYS();
            }
            break;
        }
        default:
        {
            // Evaluate your none service related loopback messages here.
        }
    }
#ifndef USE_SUPPRESS_TRACES_LOOPBACK
    ETG_TRACE_USR4(("End  : vOnLoopback()"));
#endif
}

/*-----------------------------------------------------------------------------*
 * tBool vInitialize(tVoid)                                                    *
 *-----------------------------------------------------------------------------*/
tBool vd_devicemanager_tclApp::vInitialize(tVoid)
{
    tBool bSuccess = TRUE;
    ETG_TRACE_USR4(("---> vInitialize() Entered."));

#ifdef USE_DELAY_STARTUP_SECONDS     //for debugging it is possible to delay startup
    sleep(USE_DELAY_STARTUP_SECONDS);
    ETG_TRACE_FATAL(("vInitialize: start after %d sec",USE_DELAY_STARTUP_SECONDS))
#endif

            //DeviceManagerInterface::GetInstance();

            m_poDeviceManager = new vd_devicemanager_tclService_DeviceManager(
                this);/*lint -e774 */

    if (NULL == m_poDeviceManager)
    {
        bSuccess = FALSE;

        ETG_TRACE_FATAL (("ERROR: vInitialize: Object Creation Failed for m_poDeviceManager"));
        DVM_FATAL_M_ASSERT_ALWAYS();
    }
    else
    {
        ETG_TRACE_SYS (("vInitialize: m_poDeviceManager is created "));
    }



    //-------------------------------------------
    //create worker thread
    //-------------------------------------------
    ETG_TRACE_SYS (("vInitialize: Creating DM WorkThread"));
    m_poWorkThread = new WorkThread();

#ifdef USE_SHIFT_CYCLICDIAGNOSIS
    //-------------------------------------------
    //create cyclic thread thread
    //-------------------------------------------
    ETG_TRACE_SYS (("vInitialize: Creating DM CyclicDiagThread"));
    m_poCyclicDiagThread = new CyclicDiagThread();

    //1. m_poCyclicDiagThread will be handed over to WorkThread
    //2. in VD_Main it is already allowed to call set-functions of CyclicDiagThread - although thread of m_poCyclicDiagThread has not been started yet
    //3. thread of m_poCyclicDiagThread will be started as all other threads of thread factory (framework) by WorkThread
    //4. WorkThread will be started by m_poWorkThread->bActivate(); below in this function i.e. after the 'interface'/object has been injected 
    m_poWorkThread->SetInterface(m_poCyclicDiagThread); 
#endif


    //-------------------------------------------
    //Gen2 used alos in Gen3 (originally developed for GM)
    //-------------------------------------------
    m_poDiagLibServiceGen = new diaglib::tclServiceDiaglib((ahl_tclBaseOneThreadApp*) this, 1);

    if (m_poDiagLibServiceGen)
    {
        //----------------------------------------------------------
        //Gen2 diagnosis GMMY14,15 used also for Gen3 diagnosis for GMMY16
        //---------------------------------------------------------
        m_poDmDiagLibHandlerGen2 = new DiaglibHandlerGen2(this,m_poDiagLibServiceGen);
        if (m_poDmDiagLibHandlerGen2)
        {
            ETG_TRACE_USR4 (("---m_poDmDiagLibHandlerGen2 object address: 0x%x", m_poDmDiagLibHandlerGen2));
        }
        else
        {
            ETG_TRACE_FATAL (("ERROR:!!!Creation of m_poDmDiagLibHandlerGen2 service failed"));
        }

        //----------------------------------------------------------
        //Gen3 diagnosis (Roadmap 14003 diagnosis2 for VAGMIBE and SUZSLN)
        //----------------------------------------------------------
        m_poDmDiagLibHandlerGen3 = new DiaglibHandlerGen3(this,m_poDiagLibServiceGen);
        if (m_poDmDiagLibHandlerGen3)
        {
            ETG_TRACE_USR4 (("---m_poDmDiagLibHandlerGen3 object address: 0x%x", m_poDmDiagLibHandlerGen3));
        }
        else
        {
            ETG_TRACE_FATAL (("ERROR:!!!Creation of m_poDmDiagLibHandlerGen3 serviceGen3 failed"));
        }
    } // if (OSAL_NULL != m_poDiagLibService)
    else
    {
        ETG_TRACE_USR4 (("!!! Registration failed : DiagLib serviceGen2 is NULL"));
    } // End of if-else; if (OSAL_NULL != m_poDiagLibService)

    //----------------------------------------------------------
    //DIAGLOG used in GM to send ITC's
    //----------------------------------------------------------
    m_poClientHandlerDiaglog  = new vd_devicemanager_tclClientHandler_Diaglog(this);

    if (NULL == m_poClientHandlerDiaglog)/*lint -e774 */
    {
        bSuccess = FALSE;
        ETG_TRACE_ERR(("vInitialize: ERROR: !!! Diaglog handler creation failed"));
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {
#ifdef USE_SHIFT_CYCLICDIAGNOSIS
        if(m_poCyclicDiagThread)
        {
            ETG_TRACE_SYS (("inject to CyclicDiagThread:ICyclicDiagnosis"));
            ETG_TRACE_SYS (("inject to CyclicDiagThread:ICyclicDiagReceiver"));
            m_poCyclicDiagThread->SetInterface((ICyclicDiagnosis*)m_poClientHandlerDiaglog);
#ifdef USE_ENABLE_VD_DVM_CLH_DIAGLOG_ICYCLICDIAGRECEIVER
            m_poCyclicDiagThread->SetInterface((ICyclicDiagReceiver*)m_poClientHandlerDiaglog);
#endif
        }
#endif
        ETG_TRACE_SYS (("vInitialize: m_poClientHandlerDiaglog is created "));
    }

    //----------------------------------------------------------
    //Mediamanager client handler used to get the cdda device detection
    //----------------------------------------------------------

    if((DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_MEDIAMANAGER_CLIENTHANDLER)) && (DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_INTERNAL_CDDA)))
    {
        m_poClientHandlerMediaManager = new VD_DeviceManager_clienthandler_VD_MediaManager(this);
        if (NULL == m_poClientHandlerMediaManager)/*lint -e774 */
        {
            bSuccess = FALSE;
            ETG_TRACE_ERR(("vInitialize: ERROR: !!! Mediamanager client handler creation failed"));
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            ETG_TRACE_SYS (("vInitialize: m_poClientHandlerMediaManager is created "));
        }

        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT))
        {
            m_poClientHandlerSPM = new vd_devicemanager_clienthandler_SPM(this);
            
            if (NULL == m_poClientHandlerSPM)/*lint -e774 */
            {
                bSuccess = FALSE;
                ETG_TRACE_ERR(("vInitialize: ERROR: !!! SPM client handler creation failed"));
                DVM_NORMAL_M_ASSERT_ALWAYS();
            }
            else
            {
                ETG_TRACE_SYS (("vInitialize: m_poClientHandlerSPM is created "));
            }
        }
        
    }
    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_DELAY_NOTIFY_MTP_DEVICES))
    {

        m_poClienthandler_SPI = new vd_devicemanager_clienthandler_SPI(this);
        if (NULL == m_poClienthandler_SPI)/*lint -e774 */
        {
            bSuccess = FALSE;
            ETG_TRACE_ERR(("vInitialize: ERROR: !!! SPI client handler creation failed"));
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            ETG_TRACE_SYS (("vInitialize: m_poClienthandler_SPI is created "));
        }
    }

    if (FALSE == bStartTimer(VD_DEVICEMANAGER_TIMER_ID,
                             VD_DEVICEMANAGER_TIMER_TIME_UNTIL_FIRST_TICK,
                             VD_DEVICEMANAGER_TIMER_TICK_INTERVALL))
    {
        bSuccess = FALSE;
        ETG_TRACE_FATAL (("ERROR: vInitialize: ERROR: bStartTimer VD_DEVICEMANAGER_TIMER_ID Failed"));
        DVM_FATAL_M_ASSERT_ALWAYS();
    }

    //activate worker thread 
    if ( NULL != m_poWorkThread )
    {
        ETG_TRACE_SYS (("vInitialize: Start workerthread"));

        m_poWorkThread->bActivate();
    }
    else
    {
        ETG_TRACE_FATAL (("ERROR: vInitialize: ERROR: Creation of workerthread failed"));
    }

    ETG_TRACE_USR4(("<--- vInitialize() Exit."));

    return bSuccess;
}  //  tBool vd_devicemanager_tclApp::vInitialize(tVoid)

/*-----------------------------------------------------------------------------*
 * tBool vDeInitialize(tVoid)                                                  *
 *-----------------------------------------------------------------------------*/
///@todo clean by comparing with destrucotr
tVoid vd_devicemanager_tclApp::vDeInitialize(tVoid)
{
    //_BP_TRY_BEGIN
	try
    {
        if (NULL != m_poDeviceManager)
        {
            delete m_poDeviceManager;
            m_poDeviceManager = NULL;
        }

        if (NULL != m_poWorkThread)
        {
            delete m_poWorkThread;
            m_poWorkThread = NULL;
        }

        if (NULL != m_poClientHandlerDiaglog)
        {
            delete m_poClientHandlerDiaglog;
            m_poClientHandlerDiaglog = NULL;
        }
    }
    //_BP_CATCH_ALL
	catch (...)
    {
    }
    //_BP_CATCH_END
}  // tVoid vd_devicemanager_tclApp::vDeInitialize(tVoid)

/*-----------------------------------------------------------------------------*
 * StateTable* GetInstance(vd_devicemanager_tclApp *poMainApp)                 *
 *-----------------------------------------------------------------------------*/
vd_devicemanager_tclApp *vd_devicemanager_tclApp::GetInstance()
{
    ETG_TRACE_USR4(("Begin: GetInstance"));
    vd_devicemanager_tclApp::m_singelton.lock();
    if(NULL == m_poMainAppInstance)
    {
        m_poMainAppInstance = new vd_devicemanager_tclApp();
        if(m_poMainAppInstance==NULL)
        {
            ETG_TRACE_FATAL (("GetInstance: new vd_devicemanager_tclApp() failed"));
            ETG_TRACE_ERRMEM(("GetInstance: new vd_devicemanager_tclApp() failed"));
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
    }
    vd_devicemanager_tclApp::m_singelton.unlock();
    ETG_TRACE_USR4(("End  : GetInstance"));

    return m_poMainAppInstance;
}

/*----------------------------------------------------------------------------------------*
 * VD_DeviceManager_clienthandler_VD_MediaManager* GetMediaManagerClientHandlerInstance() *
 *----------------------------------------------------------------------------------------*/
VD_DeviceManager_clienthandler_VD_MediaManager* vd_devicemanager_tclApp::GetMediaManagerClientHandlerInstance()
{
    return m_poClientHandlerMediaManager;
}


/*-----------------------------------------------------------------------------*
 * void DestroyInstance()                                                      *
 *-----------------------------------------------------------------------------*/
void vd_devicemanager_tclApp::DestroyInstance()
{
    ETG_TRACE_USR4(("Begin: DestroyInstance"));
    vd_devicemanager_tclApp::m_singelton.lock();
    if(NULL != m_poMainAppInstance)
    {
        delete m_poMainAppInstance;
        m_poMainAppInstance = NULL;
    }
    else
    {
        //do nothing
    }
    vd_devicemanager_tclApp::m_singelton.unlock();
    ETG_TRACE_USR4(("End  : DestroyInstance"));
}


/* *****************************************************************************

   FUNCTION:      vDeleteNoThrow

   DESCRIPTION:   Deletes memory without throwing an exception.

   PARAMETERS:    rfpArg: reference of pointer to memory, to be deleted

   RETURN TYPE:   void

   HINT:          Why this function? If delete is called inside the destructor,
                  Lint complains with warning 1551 that delete might throw an
                  execption, which is not caught.

                  But try / catch must not be used, and delete does not throw
                  an exception, anyway. To prevent a Lint warning deactivation,
                  this function guarantees that no exception is thrown.
                  Furthermore, it sets the given pointer to 0, and Lint is
                  happy.

                  It is a template, because two different memory types have to
                  be deleted inside this class.

----------------------------------------------------------------------------- */
template< class T > void vd_devicemanager_tclApp::vDeleteNoThrow( T*& rfpArg ) throw()
{
    delete rfpArg;
    rfpArg = 0;
}




////////////////////////////////////////////////////////////////////////////////
// <EOF>

