/*-----------------------------------------------------------------------------*
 * VD_DeviceManagerProcess.cpp                                                 *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManagerProcess.cpp
 *
 * \brief wrapps devmgr.out to get it running as a process
 *
 * \mainpage VD_DeviceManager process
 *
 * \version 16.03.2012, Koechling, Christian (Bosch), Initial Version - to
 *          enable recreate in build process for VD_DVM-files only
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifdef VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS


//-----------------------------------------------
//error check dependencies and stop compilation on error
//----------------------------------------------
#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCA
  #define IF_CCA 1
#else
  #define IF_CCA 0
#endif

#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_DBUS
  #define IF_DBUS 1
#else
  #define IF_DBUS 0
#endif

#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_ASF
  #define IF_ASF 1
#else
  #define IF_ASF 0
#endif

#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCADBUS
  #define IF_CCADBUS 1
#else
  #define IF_CCADBUS 0
#endif


#if ((IF_CCA +IF_DBUS + IF_ASF + IF_CCADBUS) != 1)
    #error "VD_DEVICEMANAGER: EITHER OF ONE INTERFACES ARE ALLOWED TO BE SET WITH VARIANT SWITCH: CCA, DBUS, ASF or CCADBUS"
    #if IF_CCA > 0
     #error "VD_DEVICEMANAGER:  IF_CCA > 0"
    #endif
    #if IF_DBUS > 0
     #error "VD_DEVICEMANAGER:  IF_DBUS > 0"
    #endif
    #if IF_ASF > 0
     #error "VD_DEVICEMANAGER:  IF_ASF > 0"
    #endif
    #if IF_CCADBUS > 0
     #error "VD_DEVICEMANAGER:  IF_CCADBUS > 0"
    #endif
#else
#endif

//-----------------------------------------------------------



#include "Config.h"

#define INCLUDE_VD_DVM_AILAHL
#define INCLUDE_VD_DVM_BASICS
#include "common/Common.h"

#if defined(VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCA) || defined(VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCADBUS)
#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;
#endif

#include "Enums.h"
#include "device/Device.h"
#include "device/DeviceCard.h"
#include "device/Diagnosis.h"
#include "main/WorkThread.h"
#if defined(VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCA) || defined(VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCADBUS)
#include "diag/DiagLibHandlerGen2.h"
#include "client/VD_DeviceManager_clienthandler_Diaglog.h"
#include "service/VD_DeviceManager_service_DeviceManager.h"
#include "main/VD_DeviceManager_main.h"
#endif


#define EVENT_SHUTDOWN_NAME "SHUTDOWN_VD_DeviceManager"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCADBUS
#include "service/VD_DeviceManager_service_DBus.h"
#endif


/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_PROCESS
#include "trcGenProj/Header/VD_DeviceManagerProcess.cpp.trc.h"
#endif

#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST




extern "C" OSAL_DECL tS32 vStartApp(tS32 /*cPar*/, tString /*aPar[]*/)
{
    tS32 s32RetVal = OSAL_OK;
    OSAL_tEventHandle  hEvShutdown = 0;
    OSAL_tEventMask    hEvRequest  = 0x00000001;

    et_vTraceOpen();
    et_vTraceBuffer(TR_TTFIS_SYSMANAGER, TR_LEVEL_DATA, 9, "START VD_DEVICEMANAGER");
    scd_init();

    if (OSAL_s32EventCreate(EVENT_SHUTDOWN_NAME, &hEvShutdown) == OSAL_ERROR)
    {
        //ETG_TRACE_ERR(("vd_devicemanager_tclApp: Creation of SPM shutdown event failed!!!"));
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }

    // Activate Exception Handling
    /*bRetVal = exh_bInitExceptionHandling();
    if (TRUE != bRetVal)
    {
        //ETG_TRACE_ERR(("vd_devicemanager_tclApp: exh_bInitExceptionHandling failed"));
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }*/
    //May be used for future reference
    //OSAL_tProcessID pId = OSAL_ProcessWhoAmI();



    //vd_devicemanager_tclApp *poVdDeviceManagerApp = new vd_devicemanager_tclApp;

//-----------------------------------------------------------------------------------------
// Alternative: CCA based inteface including diagnosis - see vd_devicemanager/interface/DeviceManagerInterface_cca.cpp
//-----------------------------------------------------------------------------------------
#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCA


#ifdef VARIANT_S_FTR_ENABLE_PROCESS_READS_ITS_REGISTRY
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        //[GMP] take care that  ai_mediaplayer/config/packages/pkg_mediaplayer.xml installs this
        //[MMP] take care that ai_mediaplayer/MultiMediaPlayer/2_config/packages/pkg_mediaplayer.xml installs this
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t) "/dev/root/opt/bosch/base/registry/vd_devicemanager.reg")) == OSAL_OK)
        {
            ETG_TRACE_FATAL(("[OK]  REGISTRY loaded: /dev/root/opt/bosch/base/registry/vd_devicemanager.reg"));
        }
        else
        {
            ETG_TRACE_FATAL(("[NOK] REGISTRY failed to load: /dev/root/opt/bosch/base/registry/vd_devicemanager.reg"));
            ETG_TRACE_ERRMEM(("[NOK] REGISTRY failed to load: /dev/root/opt/bosch/base/registry/vd_devicemanager.reg"));
        }
    }
    OSAL_s32IOClose(regHandle);
#endif



    vd_devicemanager_tclApp *poVdDeviceManagerApp = vd_devicemanager_tclApp::GetInstance();

    if (NULL != poVdDeviceManagerApp)
    {
        if (!poVdDeviceManagerApp->bInitInstance(0, CCA_C_U16_APP_DEVICEMANAGER))
        {
            //poVdDeviceManagerApp->bInitInstance() failed!!!
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            //poVdDeviceManagerApp->bInitInstance() success!"
        }
    }
    else
    {
         DVM_NORMAL_M_ASSERT_ALWAYS();
    }

    // Wait for Shutdown-Signal
    OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR,
                     OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
    if (NULL != poVdDeviceManagerApp)
    {
        poVdDeviceManagerApp->vDeinitInstance();
        //DEL_M(poVdDeviceManagerApp);
        vd_devicemanager_tclApp::DestroyInstance();

    }

#endif //#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCA

//-------------------------------------------------------------------------------------------
// Alternative: DBUS  based inteface including diagnosis - see vd_devicemanager/interface/DeviceManagerInterface_dbus.cpp
//-------------------------------------------------------------------------------------------
#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_DBUS
    WorkThread *poWorkThread = new WorkThread();
    if (NULL != poWorkThread)
    {
        poWorkThread->bActivate();
    }
    else
    {
         DVM_NORMAL_M_ASSERT_ALWAYS();
    }

    // Wait for Shutdown-Signal
    OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR,
                     OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
    if (NULL != poWorkThread)
    {
        poWorkThread->bDeActivate();
        delete poWorkThread;
    }

#endif //#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_DBUS

//-----------------------------------------------------------------------------------------
// Alternative: CCA plus DBUS planned to be used to prepare WHITELABEL GMP
// Note: I assume for 'white label' even the CCA part will be switched off in future - then we'll have to take care another time
// it is not clear if CCADBUS should be always on e.g. for GMMY17 or RNAIVI etc. I'll check wiht Stefan Scherber
//-----------------------------------------------------------------------------------------
#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCADBUS
    vd_devicemanager_tclApp *poVdDeviceManagerApp = vd_devicemanager_tclApp::GetInstance();

    if (NULL != poVdDeviceManagerApp)
    {
        if (!poVdDeviceManagerApp->bInitInstance(0, CCA_C_U16_APP_DEVICEMANAGER))
        {
            //poVdDeviceManagerApp->bInitInstance() failed!!!
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            //poVdDeviceManagerApp->bInitInstance() success!"
        }
    }
    else
    {
         DVM_NORMAL_M_ASSERT_ALWAYS();
    }


    //Start DBus Server: This is done in Workthread since white label gmp will be started without any OSAL
    DeviceManagerDBusService::GetInstance().InitDBusServer();


    // Wait for Shutdown-Signal
    OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR,
                     OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
    if (NULL != poVdDeviceManagerApp)
    {
        poVdDeviceManagerApp->vDeinitInstance();
        //DEL_M(poVdDeviceManagerApp);
        vd_devicemanager_tclApp::DestroyInstance();

    }

    //Stop DBus Server
    DeviceManagerDBusService::GetInstance().StopDBusServer();

#endif //#ifdef IF_CCA

    //Prozess: Exiting...
    OSAL_s32EventClose(hEvShutdown);
    OSAL_s32EventDelete(EVENT_SHUTDOWN_NAME);
    et_vTraceClose();
    return s32RetVal;
}
#endif // VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS

////////////////////////////////////////////////////////////////////////////////
// <EOF>
