/*-----------------------------------------------------------------------------*
 * ICyclicDiagReceiver.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ICyclicDiagnosis.h
 *
 * \brief CyclicDiagThread cant send directly to VD_DeviceManager_clienthandlerDiaglog due to dependency with CCA
              for this reason this interface it sends collected diagnosis information to VD_DeviceManager_Main which maps it
              to cca types. Another advantage is that diagnosis functionality could be hifted to its own class without deendencies with cca
              thus it'll become testable
 *
 * \version 22.01.2016, Christian Koechling(CM/ESC3), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 
 */



#ifndef INTERFCACE_CYCLICDIAGRECEIVER_H
#define INTERFCACE_CYCLICDIAGRECEIVER_H  

#include "Config.h"
#include "Enums.h"
#include <vector>


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class ICyclicDiagnosis
 */

class ICyclicDiagReceiver
{
    public:

        /*!
         * \brief Destructor
         */
        virtual ~ICyclicDiagReceiver(){};
        
        /*!
         * \brief function receives this and maps result to corresponding cca types and sends it to local loop of VD_DeviceManager_Main local loop uses vd_devicemanager_clienthandler_diaglog to send it
            
         */
        virtual void ReceiveDiagResults(vector<trDtcCodeResult> ListCyclicDiagResults) = 0;


};
// class ICyclicDiagnosis

#endif // INTERFCACE_CYCLICDIAGRECEIVER_H  

////////////////////////////////////////////////////////////////////////////////
// <EOF>

