/*-----------------------------------------------------------------------------*
 * CyclicDiagThread.h                                               *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file CyclicDiagThread.h
 *
 * \brief Worker thread for device manager
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 *\version 22.01.2016, Christian Koechling (Bosch) 

 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  
 */

#ifndef __CYCLICDIAGTHREAD_H__
#define __CYCLICDIAGTHREAD_H__

/*-----------------------------------------------------------------------------*
 * Forward declarations                                                        *
 *-----------------------------------------------------------------------------*/
class ICyclicDiagnosis;
class ICyclicDiagReceiver;


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class CyclicDiagThread
 *
 * Worker thread for device manager for monitoring device connection/disconnection
 *
 * \see ahl_tclBaseCyclicDiagThread
 */
class CyclicDiagThread :public TFThread
{
   
    public:

        typedef enum
        {
            eThread_CyclicDiagThread = 0,
            eThread_Last             = 1
        }tenThreadFunction;

        typedef enum     //transition is off->started->running->stoppcalled-> off
        {
            eThread_off        = 0,
            eThread_started    = 1,
            eThread_running    = 2,
            eThread_stopcalled = 3
        }tenThreadState;
        /*! 
         * \brief Parameterized constructor
         *
         */
        CyclicDiagThread();

        /*! 
         * \brief Destructor
         *
         * \see ahl_tclBaseCyclicDiagThread::~ahl_tclBaseCyclicDiagThread()
         */
        virtual ~CyclicDiagThread();


    /**
        * This function derives from TFThread and starts a user function in a thread from the thread factory's thread pool.
        * After leaving while loop used thread is stopped and released for other users
        *
        * @return void
        */
        virtual void Do(int functionID, void *ptr);

        tVoid SetTimeout(unsigned int StartDelay_sec, unsigned int Interval_sec);

        tVoid SetEnableCyclicDiag(tBool bEnable);

        tVoid SetInterface(ICyclicDiagnosis    *pICyclicDiagnosis);  
        tVoid SetInterface(ICyclicDiagReceiver *pICyclicDiagReceiver);


                /*! 
         * \brief start worker thread
         *
         * \return TRUE: started FALSE if already started 
         */

        void Initialize();


     /*! 
         * \brief stop worker thread
         *
 
         */

        void Shutdown();


    protected:

        LockDVM m_LockThreadActive;

        /**< to mark if thread has been started already or not*/
        tenThreadState m_eThreadState;
        tBool m_bFirstDelayFinished;


        /**< interval for cyclic diagnosis*/
        unsigned int m_StartDelay_sec;
        unsigned int m_Interval_sec;

        tBool m_bDiagEnabled;
        ICyclicDiagnosis       *m_pICyclicDiagnosis;
        ICyclicDiagReceiver    *m_pICyclicDiagReveiver;


       /*! 
        * \brief Thread Function of worker thread
        */
       virtual tVoid vThreadFunction();  //lint !e1768 : virtual function has access private  (private) different from access (public) in the base class (ahl_trclBaseWorkthread) ///@todo replace by non OSALthread


}; //lint !e1712 : default contructor not defined 

#endif // __VD_DEVICEMANAGER_WORKERTHREAD_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>
