
/*-----------------------------------------------------------------------------*
 * DeviceManagerInterface.h                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : AID                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IDeviceManagerInterfaceStoreHistory.h
 *
 * \brief Interface to store notifications of service. Helps to analyse bugs. E.g. if notification is correct then 
 *          further bug analysis has to be done in Mediaplayer or other corresponding client. IF notification is incorrect
 *          further analysis has to be done in VD_DeviceManager or unserlying platform
 *
 * \version 27.11.2014, Christian Kchling (Bosch), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef _IDEVICEMANAGER_INTERFACE_STOREHISTORY_H_
#define _IDEVICEMANAGER_INTERFACE_STOREHISTORY_H_

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class IDeviceManagerInterfaceStoreHistory
 */


class IDeviceManagerInterfaceStoreHistory
{
  public:

    /*!
     * \brief Destructor
     *
     * \note This is private since its a singleton class
     */
    virtual ~IDeviceManagerInterfaceStoreHistory(){};



/*! 
* \brief used by the service implementation to store notification  send to clients.
*          This includes list of devices which have been send. And Vector with
*          USB Connector information like HW signals Untervoltge etc. 
*           Content of what has been send is taken from DeviceListManager and PropertyListManager
*        
* \param [IN] bSend: true: service has send it succesefully , false: error not send
*
*/
    IN virtual void StoreConnectionNotificationInHistory(tBool bSend) const = 0;


    /*! 
    * \brief used by the service implementation to store notification of internal SDCard - an interface which is used by diagnosis only
    *
    * \param [IN] bSend: true: service has send it succesefully , false: error not send
    *
    */

    IN virtual void StoreDiagSDCardNotificationInHistory(tBool bSend) const = 0;


}; // class Info_tclDmEolConfSettings

#endif //_IDEVICEMANAGER_INTERFACE_STOREHISTORY_H_

