/*-----------------------------------------------------------------------------*
 * DeviceManagerInterface                                                              *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     :G3G                                                     *
 * COPYRIGHT   : (c) 2014  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file DeviceManagerInterface_cca.cpp
 *
 * \brief decouple from special CCA-Solution - this is the cca-output wrapper
 *
* objective is to connect it to other IF-mechanism then CCA
 *
 * \version Initial Version: Koechling Christian (CM-AI/ECD1)
*
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */
/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_AILAHL
#define INCLUDE_VD_DVM_READREG
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;

#include <fstream>
#include <iostream>
#include <unistd.h> //for GCC 4.7.3 

//tbd.: Maintenance - one objective is to have only interfaces included here - to have less dependencies
#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"
#include "Diagnosis.h"
#include "UDevManager.h"
#include "StateTable.h"
#include "device/DeviceListManager.h"
#include "debug/TraceCmdManager.h"
#include "DeviceManager_ErrorCodes.h"

#include "debug/HistoryManager.h"
#include "interface/DeviceManagerInterface.h"

#include "WorkThread.h"


#include "diag/DiagLibHandlerGen2.h"
#include "client/VD_DeviceManager_clienthandler_Diaglog.h"
#include "client/VD_DeviceManager_clienthandler_VD_MediaManager.h"
#include "service/VD_DeviceManager_service_DeviceManager.h"
#include "VD_DeviceManager_main.h"

#include "diag/DiagTestMeasureResistance.h"
#include "config/ConfigurationManager.h"



/*-----------------------------------------------------------------------------*
* ETG Tracing                                                                 *
*-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER
#include "trcGenProj/Header/DeviceManagerInterface_cca.cpp.trc.h"
#endif  //VARIANT_S_FTR_ENABLE_TRC_GEN
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Structs                                                                     *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace statetbl;
using namespace configmgr;

/*-----------------------------------------------------------------------------*
 * tVoid DeviceManagerInterface::vInformClientsHWSignals(...)
 *-----------------------------------------------------------------------------*/
OUT tVoid DeviceManagerInterface::vInformClientsHWSignals() const //Roadmap 14003 Diagnosis2 (notfy PortStates)
{
    ETG_TRACE_USR4(("Begin: OUT vInformClientsHWSignals [cca]"));

    if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
    {
        vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager->RequestDeviceManagerNotifyConnectionStatus(NULL,NULL);
    }
    else
    {
        ETG_TRACE_FATAL(("[WARNING] vInformClientsHWSignals(): m_poDeviceManager is NULL"));
    }

    ETG_TRACE_USR4(("End  : OUT vInformClientsHWSignals [cca]"));
}

/*-----------------------------------------------------------------------------*
 * tVoid DeviceManagerInterface::vDiagMountCDRomResult(...)
 *-----------------------------------------------------------------------------*/
OUT tVoid DeviceManagerInterface::vDiagMountCDRomResult(IN tBool bResult,tBool bMount, IN std::string strDeviceName, IN std::string strMountPoint ) const//Roadmap 14002 MountCDROM (diagMixeMode)
{
    ETG_TRACE_USR4(("Begin: OUT vDiagMountCDRomResult [cca]"));

    tBool bSuccess = FALSE;

    ETG_TRACE_COMP(("vDiagMountCDRomResult: bResult      : 0x%x", bResult));
    ETG_TRACE_COMP(("vDiagMountCDRomResult: bMount       : 0x%x", bMount));
    //these parameters prepared for later usage
    ETG_TRACE_COMP(("vDiagMountCDRomResult: strDeviceName: %s",strDeviceName.c_str()));
    ETG_TRACE_COMP(("vDiagMountCDRomResult: strMountPoint: %s",strMountPoint.c_str()));

    //case mount
    if(TRUE == bMount)
    {
        ETG_TRACE_USR1(("**********************************"));
        if(TRUE == bResult)
        {
            ETG_TRACE_USR1(("RESULT for: MOUNT: OK - mounted"));
            bSuccess = TRUE;
        }
        else
        {
            ETG_TRACE_USR1(("RESULT for: MOUNT: NOK"));
        }
        ETG_TRACE_USR1(("**********************************"));
    }
    //cas umount
    else
    {
        ETG_TRACE_USR1(("**********************************"));
        if(TRUE == bResult)
        {
            ETG_TRACE_USR1(("RESULT for: UMOUNT: OK - unmounted"));
            bSuccess = TRUE;
        }
        else
        {
            ETG_TRACE_USR1(("RESULT for: UMOUNT: NOK"));
        }
        ETG_TRACE_USR1(("**********************************"));
    }


    //=====================
    //forward to service
    //=====================
    if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
    {
        vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager->vHandle_DeviceManagerMountCDRomInternal_MethodReturn(bSuccess);
    }
    else
    {
        ETG_TRACE_FATAL(("[WARNING] vDiagMountCDRomResult(): m_poDeviceManager is NULL"));
    }

    ETG_TRACE_USR1(("vDiagMountCDRomResult: bSuccess:0x%x",bSuccess));
    ETG_TRACE_USR4(("End  : OUT vDiagMountCDRomResult [cca]"));
}

/*-----------------------------------------------------------------------------*
 * void DeviceManagerInterface::InformClients(...)
 *-----------------------------------------------------------------------------*/
OUT void DeviceManagerInterface::vInformClients(structNotifyClients &f_oNotifyClients, tBool bTest) const
{
    ETG_TRACE_USR4(("Begin: vInformClients bTest:0x%x [cca]",bTest));

    if(FALSE == bTest) //@todo check if this is necessary in test mode I don't want to manipulate lsit entries of udev manager
    {
        DeviceListManager::GetInstance()->Set_eConnectStatus(DEVLIST_UDEVMGR,&f_oNotifyClients); //@todo chang eot use references
        DeviceListManager::GetInstance()->Set_eConnectStatus(DEVLIST_STATETABLE,&f_oNotifyClients); //tbd.: check this for Roadmap 13035 maybe another parameter has to be used
    }
    ETG_TRACE_COMP(("vInformClients [cca]"));

    if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
    {
        vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager->RequestDeviceManagerNotifyConnectionStatus(&f_oNotifyClients,StateTable::GetInstance());
    }
    else
    {
        ETG_TRACE_FATAL(("[WARNING] vInformClients(...): m_poDeviceManager is NULL"));
    }

    ETG_TRACE_USR4(("End  : vInformClients [cca]"));
}

//#ifdef REFACTOR_STATETABLE_OUTPUT
/*-----------------------------------------------------------------------------*
 * void DeviceManagerInterface::InformClients(...)
 *-----------------------------------------------------------------------------*/
OUT void DeviceManagerInterface::vInformClients() const
{
    ETG_TRACE_USR4(("Begin: vInformClients() [cca]"));

    if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
    {
        vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager->RequestDeviceManagerNotifyConnectionStatus();
    }
    else
    {
        ETG_TRACE_FATAL(("[WARNING] vInformClients(): m_poDeviceManager is NULL"));
    }

    //store in History
    DeviceManagerInterface::GetInstance()->StoreConnectionNotificationInHistory(true);

    ETG_TRACE_USR4(("End: vInformClients() [cca]"));

}
//#endif
/*-----------------------------------------------------------------------------*
 *  tVoid DeviceManagerInterface::InformClientsCard(...)
 *-----------------------------------------------------------------------------*/
OUT void DeviceManagerInterface::vInformClientsCard( ) const
{
    ETG_TRACE_USR4(("Begin: InformClientsCard [cca]"));

    ETG_TRACE_COMP(("InformClientsCard: Inform DVM Service"));
    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_PRM_SDCARDSIGNALS))
    {
        ETG_TRACE_USR4(("vInformClientsCard: call RequestDeviceManagerNotifyStatusCard"));
        if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
        {
            vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager->RequestDeviceManagerNotifyStatusCard(  );
        }
        else
        {
            ETG_TRACE_FATAL(("[WARNING] vInformClientsCard(): m_poDeviceManager is NULL"));
        }
        DeviceManagerInterface::GetInstance()->StoreDiagSDCardNotificationInHistory(true);
    }
    else
    {
        ETG_TRACE_USR4(("vInformClientsCard: eConf_ENABLE_USE_PRM_SDCARDSIGNALS disabled"));
    }

    ETG_TRACE_USR4(("End  : InformClientsCard [cca]"));
}


/*-----------------------------------------------------------------------------*
 *   IN tVoid DeviceManagerInterface::bDiagEnable(...)
 *-----------------------------------------------------------------------------*/
IN tVoid DeviceManagerInterface::vDiagEnable(tBool bEnable) const
{
    ETG_TRACE_USR4(("Begin: bDiagEnable [cca]"));
    vd_devicemanager_tclApp::GetInstance()->diagEnable(bEnable);
    ETG_TRACE_USR4(("End  : bDiagEnable [cca]"));
}

/*-----------------------------------------------------------------------------*
 *   OUT DeviceManagerInterface::bGetDiagEnable()
 *-----------------------------------------------------------------------------*/
OUT tBool DeviceManagerInterface::bGetDiagEnable() const
{
    ETG_TRACE_USR4(("Begin: vDiaglogStartUsbOcTimer [cca]"));
    
    tBool bRet = vd_devicemanager_tclApp::GetInstance()->bGetDiagEnable();

    ETG_TRACE_USR4(("End  : vDiaglogStartUsbOcTimer [cca]"));
    return bRet;
}

/*-----------------------------------------------------------------------------*
 *   IN tVoid DeviceManagerInterface::vStartUsbOcTimer(...)
 *-----------------------------------------------------------------------------*/
IN tVoid DeviceManagerInterface::vDiaglogStartUsbOcTimer() const
{
    ETG_TRACE_USR4(("Begin: vDiaglogStartUsbOcTimer [cca]"));

    if(vd_devicemanager_tclApp::GetInstance()->m_poClientHandlerDiaglog)
    {
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_DIAGLOG_DTC_TRIGGERED_HWSIGNALS))
        {
            vd_devicemanager_tclApp::GetInstance()->m_poClientHandlerDiaglog->vStartUsbOcTimer( ); // Start timer to get the actual status after 3s of no changes
        }
    }

    ETG_TRACE_USR4(("End  : vDiaglogStartUsbOcTimer [cca]"));
}

/*-----------------------------------------------------------------------------*
 *   IN tVoid DeviceManagerInterface::vSetServiceAvailable(...)
 *-----------------------------------------------------------------------------*/
IN tVoid DeviceManagerInterface::vSetServiceAvailable(tBool bAvailable) const
{
    ETG_TRACE_USR4(("Begin: vSetServiceAvailable [cca]"));

    if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
    {
        vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager->vSetServiceAvailable(bAvailable);
    }
    else
    {
        ETG_TRACE_FATAL(("[WARNING] vSetServiceAvailable(): m_poDeviceManager is NULL"));
    }
    

    ETG_TRACE_USR4(("End  : vSetServiceAvailable [cca]"));
}


/*-----------------------------------------------------------------------------*
 *   IN tVoid DeviceManagerInterface::vConnectClients(...)
 *-----------------------------------------------------------------------------*/
IN tVoid DeviceManagerInterface::vConnectClients(tBool bConnect) const
{
    ETG_TRACE_USR4(("Begin: vConnectClients [cca]"));
    if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
    {
        vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager->connectClients(bConnect);
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] vConnectClients: vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager == NULL"));
    }
    ETG_TRACE_USR4(("End  : vConnectClients [cca]"));
}


/*-----------------------------------------------------------------------------*
 *   IN tVoid DeviceManagerInterface::vConnectClients(...)
 *-----------------------------------------------------------------------------*/
IN tVoid DeviceManagerInterface::vOnDiagnosisProductionLineTEST() const
{
    ETG_TRACE_USR4(("Begin: vOnDiagnosisProductionLineTEST [cca]"));

    if(vd_devicemanager_tclApp::GetInstance()->m_poDmDiagLibHandlerGen2)
    {
        vd_devicemanager_tclApp::GetInstance()->m_poDmDiagLibHandlerGen2->vOnDiagnosisDataWriteTEST();
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] vOnDiagnosisProductionLineTEST: vd_devicemanager_tclApp::GetInstance()->m_poDmDiagLibHandlerGen2 == NULL"));
    }

    ETG_TRACE_USR4(("End  : vOnDiagnosisProductionLineTEST [cca]"));
}



/*-----------------------------------------------------------------------------*
 * tVoid vSend_CDEject_MethodResult(IN CDEjectMethodResult e8CDEjectResult)                                    *
 *-----------------------------------------------------------------------------*/
IN tVoid DeviceManagerInterface::vSendOpticalDiscEjectMethodResult(IN tOpticalDiscEjectMethodResult e8OpticalDiscEjectResult)//Roadmap 15002 CD Audio device Detection
{
    ETG_TRACE_USR4(("Begin  : vSendOpticalDiscEjectMethodResult"));

    vd_devicemanager_tclService_DeviceManager *l_poDeviceManager = NULL;


    if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
    {
        l_poDeviceManager = vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager;
    }
    else
    {
        ETG_TRACE_FATAL(("[WARNING] vSendOpticalDiscEjectMethodResult(): m_poDeviceManager is NULL"));
    }

    if(l_poDeviceManager)
    {
        l_poDeviceManager->vSendOpticalDiscEjectMethodResult(e8OpticalDiscEjectResult);
    }

    ETG_TRACE_USR4(("End  : vSendOpticalDiscEjectMethodResult"));
}



/*-----------------------------------------------------------------------------*
 * tVoid vSendOpticalDiscEjectRequest(...)                                               *
 *-----------------------------------------------------------------------------*/
tVoid DeviceManagerInterface::vSendOpticalDiscEjectRequest(tDMOpticalDiscEjectCmd enCmdParam)
{
    ETG_TRACE_USR4(("Begin  : vSendOpticalDiscEjectRequest enCmdParam:%d",ETG_CENUM(tDMOpticalDiscEjectCmd,enCmdParam)));

    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_INTERNAL_CDDA))
    {
        VD_DeviceManager_clienthandler_VD_MediaManager *l_pclienthandler_VD_MediaManager = vd_devicemanager_tclApp::GetInstance()->GetMediaManagerClientHandlerInstance();
        if(l_pclienthandler_VD_MediaManager)
        {
            switch(enCmdParam)
            {
                case DM_OPTDISC_CMD_EJECT:
                    l_pclienthandler_VD_MediaManager->vSendOpticalDiscEject();
                    break;
                case DM_OPTDISC_CMD_INSERT:
                    l_pclienthandler_VD_MediaManager->vSendOpticalDiscInsert();
                    break;
            }
        }
    }
    ETG_TRACE_USR4(("End  : vSendOpticalDiscEjectRequest"));

}
/*----------------------------------------------------------------------------------*
 * tVoid vInformClientsOpticalDiscSlotState(...) *                                              *
 *----------------------------------------------------------------------------------*/
tVoid DeviceManagerInterface::vInformClientsOpticalDiscSlotState(IN const tDMOpticalDiscSlotState  eOpticalDiscSlotState) const
{
	ETG_TRACE_USR4(("Begin  : vInformClientsOpticalDiscSlotState"));
    if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
    {
	    vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager->RequestDeviceManagerNotifyOpticalDiscSloteState( eOpticalDiscSlotState);
    }
    else
    {
        ETG_TRACE_FATAL(("[WARNING] vInformClientsOpticalDiscSlotState(): m_poDeviceManager is NULL"));
    }
    ETG_TRACE_USR4(("End  : vInformClientsOpticalDiscSlotState"));
}

/*----------------------------------------------------------------------------------*
 * tVoid vInformClientsOpticalDiscCDInfo(...) *                                              *
 *----------------------------------------------------------------------------------*/
tVoid DeviceManagerInterface::vInformClientsOpticalDiscCDInfo(IN const trOpticalDiskCDInfo  f_OpticalDiskCDInfo) const
{
    ETG_TRACE_USR4(("Begin  : vInformClientsOpticalDiscCDInfo"));
    if(vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager)
    {
        ETG_TRACE_USR4(("vInformClientsOpticalDiscCDInfo f_OpticalDiskCDInfo.OpticalDriveVersion:%s",f_OpticalDiskCDInfo.OpticalDriveVersion))
        vd_devicemanager_tclApp::GetInstance()->m_poDeviceManager->RequestDeviceManagerNotifyOpticalDiscCDInfo( f_OpticalDiskCDInfo);
    }
    else
    {
        ETG_TRACE_FATAL(("[WARNING] vInformClientsOpticalDiscCDInfo(): m_poDeviceManager is NULL"));
    }
    ETG_TRACE_USR4(("End  : vInformClientsOpticalDiscCDInfo"));
}

