//ROADMAP13035_Overtemp



/*-----------------------------------------------------------------------------*
 * DeviceManagerInterface.h                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManger.h
 *
 * \brief Implementation of Interface of VD_DEviceManager used by clients - this is mainly used by CCA-VD_DeviceManagerService
 *
 * \version 10.02.2014, Christian K�chling (Bosch), version 1.0
 *          Initial version to serve ROADMAP13035_Overtemp and to make a refactoring

 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef _DEVICEMANAGER_INTERFACE_H_
#define _DEVICEMANAGER_INTERFACE_H_


/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/




/*-----------------------------------------------------------------------------*
 * namespaces                                                                     *
 *-----------------------------------------------------------------------------*/
using namespace statetbl;


/*-----------------------------------------------------------------------------*
 * Forward declarations                                                        *
 *-----------------------------------------------------------------------------*/
class vd_devicemanager_tclApp;
class DiagTestMeasureResistance;


/*-----------------------------------------------------------------------------*
 * includes                                                        *
 *-----------------------------------------------------------------------------*/
#include "interface/IDeviceManagerInterfaceGeneral.h"
#include "interface/IDeviceManagerInterfaceInternal.h"
#include "interface/IDeviceManagerInterfaceDiagnosis.h"
#include "interface/IDeviceManagerInterfaceStoreHistory.h"

#include "platform/IPrmManager.h"
#include "platform/IVoltageManager.h"



/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class Info_tclDmEolConfSettings
 */


class DeviceManagerInterface: public IDeviceManagerInterfaceGeneral,
        public IDeviceManagerInterfaceDiagnosis,
        public IDeviceManagerInterfaceInternal,
        public IDeviceManagerInterfaceStoreHistory
{
public:

    /*!
     * \brief Get singleton object
     *
     * \return DeviceManagerInterface*
     */
    static DeviceManagerInterface * GetInstance(); //Roadmap_13035_Overtemp

    /*!
     * \brief Destroys singleton object
     */
    static void  DestroyInstance();//Roadmap_13035_Overtemp

    /*!
     * \brief Assignment Operator
     *
     * \note This is a technique to disable the assignment operator for this
     *       class. So if an attempt for the assignment is made compiler
     *       complains.
     */
    DeviceManagerInterface& operator=
    (const DeviceManagerInterface &oClientHandler);


    //-----------------------------------------------------
    //see IDeviceManagerInterfaceDiagnosis for details
    //-----------------------------------------------------
    OUT virtual tVoid vDiagMountCDRomResult(OUT tBool bResult,tBool bMount, IN std::string strDeviceName, IN std::string strMountPoint) const; //Roadmap 14002 MountCDROM (diagMixeMode)
    IN  virtual tVoid vDiagMountCDRom(IN tBool bMount, OUT const std::string &strDeviceName /*e.g. /dev/sr0*/) const; //Roadmap 14002 MountCDROM (diagMixeMode)
    IN  virtual tVoid vDiagEnable(tBool bEnable) const;
    IN  virtual tVoid vDiaglogStartUsbOcTimer() const;
    OUT virtual tVoid vSendResistanceUSBConnector_Result(IN tenResultResistance enResultResistance, tenDevManagerUSBHost enUSBConnector, IN tU32 u32SendID); //Roadmap 14003 Measure resistance of USB-connector (VAGMIBE)
    IN  virtual tVoid vOnDiagnosisProductionLineTEST() const;
    OUT virtual tBool bGetUSBHardwareConnector(IN tenDevManagerUSBHost eUSBConnectorNum,OUT tenSignalValue &eActivated) const;//Roadmap 14003 ReadUSBPowerSupply_Activated/Deactivated
    IN  virtual tBool bInitUSBHardwareConnectors() const;//Roadmap 14003 ReadUSBPowerSupply_Activated/Deactivated
    IN  virtual tBool bSetUSBHardwareConnector(IN tenDevManagerUSBHost eUSBConnectorNum,IN tBool bOn) const;//Roadmap 14003 SetUSBPowerSupply_Activated/Deactivated
    IN  virtual tBool bStartMeasureResistanceUSBConnector(IN tenDevManagerUSBHost enUSBConnector, tU32 ureSendID); //Roadmap 14003 Measure resistance of USB-connector (VAGMIBE)
#ifdef USE_FOURTH_USB_CONNECTOR
    OUT virtual tBool bGetDiagnosis(CGlobalEnumerations::Diag_Type_e eDiagType, CUSBDiagnosis &f_objUSBDiagnosisHUB1, CUSBDiagnosis &f_objUSBDiagnosisHUB2, CUSBDiagnosis &f_objUSBDiagnosisHUB3, CUSBDiagnosis &f_objUSBDiagnosisHUB4) const;
#else
    OUT virtual tBool bGetDiagnosis(CGlobalEnumerations::Diag_Type_e eDiagType, CUSBDiagnosis &f_objUSBDiagnosisHUB1, CUSBDiagnosis &f_objUSBDiagnosisHUB2, CUSBDiagnosis &f_objUSBDiagnosisHUB3) const;
#endif
    OUT virtual tBool bGetDiagEnable() const;
    OUT virtual tBool bGetSdcDiagnosis( tenSlot eSdcSlot, const tBool& bSdcOcActive ) const;
    OUT virtual bool  IsCriticalVoltage();

    /*!
     * \brief Get the connection status of BTA telematics box
     *
     * \note
     *
     *       This function will be accessed by diaglog client handler periodically and check the connection to BTA box from the application layer is still active
     */
    OUT virtual tVoid  vIsBTABoxAlive(INOUT BTAMonitorStates &eBTAMonitoringState,OUT bool &bisBTAAlive) const;


    //-----------------------------------------------------
    //see IDeviceManagerInterfaceInternal  for details
    //-----------------------------------------------------
    INTERN virtual tVoid vConnectClients(tBool bConnect) const;

    //-----------------------------------------------------
    //see IDeviceManagerInterfaceGeneral  for details
    //-----------------------------------------------------
    INTERN virtual tVoid vSetServiceAvailable(tBool bAvailable) const;
    OUT    virtual tVoid vInformClients(structNotifyClients &f_oDevice, tBool bTest) const;
    OUT    virtual tVoid vInformClientsHWSignals() const; //Roadmap 14003 Diagnosis2 (notify PortStates)
    OUT    virtual tVoid vInformClientsCDDriveOvertemp(structNotifyClients &f_oDevice) const; //Roadmap_13035_Overtemp
    OUT    virtual tVoid vInformClientsCard( ) const;
    //#ifdef REFACTOR_STATETABLE_OUTPUT
    OUT    virtual tVoid vInformClients() const;
    //#endif
    IN     virtual tVoid vSetOverTemperatureCDDrive(IN tBool bOverTemperature); //Roadmap 13035 Over temperature

    IN     virtual tVoid vSetTelematicsBoxApplicationLayerAlive(IN tBool bIsBTAAlive,IN tU32 u32TimoutBeforeSendingITC);
    IN     virtual bool getDeviceProperties(const GENSTRING f_ucDeviceSerial, CDevice& f_objDevice) const;
    INOUT  virtual StateTable* getAllConnectedDevices(vector<structNotifyClients> &f_vConnectedDevices) const;

    //-----------------------------------------------------
    //see IDeviceManagerInterfaceStoreHistory  for details
    //-----------------------------------------------------
    IN virtual void StoreConnectionNotificationInHistory(tBool bSend) const;
    IN virtual void StoreDiagSDCardNotificationInHistory(tBool bSend) const;




    //-----------------------------------------------

    /*!
     * \brief command to inject PrmManager interface
     *
     * injected interface is e.g. used to test commands of prm e.g. get SDCard info normaly triggered by diagnosis
     *
     */
    IN tVoid SetPrmManagerIF(IN IPrmManager *f_pIPrmManager);

    /*!
     * \brief command to inject VoltageManager interface
     *
     * injected interface is e.g. used to test commands of prm e.g. get SDCard info normaly triggered by diagnosis
     *
     */
    IN tVoid SetVoltageManagerIF(IN IVoltageManager *f_pIVoltageManager);

    /*!
     * \brief to get the device speed of BTA device
     *
     *\param [IN] f_TelematicsBoxSpeedAndPortInfo Contains the device speed of BTA device
     *
     */

     IN virtual  tVoid vFillDeviceSpeedinfo(INOUT TelematicsBoxSpeedAndPortInfo f_TelematicsBoxSpeedAndPortInfo[ARRAYSIZEFORUSB]);

    /*!
     * \brief to send method result of  CD eject to service
     *
     *\param [IN] e8CDEjectResult contains the info whether the Mediamanager accepted, reject or not ready to accept the cd eject
     *
     */
     IN tVoid vSendOpticalDiscEjectMethodResult(IN tOpticalDiscEjectMethodResult e8OpticalDiscEjectResult);//Roadmap 15002 CD Audio device Detection




    /*!
     * \brief to send the cdda device eject request from Service to client handler of media manager.
     *
     *\param [IN]enCmdParam: insert or eject optical disc
     */
    IN  tVoid vSendOpticalDiscEjectRequest(tDMOpticalDiscEjectCmd enCmdParam);//Roadmap 15002 CD Audio device Detection


    /*!
     * \brief to send the cdda device slot status to interface
     *
     *\param [IN]tDMOpticalDiscSlotState CDDA Slot state
     *
     */
    IN  tVoid vInformClientsOpticalDiscSlotState(IN const tDMOpticalDiscSlotState  eOpticalDiscSlotState) const;

    /*!
     * \brief to send the cdda device CD Info to interface
     *
     *\param [IN]trOpticalDiskCDInfo CDDA CD Info
     *
     */
    IN  tVoid vInformClientsOpticalDiscCDInfo(IN const trOpticalDiskCDInfo  f_OpticalDiskCDInfo) const;
    /*!
     * \brief to get OverTemperature Status of internal CDDrive
     *
     *\return True means internal optical disc has over temperature
     *
     */
    OUT tBool bGetOverTemperatureCDDriveStatus();


    /*!
     * \brief to get TelematicsBoxApplicationLayerAlive Status
     *
     *\return True means internal TelematicsBoxApplicationLayer is Alive
     *
     */
    OUT tBool bGetTelematicsBoxApplicationLayerAliveStatus();

    /*!
     * \brief to add/update/remove TelematicsBox element from datapool
     *
     *\return True means internal AddTelematicsBox is success-Added/updated/removed
     *
     *param [IN]l_uiTelematicsBoxDeviceInfo TelematicsBox structure
     *param [IN]bAdd Add/update or remove boolean
     *
     */
    OUT tBool AddTelematicsBox(IN trTelematicsBoxDeviceInfo l_uiTelematicsBoxDeviceInfo,IN tBool bAdd);

    /*!
     * \brief to add/update/remove Externalhub element from datapool
     *
     *\return True means internal AddExternalHub is success-Added/updated/removed
     *
     *param [IN]l_uiExternalHubInfo ExternalHub structure
     *param [IN]bAdd Add/update or remove boolean
     *
     */
    OUT tBool AddExternalHub(IN trExternalHubInfo l_uiExternalHubInfo,IN tBool bAdd);

	 /*!
     * \brief to set the DVDDriveInfo
     *
     *\return 
     *
     *param [IN]f_rDVDDriveInfo DVDDriveInfo
     *
     */
    tVoid vSetDVDDriveInfo(IN trDVDDriveInfo f_rDVDDriveInfo);



protected:

    IPrmManager     *m_pIPrmManager;
    IVoltageManager *m_pIVoltageManager;

private:

    typedef struct{
        tU32                      u32SendID;
        tenDevManagerUSBHost      eUSBConnector;
        DiagTestMeasureResistance *pThreadPointer;
    }trTestThreadInfo;

    DeviceManagerInterface::trTestThreadInfo m_rArrayDiagTestMeasureResistance[ARRAYSIZEFORUSB];

    //Singleton helper
    static DeviceManagerInterface *m_pDeviceManagerInterface;
    static DVMLOCK                 m_singelton;

    //to store connection status about the BTA BOX. This information will be received from the FC_ATB.
    tBool m_bIsBTAAlive;

    //to store the Over Temperature status of internal optical drive
    tBool m_bOverTemperature;

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
public: /*to make it mockable in tests* (constructor, destructor must be public then) - note better use in the future interface injection instead of to many singletons*/
#endif

    /*!
     * \brief Default constructor
     *
     * \note This is private since its a singleton class
     */
    DeviceManagerInterface();

    /*!
     * \brief Destructor
     *
     * \note This is private since its a singleton class
     */
    virtual ~DeviceManagerInterface();

}; // class Info_tclDmEolConfSettings

#endif // _DEVICEMANAGER_INTERFACE_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>

