/*-----------------------------------------------------------------------------*
 * dpelements.h                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file dpelements.h
 *
 * \brief Definition of structures for datapool usage
 *
 * \version 11.08.2016, Ganesh Rengasamy (Bosch), version 1.0
 *          Initial version
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef DP_ELEMENTS_H
#define DP_ELEMENTS_H
#define VD_DEVICEMANAGER_S_IMPORT_INTERFACE_DP_VD_DEVICEMANAGER

/*!
     * \struct trDPExternalHubInfo
     *
     * Holds information about the External Hubs attached. It is used during writing/reading to datapool.
     *
     */
typedef struct
{
    tU16 u16VendorID;    //uint16_t iVendorID;
    tU16 u16ProductID;    //uint16_t iProductID;
    tU8 u16USBConnector;    //statetbl::tenDevManagerUSBHost eUsb;

}trDPExternalHubInfo;

/*!
     * \struct trDPTelematicsBoxDeviceInfo
     *
     * Holds information about the Telematics Boxes attached. It is used during writing/reading to datapool.
     *
     */
typedef struct
{
    tU16 u16VendorID;    //uint16_t iVendorID;
    tU16 u16ProductID;    //uint16_t iProductID;
    tBool bIsHighSpeedExpected;
    tU8 u16USBConnector;   //statetbl::tenDevManagerUSBHost eUsb;
}trDPTelematicsBoxDeviceInfo;

#endif // DP_ELEMENTS_H
////////////////////////////////////////////////////////////////////////////////
// <EOF>
