/*-----------------------------------------------------------------------------*
 * DiagTestMeasureResistance.h                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file DiagTestMeasureResistance.h 
 *
 * \brief stores HW-Signals like PPON, OC, Undervoltage etc.  (please refer to struct trPortStates see common/enums.h)
 *
 * \version 26.03.2014, Christian Kchling (Bosch), version 1.0
 *          Initial version 
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef DIAGTEST_MEASURERESISTANCE_BASE_H
#define DIAGTEST_MEASURERESISTANCE_BASE_H

/*-----------------------------------------------------------------------------*
 *defines
 *-----------------------------------------------------------------------------*/
#define NUM_OF_MEASURE   (tUInt)10  /*10 times measure - basis for average*/

/*-----------------------------------------------------------------------------*
 * unsing namespace                                                               *
 *-----------------------------------------------------------------------------*/
using namespace statetbl; 

/*-----------------------------------------------------------------------------*
 * class declaration                                                                *
 *-----------------------------------------------------------------------------*/
class DiagTestMeasureResistance: public ahl_tclBaseWorkThread
{
    public:

        typedef enum 
          {
              enUndefined    = 0,
              enRunning      = 1,
              enAbort        = 2,
              enFinished     = 3
          }tenThreadState;


        /*!
        * \brief constructor of object - is private for singleton class 
        *
        */
        DiagTestMeasureResistance(vd_devicemanager_tclApp *f_poMainApp, tenDevManagerUSBHost f_eUsbConnector,tU32 f_u32SendID);
    
        //-----------functions-------------------------------
        /*!
        * \brief destructor of object - is private for singleton class 
        *
        */
        virtual ~DiagTestMeasureResistance();


        /*!
        * \brief blocks until the thread has finished its work
        *
        */
        tVoid vWaitFinishThread();


        tVoid vCalcAverageResistance(OUT DeviceManagerInterface::tenResultResistance enResultResistance,IN tU32 (&u32ResultMeasurement)[NUM_OF_MEASURE]);

        tVoid vMeasureResistance(OUT tInt &f_iResultMeasurement_milliVolt,IN tenDevManagerUSBHost f_eUsbConnector);


    private:
        vd_devicemanager_tclApp m_poMainApp;
        tU32                    m_u32SendID;
        tenThreadState          m_enThreadState;
        tenDevManagerUSBHost    m_eUsbConnector;

        /*! 
            * \brief Thread Function of worker thread
            */
           virtual tVoid vThreadFunction();  //lint !e1768 : virtual function has access private  (private) different from access (public) in the base class (ahl_trclBaseWorkthread) ///@todo replace by non OSALthread

};

#endif // DIAGTEST_MEASURERESISTANCE_BASE_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

