/************************************************************************
* FILE:         DiagLibHandler
* PROJECT:      
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:
/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file DiagLibHandler.h
 *
 * \brief Diaglib Handler to receive comands from FC_Diagnosis
 *
 * \version 31.03.2014, Christian Koechling CM_AI/ECD1
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */


#ifndef DIAGLIB_GEN3_HANDLER_H
#define DIAGLIB_GEN3_HANDLER_H

/*-----------------------------------------------------------------------------*
 * Forward declarations                                                        *
 *-----------------------------------------------------------------------------*/
class vd_devicemanager_tclApp;

/*-----------------------------------------------------------------------------*
 * class                                                                       *
 *-----------------------------------------------------------------------------*/

/**
 * Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classe that handles requests for two different routines.
 */
// +++ Adjust class prefix +++
class DiaglibHandlerGen3: public IDiagLibHandler
{
public:
    // +++ Depending on the type of listener you need the associated interface to send responses +++
 
    DiaglibHandlerGen3(vd_devicemanager_tclApp *poMainApp, diaglib::tclServiceDiaglib* pDiaglibService);
    virtual ~DiaglibHandlerGen3();

    //----------------------------------
    //origin in tclRoutineControlListenerIF
    //----------------------------------
    virtual tU32 vOnGetRoutineResult ( tU32 u32RoutineId,diaglib::tContext MsgContext); 
    virtual tU32 vOnRoutineControlAbort (tU32 u32RoutineId,diaglib::tContext MsgContext);
    virtual tU32 vOnRoutineControlStart (tU32 u32RoutineId,tU32 u32Bitmask, const diaglib::tclParameterVector& oParameterVector,diaglib::tContext MsgContext);

    //----------------------------------
    //origin in tclIoControlListenerIF
    //----------------------------------
    virtual tU32 vOnIoControl (tU32 u32IoControlId,diaglib::tenIoControlAction enActionId, const diaglib::tclParameterVector& oParameterVector,diaglib::tContext MsgContext);
    virtual tU32 vOnIoControlFreeze (tU32 u32IoControlId,diaglib::tContext MsgContext);
    virtual tU32 vOnIoControlUnfreeze (tU32 u32IoControlId,diaglib::tContext MsgContext);

    //----------------------------------
    //origin in tclDiagnosisDataListenerIF
    //----------------------------------
    virtual tU32 vOnDiagnosisDataWrite(tU32 /*u32DiagDataId*/,const diaglib::tclParameterVector& /*rfcoParamVector*/,diaglib::tContext /*MsgContext*/);
    virtual tU32 vOnDiagnosisDataRead(tU32 u32DiagDataId, diaglib::tContext MsgContext);

protected:
    tVoid vAddPartialResult(IN tenDevManagerUSBHost i, IN tBool bActivated);
    tVoid vClearArray(); 

           /*!
         * \brief find out if certain USBConnector should be switched active/inactive in dependency of bitfied
         *
         * \param [in] eUsbConnector                     e.g. eUSB1, eUSB2
         * \param [in] u32DiaglibMediaStatusBits    bitfield contains info which USB connectors should be set active
         *
         * \return TRUE if eUsbConnector should be set active otherwhise FALSE
         */
    tBool bGetUSBActive(IN tenDevManagerUSBHost eUsbConnector, IN tU32 u32DiaglibMediaStatusBits) const;

      /*!
    * \brief find out if certain USBConnector should be switched active/inactive in dependen?????fied
    *
    * \param [in] eUsbConnector                     e.g. eUSB1, eUSB2
    * \param [INOUT] u32DiaglibMediaStatusBits    bitfield contains info which USB connectors should be set active
    *
    * \return TRUE if eUsbConnector should be set active otherwhise FALSE
    */

    tBool SetUSBActive(IN tenDevManagerUSBHost eUsbConnector, IN tBool bOn, INOUT  tU32 &u32DiaglibMediaStatusBits_Result) const;
           
             /*!
           * \brief find out if certain USBConnector should be tested or not
           *
           * \param [in] eUsbConnector                     e.g. eUSB1, eUSB2
           * \param [in] u32DevicesToTestBits    bitfield contains info which USB connectors should be tested
           *
           * \return TRUE if eUsbConnector should be set active otherwhise FALSE
           */
    tBool bGetUSBDeviceToTest(IN tenDevManagerUSBHost eUsbConnector, IN tU32 u32DevicesToTestBits) const;

        /*!
      * \brief find out if certain USBConnector should be changed status or not in dependency of bitfield
      *
      * \param [in] eUsbConnector                     e.g. eUSB1, eUSB2, eUSB3
      * \param [in] u32DiaglibMediaStatusBits    bitfield contains info which USB connectors should be allowed to change status
      *
      * \return TRUE if eUsbConnector can be changed status else dont care
      */
    tBool bCheckUSBChangeStatus(IN tenDevManagerUSBHost eUsbConnector, IN tU32 u32DiaglibMediaStatusBits) const;

private:
    vd_devicemanager_tclApp    *m_poMainApp;
    diaglib::tclServiceDiaglib *m_pDiaglibService;
    tenSignalValue              m_eArrUSBPowerActivated[ARRAYSIZEFORUSB];
    tBool                       m_bArrUSBPowerActivated[ARRAYSIZEFORUSB];
    tBool                       m_bRetUSBPowerActivated[ARRAYSIZEFORUSB];
    tU32                        m_u32SendID;

    DiaglibHandlerGen3();


};
#endif // DIAGLIB_GEN3_HANDLER_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

