/*-----------------------------------------------------------------------------*
 * Diagnosis.h                                                                 *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file Diagnosis.h
 *
 * \brief This file holds all the user defined enumerations that will be used
 *        across the project of the allocated memory,
 *
 * \version 17.01.2012, Koechling, Christian (Bosch), adjusted names for
 *          DTC-Diag values m_eUSB_HUB_SEARCH,m_iUSBNoOfPortsFoundAtHub
 * \version 07.03.2012, Koechling, Christian (Bosch), merged MV-code Feb27 -
 *          contains issue for startup synchronization
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 *\version 23.10.2013, Christian Koechling (Bosch) 
 *         -# start tp replace QStrings by replacing QString by define GENSTRING
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef DIAGNOSIS_H
#define DIAGNOSIS_H

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class CUSBDiagnosis
 */
 //lint -sem(CUSBDiagnosis::clear,initializer)
class CUSBDiagnosis
{
    private:
        // no members in private

    protected:
        // no members in protected

    public:

        //-----------------
        //udev related info
        //-----------------
        GENSTRING m_cVendor;
        GENSTRING m_cSerialID;   
        GENSTRING m_cUSBPortNo;       //e.g. either Hardwareport USB1 or 2   
        GENSTRING m_cDeviceName;
        GENSTRING m_cMountPoint;     
        GENSTRING m_cDeviceVersion;
        
        CGlobalEnumerations::DEVICE_TYPE_Type m_eDeviceType;
                                          
        int m_iVersion;
        tBool m_bHUBHasCardReader;
        unsigned int m_iUSBNoOfPortsFoundAtHub;
        CGlobalEnumerations::HUB_SEARCHRESULT_Type m_eUSB_HUB_SEARCH;
        
        unsigned long m_ulSize;

        //----------------------
        //prm related info      
        //----------------------
        tenSignalValue   m_enOC;   
        tenSignalValue   m_enPPON;
        tenSignalValue   m_enU60_drop;
        tenSignalValue   m_enMountedUSB; 
        tenSignalValue   m_enU50_USB_Reset;  
    
        DEVICE_CONNECTSTATUS_Type m_rStatus;

        //-----------------------------
        //BTA- Telematics Box related issues
        //-----------------------------
        tenSignalValue m_enTelematicsBoxConnected; //first use in PSA bound to FI-property which is set by FC_ATB 
        tenSignalValue m_enTelematicsBoxSpeedOk;   //to send ITC if speed is to low

        /*!
         * \brief Clears the object
         */
        void clear()
        {
             m_cVendor        = "";
             m_cSerialID      = "";
             m_cUSBPortNo     = "";       //e.g. either Hardwareport USB1 or 2   
             m_cDeviceName    = "";
             m_cMountPoint    = "";
             m_cDeviceVersion = "";
             
             m_eDeviceType = CGlobalEnumerations::DTY_UNKNOWN;
         
             m_iVersion          = 0;
             m_bHUBHasCardReader = FALSE;
             m_iUSBNoOfPortsFoundAtHub = 0;
             m_eUSB_HUB_SEARCH = CGlobalEnumerations::HUB_FOUND_NO;
             
             m_ulSize = 0;
             
             //PRM related values
             m_enOC            = SIG_UNDEF;
             m_enPPON          = SIG_UNDEF;
             m_enU60_drop      = SIG_UNDEF;
             m_enMountedUSB    = SIG_UNDEF;
             m_enU50_USB_Reset = SIG_UNDEF;
             
             m_rStatus         = USB_DEV_UNDEFINED;

             m_enTelematicsBoxConnected = SIG_UNDEF;
             m_enTelematicsBoxSpeedOk   = SIG_UNDEF;
            
       }

        /*!
         * \brief Constructor
         */
        CUSBDiagnosis()
        {
            clear();
        }

        /*!
         * \brief Destructor
         */
        ~CUSBDiagnosis()
        {
        }
};

#endif // DIAGNOSIS_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>
