/*-----------------------------------------------------------------------------*
 * Device.h                                                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*! 
 * \file Device.h
 *
 * \brief data container to hold device information i.e. properties of the
 *        connected devices and it is used for notification to clients.
 *
 * \version Initial Version
 * \version 01.11.2011, Koechling, Christian (Bosch), statemachine supports
 *          several devices at one hub, product ID to charge apple and cleanup
 * \version 01.11.2011, Sunder Negi (Montavista), Disk storage details changed
 *          to unsigned long long from GENSTRING
 * \version 17.11.2011, Koechling, Christian (Bosch), cleanup: 1st step to shift
 *          includes to Common.h, merge of latest MV bugfixes from Sunder 9.11.2011
 * \version 06.12.2011, Koechling, Christian (Bosch), add send counter
 * \version 16.12.2011, Sunder Negi (Montavista), force mount added (some factory
 *          formated SD-cards)
 * \version 18.12.2011, Koechling, Christian (Bosch), cleanup config.h for
 *          'USE_NEW_MAPUSBSTRING'
 * \version 14.03.2012, Koechling, Christian (Bosch), cleanup define USE_BUGFIX_HUB
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 02.08.2012, Negi, Sunder (MontaVista),
 *          -# Refactored debug information logging
 *          -# Added History Manager, refer define HISTORY_MANAGER
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 *          fixed traces again
 * \version 09.08.2012, Negi, Sunder (MontaVista), usb and port no are made integer
 * \version 13.08.2012, Negi, Sunder (MontaVista), added member to check if
 *          this device is being used for storing the traces
 * \version 24.08.2012, Negi, Sunder (MontaVista), cleanup HANDLE_GPT
 * \version 28,08,2012, Negi, Sunder (MontaVista), change vendorid, productid to integers
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 *\version 23.10.2013, Christian Koechling (Bosch) 
 *         -# start tp replace QStrings by replacing QString by define GENSTRING
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef __CDEVICECARD_H__
#define __CDEVICECARD_H__

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace std;
using namespace statetbl;

/*-----------------------------------------------------------------------------*
 * Forward declaration                                                                  *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * defines                                                           *
 *-----------------------------------------------------------------------------*/
#define     SizeCIDRegister      16

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class CDeviceCard
 *
 * \brief class to hold the properties of the device
 */
class CDeviceCard
{
    private:

    public:

        //depricated part
        tenSlot        m_eSlot;                            // SD Card slot eCard0 (, eCard1, ...)
        //new part 
        tenSignalValue m_eConnected;                          //SIG_TRUE: SDCard (internal )inserted, SIG_FALSE: SDCard ()
        GENSTRING      m_strUUIDDeviceName;                   // e.g. AAM_dev_mmcblk0p1
        GENSTRING      m_strMountPoint;                       //e.g. /media/AAM_dev_mmcblk0p1
        //body
        tBool          m_bOverCurrent;                     // SD Card overcurrent status. FALSE: No overcurrent detected
        tBool          m_bSlotEnable;                      // SD Card enable status: TRUE: SD Card Slot is enabled
      
        tU16           m_u16MediaState;                    // e.g. MEDIA_READY or MEDIA_NOT_READY
        tU16           m_u16MediaType;                     // e.g. MEDIA_EJECTED
                                                    // for following variables see also OSAL_trIOCtrlCardState in  FILE:         osioctrl.h
        tBool          m_bHW_WriteProtected;               // indicates HW wite protection of the card is set
        tBool          m_bSW_WriteProtected;               // indicates HW wite protection of the card is set
        tBool          m_bMounted;                         // indicates the current mount state
        tU8            m_u8ManufactureId;                  // Card ManufactureId
        tU32           m_u32SerialNumber;                  // Card SerialNumber
        tU8            m_u8SDCardSpecVersion;              // u8SDCardSpecVersion indicates the the value of CSD Register
                                                    // ('0' indicates spec 1.0 to 1.10)
        tU8            m_u8CIDRegister[SizeCIDRegister];   // content of Card Id Rgister
        tU64           m_u64CardSize;                      // card size

      

//       OSAL_tMSecond m_rSendTime_ms;                ///< after startup each notification to clients gets its number

//        bool m_bIsLogDump;                          ///< debug information is being stored in this device

        /*!
         * \brief Constructor
         */
        CDeviceCard();

        /*!
         * \brief Destructor
         */
        ~CDeviceCard();

        /*Public methods*/

        tVoid vSetErrorValues( );

        /*!
         * \brief Copies f_CDeviceCard into this
         *
         * \param [in] f_CDeviceCard device to be copied
         */
        void FillDevice( const CDeviceCard& f_CDeviceCard );

        /*!
         * \brief Prints device properties
         */
        void Show();
};


#endif // __CDEVICECARD_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

