/*-----------------------------------------------------------------------------*
 * VoltClientHistory.h                                                          *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VoltClientHistory.h
 *
 * \brief This file holds the declaration for VoltClientHistory
 *
 * \version 19.08.2014, adjusted for Gen3 with VoltageManager
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

#ifndef VOLTCLIENTHISTORY_H_
#define VOLTCLIENTHISTORY_H_

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Structs                                                                     *
 *-----------------------------------------------------------------------------*/
struct VoltEvt
{
    int            send_nr;
    OSAL_tMSecond  sent_time;
    tenSignalValue history;
};

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class VoltClientHistory
 *
 * \brief class to hold the debug information of SPM clienthandler
 *
 * \see CObjectHistory
 */
class VoltClientHistory:public CObjectHistory
{
    private:
        int m_currIndex;
        int m_iSendNo;

        struct VoltEvt m_rVoltEvts[HELPER_ANALYSIS_VOLTCALLLBACKS];

    public:

        /*!
         * \brief Constructor
         */
        VoltClientHistory();

        /*!
         * \brief Destructor
         */
        ~VoltClientHistory();

        /*!
         * \brief adds info to debug history
         *
         * \param [in] eSpmCvmActive the debug info
         */
        void AddToHistory (tenSignalValue eVolt);

        /*!
         * \brief clears the Diagnosis clienthandler history
         */
        //lint -sem(VoltClientHistory::ClearHistory,initializer)
        void ClearHistory();

        /*!
         * \brief displays the Diagnosis clienthandler history
         */
        void TraceHistory();
};

#endif // VOLTCLIENTHISTORY_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
