/*-----------------------------------------------------------------------------*
 * VoltClientHistory.cpp                                                        *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2014 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VoltClientHistory.cpp
 *
 * \brief This file holds the implementation for VoltClientHistory
 *
 * \version 27.08.2015, Christian Kchling  initial version
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"
#include "debug/ObjectHistory.h"
#include "debug/VoltClientHistory.h"
#include "config/ConfigurationManager.h" //for eclapsed time

/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_HISTORYMANAGER
#include "trcGenProj/Header/VoltClientHistory.cpp.trc.h"
#endif

#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
VoltClientHistory::VoltClientHistory()
    :CObjectHistory()
{
    VoltClientHistory::ClearHistory (); 

}//lint !e1566 
// Warning 1566: prio3: member 'VoltClientHistory::m_currIndex' might have been initialized by a separate function but no '-sem(VoltClientHistory::ClearHistory,initializer)' was seen
// Warning 1566: prio3: member 'VoltClientHistory::m_iSendNo'   might have been initialized by a separate function but no '-sem(VoltClientHistory::ClearHistory,initializer)' was seen
// Warning 1566: prio3: member 'VoltClientHistory::m_rVoltEvts' might have been initialized by a separate function but no '-sem(VoltClientHistory::ClearHistory,initializer)' was seen
//done in ClearHistory()

/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
VoltClientHistory::~VoltClientHistory()
{
    // Do nothing
}

/*-----------------------------------------------------------------------------*
 * void AddToHistory (UsbPortState *pPortState)                                *
 *-----------------------------------------------------------------------------*/
void VoltClientHistory::AddToHistory(tenSignalValue eVolt)
{
    ETG_TRACE_USR3 (("AddToHistory: Begin "));

    m_LockHistory.lock();

    m_iSendNo++;
    m_rVoltEvts[m_currIndex].history   = eVolt;
    m_rVoltEvts[m_currIndex].send_nr   = m_iSendNo;
    m_rVoltEvts[m_currIndex].sent_time = (tU32)ConfigurationManager::GetInstance()->GetEclapsedTime_ms();
    m_currIndex++;

    if (m_currIndex >= HELPER_ANALYSIS_VOLTCALLLBACKS)
    {
        m_currIndex = 0;
    }

    m_LockHistory.unlock();

    ETG_TRACE_USR3 (("AddToHistory: End  "));
}

/*-----------------------------------------------------------------------------*
 * void TraceHistory ()                                                        *
 *-----------------------------------------------------------------------------*/
void VoltClientHistory::TraceHistory()
{
    ETG_TRACE_USR3 (("TraceHistory: Begin"));
    ETG_TRACE_FATAL (("[ok] ===================>Device Manager Voltage Warning History======================"));

    tU64 u64StartTimeAbsoluteDeviceManager = ConfigurationManager::GetInstance()->GetStartTime_ms();
    ETG_TRACE_U64_FATAL((char*)"u64StartTimeAbsoluteDeviceManager (ms) : ",u64StartTimeAbsoluteDeviceManager);
    ETG_TRACE_U64_FATAL((char*)"u64StartTimeAbsoluteDeviceManager (sec): ",u64StartTimeAbsoluteDeviceManager/1000);

    // dump to file, if available
    if (NULL != m_poDumpFile)
    {
        fprintf (m_poDumpFile,
                "\n[ok] ===================>Device Manager Voltage Warning History======================");
    }

    for (int itr = 0; itr < m_currIndex;itr++)
    {
        ETG_TRACE_FATAL ((">>>>>>>>>>>>>>>>>>>>>>/Voltage Warning History [%d]>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
                m_rVoltEvts[itr].send_nr));
        ETG_TRACE_FATAL (("[%d]  SendNo      :        %d    ",
                m_rVoltEvts[itr].send_nr,m_rVoltEvts[itr].send_nr));
        ETG_TRACE_FATAL (("[%d]  Sent Time   :        %d ms ",
                m_rVoltEvts[itr].send_nr,m_rVoltEvts[itr].sent_time));
        ETG_TRACE_FATAL (("[%d]  Notification:        %d    ",
                m_rVoltEvts[itr].send_nr, ETG_ENUM(TENSIGNALVALUE,
                        m_rVoltEvts[itr].history)));
        ETG_TRACE_FATAL ((">>>>>>>>>>>>>>>>>>>>>>Voltage Warning History/>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"));

        // dump to file, if available
        if (NULL != m_poDumpFile)
        {
            fprintf (m_poDumpFile,
                    "\n>>>>>>>>>>>>>>>>>>>>>>/Voltage Warning History [%d]>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>",
                    m_rVoltEvts[itr].send_nr);
            fprintf (m_poDumpFile, "\n[%d]  SendNo      :        %d    ",
                    m_rVoltEvts[itr].send_nr,m_rVoltEvts[itr].send_nr);
            fprintf (m_poDumpFile, "\n[%d]  Sent Time   :        %u ms ",
                    m_rVoltEvts[itr].send_nr, (tUInt)m_rVoltEvts[itr].sent_time);
            fprintf (m_poDumpFile, "\n[%d]  Notification:        %d    ",
                    m_rVoltEvts[itr].send_nr, ETG_ENUM(TENSIGNALVALUE,
                            m_rVoltEvts[itr].history));
            fprintf (m_poDumpFile,
                    "\n>>>>>>>>>>>>>>>>>>>>>>Voltage Warning History/>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
    }

    ETG_TRACE_FATAL (("[ok] ===================Device Manager Voltage Warning History<======================"));

    // dump to file, if available
    if (NULL != m_poDumpFile)
    {
        fprintf (m_poDumpFile,
                "\n[ok] ===================Device Manager Voltage Warning History<======================");
    }

    ETG_TRACE_USR3 (("TraceHistory: End"));
}

/*-----------------------------------------------------------------------------*
 * void ClearHistory ()                                                        *
 *-----------------------------------------------------------------------------*/
void VoltClientHistory::ClearHistory()
{
    ETG_TRACE_USR3 (("ClearHistory: Begin"));

    for (int itr = 0; itr < HELPER_ANALYSIS_VOLTCALLLBACKS;itr++)
    {
        m_rVoltEvts[itr].history   = SIG_UNDEF;
        m_rVoltEvts[itr].send_nr   = 0;
        m_rVoltEvts[itr].sent_time = 0;
    }

    m_iSendNo   = 0;
    m_currIndex = 0;

    ETG_TRACE_USR3 (("ClearHistory: End"));
}   //lint !e1565 Warning 1565: member 'CObjectHistory::m_poDumpFile' (VD_DeviceManager/inc/debug/ObjectHistory.h) not assigned by initializer function

////////////////////////////////////////////////////////////////////////////////
// <EOF>
