/*-----------------------------------------------------------------------------*
 * PrmHistory.h                                                                *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file PrmHistory.h
 *
 * \brief This file holds the declaration for CPrmHistory
 *
 * \version 02.08.2012, Negi, Sunder (MontaVista), initial version
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */
#ifndef PRMHISTORY_H_
#define PRMHISTORY_H_

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Namespace                                                                   *
 *-----------------------------------------------------------------------------*/
using namespace prmmgr;

/*-----------------------------------------------------------------------------*
 * Structs                                                                     *
 *-----------------------------------------------------------------------------*/
struct PrmEvt {
    unsigned int  send_nr;
    OSAL_tMSecond send_time;
    UsbPortState  history;
};

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class CPrmHistory
 *
 * \brief class to hold the debug information of PrmManager
 *
 * \see CObjectHistory
 */
class CPrmHistory:public CObjectHistory
{
    private:
        unsigned int  m_currIndex, m_uiSendNo;

        struct PrmEvt m_aoPrmEvts[HELPER_ANAYLSIS_PRMCALLBACKS];

    public:
        /*!
         * \brief Constructor
         */
        CPrmHistory();

        /*!
         * \brief Destructor
         */
        ~CPrmHistory();

        /*!
         * \brief adds info to debug history
         *
         * \param [in] pPortState the debug information
         */
        void AddToHistory ( const UsbPortState *pPortState);

        /*!
         * \brief clears the PrmManager history
         */
        //lint -sem(CPrmHistory::ClearHistory,initializer)
        void ClearHistory();

        /*!
         * \brief displays the PrmManager history
         */
        void TraceHistory();
};

#endif // PRMHISTORY_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
