/*-----------------------------------------------------------------------------*
 * ObjectHistory.h                                                             *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ObjectHistory.h
 *
 * \brief This file holds the declaration for ObjectHistory
 *
 * Each object that needs to maintain history needs to implement this interace.
 *
 * \version 02.08.2012, Negi, Sunder (MontaVista), initial version
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 * \version 14.08.2012, Negi, Sunder (MontaVista), added new FILE member object
 *          to dump traces to
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef OBJECTHISTORY_H_
#define OBJECTHISTORY_H_

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include "LockDVM.h"
/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class CObjectHistory
 *
 * \brief class to hold the debug information about an object
 */
class CObjectHistory
{
    protected:

        FILE *m_poDumpFile; ///< file to dump traces to
        LockDVM m_LockHistory;
        

    public:

        CObjectHistory();

        virtual ~CObjectHistory();

        /*!
         * \brief clears the object history
         *
         * \note this is a pure virtual function. The inherited class need to
         * define as per its functionality
         */
        virtual void ClearHistory () = 0;

        /*!
         * \brief displays the object history
         *
         * \note this is a pure virtual function. The inherited class need to
         * define as per its functionality
         */
        virtual void TraceHistory () = 0;

        /*!
         * \brief Sets the file to dump debug information to
         *
         * \param [in] poDumpFile the file pointer
         */
        void setDumpFile(FILE* poDumpFile);
};

#endif // OBJECTHISTORY_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
