/*-----------------------------------------------------------------------------*
 * VoltClientHistory.h                                                          *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VoltClientHistory.h
 *
 * \brief This file holds the declaration for VoltClientHistory
 *
 * \version 19.08.2014, adjusted for Gen3 with VoltageManager
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

#ifndef INTERFACEHISTORY_H_
#define INTERFACEHISTORY_H_

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Structs                                                                     *
 *-----------------------------------------------------------------------------*/
struct InterfaceHistoryElem
{
    tBool             bSend;
    int               send_nr;
    OSAL_tMSecond     sent_time;
    vector<CDevice>   ListOfSendDevicestServices;
    trPortStates      ListOfSendArrayPortStates[ARRAYSIZEFORUSB];
};

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class VoltClientHistory
 *
 * \brief class to hold the debug information of SPM clienthandler
 *
 * \see CObjectHistory
 */
class InterfaceHistory:public CObjectHistory
{
    private:
        int   m_currIndex;  
        int   m_iSendNo;    /*each send vector gets a SendNo*/
        
        struct InterfaceHistoryElem m_rSendConnectionNotificationInterface[HELPER_ANALYSIS_SENDINTERFACESERVICE];

    public:

        /*!
         * \brief Constructor
         */
        InterfaceHistory();

        /*!
         * \brief Destructor
         */
        ~InterfaceHistory();

        /*!
         * \brief adds info to debug history
         *
         * \param [in] bSend: true: has been send successfully by the service; false: problems with sending although device list has been handed over to the services 'ok'
         * \param [in] f_ListOfSendDevicestServices: vector of devices send this contain connected and removed device.
         * \param [in] trPortStates: List of port states
         */
        void AddToHistory (IN tBool bSend, IN vector<CDevice> &f_ListOfSendDevicestServices, IN trPortStates (&f_ListOfSendArrayPortStates)[ARRAYSIZEFORUSB]);
        

        /*!
         * \brief clears the Diagnosis clienthandler history
         */
        //lint -sem(VoltClientHistory::ClearHistory,initializer)
        void ClearHistory();

        void Init();

        /*!
         * \brief displays the Diagnosis clienthandler history
         */
        void TraceHistory();

    protected:

        void TraceHistoryDeviceListSummary(IN unsigned int itr);
        void TraceHistoryDeviceList(IN unsigned int itr, OUT tBool &f_bUsed);
        void TraceHistoryConnectorList(IN unsigned int itr);
    
};

#endif // INTERFACEHISTORY_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
