/*-----------------------------------------------------------------------------*
 * HWMalfunctionHistory.cpp                                                        *
 *-----------------------------------------------------------------------------*

 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file HWMalfunctionHistory.cpp
 *
 * \brief This file holds the implementation for HWMalfunctionHistory
 *
 * \version 31.03.2016, Christian Kchling  initial version
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#include "Enums.h"
#include "Device.h"
//#include "DeviceCard.h"
#include "debug/ObjectHistory.h"
#include "debug/HWMalfunctionHistory.h"
#include "config/ConfigurationManager.h" //for eclapsed time

//#include <stdio.h>antilint: repeatedly included but does not have a standard include guard


/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_HISTORYMANAGER
#include "trcGenProj/Header/HWMalfunctionHistory.cpp.trc.h"
#endif

#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
HWMalfunctionHistory::HWMalfunctionHistory()
    :CObjectHistory()
{
    HWMalfunctionHistory::ClearHistory (); 

}//lint !e1566 
// Warning 1566: prio3: member 'HWMalfunctionHistory::m_currIndex' might have been initialized by a separate function but no '-sem(HWMalfunctionHistory::ClearHistory,initializer)' was seen
// Warning 1566: prio3: member 'HWMalfunctionHistory::m_iSendNo'   might have been initialized by a separate function but no '-sem(HWMalfunctionHistory::ClearHistory,initializer)' was seen
// Warning 1566: prio3: member 'HWMalfunctionHistory::m_rHWMalfunctionEvt' might have been initialized by a separate function but no '-sem(HWMalfunctionHistory::ClearHistory,initializer)' was seen
//done in ClearHistory()

/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
HWMalfunctionHistory::~HWMalfunctionHistory()
{
    // Do nothing
}

/*-----------------------------------------------------------------------------*
 * void AddToHistory (UsbPortState *pPortState)                                *
 *-----------------------------------------------------------------------------*/
void HWMalfunctionHistory::AddToHistory(GenString strFctName,structNotifyClients *pDeviceInfo)
{
    ETG_TRACE_USR3(("AddToHistory: Begin "));

    m_LockHistory.lock();
    m_iSendNo++;
    m_rHWMalfunctionEvt[m_currIndex].send_nr            = m_iSendNo;
    m_rHWMalfunctionEvt[m_currIndex].sent_time          = (tU32)ConfigurationManager::ConfigurationManager::GetInstance()->GetEclapsedTime_ms();
    m_rHWMalfunctionEvt[m_currIndex].strCallingFunction = strFctName;
    if(pDeviceInfo)
    {
        m_rHWMalfunctionEvt[m_currIndex].bDeviceInfoValid = TRUE;
        memcpy(&m_rHWMalfunctionEvt[m_currIndex].deviceInfo,pDeviceInfo,sizeof(structNotifyClients));
    }
    else
    {
        m_rHWMalfunctionEvt[m_currIndex].bDeviceInfoValid = FALSE;
        memset(&m_rHWMalfunctionEvt[m_currIndex].deviceInfo,0,sizeof(structNotifyClients));
  
    }
   
    m_currIndex++;


    if (m_currIndex >= HELPER_ANALYSIS_HWMALFUNCTION)
    {
        m_currIndex = 0;
    }

    m_LockHistory.unlock();
    ETG_TRACE_USR3(("AddToHistory: End  "));
}

/*-----------------------------------------------------------------------------*
 * void TraceHistory ()                                                        *
 *-----------------------------------------------------------------------------*/
void HWMalfunctionHistory::TraceHistory()
{
    ETG_TRACE_USR3(("TraceHistory: Begin"));
    ETG_TRACE_FATAL(("[ok] ===================>Device Manager HWMalfunction History======================"));
    ETG_TRACE_FATAL(("please refer to section 5.1 in https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-730309/DESIGN_15003_HandlingOfTemporaryUnavailableDevices_05.doc"));
    ETG_TRACE_FATAL((" Tprev:%d (ms)                            ",DVM_Tprev_ms));
    ETG_TRACE_FATAL((" Tpost:%d (ms)                            ",DVM_Tpost_ms));
    ETG_TRACE_FATAL(("[ok] ------------------------------------------------------------------------------"));
    GenString strData;
    GenString strConnect;
    GenString strDeviceType;
    char cDataLine1[500];
    char cDataLine2[500];
    // dump to file, if available
    if (NULL != m_poDumpFile)
    {
        fprintf (m_poDumpFile,
                "\n[ok] ===================>Device Manager HWMalfunction History======================");
    }


    for (int itr = 0; itr < m_currIndex;itr++)
    {
        //print if history has entries
        if( m_rHWMalfunctionEvt[itr].send_nr != -1 )
        {
            //-------------------
            //entry bound to a device
            //-------------------
            if(TRUE == m_rHWMalfunctionEvt[itr].bDeviceInfoValid)
            {
                strData = GenString("++++++++++ Device: ");
                strData+= GenString(m_rHWMalfunctionEvt[itr].deviceInfo.cSerialID);
                strData+= GenString("   ");
                strData+= GenString(m_rHWMalfunctionEvt[itr].deviceInfo.cMountPoint);
                strData+= GenString(" +++++++++"); 
            }
            //-------------------------------------------------------
            //entry bound to a signal or informative entry wthout device context
            //-------------------------------------------------------
            else
            {
                strData = GenString("!!! SIGNAL !!!");
            }

            //-------------------------
            //device type as a string
            //------------------------
           
            switch(m_rHWMalfunctionEvt[itr].deviceInfo.eDeviceType)
            {
                case CGlobalEnumerations::DTY_UNKNOWN:
                    strDeviceType = "DTY_UNKNOWN";
                    break;
                case CGlobalEnumerations::DTY_USB:
                    strDeviceType = "DTY_USB";
                    break;
                case CGlobalEnumerations::DTY_SD:
                    strDeviceType = "DTY_SD";
                    break;
                case CGlobalEnumerations::DTY_IPOD:
                    strDeviceType = "DTY_IPOD";
                    break;
                case CGlobalEnumerations::DTY_IPHONE:
                    strDeviceType = "DTY_IPHONE";
                    break;
                case CGlobalEnumerations::DTY_MTP:
                    strDeviceType = "DTY_MTP";
                    break;
                case CGlobalEnumerations::DTY_BLUETOOTH:
                    strDeviceType = "DTY_BLUETOOTH";
                    break;
                case CGlobalEnumerations::DTY_MSZUNE:
                    strDeviceType = "DTY_MSZUNE";
                    break;
                case CGlobalEnumerations::DTY_IPAD:
                    strDeviceType = "DTY_IPAD";
                    break;
                case CGlobalEnumerations::DTY_HUB:
                    strDeviceType = "DTY_HUB";
                    break;
                case CGlobalEnumerations::DTY_NOT_SUPPORTED:
                    strDeviceType = "DTY_NOT_SUPPORTED";
                    break;
                case CGlobalEnumerations::DTY_CDROM:
                    strDeviceType = "DTY_CDROM";
                    break;
                case CGlobalEnumerations::DTY_SD_INTERNAL:
                    strDeviceType = "DTY_SD_INTERNAL";
                    break;
                case CGlobalEnumerations::DTY_DIGIAUX:
                    strDeviceType = "DTY_DIGIAUX";
                    break;
                case CGlobalEnumerations::DTY_BTA:
                    strDeviceType = "DTY_UNKNOWN";
                    break;
                case CGlobalEnumerations::DTY_MISCELLANEOUS:
                    strDeviceType = "DTY_MISCELLANEOUS";
                    break;
                case CGlobalEnumerations::DTY_CDDA:
                    strDeviceType = "DTY_CDDA";
                    break;
                default:
                    strDeviceType  = "[NOK] ";
                    strDeviceType += GenString(((int)m_rHWMalfunctionEvt[itr].deviceInfo.eDeviceType));
                    break;
            }
 
      
 

            //-------------------------
            //connect as string
            //-------------------------
            switch (m_rHWMalfunctionEvt[itr].deviceInfo.eConnectStatus)
            {
                case USB_DEV_UNDEFINED:
                    strConnect = "USB_DEV_UNDEFINED";
                    break;
                case USB_DEV_WARNING:
                    strConnect = "USB_DEV_WARNING";
                    break;
                case USB_DEV_CONNECTED:
                    strConnect = "USB_DEV_CONNECTED";
                    break;
                case USB_DEV_REMOVED_BY_USR:
                    strConnect = "USB_DEV_REMOVED_BY_USR";
                    break;
                case USB_DEV_UNAVAIL_BAT_LOWVOLT:
                    strConnect = "USB_DEV_UNAVAIL_BAT_LOWVOLT";
                    break;
                case USB_DEV_UNAVAIL_HW_MALFUNC:
                    strConnect = "USB_DEV_UNAVAIL_HW_MALFUNC";
                    break;
                case USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT:
                    strConnect = "USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT";
                    break;
                case USB_DEV_INTERNAL_APPLY_CONNECT:
                    strConnect = "USB_DEV_INTERNAL_APPLY_CONNECT";
                    break;
                case USB_DEV_INTERNAL_APPLY_REMOVED_BY_USR:
                    strConnect = "USB_DEV_INTERNAL_APPLY_REMOVED_BY_USR";
                    break;
                case USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE:
                    strConnect = "USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE";
                    break;
                case USB_DEV_INTERNAL_APPLY_CONNECT_SUPPRESSED:
                    strConnect = "USB_DEV_INTERNAL_APPLY_CONNECT_SUPPRESSED";
                    break;
                case USB_DEV_INTERNAL_APPLY_CONNECT_AFTER_MALFUNC:
                    strConnect = "USB_DEV_INTERNAL_APPLY_CONNECT_AFTER_MALFUNC";
                    break;
                default:
                    strConnect  = "[NOK] ";
                    strConnect += GenString(((int)m_rHWMalfunctionEvt[itr].deviceInfo.eConnectStatus));
                    break;

           }


            if(TRUE == m_rHWMalfunctionEvt[itr].bDeviceInfoValid)
            {
                snprintf(cDataLine1, sizeof(cDataLine1),"m_rHWMalfunctionEvt[%u], SendNo: %u, Time_ms:%d, DeviceType:%s, USBConnector:USB%d ConnectState:%s ",
                                           itr,
                                           m_rHWMalfunctionEvt[itr].send_nr,
                                           m_rHWMalfunctionEvt[itr].sent_time,
                                           strDeviceType.toStdString().c_str(),
                                           (int)m_rHWMalfunctionEvt[itr].deviceInfo.eUSB,
                                           strConnect.toStdString().c_str());
    
                snprintf(cDataLine2, sizeof(cDataLine2),"MalfunctionElapsedTime_sec: %d, TimeStampApplyForConnect_ms: %llu, TimeStampApplyForRemove_ms: %llu, TimeStamp_Malfunction_ms: %llu, TimeStamp_HighRiskForMalfunction_ms: %llu",
                                           m_rHWMalfunctionEvt[itr].deviceInfo.s32MalfunctionElapsedTime_sec,
                                           m_rHWMalfunctionEvt[itr].deviceInfo.u64TimeStamp_ApplyForConnect,
                                           m_rHWMalfunctionEvt[itr].deviceInfo.u64TimeStamp_ApplyForRemove,
                                           m_rHWMalfunctionEvt[itr].deviceInfo.u64TimeStamp_Malfunction,
                                           m_rHWMalfunctionEvt[itr].deviceInfo.u64TimeStamp_HighRiskForMalfunction);
            }
            else
            {
                snprintf(cDataLine1, sizeof(cDataLine1),"m_rHWMalfunctionEvt[%u], SendNo: %u, Time_ms:%d",
                                       itr,
                                       m_rHWMalfunctionEvt[itr].send_nr,
                                       m_rHWMalfunctionEvt[itr].sent_time);
         
            }




            ETG_TRACE_FATAL(("[ok] %s ",strData.toStdString().c_str() ));
            ETG_TRACE_FATAL(("[ok] Fct.: %s ",m_rHWMalfunctionEvt[itr].strCallingFunction.toStdString().c_str()));
            ETG_TRACE_FATAL(("[ok] %s ",cDataLine1 ));
            if(TRUE == m_rHWMalfunctionEvt[itr].bDeviceInfoValid)
            {
                ETG_TRACE_FATAL(("[ok] %s ",cDataLine2 ));
            }
            ETG_TRACE_FATAL(("[ok] -------------------------------------------------------------------------------------------------------------------------------------------------------------------"));



            // dump to file, if available
            if (NULL != m_poDumpFile)
            {
                fprintf (m_poDumpFile,"\n[ok] %s ",strData.toStdString().c_str() );
                fprintf (m_poDumpFile,"\n[ok] Fct.: %s ",m_rHWMalfunctionEvt[itr].strCallingFunction.toStdString().c_str() );
                fprintf (m_poDumpFile,"\n[ok] %s ",cDataLine1 );
                fprintf (m_poDumpFile,"\n[ok] %s ",cDataLine2 );
                fprintf (m_poDumpFile,"\n[ok]-----------------------------------------------------------------------------------------------------------");
            }

        }
        
    }

    ETG_TRACE_FATAL(("[ok] ===================HWMalfunction (temporary not available) History<======================"));

    // dump to file, if available
    if (NULL != m_poDumpFile)
    {
        fprintf (m_poDumpFile,
                "\n[ok] ===================HWMalfunction (temporary not available) History<======================");
    }

    ETG_TRACE_USR3(("TraceHistory: End"));
}

/*-----------------------------------------------------------------------------*
 * void ClearHistory ()                                                        *
 *-----------------------------------------------------------------------------*/
void HWMalfunctionHistory::ClearHistory()
{
    ETG_TRACE_USR3(("ClearHistory: Begin"));

    for (int itr = 0; itr < HELPER_ANALYSIS_HWMALFUNCTION;itr++)
    {
        m_rHWMalfunctionEvt[itr].send_nr   = -1;
        m_rHWMalfunctionEvt[itr].sent_time = 0;
        memset(&m_rHWMalfunctionEvt[m_currIndex].deviceInfo,0,sizeof(structNotifyClients));
    }

    m_iSendNo   = 0;
    m_currIndex = 0;

    ETG_TRACE_USR3(("ClearHistory: End"));
}   //lint !e1565 Warning 1565: member 'CObjectHistory::m_poDumpFile' (VD_DeviceManager/inc/debug/ObjectHistory.h) not assigned by initializer function

////////////////////////////////////////////////////////////////////////////////
// <EOF>
