/*-----------------------------------------------------------------------------*
 * DiagClientHistory.cpp                                                       *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file DiagClientHistory.cpp
 *
 * \brief This file holds the implementation for CDiagClientHistory
 *
 * \version 02.08.2012, Negi, Sunder (MontaVista), initial version
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 * \version 13.08.2012, Negi, Sunder (MontaVista), cleanup logging to usb (WRITEHISTORYTOUSBSTICK)
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_FIDIAG
#define INCLUDE_VD_DVM_AILAHL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"
#include "Diagnosis.h"
#include "StateTable.h"
#include "debug/ObjectHistory.h"
#include "config/ConfigurationManager.h" //for eclapsed time

/*-----------------------------------------------------------------------------*
 * Namespace                                                                *
 *-----------------------------------------------------------------------------*/
using namespace dvmDiaglog;

/*-----------------------------------------------------------------------------*
 * includes which depend on name space
 *-----------------------------------------------------------------------------*/
#include "debug/DiagClientHistory.h"

/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_HISTORYMANAGER
#include "trcGenProj/Header/DiagClientHistory.cpp.trc.h"
#endif

#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
CDiagClientHistory::CDiagClientHistory()
    :CObjectHistory() 
{
    CDiagClientHistory::ClearHistory ();

}//lint !e1566 
//Warning 1566: prio3: member 'CDiagClientHistory::m_currIndex'   might have been initialized by a separate function but no '-sem(CDiagClientHistory::ClearHistory,initializer)' was seen
//Warning 1566: prio3: member 'CDiagClientHistory::m_iSendCounter'might have been initialized by a separate function but no '-sem(CDiagClientHistory::ClearHistory,initializer)' was seen
//Warning 1566: prio3: member 'CDiagClientHistory::m_aoDiagEvts'  might have been initialized by a separate function but no '-sem(CDiagClientHistory::ClearHistory,initializer)' was seen


/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
CDiagClientHistory::~CDiagClientHistory()
{
    // Do nothing
}

/*-----------------------------------------------------------------------------*
 * void AddToHistory (midw_fi_tcl_TestResultList& f_oTestResultList)           *
 *-----------------------------------------------------------------------------*/
void CDiagClientHistory::AddToHistory (trDiagEvt& f_rDiagEvent)
{
    ETG_TRACE_USR3 (("AddToHistory: Begin"));
    m_LockHistory.lock();

    m_aoDiagEvts[m_currIndex].send_nr   = ++m_iSendCounter;
    m_aoDiagEvts[m_currIndex].sent_time = (tU32)ConfigurationManager::GetInstance()->GetEclapsedTime_ms();//note OSAL_ClockGetElapsedTime() & OSAL_tMSecond have been replaced MAx val 2^32=4294967296 = 49,7 days. ETG-Trace of values of 64bit are difficult  thats why 32bit are. Is ok because would cover ignitioncycle of 49.7 days
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB1_SIGNAL_OVERCURRENT].s8DtcResult  = f_rDiagEvent.last_msg[enITC_USB1_SIGNAL_OVERCURRENT].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB2_SIGNAL_OVERCURRENT].s8DtcResult  = f_rDiagEvent.last_msg[enITC_USB2_SIGNAL_OVERCURRENT].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB3_SIGNAL_OVERCURRENT].s8DtcResult  = f_rDiagEvent.last_msg[enITC_USB3_SIGNAL_OVERCURRENT].s8DtcResult;
#ifdef USE_FOURTH_USB_CONNECTOR
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB4_SIGNAL_OVERCURRENT].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB4_SIGNAL_OVERCURRENT].s8DtcResult;
#endif

    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB1_HUB_NOT_DETECTED].s8DtcResult        = f_rDiagEvent.last_msg[enITC_USB1_HUB_NOT_DETECTED].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB2_HUB_NOT_DETECTED].s8DtcResult        = f_rDiagEvent.last_msg[enITC_USB2_HUB_NOT_DETECTED].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB3_HUB_NOT_DETECTED].s8DtcResult        = f_rDiagEvent.last_msg[enITC_USB3_HUB_NOT_DETECTED].s8DtcResult;
#ifdef USE_FOURTH_USB_CONNECTOR
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB4_HUB_NOT_DETECTED].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB4_HUB_NOT_DETECTED].s8DtcResult;
#endif

    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult;
#ifdef USE_FOURTH_USB_CONNECTOR
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult;
#endif

    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB1_POWER_SUPPLY_FAULT].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB1_POWER_SUPPLY_FAULT].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB2_POWER_SUPPLY_FAULT].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB2_POWER_SUPPLY_FAULT].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB3_POWER_SUPPLY_FAULT].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB3_POWER_SUPPLY_FAULT].s8DtcResult;
#ifdef USE_FOURTH_USB_CONNECTOR
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB4_POWER_SUPPLY_FAULT].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB4_POWER_SUPPLY_FAULT].s8DtcResult;
#endif
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB1_OPEN].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB1_OPEN].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB2_OPEN].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB2_OPEN].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB3_OPEN].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB3_OPEN].s8DtcResult;
#ifdef USE_FOURTH_USB_CONNECTOR
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB4_OPEN].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB4_OPEN].s8DtcResult;
#endif

    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB1_LINK_DISABLED].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB1_LINK_DISABLED].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB2_LINK_DISABLED].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB2_LINK_DISABLED].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB3_LINK_DISABLED].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB3_LINK_DISABLED].s8DtcResult;
#ifdef USE_FOURTH_USB_CONNECTOR
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB4_LINK_DISABLED].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB4_LINK_DISABLED].s8DtcResult;
#endif
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB1_SPEED_REDUCED].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB1_SPEED_REDUCED].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB2_SPEED_REDUCED].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB2_SPEED_REDUCED].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB3_SPEED_REDUCED].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB3_SPEED_REDUCED].s8DtcResult;
#ifdef USE_FOURTH_USB_CONNECTOR
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB4_SPEED_REDUCED].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB4_SPEED_REDUCED].s8DtcResult;
#endif
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB1_DATA_LINE_FAULT].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB1_DATA_LINE_FAULT].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB2_DATA_LINE_FAULT].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB2_DATA_LINE_FAULT].s8DtcResult;
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB3_DATA_LINE_FAULT].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB3_DATA_LINE_FAULT].s8DtcResult;
#ifdef USE_FOURTH_USB_CONNECTOR
    m_aoDiagEvts[m_currIndex].last_msg[enITC_USB4_DATA_LINE_FAULT].s8DtcResult = f_rDiagEvent.last_msg[enITC_USB4_DATA_LINE_FAULT].s8DtcResult;
#endif

    m_currIndex++;

    if (m_currIndex >= HELPER_ANAYLSIS_SEND2DIAGNOSIS)  /*example: 5 max index 4 if >4 then reset*/
    {
        m_currIndex = 0;
    }

    m_LockHistory.unlock();

    ETG_TRACE_USR3 (("AddToHistory: End"));
}


/*-----------------------------------------------------------------------------*
 * void ClearHistory ()                                                        *
 *-----------------------------------------------------------------------------*/
void CDiagClientHistory::ClearHistory()
{
    ETG_TRACE_USR3 (("ClearHistory: Begin"));

    for (unsigned int itr = 0; itr < HELPER_ANAYLSIS_SEND2DIAGNOSIS;itr++)
    {
        m_aoDiagEvts[itr].last_msg[enITC_USB1_SIGNAL_OVERCURRENT].s8DtcResult  = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB2_SIGNAL_OVERCURRENT].s8DtcResult  = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB3_SIGNAL_OVERCURRENT].s8DtcResult  = -1;
#ifdef USE_FOURTH_USB_CONNECTOR
        m_aoDiagEvts[itr].last_msg[enITC_USB4_SIGNAL_OVERCURRENT].s8DtcResult = -1;
#endif
        m_aoDiagEvts[itr].last_msg[enITC_USB1_HUB_NOT_DETECTED].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB2_HUB_NOT_DETECTED].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB3_HUB_NOT_DETECTED].s8DtcResult        = -1;
#ifdef USE_FOURTH_USB_CONNECTOR
        m_aoDiagEvts[itr].last_msg[enITC_USB4_HUB_NOT_DETECTED].s8DtcResult = -1;
#endif
        m_aoDiagEvts[itr].last_msg[enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult = -1;
#ifdef USE_FOURTH_USB_CONNECTOR
        m_aoDiagEvts[itr].last_msg[enITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult = -1;
#endif

        m_aoDiagEvts[itr].last_msg[enITC_USB1_POWER_SUPPLY_FAULT].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB2_POWER_SUPPLY_FAULT].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB3_POWER_SUPPLY_FAULT].s8DtcResult        = -1;
#ifdef USE_FOURTH_USB_CONNECTOR
        m_aoDiagEvts[itr].last_msg[enITC_USB4_POWER_SUPPLY_FAULT].s8DtcResult = -1;
#endif
        m_aoDiagEvts[itr].last_msg[enITC_USB1_OPEN].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB2_OPEN].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB3_OPEN].s8DtcResult        = -1;
#ifdef USE_FOURTH_USB_CONNECTOR
        m_aoDiagEvts[itr].last_msg[enITC_USB4_OPEN].s8DtcResult = -1;
#endif

        m_aoDiagEvts[itr].last_msg[enITC_USB1_LINK_DISABLED].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB2_LINK_DISABLED].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB3_LINK_DISABLED].s8DtcResult        = -1;
#ifdef USE_FOURTH_USB_CONNECTOR
        m_aoDiagEvts[itr].last_msg[enITC_USB4_LINK_DISABLED].s8DtcResult = -1;
#endif
        m_aoDiagEvts[itr].last_msg[enITC_USB1_SPEED_REDUCED].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB2_SPEED_REDUCED].s8DtcResult        = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB3_SPEED_REDUCED].s8DtcResult        = -1;
#ifdef USE_FOURTH_USB_CONNECTOR
        m_aoDiagEvts[itr].last_msg[enITC_USB4_SPEED_REDUCED].s8DtcResult = -1;
#endif
        m_aoDiagEvts[itr].last_msg[enITC_USB1_DATA_LINE_FAULT].s8DtcResult      = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB2_DATA_LINE_FAULT].s8DtcResult      = -1;
        m_aoDiagEvts[itr].last_msg[enITC_USB3_DATA_LINE_FAULT].s8DtcResult      = -1;
#ifdef USE_FOURTH_USB_CONNECTOR
        m_aoDiagEvts[itr].last_msg[enITC_USB4_DATA_LINE_FAULT].s8DtcResult = -1;
#endif

        m_aoDiagEvts[itr].send_nr   = 0;
        m_aoDiagEvts[itr].sent_time = 0;
    }

    m_currIndex    = 0;
    m_iSendCounter = 0;

    ETG_TRACE_USR3 (("ClearHistory: End"));
}   //lint !e1565 Warning 1565: member 'CObjectHistory::m_poDumpFile' (VD_DeviceManager/inc/debug/ObjectHistory.h) not assigned by initializer function

/*-----------------------------------------------------------------------------*
 * void TraceHistory ()                                                        *
 *-----------------------------------------------------------------------------*/
tVoid CDiagClientHistory::TraceHistory()
{
    ETG_TRACE_USR3 (("TraceHistory: Begin"));

    ETG_TRACE_FATAL (("[ok] ================>Device Manager Diagnosis Client History==================="));

    tU64 u64StartTimeAbsoluteDeviceManager = ConfigurationManager::GetInstance()->GetStartTime_ms();
    ETG_TRACE_U64_FATAL((char*)"u64StartTimeAbsoluteDeviceManager (ms) : ",u64StartTimeAbsoluteDeviceManager);
    ETG_TRACE_U64_FATAL((char*)"u64StartTimeAbsoluteDeviceManager (sec): ",u64StartTimeAbsoluteDeviceManager/1000);

    ETG_TRACE_FATAL (("[ok] -1:not send "));
    ETG_TRACE_FATAL (("[ok] 0 :PASSED"));
    ETG_TRACE_FATAL (("[ok] 1 :FAILED"));
    ETG_TRACE_FATAL (("[ok] 2 :UNDEFINED"));
    // dump to file, if available
    if (NULL != m_poDumpFile)
    {
        fprintf (m_poDumpFile,
                "\n[ok] ================>Device Manager Diagnosis Client History===================");
    }
    
    unsigned int currIndex = m_currIndex; 
    for (unsigned int itr = 0; itr < currIndex; itr++)
    {
        ETG_TRACE_FATAL (("[ok] ***********************/TraceMsgsSendToDiagnosis[%d]***********************************", itr));
        ETG_TRACE_FATAL (("[ok]  Send No       : %d                                                                    ",
                m_aoDiagEvts[itr].send_nr));
        ETG_TRACE_FATAL (("[ok]  Send Time (ms): %d (elapsed time)                                                    ",
                m_aoDiagEvts[itr].sent_time));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB1_SIGNAL_OVERCURRENT            USB1        %d    (Signal Current Over Threshold)          ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_SIGNAL_OVERCURRENT].s8DtcResult ));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB2_SIGNAL_OVERCURRENT            USB2        %d    (Signal Current Over Threshold)          ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_SIGNAL_OVERCURRENT].s8DtcResult ));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB3_SIGNAL_OVERCURRENT            USB3        %d    (Signal Current Over Threshold)          ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_SIGNAL_OVERCURRENT].s8DtcResult ));
#ifdef USE_FOURTH_USB_CONNECTOR
        ETG_TRACE_FATAL(("[ok] [%d] enITC_USB4_SIGNAL_OVERCURRENT            USB4        %d    (Signal Current Over Threshold)          ",
            itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_SIGNAL_OVERCURRENT].s8DtcResult));
#endif

        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB1_HUB_NOT_DETECTED              USB HUB 1   %d    (Open Circuit)                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_HUB_NOT_DETECTED].s8DtcResult ));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB2_HUB_NOT_DETECTED              USB HUB 2   %d    (Open Circuit)                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_HUB_NOT_DETECTED].s8DtcResult));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB3_HUB_NOT_DETECTED              USB HUB 3   %d    (Open Circuit)                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_HUB_NOT_DETECTED].s8DtcResult));
#ifdef USE_FOURTH_USB_CONNECTOR
        ETG_TRACE_FATAL(("[ok] [%d] enITC_USB4_HUB_NOT_DETECTED              USB HUB 4   %d    (Open Circuit)                           ",
            itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_HUB_NOT_DETECTED].s8DtcResult));
#endif

        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH   USB HUB 1   %d    (Above Maximum Threshold)                ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH   USB HUB 2   %d    (Above Maximum Threshold)                ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult ));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH   USB HUB 3   %d    (Above Maximum Threshold)                ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult ));
#ifdef USE_FOURTH_USB_CONNECTOR
        ETG_TRACE_FATAL(("[ok] [%d] enITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH   USB HUB 4   %d    (Above Maximum Threshold)                ",
            itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult));
#endif

        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB1_POWER_SUPPLY_FAULT              USB HUB 1   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_POWER_SUPPLY_FAULT].s8DtcResult ));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB2_POWER_SUPPLY_FAULT              USB HUB 2   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_POWER_SUPPLY_FAULT].s8DtcResult));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB3_POWER_SUPPLY_FAULT              USB HUB 3   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_POWER_SUPPLY_FAULT].s8DtcResult));
#ifdef USE_FOURTH_USB_CONNECTOR
        ETG_TRACE_FATAL(("[ok] [%d] enITC_USB4_POWER_SUPPLY_FAULT              USB HUB 4   %d                                           ",
            itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_POWER_SUPPLY_FAULT].s8DtcResult));
#endif

        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB1_OPEN                            USB1   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_OPEN].s8DtcResult ));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB2_OPEN                            USB2   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_OPEN].s8DtcResult));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB3_OPEN                            USB3   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_OPEN].s8DtcResult));
#ifdef USE_FOURTH_USB_CONNECTOR
        ETG_TRACE_FATAL(("[ok] [%d] enITC_USB4_OPEN                            USB4   %d                                           ",
            itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_OPEN].s8DtcResult));
#endif

        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB1_LINK_DISABLED                            USB1   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_LINK_DISABLED].s8DtcResult ));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB2_LINK_DISABLED                            USB2   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_LINK_DISABLED].s8DtcResult));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB3_LINK_DISABLED                            USB3   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_LINK_DISABLED].s8DtcResult));
#ifdef USE_FOURTH_USB_CONNECTOR
        ETG_TRACE_FATAL(("[ok] [%d] enITC_USB4_LINK_DISABLED                            USB4   %d                                           ",
            itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_LINK_DISABLED].s8DtcResult));
#endif

        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB1_SPEED_REDUCED                            USB1   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_SPEED_REDUCED].s8DtcResult ));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB2_SPEED_REDUCED                            USB2   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_SPEED_REDUCED].s8DtcResult));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB3_SPEED_REDUCED                            USB3   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_SPEED_REDUCED].s8DtcResult));
#ifdef USE_FOURTH_USB_CONNECTOR
        ETG_TRACE_FATAL(("[ok] [%d] enITC_USB4_SPEED_REDUCED                            USB4   %d                                           ",
            itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_SPEED_REDUCED].s8DtcResult));
#endif

        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB1_DATA_LINE_FAULT                          USB1   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_DATA_LINE_FAULT].s8DtcResult ));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB2_DATA_LINE_FAULT                          USB2   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_DATA_LINE_FAULT].s8DtcResult));
        ETG_TRACE_FATAL (("[ok] [%d] enITC_USB3_DATA_LINE_FAULT                          USB3   %d                                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_DATA_LINE_FAULT].s8DtcResult));
#ifdef USE_FOURTH_USB_CONNECTOR
        ETG_TRACE_FATAL(("[ok] [%d] enITC_USB4_DATA_LINE_FAULT                          USB4   %d                                           ",
            itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_DATA_LINE_FAULT].s8DtcResult));
#endif

        ETG_TRACE_FATAL (("[ok] ***********************TraceMsgsSendToDiagnosis[%d]\***********************************", itr));
        ETG_TRACE_FATAL (("[ok]                                                                                        "));

        // dump to file, if available
        if (NULL != m_poDumpFile)
        {
            fprintf (m_poDumpFile, "\n[ok] ***********************/TraceMsgsSendToDiagnosis[%u]***********************************",
                    itr);
            fprintf (m_poDumpFile, "\n[ok]  Send No       : %u                                                                    ",
                    m_aoDiagEvts[itr].send_nr);
            fprintf (m_poDumpFile, "\n[ok]  Send Time (ms): %u (elapsed time)                                                    ",
                    (tUInt)m_aoDiagEvts[itr].sent_time);
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB1_SIGNAL_OVERCURRENT            USB1        %d    (Signal Current Over Threshold)          ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_SIGNAL_OVERCURRENT].s8DtcResult );
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB2_SIGNAL_OVERCURRENT            USB2        %d    (Signal Current Over Threshold)          ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_SIGNAL_OVERCURRENT].s8DtcResult );
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB3_SIGNAL_OVERCURRENT            USB3        %d    (Signal Current Over Threshold)          ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_SIGNAL_OVERCURRENT].s8DtcResult );
#ifdef USE_FOURTH_USB_CONNECTOR
            fprintf(m_poDumpFile, "\n[ok] [%u] enITC_USB4_SIGNAL_OVERCURRENT            USB4        %d    (Signal Current Over Threshold)          ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_SIGNAL_OVERCURRENT].s8DtcResult);
#endif

            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB1_HUB_NOT_DETECTED              USB HUB 1   %d    (Open Circuit)                           ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_HUB_NOT_DETECTED].s8DtcResult );
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB2_HUB_NOT_DETECTED              USB HUB 2   %d    (Open Circuit)                           ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_HUB_NOT_DETECTED].s8DtcResult);
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB3_HUB_NOT_DETECTED              USB HUB 3   %d    (Open Circuit)                           ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_HUB_NOT_DETECTED].s8DtcResult);
#ifdef USE_FOURTH_USB_CONNECTOR
            fprintf(m_poDumpFile, "\n[ok] [%u] enITC_USB4_HUB_NOT_DETECTED              USB HUB 4   %d    (Open Circuit)                           ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_HUB_NOT_DETECTED].s8DtcResult);
#endif

            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH   USB HUB 1   %d    (Above Maximum Threshold)                ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult);
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH   USB HUB 2   %d    (Above Maximum Threshold)                ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult );
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH   USB HUB 3   %d    (Above Maximum Threshold)                ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult );
#ifdef USE_FOURTH_USB_CONNECTOR
            fprintf(m_poDumpFile, "\n[ok] [%u] enITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH   USB HUB 4   %d    (Above Maximum Threshold)                ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_HUB_NUMBER_OF_PORT_MISMATCH].s8DtcResult);
#endif

            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB1_POWER_SUPPLY_FAULT            USB1   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_POWER_SUPPLY_FAULT].s8DtcResult);
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB2_POWER_SUPPLY_FAULT            USB2   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_POWER_SUPPLY_FAULT].s8DtcResult );
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB3_POWER_SUPPLY_FAULT            USB3   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_POWER_SUPPLY_FAULT].s8DtcResult );
#ifdef USE_FOURTH_USB_CONNECTOR
            fprintf(m_poDumpFile, "\n[ok] [%u] enITC_USB4_POWER_SUPPLY_FAULT            USB4   %d                                             ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_POWER_SUPPLY_FAULT].s8DtcResult);
#endif

            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB1_OPEN                          USB1   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_OPEN].s8DtcResult);
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB2_OPEN                          USB2   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_OPEN].s8DtcResult );
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB3_OPEN                          USB3   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_OPEN].s8DtcResult );
#ifdef USE_FOURTH_USB_CONNECTOR
            fprintf(m_poDumpFile, "\n[ok] [%u] enITC_USB4_OPEN                          USB4   %d                                             ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_OPEN].s8DtcResult);
#endif

            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB1_LINK_DISABLED                          USB1   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_LINK_DISABLED].s8DtcResult);
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB2_LINK_DISABLED                          USB2   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_LINK_DISABLED].s8DtcResult );
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB3_LINK_DISABLED                          USB3   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_LINK_DISABLED].s8DtcResult );
#ifdef USE_FOURTH_USB_CONNECTOR
            fprintf(m_poDumpFile, "\n[ok] [%u] enITC_USB4_LINK_DISABLED                          USB4   %d                                             ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_LINK_DISABLED].s8DtcResult);
#endif

            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB1_SPEED_REDUCED                          USB1   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_SPEED_REDUCED].s8DtcResult);
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB2_SPEED_REDUCED                          USB2   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_SPEED_REDUCED].s8DtcResult );
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB3_SPEED_REDUCED                          USB3   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_SPEED_REDUCED].s8DtcResult );
#ifdef USE_FOURTH_USB_CONNECTOR
            fprintf(m_poDumpFile, "\n[ok] [%u] enITC_USB4_SPEED_REDUCED                          USB4   %d                                             ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_SPEED_REDUCED].s8DtcResult);
#endif

            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB1_DATA_LINE_FAULT                        USB1   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB1_DATA_LINE_FAULT].s8DtcResult);
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB2_DATA_LINE_FAULT                        USB2   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB2_DATA_LINE_FAULT].s8DtcResult );
            fprintf (m_poDumpFile, "\n[ok] [%u] enITC_USB3_DATA_LINE_FAULT                        USB3   %d                                             ",
                    itr, m_aoDiagEvts[itr].last_msg[enITC_USB3_DATA_LINE_FAULT].s8DtcResult );
#ifdef USE_FOURTH_USB_CONNECTOR
            fprintf(m_poDumpFile, "\n[ok] [%u] enITC_USB4_DATA_LINE_FAULT                        USB4   %d                                             ",
                itr, m_aoDiagEvts[itr].last_msg[enITC_USB4_DATA_LINE_FAULT].s8DtcResult);
#endif



            fprintf (m_poDumpFile, "\n[ok] ***********************TraceMsgsSendToDiagnosis[%u]\\***********************************",
                    itr);
            fprintf (m_poDumpFile, "\n[ok]                                                                                        ");
        }
   }

    ETG_TRACE_FATAL (("[ok] Key:  -1:nothing send, 0:Passed, 1:Failed, 2:Undefined"));
    ETG_TRACE_FATAL (("[ok] =================Device Manager Diagnosis Client History<=================="));

    // dump to file, if available
    if (NULL != m_poDumpFile)
    {
        fprintf (m_poDumpFile,
                "\n[ok] Key:  -1:nothing send, 0:Passed, 1:Failed, 2:Undefined");
        fprintf (m_poDumpFile,
                "\n[ok] ================>Device Manager Diagnosis Client History===================");
    }

    ETG_TRACE_USR3 (("TraceHistory: End"));
}

////////////////////////////////////////////////////////////////////////////////
// <EOF>
