/*-----------------------------------------------------------------------------*
 * DeviceProcessorHistory.h                                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file DeviceProcessorHistory.h
 *
 * \brief This file holds the declaration for CDeviceProcessorHistory
 *
 * \version 02.08.2012, Negi, Sunder (MontaVista), initial version
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 *\version 23.10.2013, Christian Koechling (Bosch) 
 *         -# start tp replace QStrings by replacing QString by define GENSTRING
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

#ifndef DEVICEPROCESSORHISTORY_H_
#define DEVICEPROCESSORHISTORY_H_

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Structs                                                                     *
 *-----------------------------------------------------------------------------*/
struct DevEvt {
    int     rcv_counter;
    GENSTRING serial_id;
    GENSTRING action;
    GENSTRING mount_point;
    GENSTRING dev_node;
    CGlobalEnumerations::DEVICE_TYPE_Type dev_type;
    tU32      u32TimeStamp; //max value is 2^32 = 4.294.967.295ms =49 days 
};

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class CDeviceProcessorHistory
 *
 * \brief class to hold the debug information of DeviceProcessor
 *
 * \see CObjectHistory
 */
class CDeviceProcessorHistory:public CObjectHistory
{
    private:
        unsigned int m_uiCurrent;
        unsigned int m_uiTotalCounter;

        struct DevEvt m_aoDevEvts[HELPER_ANALYSIS_UDEVEVENTS];

    public:

        /*!
         * \brief Constructor
         */
        CDeviceProcessorHistory();

        /*!
         * \brief Destructor
         */
        ~CDeviceProcessorHistory();

        /*!
         * \brief adds info to debug history
         *
         * \param [in] f_cAction the device event
         * \param [in] f_pCurDevice the device
         */
        void AddToHistory (GENSTRING f_cAction, const CDevice *f_pCurDevice);

        /*!
         * \brief adds info to debug history
         *
         * \param [in] f_cAction the device event
         * \param [in] f_cDevNode the device node
         * \param [in] f_cMountPoint device mount-point
         */
        void AddToHistory (GENSTRING f_cAction, GENSTRING f_cDevNode = "",
                GENSTRING f_cMountPoint = "");

        /*!
         * \brief clears the DeviceProcessor history
         */
        //lint -sem(CDeviceProcessorHistory::ClearHistory,initializer)
        void ClearHistory();

        /*!
         * \brief displays the DeviceProcessor history
         */
        void TraceHistory();
};

#endif // DEVICEPROCESSORHISTORY_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>

