///@todo take this and dependencies from code tVoid StateTable::fillTestDevices(tVoid)
///@todo take prm mount from code this won't be used anymore
///@todo check if it is possible to incluefr the state table project dependent
/*-----------------------------------------------------------------------------*
 * StateTable.cpp                                                              *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file StateTable.cpp
 *
 * \brief This file holds the implementation of the StateTable which uses inputs
 *        of UdevManger and prm to evaluate a result to be send to the clients.
 *
 * \version Initial Version
 * \version 05.08.2011, Koechling, Christian (Bosch), Interface VD_DeviceManager
 *          changed
 *
 *-----------------------------------------------------------------
 *                                    development for Gen3:
 *-----------------------------------------------------------------
 *\version 23.10.2013, Christian Koechling (Bosch)
 *          -# start tp replace QStrings by replacing QString by define GENSTRING
 *
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#include <unistd.h> //for GCC 4.7.3
#include <sys/mount.h>  //Roadmap 14002 MountCDROM
//#include <sys/types.h>  //Roadmap 14002 MountCDROM
#include <sys/stat.h>   //Roadmap 14002 MountCDROM
#include <iostream>
#include <fstream>
#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"
#include "Diagnosis.h"
#include "UDevManager.h"
#include "IPrmManagerCard.h"
#include "StateTable.h"
#include "device/DeviceListManager.h"
#include "DeviceManager_ErrorCodes.h"
#include "interface/DeviceManagerInterface.h"
#include "debug/HistoryManager.h"
#include "config/ConfigurationManager.h"
#include "ports/PortListManager.h"

#include "TimerDVM.h"//for Timer replacement
#include "MessageQueueDVM.h"//for MessageQueue replacement

#include "common/utils.h"

/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_STATE_TABLE
#include "trcGenProj/Header/StateTable.cpp.trc.h"
#endif
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST


/*-----------------------------------------------------------------------------*
 * namespace                                                                     *
 *-----------------------------------------------------------------------------*/
using namespace configmgr;

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/


#define LOCK_TABLE     m_table.lock();
#define UNLOCK_TABLE   m_table.unlock();

#define LOCK_THREAD     m_thread.lock();
#define UNLOCK_THREAD   m_thread.unlock();

#define STATETABLE_ELEMENTS  (sizeof(StateTable::m_voltageFailureStateTable_USB1)/ sizeof(voltageFailure_IFOutput_t))


#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
static IDeviceManagerInterfaceGeneral   *g_pIDeviceManagerInterfaceGeneral   = NULL;
static IDeviceManagerInterfaceDiagnosis *g_pIDeviceManagerInterfaceDiagnosis = NULL;
static IUdevManagerInternalInput        *g_pIUdevManagerInternalInput        = NULL;

#define DVMGRIF_GENERAL                  g_pIDeviceManagerInterfaceGeneral
#define DVMGRIF_DIAGNOSIS                g_pIDeviceManagerInterfaceDiagnosis
#define UDEVMGRIF_INTERNALINPUT          g_pIUdevManagerInternalInput
#else
#define DVMGRIF_GENERAL          DeviceManagerInterface::GetInstance()
#define DVMGRIF_DIAGNOSIS        DeviceManagerInterface::GetInstance()
#define UDEVMGRIF_INTERNALINPUT  CUDevManager::GetInstance()
#endif

#define TIMER1_STETBL (char*)"TIMER1_STETBL"
#define TIMER2_STETBL (char*)"TIMER2_STETBL"
/*-----------------------------------------------------------------------------*
 * State table initialisation                                                 *
 *-----------------------------------------------------------------------------*/

/*
===================
how to read this table:
===================
at the left hand side you find output states like USB_DEV_REMOVED_BY_USR, USB_DEV_CONNECTED etc.
in brackets further right in each line you find the combination of Inputsignals which would result in e.g. UDB_DEV_CONNECTED

in fuction StateTable::getResult(...) the table is used to deduce the left hand output (result) entry.

In the traces you find e.g. such an entry
                                                                                                     Current Signal      SignalplusAny     Pattern[00]  [StateTable.cpp(852)]
<gen3flex@dlt>(core0)VD_DVM_STE_TBL__CMP :   U60_drop                :0x02               0x02            0x01      [StateTable.cpp(853)]
<gen3flex@dlt>(core0)VD_DVM_STE_TBL__CMP :   U50_USB_Reset      :0x01               0x01            0x01      [StateTable.cpp(856)]
<gen3flex@dlt>(core0)VD_DVM_STE_TBL__CMP :   OC                           :0x01               0x01            0x01      [StateTable.cpp(859)]
<gen3flex@dlt>(core0)VD_DVM_STE_TBL__CMP :   PPON                       :0x02               0x02            0x02      [StateTable.cpp(862)]
<gen3flex@dlt>(core0)VD_DVM_STE_TBL__CMP :   mountedUSB (prm)  :0x02               0x02            0x00      [StateTable.cpp(865)]
<gen3flex@dlt>(core0)VD_DVM_STE_TBL__CMP :   mountedUSB (udev) :0x02               0x02            0x00      [StateTable.cpp(868)]

Current Signal:             is the current input from plattform
Pattern:                        is the row of the table below here it is that with index 0 i,e, to check for output USB_DEV_UNDEFINED
SignalplusAny:              means take the CurrentSignal input and replace those entries which are SIG_ANY according to Pattern. Then result will be compared to the pattern.
                                     In the example on can see that it does not match - hence the next pattern will be used

Note: U60_drop is intialised SIG_FALSE if in GM software is configured not to listen to drv_volt signals hence U60_drop is always set false

@todo mountedUSB_prm, USBAll  have to be cleaned from code
@todo to serve CDROM another table might be necessary

*/

voltageFailure_IFOutput_t StateTable::m_voltageFailureStateTable_USB1[] =
{
    /*                 SIGNALS->:                                                   USB#Host  U60_drop   USBAll                      OC          PPON        mountedUSB_prm   mountedUSB_udev */
    /*------------------------------------------------------------------------------------------------------------------------------*/
    /*No.  RESULT (5 entries):                                                                                                      */

    /*01*/{{/*USBPort1*/USB_DEV_UNDEFINED},          {   eUSB1,   SIG_FALSE,   SIG_ANY,   SIG_FALSE,   SIG_TRUE,    SIG_UNDEF,      SIG_UNDEF }},

    /*02*/{{/*USBPort1*/USB_DEV_REMOVED_BY_USR},     {   eUSB1,   SIG_FALSE,   SIG_ANY,   SIG_FALSE,   SIG_TRUE,    SIG_FALSE,      SIG_FALSE }},     /*only send if device is disconnected*/

    /*03*/{{/*USBPort1*/USB_DEV_CONNECTED},          {   eUSB1,   SIG_FALSE,   SIG_ANY,   SIG_FALSE,   SIG_TRUE,    SIG_TRUE,       SIG_TRUE  }},    /*only send if device is conected*/

    /*04*/{{/*USBPort1*/USB_DEV_UNAVAIL_HW_MALFUNC}, {   eUSB1,   SIG_ANY,     SIG_ANY,   SIG_TRUE,    SIG_ANY,     SIG_TRUE,       SIG_TRUE   }},   /*only send if device is conected*/

    /*05*/{{/*USBPort1*/USB_DEV_UNAVAIL_BAT_LOWVOLT},{   eUSB1,   SIG_TRUE,    SIG_ANY,   SIG_ANY,     SIG_ANY,     SIG_TRUE,       SIG_TRUE   }}    /*only send if device is conected*/

    /*-----------------------------------------------------------------------------------------------------------------------------------------*/
};

voltageFailure_IFOutput_t StateTable::m_voltageFailureStateTable_USB2[] =
{
    /*                 SIGNALS->:                                                USB#Host   U60_drop          USBAll                     OC          PPON         mountedUSB_prm   mountedUSB_udev */
    /*---------------------------------------------------------------------------------------------------------------------------------*/
    /*No.  RESULT (5 entries):                                                                                                         */

    /*01*/{{/*USBPort2*/USB_DEV_UNDEFINED},          {   eUSB2,   SIG_FALSE,   SIG_ANY,   SIG_FALSE,   SIG_TRUE,    SIG_UNDEF,      SIG_UNDEF }},

    /*02*/{{/*USBPort2*/USB_DEV_REMOVED_BY_USR},     {   eUSB2,   SIG_FALSE,   SIG_ANY,   SIG_FALSE,   SIG_TRUE,    SIG_FALSE,      SIG_FALSE }},

    /*03*/{{/*USBPort2*/USB_DEV_CONNECTED},          {   eUSB2,   SIG_FALSE,   SIG_ANY,   SIG_FALSE,   SIG_TRUE,    SIG_TRUE,       SIG_TRUE }},

    /*04*/{{/*USBPort2*/USB_DEV_UNAVAIL_HW_MALFUNC}, {   eUSB2,   SIG_FALSE,   SIG_ANY,   SIG_TRUE,    SIG_ANY,     SIG_TRUE,       SIG_TRUE  }},

    /*05*/{{/*USBPort2*/USB_DEV_UNAVAIL_BAT_LOWVOLT},{   eUSB2,   SIG_TRUE,    SIG_ANY,   SIG_ANY,     SIG_ANY,     SIG_TRUE,       SIG_TRUE  }}

    /*-----------------------------------------------------------------------------------------------------------------------------------------*/
};

voltageFailure_IFOutput_t StateTable::m_voltageFailureStateTable_USB3[] =
{
    /*                 SIGNALS->:                                                USB#Host   U60_drop          USBAll                     OC          PPON         mountedUSB_prm   mountedUSB_udev */
    /*---------------------------------------------------------------------------------------------------------------------------------*/
    /*No.  RESULT (5 entries):                                                                                                         */

    /*01*/{ {/*USBPort3*/USB_DEV_UNDEFINED }, { eUSB3, SIG_FALSE, SIG_ANY, SIG_FALSE, SIG_TRUE, SIG_UNDEF, SIG_UNDEF } },

    /*02*/{ {/*USBPort3*/USB_DEV_REMOVED_BY_USR }, { eUSB3, SIG_FALSE, SIG_ANY, SIG_FALSE, SIG_TRUE, SIG_FALSE, SIG_FALSE } },

    /*03*/{ {/*USBPort3*/USB_DEV_CONNECTED }, { eUSB3, SIG_FALSE, SIG_ANY, SIG_FALSE, SIG_TRUE, SIG_TRUE, SIG_TRUE } },

    /*04*/{ {/*USBPort3*/USB_DEV_UNAVAIL_HW_MALFUNC }, { eUSB3, SIG_FALSE, SIG_ANY, SIG_TRUE, SIG_ANY, SIG_TRUE, SIG_TRUE } },

    /*05*/{ {/*USBPort3*/USB_DEV_UNAVAIL_BAT_LOWVOLT }, { eUSB3, SIG_TRUE, SIG_ANY, SIG_ANY, SIG_ANY, SIG_TRUE, SIG_TRUE } }

    /*-----------------------------------------------------------------------------------------------------------------------------------------*/
};

#ifdef USE_FOURTH_USB_CONNECTOR
voltageFailure_IFOutput_t StateTable::m_voltageFailureStateTable_USB4[] =
{
    /*                 SIGNALS->:                                                USB#Host   U60_drop          USBAll                     OC          PPON         mountedUSB_prm   mountedUSB_udev */
    /*---------------------------------------------------------------------------------------------------------------------------------*/
    /*No.  RESULT (5 entries):                                                                                                         */

    /*01*/{{/*USBPort4*/USB_DEV_UNDEFINED},          {   eUSB4,   SIG_FALSE,   SIG_ANY,   SIG_FALSE,   SIG_TRUE,    SIG_UNDEF,      SIG_UNDEF }},

    /*02*/{{/*USBPort4*/USB_DEV_REMOVED_BY_USR},     {   eUSB4,   SIG_FALSE,   SIG_ANY,   SIG_FALSE,   SIG_TRUE,    SIG_FALSE,      SIG_FALSE }},

    /*03*/{{/*USBPort4*/USB_DEV_CONNECTED},          {   eUSB4,   SIG_FALSE,   SIG_ANY,   SIG_FALSE,   SIG_TRUE,    SIG_TRUE,       SIG_TRUE }},

    /*04*/{{/*USBPort4*/USB_DEV_UNAVAIL_HW_MALFUNC}, {   eUSB4,   SIG_FALSE,   SIG_ANY,   SIG_TRUE,    SIG_ANY,     SIG_TRUE,       SIG_TRUE  }},

    /*05*/{{/*USBPort4*/USB_DEV_UNAVAIL_BAT_LOWVOLT},{   eUSB4,   SIG_TRUE,    SIG_ANY,   SIG_ANY,     SIG_ANY,     SIG_TRUE,       SIG_TRUE  }}

    /*-----------------------------------------------------------------------------------------------------------------------------------------*/
};
#endif


/*
===================
how to read this table:
===================
e.g. current state at the left hand side is 'USB_DEV_CONNECTED'
after StateTable::getResult(...) has been executed next demanded state might be 'USB_DEV_UNAVAIL_BAT_LOWVOLT' this leads to 'eLOWVOLT'

'eLowvolt' then gives the index for table m_msgListInformClients.
clients would be informed about 'USB_DEV_UNAVAIL_BAT_LOWVOLT' - it would be possible also to send a sequence of messages in such case




*/

/*-----------------------------------------------------------------------------*
 * State table initialisation - inform clients add on                                                                  *
 *-----------------------------------------------------------------------------*/
StateTableElemInformClients_t StateTable::m_stateTableInformClients[] =
{
    /*                 demanded state->:            USB_DEV_UNDEFINED  USB_DEV_WARNING  USB_DEV_CONNECTED  USB_DEV_REMOVED_BY_USR  USB_DEV_UNAVAIL_BAT_LOWVOLT  USB_DEV_UNAVAIL_HW_MALFUNC  USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT}}*/

    /*-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    /*current state:                                                                                                                                                                                                                       */

    /*00*/{USB_DEV_UNDEFINED,                      {   eNo,               eNo,            eCONNECT,          eNo,                    eNo,                         eNo,                        eNo                                 }},

    /*01*/{USB_DEV_WARNING,                        {   eNo,               eNo,            eCONNECT,          eREMOVE,                eLOWVOLT,                    eMALFUNC,                   eNo                                 }},

    /*02*/{USB_DEV_CONNECTED,                      {   eNo,               eWARN,          eNo,               eNo,                    eLOWVOLT,                    eMALFUNC,                   eNo                                 }},

    /*03*/{USB_DEV_REMOVED_BY_USR,                 {   eNo,               eNo,            eNo,               eNo,                    eNo,                         eNo,                        eNo                                 }},
    #ifndef USE_SENT_ALL_CHANGES
    /*04*/{USB_DEV_UNAVAIL_BAT_LOWVOLT,            {   eNo,               eNo,            eCONNECT,          eNo,                    eNo,                         eNo,                        eNo                                 }},

    /*05*/{USB_DEV_UNAVAIL_HW_MALFUNC,             {   eNo,               eNo,            eCONNECT,          eNo,                    eNo,                         eNo,                        eNo                                 }},
    #else // USE_SENT_ALL_CHANGES
    /*04*/{USB_DEV_UNAVAIL_BAT_LOWVOLT,            {   eNo,               eNo,            eCONNECT,          eREMOVE,                eNo,                         eNo,                        eNo                                 }},

    /*05*/{USB_DEV_UNAVAIL_HW_MALFUNC,             {   eNo,               eNo,            eCONNECT,          eREMOVE,                eNo,                         eNo,                        eNo                                 }},
    #endif //USE_SENT_ALL_CHANGES
    /*06*/{USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT,   {   eNo,               eNo,            eCONNECT,          eNo,                    eNo,                         eNo,                        eNo                                 }},

    #ifdef BUGFIX_CONNECTIPOD_REMOVEUSBSAMETIME
    /*07*/{USB_DEV_INTERNAL_APPLY_CONNECT,         {   eNo,               eNo,            eCONNECT,          eCONNECT,               eLOWVOLT_CONNECT,            eMALFUNC_CONNECT,           eNo                                 }},
    #else
    /*07*/{USB_DEV_INTERNAL_APPLY_CONNECT,         {   eNo,               eNo,            eCONNECT,          eNo,                    eLOWVOLT_CONNECT,            eMALFUNC_CONNECT,           eNo                                 }},
    #endif
    /*08*/{USB_DEV_INTERNAL_APPLY_REMOVED_BY_USR,  {   eNo,               eNo,            eNo,               eREMOVE,                eREMOVE,                     eREMOVE,                    eNo                                 }}

    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
};


/*output of this list*/
/*Note: to make the aboce list readyble more comfortable '0' has been used instead of eNone*/
MsgListElemInformClients_t StateTable::m_msgListInformClients[] =
{
    /*eNone*/              {/*numOfMsgs=*/0,{/*msglist:*/-1                               ,-1                                ,-1                           }},
    /*eWARN   */           {/*numOfMsgs=*/1,{/*msglist:*/(tInt)USB_DEV_WARNING            ,-1                                ,-1                           }},
    /*eCONNECT*/           {/*numOfMsgs=*/1,{/*msglist:*/(tInt)USB_DEV_CONNECTED          ,-1                                ,-1                           }},
    /*eREMOVE */           {/*numOfMsgs=*/1,{/*msglist:*/(tInt)USB_DEV_REMOVED_BY_USR     ,-1                                ,-1                           }},
    #ifndef USE_SENT_ALL_CHANGES
    /*eLOWVOLT*/           {/*numOfMsgs=*/2,{/*msglist:*/(tInt)USB_DEV_UNAVAIL_BAT_LOWVOLT,-1                                ,-1                           }},
    /*eLOWVOLT_CONNECT*/   {/*numOfMsgs=*/3,{/*msglist:*/(tInt)USB_DEV_CONNECTED          ,(tInt)USB_DEV_UNAVAIL_BAT_LOWVOLT ,(tInt)USB_DEV_REMOVED_BY_USR }},
    /*eMALFUNC*/           {/*numOfMsgs=*/2,{/*msglist:*/(tInt)USB_DEV_UNAVAIL_HW_MALFUNC ,(tInt)USB_DEV_REMOVED_BY_USR      ,-1                           }},
    /*eMALFUNC_CONNECT*/   {/*numOfMsgs=*/3,{/*msglist:*/(tInt)USB_DEV_CONNECTED          ,(tInt)USB_DEV_UNAVAIL_HW_MALFUNC  ,(tInt)USB_DEV_REMOVED_BY_USR }}
    #else // USE_SENT_ALL_CHANGES
    /*eLOWVOLT*/           {/*numOfMsgs=*/1,{/*msglist:*/(tInt)USB_DEV_UNAVAIL_BAT_LOWVOLT,-1                                ,-1                           }},
    /*eLOWVOLT_CONNECT*/   {/*numOfMsgs=*/2,{/*msglist:*/(tInt)USB_DEV_CONNECTED          ,(tInt)USB_DEV_UNAVAIL_BAT_LOWVOLT ,-1                           }},
    /*eMALFUNC*/           {/*numOfMsgs=*/1,{/*msglist:*/(tInt)USB_DEV_UNAVAIL_HW_MALFUNC ,-1                                ,-1                           }},
    /*eMALFUNC_CONNECT*/   {/*numOfMsgs=*/2,{/*msglist:*/(tInt)USB_DEV_CONNECTED          ,(tInt)USB_DEV_UNAVAIL_HW_MALFUNC  ,-1                           }}
    #endif //USE_SENT_ALL_CHANGES
};

/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace prmmgr;
using namespace statetbl;

/*-----------------------------------------------------------------------------*
 * Singleton                                                                   *
 *-----------------------------------------------------------------------------*/
// static pointer used to ensure a single instance of StateTable
StateTable     *StateTable::m_pStateTableManager = NULL;
DVMLOCK         StateTable::m_singelton;

/*-----------------------------------------------------------------------------*
 * Parameterized constructor                                                   *
 *-----------------------------------------------------------------------------*/

StateTable::StateTable()
{
    ETG_TRACE_USR4(("Begin: constructor StateTable"));

    m_bIsActive = FALSE;
#ifdef BUGFIX_POORDEVICERECOGNITION
    m_bIsActive = TRUE;
#endif
    m_u32CommonIntervalTimer_ms    = 0;
    m_u32ConnectIntervalTimer_ms   = 0;
    m_bEnableExecutionTimer  = FALSE;
    m_iIntervalSignalCounter = 0;

    m_resultLastSendtoClient[eUSB1].resultUSB=USB_DEV_UNDEFINED;
    m_resultLastSendtoClient[eUSB2].resultUSB=USB_DEV_UNDEFINED;
    m_resultLastSendtoClient[eUSB3].resultUSB = USB_DEV_UNDEFINED;
#ifdef USE_FOURTH_USB_CONNECTOR
    m_resultLastSendtoClient[eUSB4].resultUSB=USB_DEV_UNDEFINED;
#endif

    m_bCommonTimerStarted=FALSE; //has been initiaized but not started yet
    m_bConnectTimerStarted = FALSE;//has been initiaized but not started yet

    for(tInt i = (tInt)eUSB1; i<ARRAYSIZEFORUSB;++i)
    {
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_PRM_HWSIGNALS))
        {
            /*prm sets intial value if vd_devicemanager registers at it*/

            /*current status of signals are stored here - this is the initialization part*/
            m_signal[i].usb = (tenDevManagerUSBHost)i;
            m_signal[i].OC            = SIG_UNDEF;
            m_signal[i].PPON          = SIG_UNDEF;
            m_signal[i].mountedUSB    = SIG_UNDEF; //@todo obsolete covered by mountedUSBref
            m_signal[i].mountedUSBref = SIG_UNDEF;
            m_signal[i].U50_USB_Reset = SIG_UNDEF;

            m_result[i].resultUSB    =USB_DEV_UNDEFINED;

#ifdef WORKAROUND_PRMBUG
            ETG_TRACE_COMP(("WORKAROUND_PRMBUG enabled: in case of SIG_UNDEF signals of PRM ERRMEM-ENTRY will be created"));
            /*current status of signals are stored here - this is the initialization part*/
            /*this is done in case prm does not send any callback at all in G3G*/
            m_signal[i].usb = (tenDevManagerUSBHost)i;
            m_signal[i].OC            = SIG_FALSE;
            m_signal[i].PPON          = SIG_TRUE;
            m_signal[i].mountedUSB    = SIG_FALSE;//@todo obsolete covered bymountedUSBref
            m_signal[i].mountedUSBref = SIG_FALSE;
            m_signal[i].U50_USB_Reset = SIG_FALSE;

            m_result[i].resultUSB    = USB_DEV_REMOVED_BY_USR;
#endif
        }
        else
        {
            /*current status of signals are stored here - this is the initialization part*/
            m_signal[i].usb = (tenDevManagerUSBHost)i;
            m_signal[i].OC            = SIG_FALSE;
            m_signal[i].PPON          = SIG_TRUE;
            m_signal[i].mountedUSB    = SIG_FALSE;
            m_signal[i].mountedUSBref = SIG_FALSE;
            m_signal[i].U50_USB_Reset = SIG_FALSE;

            m_result[i].resultUSB    = USB_DEV_REMOVED_BY_USR;
        }

        m_signal[i].U60_drop      = SIG_FALSE;   //drv_volt does not signal low volt end at normal startup - we have to assume this


#ifdef MONITOR_PERMANENT_HW_FAILURE
        m_u32CountPermanentOvercurrent[i] = 0;
#endif
    }//for(tInt i = eUSB1; i<ARRAYSIZEFORUSB;++i)

    /*main msgQ which is used to send input  of prm,udev and spm etc. too after an intervall timer expires the reult will be evaluated for clients*/
    m_msgQ.u32MaxElementsInQueue     = MAXMSGSINQ;
    m_msgQ.u16SizeOfElement          = UTIL_LENOFQMSG;
    OSAL_szStringCopy(m_msgQ.sMsgQName,STATETABLEQ);//lint !e522: (or direkt call to strcpy): Warning 522: prio3: Highest operation, a 'cast', lacks side-effects

    if (MessageQueueDVM::OK != m_MessageQueueDVM.iInit(m_msgQ.sMsgQName,m_msgQ.u32MaxElementsInQueue,m_msgQ.u16SizeOfElement,VDDVM_EN_READWRITE))
    {
        ETG_TRACE_FATAL(("ERROR:m_MessageQueueDVM.iInit failed"));
        ETG_TRACE_ERRMEM(("ERROR:m_MessageQueueDVM.iInit failed"));
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }

    ETG_TRACE_USR1(("StateTable: create MsgQ"));
    ETG_TRACE_USR4(("            m_msgQ.sMsgQName             = %s",m_msgQ.sMsgQName));
    ETG_TRACE_USR4(("            m_msgQ.u16SizeOfElement       = %d",m_msgQ.u16SizeOfElement));
    ETG_TRACE_USR4(("            m_msgQ.u32MaxElementsInQueue = %d",m_msgQ.u32MaxElementsInQueue));

#ifdef USE_SENT_ALL_CHANGES
    // create timer and check return value
    if(TimerDVM::OK != m_TimerDvm1UsbRecognitionAfterClvEvent.iTimerCreate( vOnTimeoutUsbRecognitionAfterClvEvent, (tPVoid)this ,TIMER1_STETBL )  )
    {
        ETG_TRACE_FATAL(("StateTable: timer creation failed: m_TimerDvm1UsbRecognitionAfterClvEvent for vOnTimeoutUsbRecognitionAfterClvEvent"));
    }
#endif //#if USE_SENT_ALL_CHANGES


    if(TimerDVM::OK != m_TimerDvm2SignalAccumulationTimer.iTimerCreate( vOnTimeoutSignalAccumulationTimer, (tPVoid)this , TIMER2_STETBL ) )
    {
        ETG_TRACE_FATAL(("StateTable: timer creation failed: m_TimerDvm2SignalAccumulationTimer for vOnTimeoutSignalAccumulationTimer"));
    }



    m_bOverTemperature  = FALSE; //Roadmap 13035 OverTemperature
    m_bMountedCDRomDiag = FALSE; //Roadmap 14002 CDROMMount (MixedModeDiag)

    m_pIPrmManagerCard = NULL;

    //test hook  used in unit test
    m_bTestHookNoErase = false;

    ETG_TRACE_USR4(("End  : constructor StateTable"));
}

/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
StateTable::~StateTable()
{
    //@todo check clean shutdown eventually shift this to function DestroyInstance
    vShutdown();           //lint !e1551 Warning 1551;Function may throw exception

#ifdef USE_SENT_ALL_CHANGES
    m_TimerDvm1UsbRecognitionAfterClvEvent.iTimerStop();     //stop the timer
    m_TimerDvm1UsbRecognitionAfterClvEvent.iTimerDelete( );            // delete the timer
#endif //#if USE_SENT_ALL_CHANGES


    ETG_TRACE_USR1(( "bStopTimer( ): Stop timer m_TimerDvm2SignalAccumulationTimer" ));
    m_TimerDvm2SignalAccumulationTimer.iTimerStop();            //stop the timer
    m_TimerDvm2SignalAccumulationTimer.iTimerDelete();            // delete the timer


}

/*-----------------------------------------------------------------------------*
 * tVoid sendSignalsTest(voltageFailure_HWSignalsAll_t signal)                 *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::sendSignalsTest( const voltageFailure_HWSignalsAll_t& voltageFailuresignal)
{
    UsbPortState rPortState;
    tBool bSend2Q;

    ETG_TRACE_USR4(("Begin: sendSignalsTest"));
    ETG_TRACE_USR2(("sendSignalsTest:signal[USB%1d].U60_drop       %d                ",voltageFailuresignal.usb,ETG_ENUM(TENSIGNALVALUE,voltageFailuresignal.U60_drop)));
    ETG_TRACE_USR2(("sendSignalsTest:signal[USB%1d].U50_USB_Reset  %d                ",voltageFailuresignal.usb,ETG_ENUM(TENSIGNALVALUE,voltageFailuresignal.U50_USB_Reset)));
    ETG_TRACE_USR2(("sendSignalsTest:signal[USB%1d].OC             %d                ",voltageFailuresignal.usb,ETG_ENUM(TENSIGNALVALUE,voltageFailuresignal.OC)));
    ETG_TRACE_USR2(("sendSignalsTest:signal[USB%1d].PPON           %d                ",voltageFailuresignal.usb,ETG_ENUM(TENSIGNALVALUE,voltageFailuresignal.PPON)));
    ETG_TRACE_USR2(("sendSignalsTest:signal[USB%1d].mountedUSB     %d                ",voltageFailuresignal.usb,ETG_ENUM(TENSIGNALVALUE,voltageFailuresignal.mountedUSB)));
    ETG_TRACE_USR2(("sendSignalsTest:signal[USB%1d].mountedUSBref  %d                ",voltageFailuresignal.usb,ETG_ENUM(TENSIGNALVALUE,voltageFailuresignal.mountedUSBref)));

    LOCK_TABLE;

    //-------------------------------
    //helper to simulate PRM HW-signals
    //-------------------------------

    rPortState.u8PortNr     = (tU8)voltageFailuresignal.usb;
    rPortState.u8UV         = (tU8)voltageFailuresignal.U50_USB_Reset;
    rPortState.u8OC         = (tU8)voltageFailuresignal.OC;
    rPortState.u8PPON       = (tU8)voltageFailuresignal.PPON;

    //@todo mechanism may be added to simulate timings of prm
    rPortState.u32OCStartTime  =0;
    rPortState.u32OCEndTime    =0;
    rPortState.u32UVStartTime  =0;
    rPortState.u32UVEndTime    =0;
    rPortState.u32PPONStartTime=0;
    rPortState.u32PPONEndTime  =0;

    //now adjust only those which are !=SIG_ANY
    bSend2Q = FALSE;
    if(SIG_ANY != voltageFailuresignal.U50_USB_Reset)
    {
        rPortState.u8UV=(tU8)voltageFailuresignal.U50_USB_Reset;
        bSend2Q = TRUE;
    }
    if(SIG_ANY != voltageFailuresignal.OC)
    {
        rPortState.u8OC=(tU8)voltageFailuresignal.OC;
        bSend2Q=TRUE;
    }
    if(SIG_ANY != voltageFailuresignal.PPON)
    {
        rPortState.u8PPON=(tU8)voltageFailuresignal.PPON;
        bSend2Q=TRUE;
    }
    //send2Q
    if(TRUE==bSend2Q)
    {
        setHWSignals(&rPortState);
    }

    //---------------------------------
    //helper to simulate SPM U60_drop signal
    //---------------------------------
    if(SIG_ANY != voltageFailuresignal.U60_drop)
    {
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_VOLTAGEMANAGER))
        {
            setVoltage(voltageFailuresignal.usb,voltageFailuresignal.U60_drop);//send2Q
        }
    }
    //--------------------------------------
    //helper to simulate udev Mount signals
    //--------------------------------------
    if(SIG_ANY != voltageFailuresignal.mountedUSBref)
    {
        if( (SIG_TRUE == voltageFailuresignal.mountedUSBref) || (SIG_FALSE == voltageFailuresignal.mountedUSBref) )
        {
            //@todo possible cleanup: bind this to internal execution of set mount
            m_TestDevice[voltageFailuresignal.usb].m_eConnectStatus = USB_DEV_REMOVED_BY_USR;
            if(SIG_TRUE == voltageFailuresignal.mountedUSBref)
            {
                m_TestDevice[voltageFailuresignal.usb].m_eConnectStatus = USB_DEV_CONNECTED;
            }

            setMount(enMountUdev,voltageFailuresignal.usb,voltageFailuresignal.mountedUSBref,&m_TestDevice[voltageFailuresignal.usb]);
        }
        else
        {
            ETG_TRACE_FATAL(("ERROR sendSignalsTest: Wrong value: signal.mountedUSBref=0x%x",voltageFailuresignal.mountedUSBref));
        }
    }

    UNLOCK_TABLE

            ETG_TRACE_USR4(("End  : sendSignals"));
}

/*-----------------------------------------------------------------------------*
 * tVoid setSignals(voltageFailure_HWSignalsAll_t signal)                      *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::setSignals( const voltageFailure_HWSignalsAll_t& voltageFailuresignal)
{
    ETG_TRACE_USR4(("Begin: setSignals"));
    LOCK_TABLE
            tenDevManagerUSBHost usb=voltageFailuresignal.usb;

    if( (usb<eUSB1) || ((tInt)usb>=ARRAYSIZEFORUSB))
    {




#if !defined(BUGFIX_DECOUPLE_SDCARD_PRM) && !defined(BUGFIX_DECOUPLE_CDROM_PRM)
        ETG_TRACE_FATAL(("[ERROR]:setSignals: usb:%d",(tInt)usb));
        ETG_TRACE_ERRMEM(("[ERROR]:setSignals: usb:%d",(tInt)usb));
        DVM_NORMAL_M_ASSERT_ALWAYS();
#endif
        ETG_TRACE_USR1(("setSignals: Nothing set because eUSB%d not bound to prm signals", (tInt)usb));
        ETG_TRACE_USR1(("setSignals: USB Connectors bound to HW signals are:"));
        for(tInt k=(tInt)eUSB1; k<ARRAYSIZEFORUSB; k++)
        {
            ETG_TRACE_USR1(("setSignals: eUSB%d is bound to",k));
        }
    }
    else
    {
        m_signal[usb].OC            = voltageFailuresignal.OC;
        m_signal[usb].PPON          = voltageFailuresignal.PPON ;
        m_signal[usb].U60_drop      = voltageFailuresignal.U60_drop;
        m_signal[usb].mountedUSB    = voltageFailuresignal.mountedUSB;
        m_signal[usb].mountedUSBref = voltageFailuresignal.mountedUSBref;
        m_signal[usb].U50_USB_Reset = voltageFailuresignal.U50_USB_Reset;

        ETG_TRACE_USR1(("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
        ETG_TRACE_USR1((" setSignal: (show new current value):                   "));
        ETG_TRACE_USR1((" setSignal:m_signal[USB%1d].U60_drop             %d               ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].U60_drop)));
        ETG_TRACE_USR1((" setSignal:m_signal[USB%1d].U50_USB_Reset        %d               ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].U50_USB_Reset) ));
        ETG_TRACE_USR1((" setSignal:m_signal[USB%1d].OC                   %d               ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].OC )));
        ETG_TRACE_USR1((" setSignal:m_signal[USB%1d].PPON                 %d                   ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].PPON )));
        ETG_TRACE_USR1((" setSignal:m_signal[USB%1d].mountedUSB  (prm)    %d               ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].mountedUSB ) ));
        ETG_TRACE_USR1((" setSignal:m_signal[USB%1d].mountedUSB  (udev)   %d               ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].mountedUSBref ) ));
        ETG_TRACE_USR1(("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
    }

    UNLOCK_TABLE
            ETG_TRACE_USR4(("End  : setSignals"));
}

/*-----------------------------------------------------------------------------*
 * tVoid ChkTriggerTimer(tVoid)                                                *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vChkTriggerTimer(const tBool isDeviceConnection) /*see -  case enTimerExp in StartMonitorLooseBlocking*/
{
    ETG_TRACE_USR4(("Begin: vChkTriggerTimer: m_bEnableExecutionTimer: m_bEnableExecutionTimer:0x%x m_bCommonTimerStarted:0x%x m_bConnectTimerStarted::0x%x",m_bEnableExecutionTimer, m_bCommonTimerStarted,m_bConnectTimerStarted));
    if(TRUE == m_bEnableExecutionTimer)
    {
        //if timer not started then start timer otherwhise increment counter for later analysis
        if((FALSE == m_bCommonTimerStarted) && (FALSE == m_bConnectTimerStarted))
        {
            tU32 u32Timer_ms;
            //HWMALFUNCTIONHISTORY.AddToHistory(GENSTRING("vChkTriggerTimer(): START TIMER - (expires in DVM_Tpost_ms)"),NULL);
            m_iIntervalSignalCounter = 0;
            /*
             *NCG3D-146730:If request is to trigger timer for connection event then start the timer with timeout value of m_u32ConnectIntervalTimer_ms
             *else start the timer with m_u32ConnectIntervalTimer_ms(common timout value for events like device disconnection,malfunction,...)
             */
            if(true == isDeviceConnection)
            {
                u32Timer_ms = m_u32ConnectIntervalTimer_ms;
                ETG_TRACE_COMP(("vChkTriggerTimer: m_u32ConnectIntervalTimer_ms:%d",u32Timer_ms));
            }
            else
            {
                u32Timer_ms = m_u32CommonIntervalTimer_ms;
                ETG_TRACE_COMP(("vChkTriggerTimer: m_u32CommonIntervalTimer_ms:%d",u32Timer_ms));
            }

            //-----------------------------------------
            //Timeout value is 0, no need to trigger timer. vCASEenTimerExp to be called immediately
            //No need to set m_bConnect/commonTimerStarted flag, since we handle the vCASEenTimerExp through msg and no race condition will occur
            //-----------------------------------------
            if(0 == u32Timer_ms)
            {
                ETG_TRACE_COMP(("vChkTriggerTimer: TIMER not started since connect timeout value is zero!"));
                setTimerExpired(this);
            }
            else//Timeout value is non-zero ,so start the timer
            {
                if(TimerDVM::ERROR != m_TimerDvm2SignalAccumulationTimer.iTimerStart( u32Timer_ms,
                                                                                      /*(OSAL_tMSecond) interval = */0 ,
                                                                                      (void*)this,
                                                                                      &bOnTimeoutSignalAccumulationTimer,
                                                                                      TIMER2_STETBL))
                {
                    if(true == isDeviceConnection)
                    {
                        m_bConnectTimerStarted = TRUE;
                    }
                    else
                    {
                        m_bCommonTimerStarted = TRUE;
                    }
                    ETG_TRACE_COMP(("vChkTriggerTimer: TIMER started!"));
                }
                else
                {
                    ETG_TRACE_FATAL(("vChkTriggerTimer: NOK: TIMER start failed!"));
                }
            }
        }
        /*
         * we got a disconnect and already a connect timer is going on, so restart the timer to catch the electrical failure if there is any
         * Note : currently this code part will not be executed because the connect timeout value is 0, hence "TRUE == m_bConnectTimerStarted" is not possible
         * Refer Config.h STATETABLE_CONNECT_EXECUTION_TIME_MS for furter info
         */
        else if(false == isDeviceConnection && TRUE == m_bConnectTimerStarted)
        {
            if(TimerDVM::ERROR != m_TimerDvm2SignalAccumulationTimer.iTimerStop())
            {
                m_bConnectTimerStarted = FALSE;
                ETG_TRACE_COMP(("vChkTriggerTimer: Connect TIMER stopped successfully"));
                ETG_TRACE_COMP(("vChkTriggerTimer: Restart timer interval, m_u32CommonIntervalTimer_ms:%d",m_u32CommonIntervalTimer_ms));
                if(TimerDVM::ERROR != m_TimerDvm2SignalAccumulationTimer.iTimerStart( m_u32CommonIntervalTimer_ms,
                                                                                      /*(OSAL_tMSecond) interval = */0 ,
                                                                                      (void*)this,
                                                                                      &bOnTimeoutSignalAccumulationTimer,
                                                                                      TIMER2_STETBL))
                {
                    m_bCommonTimerStarted = TRUE;;
                    ETG_TRACE_COMP(("vChkTriggerTimer: TIMER Re-started!"));
                }
                else
                {
                    ETG_TRACE_FATAL(("vChkTriggerTimer: NOK: TIMER Re-start failed!"));
                }
            }
            else
            {
                ETG_TRACE_FATAL(("vChkTriggerTimer: NOK: TIMER STOP!"));
            }
        }
        else
        {
            ETG_TRACE_COMP(("vChkTriggerTimer:Common Timer or Connect timer is already running"));
        }

        m_iIntervalSignalCounter++;
    }
    else
    {
        ETG_TRACE_COMP(("vChkTriggerTimer:m_bEnableExecutionTimer==FALSE"));
    }
    ETG_TRACE_USR4(("End  : vChkTriggerTimer"));
}


/*-----------------------------------------------------------------------------*
 * tVoid getSignals(tenDevManagerUSBHost usb,                                  *
 *          voltageFailure_HWSignalsAll_t *pSignal)                            *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::getSignals(tenDevManagerUSBHost usb,voltageFailure_HWSignalsAll_t *pSignal)
{
    ETG_TRACE_USR4(("Begin: getSignals"));
    LOCK_TABLE

    if( (usb<eUSB1) || ((tInt)usb>=ARRAYSIZEFORUSB))
    {
#if !defined(BUGFIX_DECOUPLE_SDCARD_PRM) && !defined(BUGFIX_DECOUPLE_CDROM_PRM)
        DVM_NORMAL_M_ASSERT_ALWAYS();
#endif
        ETG_TRACE_USR1(("getSignals: Nothing 'to get' because eUSB%d not bound to HW signals", (tInt)usb));
        ETG_TRACE_USR1(("getSignals: USB Connectors bound to HW signals are:"));
        for(tInt k=(tInt)eUSB1; k<ARRAYSIZEFORUSB; k++)
        {
            ETG_TRACE_USR1(("getSignals: eUSB%d is bound to",k));
        }

        ETG_TRACE_USR1(("getSignals: do default initialization"));
        //initialize pSignal - SUZUKI-22274 - valgrind analysis -
        //although it  is now done in calling function - intialization is done here additionally to care if function is called from other directions
        //before it could happen that in function getSignals oSignal.usb could be set occasionally to eUSB1 and eUSB2
        //and in automatic tests  even saw oSignal.PPON=600 could be seen
        //in other words: such values could have interfer normal evaluation for eUSB1&2 devices
        //and devices would not be detected
        pSignal->usb           = eUSBUndef;
        pSignal->OC            = SIG_FALSE;
        pSignal->PPON          = SIG_TRUE;
        pSignal->U60_drop      = SIG_FALSE;
        pSignal->mountedUSB    = SIG_FALSE;
        pSignal->mountedUSBref = SIG_FALSE;
        pSignal->U50_USB_Reset = SIG_FALSE;

    }
    else
    {
        ETG_TRACE_COMP(("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
        ETG_TRACE_COMP((" getSignal (show current value):                        "));
        ETG_TRACE_COMP((" getSignal:m_signal[USB%1d].U60_drop           %d                 ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].U60_drop)));
        ETG_TRACE_COMP((" getSignal:m_signal[USB%1d].U50_USB_Reset      %d                 ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].U50_USB_Reset) ));
        ETG_TRACE_COMP((" getSignal:m_signal[USB%1d].OC                 %d                 ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].OC )));
        ETG_TRACE_COMP((" getSignal:m_signal[USB%1d].PPON               %d                 ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].PPON )));
        ETG_TRACE_COMP((" getSignal:m_signal[USB%1d].mountedUSB  (prm)  %d                 ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].mountedUSB ) ));
        ETG_TRACE_COMP((" getSignal:m_signal[USB%1d].mountedUSB  (udev) %d                 ",usb, ETG_ENUM(TENSIGNALVALUE,m_signal[usb].mountedUSBref ) ));
        ETG_TRACE_COMP(("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));

        pSignal->usb           = usb;
        pSignal->OC            = m_signal[usb].OC;
        pSignal->PPON          = m_signal[usb].PPON;
        pSignal->U60_drop      = m_signal[usb].U60_drop;
        pSignal->mountedUSB    = m_signal[usb].mountedUSB;
        pSignal->mountedUSBref = m_signal[usb].mountedUSBref;
        pSignal->U50_USB_Reset = m_signal[usb].U50_USB_Reset;

    }

    UNLOCK_TABLE

    ETG_TRACE_USR4(("End  : getSignals"));
}

/*-----------------------------------------------------------------------------*
 * tVoid getResult(tenDevManagerUSBHost usb,voltageFailure_Result_t *pResult)  *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::getResult(IN tenDevManagerUSBHost usb,OUT voltageFailure_Result_t *pResult)
{
    CalcStateTableResult(IN usb,IN m_signal[usb], OUT pResult);
}

tVoid StateTable::CalcStateTableResult(IN tenDevManagerUSBHost usb,IN voltageFailure_HWSignalsAll_t &oCurrSignal,
                                       OUT voltageFailure_Result_t *pResult)
{
    tBool bFound;
    tInt i;
    voltageFailure_HWSignalsAll_t voltageFailuresignal, *pSignal,*pCurrentSignal,*pPattern2CompareWith;

    ETG_TRACE_COMP(("Begin: getResult"));
    LOCK_TABLE

            pSignal              = &voltageFailuresignal;
    pCurrentSignal       = &oCurrSignal;

    //--------------------------------------
    //trace
    //--------------------------------------
    ETG_TRACE_COMP(("+++++++++++++++++++++++++++++"));
    ETG_TRACE_COMP((" getResult:USB%1d ",usb));
    ETG_TRACE_COMP(("+++++++++++++++++++++++++++++"));
    ETG_TRACE_COMP((" getResult:m_signal[USB%1d].U60_drop      :%d",usb, ETG_ENUM(TENSIGNALVALUE,oCurrSignal.U60_drop) ));
    ETG_TRACE_COMP((" getResult:m_signal[USB%1d].U50_USB_Reset :%d",usb, ETG_ENUM(TENSIGNALVALUE,oCurrSignal.U50_USB_Reset) ));
    ETG_TRACE_COMP((" getResult:m_signal[USB%1d].OC            :%d",usb, ETG_ENUM(TENSIGNALVALUE,oCurrSignal.OC ) ));
    ETG_TRACE_COMP((" getResult:m_signal[USB%1d].PPON          :%d",usb, ETG_ENUM(TENSIGNALVALUE,oCurrSignal.PPON ) ));
    ETG_TRACE_COMP((" getResult:m_signal[USB%1d].mountedUSB    :%d",usb, ETG_ENUM(TENSIGNALVALUE,oCurrSignal.mountedUSB ) ));
    ETG_TRACE_COMP((" getResult:m_signal[USB%1d].mountedUSBref :%d",usb, ETG_ENUM(TENSIGNALVALUE,oCurrSignal.mountedUSBref ) ));


    /**/

    ETG_TRACE_COMP((" STATETABLE_ELEMENTS    :%d", (tU32)STATETABLE_ELEMENTS));
    ETG_TRACE_COMP(("   SIG_UNDEF=0x%x  SIG_FALSE=0x%x  SIG_TRUE=0x%x  SIG_UNUSED=0x%x  SIG_ANY=0x%x  ",
                    SIG_UNDEF,SIG_FALSE,SIG_TRUE,SIG_UNUSED,SIG_ANY));


    bFound=FALSE;
    for(i=0;i<(tInt)STATETABLE_ELEMENTS;i++)
    {
        switch(usb)
        {
        case eUSB1:
            pPattern2CompareWith = &(m_voltageFailureStateTable_USB1[i].signalsHW);
            break;
        case eUSB2:
            pPattern2CompareWith = &(m_voltageFailureStateTable_USB2[i].signalsHW);
            break;
        case eUSB3:
            pPattern2CompareWith = &(m_voltageFailureStateTable_USB3[i].signalsHW);
            break;
#ifdef USE_FOURTH_USB_CONNECTOR
        case eUSB4:
            pPattern2CompareWith = &(m_voltageFailureStateTable_USB4[i].signalsHW);
            break;
#endif
        default:
            pPattern2CompareWith = NULL;
            ETG_TRACE_FATAL(("[ERROR]:getResult: i:%d",(tInt)i));
            ETG_TRACE_ERRMEM(("[ERROR]:getResult: i:%d",(tInt)i));
            DVM_NORMAL_M_ASSERT_ALWAYS();
            break;
        }

        if(NULL != pPattern2CompareWith)
        {
            //--------------------------------------------------------------
            //search SIG_UNDEF i.e. 0xFF and copy to entry signal
            //--------------------------------------------------------------
            //memcpy(&pSignal,&pCurrentSignal,sizeof(voltageFailure_HWSignalsAll_t)); //copy current to signal

            pSignal->usb           =pCurrentSignal->usb;
            pSignal->U60_drop      =pCurrentSignal->U60_drop;
            pSignal->U50_USB_Reset =pCurrentSignal->U50_USB_Reset;
            pSignal->OC            =pCurrentSignal->OC;
            pSignal->PPON          =pCurrentSignal->PPON;
            pSignal->mountedUSB    =pCurrentSignal->mountedUSB;
            pSignal->mountedUSBref =pCurrentSignal->mountedUSBref;

            if(SIG_ANY == pPattern2CompareWith->U60_drop)      pSignal->U60_drop      = SIG_ANY;
            if(SIG_ANY == pPattern2CompareWith->U50_USB_Reset) pSignal->U50_USB_Reset = SIG_ANY;
            if(SIG_ANY == pPattern2CompareWith->OC)            pSignal->OC            = SIG_ANY;
            if(SIG_ANY == pPattern2CompareWith->PPON)          pSignal->PPON          = SIG_ANY;
            if(SIG_ANY == pPattern2CompareWith->mountedUSB)    pSignal->mountedUSB    = SIG_ANY;
            if(SIG_ANY == pPattern2CompareWith->mountedUSBref) pSignal->mountedUSBref = SIG_ANY;

            if(SIG_UNUSED == pPattern2CompareWith->U60_drop)      pSignal->U60_drop      = SIG_UNUSED;
            if(SIG_UNUSED == pPattern2CompareWith->U50_USB_Reset) pSignal->U50_USB_Reset = SIG_UNUSED;
            if(SIG_UNUSED == pPattern2CompareWith->OC)            pSignal->OC            = SIG_UNUSED;
            if(SIG_UNUSED == pPattern2CompareWith->PPON)          pSignal->PPON          = SIG_UNUSED;
            if(SIG_UNUSED == pPattern2CompareWith->mountedUSB)    pSignal->mountedUSB    = SIG_UNUSED;
            if(SIG_UNUSED == pPattern2CompareWith->mountedUSBref) pSignal->mountedUSBref = SIG_UNUSED;

            //------------------------------------------------------------------------------------
            //compare entry signal with pattern after arbitrary values had been taken into account
            //------------------------------------------------------------------------------------
            ETG_TRACE_COMP(("                                                                        "));
            ETG_TRACE_COMP(("                    Current Signal      SignalplusAny     Pattern[%.2d] ",i));
            ETG_TRACE_COMP(("   U60_drop           :0x%.2x               0x%.2x            0x%.2x     ",pCurrentSignal->U60_drop,
                            pSignal->U60_drop,
                            pPattern2CompareWith->U60_drop));
            ETG_TRACE_COMP(("   U50_USB_Reset      :0x%.2x               0x%.2x            0x%.2x     ",pCurrentSignal->U50_USB_Reset,
                            pSignal->U50_USB_Reset,
                            pPattern2CompareWith->U50_USB_Reset ));
            ETG_TRACE_COMP(("   OC                 :0x%.2x               0x%.2x            0x%.2x     ",pCurrentSignal->OC,
                            pSignal->OC,
                            pPattern2CompareWith->OC));
            ETG_TRACE_COMP(("   PPON               :0x%.2x               0x%.2x            0x%.2x     ",pCurrentSignal->PPON,
                            pSignal->PPON,
                            pPattern2CompareWith->PPON));
            ETG_TRACE_COMP(("   mountedUSB (prm)   :0x%.2x               0x%.2x            0x%.2x     ",pCurrentSignal->mountedUSB,
                            pSignal->mountedUSB,
                            pPattern2CompareWith->mountedUSB));
            ETG_TRACE_COMP(("   mountedUSB (udev)  :0x%.2x               0x%.2x            0x%.2x     ",pCurrentSignal->mountedUSBref,
                            pSignal->mountedUSBref,
                            pPattern2CompareWith->mountedUSBref));

            if(0==memcmp( pSignal, pPattern2CompareWith, sizeof(voltageFailure_HWSignalsAll_t) ) )
            {
                ETG_TRACE_COMP(("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"));
                ETG_TRACE_COMP(("Found value index=%d                                                           ",i));
                ETG_TRACE_COMP(("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"));
                switch(usb)
                {
                case eUSB1:
                    pResult->resultUSB = m_voltageFailureStateTable_USB1[i].result4Client.resultUSB;
                    break;
                case eUSB2:
                    pResult->resultUSB = m_voltageFailureStateTable_USB2[i].result4Client.resultUSB;
                    break;
                case eUSB3:
                    pResult->resultUSB = m_voltageFailureStateTable_USB3[i].result4Client.resultUSB;
                    break;
#ifdef USE_FOURTH_USB_CONNECTOR
                case eUSB4:
                    pResult->resultUSB = m_voltageFailureStateTable_USB4[i].result4Client.resultUSB;
                    break;

#endif
                default:
                    ETG_TRACE_FATAL(("[ERROR]:getResult: usb:%d",(tInt)usb));
                    ETG_TRACE_ERRMEM(("[ERROR]:getResult: usb:%d",(tInt)usb));
                    DVM_NORMAL_M_ASSERT_ALWAYS();
                    break;
                }
                bFound = TRUE;
                break;
            }
        }
    }

    if( bFound == FALSE )
    {
        pResult->resultUSB = USB_DEV_UNDEFINED;
        ETG_TRACE_FATAL(("[ok - informative] getResult:USB%1d: NO PATTERN OF STATE TABLE MATCHES TO SIGNAL",usb));
    }

    UNLOCK_TABLE
            ETG_TRACE_COMP(("End  : getResult"));
}

/*-----------------------------------------------------------------------------*
 * tVoid setIntervalTime(tU32 u32IntervalTimer)                                *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::setIntervalTime(tU32 u32IntervalTimer)
{
    m_u32CommonIntervalTimer_ms=u32IntervalTimer;
}

/*-----------------------------------------------------------------------------*
 * tVoid StateTable::updateIntervalTimeFromConfiguration()
 *-----------------------------------------------------------------------------*/
tVoid StateTable::updateIntervalTimeFromConfiguration()
{
    m_u32CommonIntervalTimer_ms=ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_STATETABLE_EXECUTION_TIME_MS);
}

/*-----------------------------------------------------------------------------*
 * tVoid util_vSendMsg2Q(const util_StructQInfo* pQInfo,                       *
 *          const util_StructMsg* pMsg)                                        *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::util_vSendMsg2Q(const util_StructQInfo* /*pQInfo*/,const util_StructMsg* pMsg)
{
    int iRetVal;

    //util_StructMsg oMSG;

    ETG_TRACE_USR4(("Begin: util_vSendWMSG2Queue"));


    DVM_FATAL_M_ASSERT(pMsg);

    //memset(&oMSG, 0x00,  sizeof(util_StructMsg));
    if( pMsg )
    {
        //memcpy(&oMSG, pMsg, sizeof(util_StructMsg));

        ETG_TRACE_USR1(("util_vSendMsg2Q: pMsg->eMsgType: %d",ETG_ENUM(TENMSGTYP,pMsg->eMsgType)));
        ETG_TRACE_USR4(("                 pMsg->u16LenCont=%d ",pMsg->u16LenCont));
        ETG_TRACE_USR4(("                 pMsg->pu8Content: 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x ...",
                        pMsg->pu8Content[0],pMsg->pu8Content[1],pMsg->pu8Content[2],pMsg->pu8Content[3],pMsg->pu8Content[4],pMsg->pu8Content[5]));

        ETG_TRACE_USR4(("util_vSendMsg2Q: UTIL_LENOFQMSG: %d",(int)UTIL_LENOFQMSG));

        iRetVal = m_MessageQueueDVM.iMessageQueuePost((void*)pMsg,UTIL_LENOFQMSG, (int) 0); /*Priority 0 highes 7 lowest*/

        if(MessageQueueDVM::OK != iRetVal)
        {
            ETG_TRACE_FATAL(("ERROR:util_vSendMsg2Q: Post2MsgQ failed!!"));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("ERROR: util_vSendMsg2Q:NULL==pMsg"));
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }

    ETG_TRACE_USR4(("End  : util_vSendWMSG2Queue"));
}

/*-----------------------------------------------------------------------------*
 * tS32 util_s32Wait4Q(const util_StructQInfo* pQInfo,                         *
 *          const util_StructMsg* pMsg, OSAL_tMSecond timeout_ms)              *
 *-----------------------------------------------------------------------------*/
tS32 StateTable::util_s32Wait4Q(const util_StructQInfo* pQInfo,
                                util_StructMsg* pMsg,unsigned int timeout_ms)
{
    int s32RetVal=OSAL_ERROR;   //care for getting this OSAL-specific value away from code
    unsigned int uLenOfMsg = 0;
    int iRetVal  = MessageQueueDVM::ERROR;
    tU8 u8Payload[UTIL_LENOFQMSG];
    ETG_TRACE_USR4(("Begin:util_s32Wait4Queue (%s)",pQInfo->sMsgQName));
    memset(u8Payload, 0x00, sizeof(u8Payload));

    if( pQInfo )
    {
        if( pMsg  )
        {
            //------------------------------------------------------
            // wait for Osal queue with PWR_STATE_REQ Messages
            //------------------------------------------------------
            iRetVal = m_MessageQueueDVM.iMessageQueueWait((void*)u8Payload,
                                                          uLenOfMsg/*UTIL_LENOFQMSG*/,     //cast possible since
                                                          OSAL_NULL,           //0 highest 7 lowest
                                                          (int) timeout_ms/*ms*/);

            if(uLenOfMsg != (unsigned int)UTIL_LENOFQMSG)
            {
                ETG_TRACE_USR4(("util_s32Wait4Q: ReceivedMSG len error: uLenOfMsg (%d) != UTIL_LENOFQMSG (%d)",uLenOfMsg,(unsigned int)UTIL_LENOFQMSG));

                memset(u8Payload, 0x00, sizeof(u8Payload));
                iRetVal = MessageQueueDVM::ERROR;
            }

            memcpy(pMsg, u8Payload, UTIL_LENOFQMSG);

            if (MessageQueueDVM::ERROR == iRetVal)
            {
                /*chk if timout or ERROR*/
                if(pMsg->eMsgType==enTimout)
                {
                    ETG_TRACE_USR4(("util_s32Wait4Queue: Timout "));
                    s32RetVal=OSAL_E_TIMEOUT;
                }
            }
            else
            {
                ETG_TRACE_USR4(("iRetVal:%d ",s32RetVal));
                ETG_TRACE_USR1(("util_s32Wait4Q:  pMsg->eMsgType: %d",ETG_ENUM(TENMSGTYP,pMsg->eMsgType)));
                ETG_TRACE_USR4(("                 pMsg->u16LenCont=%d ",pMsg->u16LenCont));
                ETG_TRACE_USR4(("                 pMsg->pu8Content: 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x ...",
                                pMsg->pu8Content[0],pMsg->pu8Content[1],pMsg->pu8Content[2],pMsg->pu8Content[3],pMsg->pu8Content[4],pMsg->pu8Content[5]));

#ifdef MONITOR_PERMANENT_HW_FAILURE
                //clarify with osal collegeues why they don't give a reasonable return value if timeout_ms!= FOREVER
                if((0 == s32RetVal) && (0 == (tInt)pMsg->eMsgType) && (0 == pMsg->u16LenCont))
                {
                    ETG_TRACE_USR4(("util_s32Wait4Queue: Timout timeout_ms:%d ms",timeout_ms));
                    s32RetVal = OSAL_E_TIMEOUT;
                }
                else
#endif
                {
                    s32RetVal=OSAL_E_NOERROR;
                }
            }
        }
        else
        {
            s32RetVal=OSAL_ERROR;
            ETG_TRACE_FATAL(("ERROR: util_s32Wait4Q:NULL==pMsg"));
        }

        ETG_TRACE_USR4(("End  : iRetVal:%d util_s32Wait4Queue (%s) ",iRetVal,pQInfo->sMsgQName));

    }
    return s32RetVal;
}

/*-----------------------------------------------------------------------------*
 * tBool bFillstructNotifyClients(structNotifyClients *pNotifyClients_Dest,    *
 *          CDevice* pCurDevice_Src)                                           *
 *-----------------------------------------------------------------------------*/
tBool StateTable::bFillstructNotifyClients(
        structNotifyClients *pNotifyClients_Dest, const CDevice* pCurDevice_Src)
{
    tBool bRet = TRUE;
    memset(pNotifyClients_Dest,0,sizeof(structNotifyClients)); //Initialize
    if( (NULL!=pNotifyClients_Dest) && (NULL!=pCurDevice_Src) )
    {
        pNotifyClients_Dest->eUSB            = pCurDevice_Src->m_eUSB;
        pNotifyClients_Dest->eDeviceType     = pCurDevice_Src->m_eDeviceType;
        pNotifyClients_Dest->eConnectStatus  = pCurDevice_Src->m_eConnectStatus;
        pNotifyClients_Dest->iVendorID       = pCurDevice_Src->m_iVendorID;
        pNotifyClients_Dest->iProductID      = pCurDevice_Src->m_iProductID;
        pNotifyClients_Dest->u64Size         = pCurDevice_Src->m_u64Size;
        pNotifyClients_Dest->eDeviceSpeedUSB = pCurDevice_Src->m_DeviceSpeedUSB;
        pNotifyClients_Dest->eDeviceUnsupportedReason = pCurDevice_Src->m_eDeviceUnsupportedReason;
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_DELAY_NOTIFY_MTP_DEVICES))
        {
            pNotifyClients_Dest->u64TimeStamp_ConnectTimeStampForRetry = 0;
        }
#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
        pNotifyClients_Dest->eFSType          = pCurDevice_Src->m_eFSType;
#endif //USE_FILESYSTEMTYPE_ALIAS_FSTY
#ifdef USE_TOTAL_USED_FREE_SIZE
        pNotifyClients_Dest->u64TotalSize_KB = pCurDevice_Src->m_u64TotalSize_KB;
        pNotifyClients_Dest->u64UsedSize_KB  = pCurDevice_Src->m_u64UsedSize_KB;
        pNotifyClients_Dest->u64FreeSize_KB  = pCurDevice_Src->m_u64FreeSize_KB;
#endif //USE_TOTAL_USED_FREE_SIZE
#ifdef USE_PARITIONNUMBER
        pNotifyClients_Dest->u8ValidPartitionNo = (tU8)pCurDevice_Src->m_iValidPartitionNo;
#endif //USE_PARITIONNUMBER


        /*additional error check to keep an eye on memory faults or to see if array size of dest string to slow*/
        if((tU32)(pCurDevice_Src->m_cSerialID.length()/*number of characters of string*/+1/*terminating '\0'*/) >=(tU32)sizeof(pNotifyClients_Dest->cSerialID))
        {
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[dest  ]sizeof(pNotifyClients_Dest->cSerialID)=%d  ",sizeof(pNotifyClients_Dest->cSerialID) ));
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[source]pCurDevice_Src->m_cSerialID.length()-1=%d  ",   pCurDevice_Src->m_cSerialID.length()-1    ));
            bRet = FALSE;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        if((tU32)(pCurDevice_Src->m_cUSBPort.length()/*number of characters of string*/+1 /*terminating '\0'*/) >=(tU32)sizeof(pNotifyClients_Dest->cUSBPort))
        {
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[dest  ]sizeof(pNotifyClients_Dest->cUSBPort)=%d  ",sizeof(pNotifyClients_Dest->cUSBPort) ));
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[source]pCurDevice_Src->cUSBPort.length()-1=%d  ",   pCurDevice_Src->m_cUSBPort.length()-1    ));
            bRet = FALSE;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        if((tU32)(pCurDevice_Src->m_cDeviceVersion.length()/*number of characters of string*/+1 /*terminating '\0'*/ )>=(tU32)sizeof(pNotifyClients_Dest->cDeviceVersion))
        {
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[dest  ]sizeof(pNotifyClients_Dest->cDeviceVersion)=%d  ",sizeof(pNotifyClients_Dest->cDeviceVersion) ));
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[source]pCurDevice_Src->cDeviceVersion.length()-1=%d  ",   pCurDevice_Src->m_cDeviceVersion.length()-1    ));
            bRet = FALSE;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        if((tU32)(pCurDevice_Src->m_cDeviceName.length()/*number of characters of string*/+1 /*terminating '\0'*/) >=(tU32)sizeof(pNotifyClients_Dest->cDeviceName))
        {
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[dest  ]sizeof(pNotifyClients_Dest->cDeviceName)=%d  ",(tU32)sizeof(pNotifyClients_Dest->cDeviceName) ));
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[source]pCurDevice_Src->cDeviceName.length()-1=%d  ",   pCurDevice_Src->m_cDeviceName.length()-1    ));
            bRet = FALSE;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        if((tU32)(pCurDevice_Src->m_cAccessoryName.length()/*number of characters of string*/+1 /*terminating '\0'*/) >=(tU32)sizeof(pNotifyClients_Dest->cAccessoryName))
        {
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[dest  ]sizeof(pNotifyClients_Dest->cAccessoryName)=%d  ",sizeof(pNotifyClients_Dest->cAccessoryName) ));
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:pCurDevice_Src->cAccessoryName.length()-1=%d  ",   pCurDevice_Src->m_cAccessoryName.length()-1    ));
            bRet = FALSE;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        if((tU32)(pCurDevice_Src->m_cMountPoint.length()/*number of characters of string*/+1 /*terminating '\0'*/ )>=(tU32)sizeof(pNotifyClients_Dest->cMountPoint))
        {
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[dest  ]sizeof(pNotifyClients_Dest->cMountPoint)=%d  ",sizeof(pNotifyClients_Dest->cMountPoint) ));
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[source]pCurDevice_Src->cMountPoint.size-1=%d  ",   pCurDevice_Src->m_cMountPoint.size()-1    ));
            bRet = FALSE;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        if((tU32)(pCurDevice_Src->m_cManufacturer.length()/*number of characters of string*/+1 /*terminating '\0'*/ )>=(tU32)sizeof(pNotifyClients_Dest->cManufacturer))
        {
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[dest  ]sizeof(pNotifyClients_Dest->cManufacturer)=%d  ",sizeof(pNotifyClients_Dest->cManufacturer) ));
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[source]pCurDevice_Src->m_cManufacturer.length()-1=%d  ",   pCurDevice_Src->m_cManufacturer.length()-1    ));
            bRet = FALSE;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        if((tU32)(pCurDevice_Src->m_cDevpath.length()/*number of characters of string*/+1 /*terminating '\0'*/ )>=(tU32)sizeof(pNotifyClients_Dest->cDevPath))
        {
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[dest  ]sizeof(pNotifyClients_Dest->cDevpath)=%d  ",sizeof(pNotifyClients_Dest->cDevPath) ));
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[source]pCurDevice_Src->m_cDevpath.size-1=%d  ",   pCurDevice_Src->m_cDevpath.size()-1    ));
            bRet = FALSE;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        if((tU32)(pCurDevice_Src->m_cAccessoryName2.length()/*number of characters of string*/+1 /*terminating '\0'*/) >=(tU32)sizeof(pNotifyClients_Dest->cAccessoryName2))
        {
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:[dest  ]sizeof(pNotifyClients_Dest->cAccessoryName2)=%d  ",sizeof(pNotifyClients_Dest->cAccessoryName2) ));
            ETG_TRACE_FATAL(("ERROR: bFillstructNotifyClients:pCurDevice_Src->m_cAccessoryName2.length()-1=%d  ",   pCurDevice_Src->m_cAccessoryName2.length()-1    ));
            bRet = FALSE;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        /*copy strings*/
        /*target string*/                  /*source string*/                            /*max size of target string*/         /*1 byte space kept to be padded by srtncopy with '\0' to terminate string*/
        strncpy(pNotifyClients_Dest->cSerialID,     pCurDevice_Src->m_cSerialID.toStdString().c_str(),     sizeof(pNotifyClients_Dest->cSerialID)     -1);//lint !e522: (or direkt call to strncpy): Warning 522: prio3: Highest operation, a 'cast', lacks side-effects
        strncpy(pNotifyClients_Dest->cUSBPort,      pCurDevice_Src->m_cUSBPort.toStdString().c_str(),      sizeof(pNotifyClients_Dest->cUSBPort)      -1);//lint !e522: (or direkt call to strncpy): Warning 522: prio3: Highest operation, a 'cast', lacks side-effects
        strncpy(pNotifyClients_Dest->cDeviceVersion,pCurDevice_Src->m_cDeviceVersion.toStdString().c_str(),sizeof(pNotifyClients_Dest->cDeviceVersion)-1);//lint !e522: (or direkt call to strncpy): Warning 522: prio3: Highest operation, a 'cast', lacks side-effects
        strncpy(pNotifyClients_Dest->cDeviceName,   pCurDevice_Src->m_cDeviceName.toStdString().c_str(),   sizeof(pNotifyClients_Dest->cDeviceName)   -1);//lint !e522: (or direkt call to strncpy): Warning 522: prio3: Highest operation, a 'cast', lacks side-effects
        strncpy(pNotifyClients_Dest->cAccessoryName,pCurDevice_Src->m_cAccessoryName.toStdString().c_str(),sizeof(pNotifyClients_Dest->cAccessoryName)-1);//lint !e522: (or direkt call to strncpy): Warning 522: prio3: Highest operation, a 'cast', lacks side-effects
        strncpy(pNotifyClients_Dest->cMountPoint,   pCurDevice_Src->m_cMountPoint.toStdString().c_str(),   sizeof(pNotifyClients_Dest->cMountPoint)   -1);//lint !e522: (or direkt call to strncpy): Warning 522: prio3: Highest operation, a 'cast', lacks side-effects
        strncpy(pNotifyClients_Dest->cManufacturer, pCurDevice_Src->m_cManufacturer.toStdString().c_str(), sizeof(pNotifyClients_Dest->cManufacturer) -1);//lint !e522: (or direkt call to strncpy): Warning 522: prio3: Highest operation, a 'cast', lacks side-effects
        if((DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_NOTIFY_DEVPATH)))
        {
            strncpy(pNotifyClients_Dest->cDevPath,  pCurDevice_Src->m_cDevpath.toStdString().c_str(),      sizeof(pNotifyClients_Dest->cDevPath)      -1);
        }
        strncpy(pNotifyClients_Dest->cDevNode,  pCurDevice_Src->m_cDevnode.toStdString().c_str(),      sizeof(pNotifyClients_Dest->cDevNode)      -1);
#ifdef  MSD_BIGGEST_PARTITON_FEATURE
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MSD_WAIT_FOR_PARTITIONS_ALL))
        {
            pNotifyClients_Dest->u8TotalValidPartitons =(tU8)pCurDevice_Src->m_iTotalValidPartitons;
            strncpy(pNotifyClients_Dest->cAccessoryName2,pCurDevice_Src->m_cAccessoryName2.toStdString().c_str(),sizeof(pNotifyClients_Dest->cAccessoryName2)-1);//lint !e522: (or direkt call to strncpy): Warning 522: prio3: Highest operation, a 'cast', lacks side-effects
        }
#endif//MSD_BIGGEST_PARTITON_FEATURE

        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cSerialID:        %s",pNotifyClients_Dest->cSerialID));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cUSBPort:         %s",pNotifyClients_Dest->cUSBPort));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cDeviceVersion:   %s",pNotifyClients_Dest->cDeviceVersion));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cDeviceName:      %s",pNotifyClients_Dest->cDeviceName));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cAccessoryName:   %s",pNotifyClients_Dest->cAccessoryName));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cAccessoryName2:  %s",pNotifyClients_Dest->cAccessoryName2));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cMountPoint:      %s",pNotifyClients_Dest->cMountPoint));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cDevPath:         %s",pNotifyClients_Dest->cDevPath));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cDevNode:         %s",pNotifyClients_Dest->cDevNode));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->eDeviceType:      %d",ETG_ENUM(DVM_DEVICE_TYPE,pNotifyClients_Dest->eDeviceType)));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->eConnectStatus:   %d",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,pNotifyClients_Dest->eConnectStatus)));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->eUSB:             %d",ETG_ENUM(TENDEVMANAGERUSBHOST,pNotifyClients_Dest->eUSB)));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->cManufacturer:    %s",pNotifyClients_Dest->cManufacturer));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->iVendorID:        0x%04x",pNotifyClients_Dest->iVendorID));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->iProductID:       0x%04x",pNotifyClients_Dest->iProductID));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->u64Size:          %u",(tU32)pNotifyClients_Dest->u64Size));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->eDeviceSpeedUSB:  %d",ETG_ENUM(TENDEVICESPEEDUSB,pNotifyClients_Dest->eDeviceSpeedUSB)));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->eDeviceUnsupportedReason:  %d",ETG_ENUM(TENDEVICEUNSUPPORTEDREASON,pNotifyClients_Dest->eDeviceUnsupportedReason)));
#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->eFSType:          %d",ETG_CENUM( CGlobalEnumerations::FILESYSTEM_TYPE_Type,pNotifyClients_Dest->eFSType)));
#endif
#ifdef USE_TOTAL_USED_FREE_SIZE
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->u64TotalSize_KB:  %u",pNotifyClients_Dest->u64TotalSize_KB));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->u64UsedSize_KB:   %u",pNotifyClients_Dest->u64UsedSize_KB));
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->u64FreeSize_KB:   %u",pNotifyClients_Dest->u64FreeSize_KB));
#endif
#ifdef USE_PARITIONNUMBER
        ETG_TRACE_USR4(("bFillstructNotifyClients:pNotifyClients_Dest->u8ValidPartitionNo:%u",pNotifyClients_Dest->u8ValidPartitionNo));
#endif


    }
    else
    {
        bRet = FALSE;
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    return bRet;
}

/*-----------------------------------------------------------------------------*
 * tBool bFillCDevice(CDevice* pCurDevice_Dest,                                *
 *          structNotifyClients* pNotifyClients_Src)                           *
 *-----------------------------------------------------------------------------*/
tBool StateTable::bFillCDevice( CDevice* pCurDevice_Dest, const structNotifyClients* pNotifyClients_Src) const
{
    tBool bRet = TRUE;
    if( (NULL!=pCurDevice_Dest) && (NULL!=pNotifyClients_Src) )
    {
        pCurDevice_Dest->clear(); //Initialize
        pCurDevice_Dest->m_cSerialID             = pNotifyClients_Src->cSerialID;
        pCurDevice_Dest->m_cUSBPort              = pNotifyClients_Src->cUSBPort;
        pCurDevice_Dest->m_eDeviceType           = pNotifyClients_Src->eDeviceType;
        pCurDevice_Dest->m_cDeviceVersion        = pNotifyClients_Src->cDeviceVersion;
        pCurDevice_Dest->m_cDeviceName           = pNotifyClients_Src->cDeviceName;
        pCurDevice_Dest->m_cAccessoryName        = pNotifyClients_Src->cAccessoryName;
        pCurDevice_Dest->m_cMountPoint           = pNotifyClients_Src->cMountPoint;
        if((DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_NOTIFY_DEVPATH)))
        {
            pCurDevice_Dest->m_cDevpath              = pNotifyClients_Src->cDevPath;
        }
        pCurDevice_Dest->m_cDevnode              = pNotifyClients_Src->cDevNode;
        pCurDevice_Dest->m_eConnectStatus        = pNotifyClients_Src->eConnectStatus;
        pCurDevice_Dest->m_cManufacturer         = pNotifyClients_Src->cManufacturer;
        pCurDevice_Dest->m_iVendorID             = pNotifyClients_Src->iVendorID;
        pCurDevice_Dest->m_iProductID            = pNotifyClients_Src->iProductID;
        pCurDevice_Dest->m_u64Size               = pNotifyClients_Src->u64Size;

#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
        pCurDevice_Dest->m_eFSType = pNotifyClients_Src->eFSType;
#endif
#ifdef USE_TOTAL_USED_FREE_SIZE
        pCurDevice_Dest->m_u64TotalSize_KB       = pNotifyClients_Src->u64TotalSize_KB;
        pCurDevice_Dest->m_u64UsedSize_KB        = pNotifyClients_Src->u64UsedSize_KB;
        pCurDevice_Dest->m_u64FreeSize_KB        = pNotifyClients_Src->u64FreeSize_KB;
#endif
#ifdef USE_PARITIONNUMBER
        pCurDevice_Dest->m_iValidPartitionNo     = pNotifyClients_Src->u8ValidPartitionNo;
#endif
#ifdef  MSD_BIGGEST_PARTITON_FEATURE
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MSD_WAIT_FOR_PARTITIONS_ALL))
        {
            pCurDevice_Dest->m_cAccessoryName2       = pNotifyClients_Src->cAccessoryName2;
            pCurDevice_Dest->m_iTotalValidPartitons  = pNotifyClients_Src->u8TotalValidPartitons;
        }
#endif

        //care that connector is shown if VD_DVM_GET_CONNECTED ALL is called
        pCurDevice_Dest->m_eUSB                  = pNotifyClients_Src->eUSB;
    }
    else
    {
        bRet = FALSE;
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    return bRet;
}


/*---------------------------------------------------------------------------------------------------------*
 * tBool setMountFill(tenMsgTyp eMsgType,tenDevManagerUSBHost eUsb, tenSignalValue eMount, CDevice* pCurDevice)                        *
 *---------------------------------------------------------------------------------------------------------*/
tBool StateTable::setMountFill(IN tenMsgTyp eMsgType,IN tenDevManagerUSBHost eUsb,IN tenSignalValue eMount, const CDevice* pCurDevice,OUT util_StructMsg &oMsg)
{
    tBool bRet = FALSE;
    structNotifyClients  oNotifyClients;

    if(TRUE == bFillstructNotifyClients(OUT &oNotifyClients,IN pCurDevice))
    {
        oNotifyClients.eUSB = eUsb;

        //prepare to send to Q
        oMsg.eMsgType   = eMsgType;
        oMsg.u16LenCont = sizeof(tenDevManagerUSBHost/*eUsb*/) + sizeof(tenSignalValue/*eMount*/) + sizeof(structNotifyClients);
        if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
        {
            ETG_TRACE_FATAL(("ERROR: setMount_add: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
            oMsg.u16LenCont=0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            memcpy(&(oMsg.pu8Content[0]),           &eUsb,sizeof(tenDevManagerUSBHost/*eUsb*/));
            memcpy(&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)]),&eMount,sizeof(tenSignalValue/*eMount*/));
            memcpy(&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)+sizeof(tenSignalValue/*eMount*/)]),&oNotifyClients,sizeof(structNotifyClients));
            //send it is ok
            bRet = TRUE;

        }
    }
    else
    {
        ETG_TRACE_FATAL(("ERROR: setMount_udev: FALSE==bFillstructNotifyClients"));
    }

    return bRet;
}


/*---------------------------------------------------------------------------------------------------------*
 * tBool setCDDANotifiedFill(IN tenMsgTyp eMsgType, IN const CDevice* pCurDevice,OUT util_StructMsg &oMsg)*
 *---------------------------------------------------------------------------------------------------------*/
tBool  StateTable::setCDDANotifiedFill(IN tenMsgTyp eMsgType,IN tenSignalValue eMount,  IN const CDevice* pCurDevice,OUT util_StructMsg &oMsg)
{
    tBool bRet = FALSE;
    structNotifyClients  oNotifyClients;
    tenDevManagerUSBHost eUsb = eUSBUndef;


    if(TRUE == bFillstructNotifyClients(OUT &oNotifyClients,IN pCurDevice))
    {
        oNotifyClients.eUSB = eUSBUndef;
        //prepare to send to Q
        oMsg.eMsgType   = eMsgType;
        oMsg.u16LenCont = sizeof(tenDevManagerUSBHost/*eUsb*/) + sizeof(tenSignalValue/*eMount*/) + sizeof(structNotifyClients);
        if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
        {
            ETG_TRACE_FATAL(("ERROR: setCDDANotifiedFill: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
            oMsg.u16LenCont=0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            memcpy(&(oMsg.pu8Content[0]),           &eUsb,sizeof(tenDevManagerUSBHost/*eUsb*/));
            memcpy(&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)]),&eMount,sizeof(tenSignalValue/*eMount*/));
            memcpy(&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)+sizeof(tenSignalValue/*eMount*/)]),&oNotifyClients,sizeof(structNotifyClients));
            //send it is ok
            bRet = TRUE;

        }
    }
    else
    {
        ETG_TRACE_FATAL(("ERROR: setCDDANotifiedFill: FALSE==bFillstructNotifyClients"));
    }

    return bRet;
}

/*------------------------------------------------------------------------------------------------------------------------*
 * tBool setOpticalDiscSlotStateNotifiedFill(...)*
 *------------------------------------------------------------------------------------------------------------------------*/
tBool StateTable::setOpticalDiscSlotStateNotifiedFill(IN tenMsgTyp eMsgType,IN tDMOpticalDiscSlotState   eOpticalDiscSlotState,OUT util_StructMsg &oMsg)
{
    tBool bRet = FALSE;

    //prepare to send to Q
    oMsg.eMsgType   = eMsgType;
    oMsg.u16LenCont = sizeof(tDMOpticalDiscSlotState);
    if( oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN )
    {
        ETG_TRACE_FATAL(( "[ERROR]: setOpticalDiscSlotStateNotifiedFill: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)", oMsg.u16LenCont, (tU16)UTIL_MAX_CONTENT_LEN) );
        oMsg.u16LenCont = 0;
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {
        ETG_TRACE_USR4(("setOpticalDiscSlotStateNotifiedFill: Filling the slot state: %d",ETG_ENUM(tDMOpticalDiscSlotState, eOpticalDiscSlotState)));
        memcpy( &(oMsg.pu8Content[0]), & eOpticalDiscSlotState, sizeof(tDMOpticalDiscSlotState) );
        bRet = TRUE;

    }
    return bRet;

}



/*-------------------------------------------------------------------------------------------------------*
 * tVoid setMount(tenMsgTyp eMsgType,tenDevManagerUSBHost eUsb,tenSignalValue eMount, CDevice* pCurDevice)                        *
 *-------------------------------------------------------------------------------------------------------*/
tVoid StateTable::setMount(tenMsgTyp eMsgType,tenDevManagerUSBHost eUsb,tenSignalValue eMount, const CDevice* pCurDevice)
{

    util_StructQInfo    *pMsgQInfo=&m_msgQ;


    ETG_TRACE_USR4(("Begin: setMount_udev"));
    ETG_TRACE_COMP(("->################### setMount_udev:USB%1d,%d,%d #####################",
                    (int)eUsb,
                    ETG_ENUM(TENMSGTYP,eMsgType),
                    ETG_ENUM(TENSIGNALVALUE,eMount)));

#ifdef IMPROVE_CRITVOLT
    if(TRUE == DeviceListManager::GetInstance()->getPlatformEventsLocked(eUsb))
    {
        ETG_TRACE_COMP(("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
        ETG_TRACE_COMP(("FilterWithConfiguration:eUSB%1d locked - don't add to list",eUsb));
        ETG_TRACE_COMP(("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
    }
    else
#endif
    {
        /*send to MsgQ received in StateTable::vThreadFunction */

        util_StructMsg oMsg;
        tBool bSend = setMountFill(IN eMsgType,IN eUsb,IN eMount, IN pCurDevice,OUT oMsg);
        //--------------
        //send it
        //--------------
        if(bSend)
        {
            pMsgQInfo=&m_msgQ;
            util_vSendMsg2Q(pMsgQInfo,&oMsg);
        }


    }
    ETG_TRACE_USR4(("End  : setMount_udev"));
}


/*-------------------------------------------------------------------------------------------------------*
 * tVoid vsetCDDANotified(tenMsgTyp eMsgType,IN DEVICE_CONNECTSTATUS_Type  enConnectStatus, IN const CDevice* pCurDevice)                        *
 *-------------------------------------------------------------------------------------------------------*/
tVoid StateTable::vsetCDDANotified(tenMsgTyp eMsgType,IN DEVICE_CONNECTSTATUS_Type  enConnectStatus, IN const CDevice* pCurDevice)
{

    util_StructQInfo    *pMsgQInfo=&m_msgQ;
    tenSignalValue eMount;


    ETG_TRACE_USR4(("Begin: vsetCDDANotified"));
    ETG_TRACE_COMP(("->################### vsetCDDANotified:,%d,%d #####################",
                    ETG_ENUM(TENMSGTYP,eMsgType),
                    ETG_ENUM(DEVICE_CONNECTSTATUS_Type,enConnectStatus)));

    if( USB_DEV_INTERNAL_APPLY_CONNECT == enConnectStatus)
    {
        eMount = SIG_TRUE;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
        HWMALFUNCTIONHISTORY.AddToHistory("vsetCDDANotified: eMount = SIG_TRUE",NULL);
#endif

    }
    else
    {
        eMount = SIG_FALSE;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
        HWMALFUNCTIONHISTORY.AddToHistory("vsetCDDANotified: eMount = SIG_FALSE",NULL);
#endif
    }


    /*send to MsgQ received in StateTable::vThreadFunction */

    util_StructMsg oMsg;
    tBool bSend = setCDDANotifiedFill(IN eMsgType,IN eMount, IN pCurDevice,OUT oMsg);
    //--------------
    //send it
    //--------------
    if(bSend)
    {
        pMsgQInfo=&m_msgQ;
        util_vSendMsg2Q(pMsgQInfo,&oMsg);
    }



    ETG_TRACE_USR4(("End  : vsetCDDANotified"));
}



/*-------------------------------------------------------------------------------------------*
tVoid vSetOpticalDiscSlotStateNotified(...) *
*--------------------------------------------------------------------------------------------*/
tVoid StateTable::vSetOpticalDiscSlotStateNotified(IN tenMsgTyp eMsgType, IN tDMOpticalDiscSlotState   eOpticalDiscSlotState)
{

    util_StructQInfo    *pMsgQInfo=&m_msgQ;


    ETG_TRACE_USR4(("Begin: vSetOpticalDiscSlotStateNotified"));
    ETG_TRACE_COMP(("->################### vSetOpticalDiscSlotStateNotified:,%d,%d #####################",
                    ETG_ENUM(TENMSGTYP,eMsgType),
                    ETG_CENUM(tDMOpticalDiscSlotState, eOpticalDiscSlotState)));

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST  //intermediate
    char cData[80];
    snprintf(cData,sizeof(cData),"vSetOpticalDiscSlotStateNotified(...): tenMsgTyp:0x%x, eOpticalDiscSlotState: 0x%x",(int)eMsgType,(int)eOpticalDiscSlotState);
    HWMALFUNCTIONHISTORY.AddToHistory(GENSTRING(cData),NULL);
#endif

    /*send to MsgQ received in StateTable::vThreadFunction */

    util_StructMsg oMsg;
    tBool bSend = setOpticalDiscSlotStateNotifiedFill(IN eMsgType, IN  eOpticalDiscSlotState,OUT oMsg);
    //--------------
    //send it
    //--------------
    if(bSend)
    {
        pMsgQInfo=&m_msgQ;
        util_vSendMsg2Q(pMsgQInfo,&oMsg);
    }



    ETG_TRACE_USR4(("End  : vSetOpticalDiscSlotStateNotified"));
}

/*-----------------------------------------------------------------------------*
 * tVoid vTriggerTimer(tVoid)                                                  *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vTriggerTimer(const tBool isDeviceConnection) /*see -  case enTimerExp in StartMonitorLooseBlocking*/
{
    util_StructMsg       oMsg;
    util_StructQInfo    *pMsgQInfo=&m_msgQ;

    ETG_TRACE_USR4(("Begin: vTriggerTimer"));
    ETG_TRACE_COMP(("->################### vTriggerTimer #####################"));

    //prepare to send to Q
    oMsg.eMsgType   = enTriggerTimer;
    oMsg.u16LenCont = sizeof(isDeviceConnection);
    memcpy(&(oMsg.pu8Content[0]),&isDeviceConnection,sizeof(isDeviceConnection));
    util_vSendMsg2Q(pMsgQInfo,&oMsg);


    ETG_TRACE_USR4(("End  : vTriggerTimer"));
}

tBool StateTable::setVoltageFill(IN tenDevManagerUSBHost eUsb,IN tenSignalValue eU60_drop, OUT util_StructMsg &oMsg)
{
    tBool bRet = FALSE;

    //prepare to send to Q
    oMsg.eMsgType   = enVoltWarning;
    oMsg.u16LenCont = sizeof(tenDevManagerUSBHost/*eUsb*/)+sizeof(tenDevManagerUSBHost/*eU60_drop*/);
    if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
    {
        ETG_TRACE_FATAL(("ERROR: setMount: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
        oMsg.u16LenCont=0;
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {
        memcpy(&(oMsg.pu8Content[0]),&eUsb,sizeof(tenDevManagerUSBHost/*eUsb*/));
        memcpy(&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)]),&eU60_drop,sizeof(tenSignalValue/*eU60_drop*/));

        bRet = TRUE; //copied ok
    }


    return bRet;
}
/*-----------------------------------------------------------------------------*
 * tVoid setVoltage(tenDevManagerUSBHost eUsb,tenSignalValue eU60_drop)     *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::setVoltage(IN tenDevManagerUSBHost eUsb,IN tenSignalValue eU60_drop)
{
#ifndef USE_HIGHRISK4USB_HWMALFUNCTION
    ETG_TRACE_USR4(("Begin: setVoltage"));
    ETG_TRACE_COMP(("->################### setVoltage: :USB%1d,eU60_drop=%d#####################",
                    (int)eUsb,ETG_ENUM(TENSIGNALVALUE,eU60_drop)));

    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_VOLTAGEMANAGER))
    {
        util_StructMsg oMsg;
        tBool bSend = setVoltageFill(IN eUsb,IN eU60_drop,OUT oMsg); //this function has been established to offer unittesting of state table
        //--------------
        //send it
        //--------------
        if(bSend)
        {
            util_StructQInfo    *pMsgQInfo=&m_msgQ;
            util_vSendMsg2Q(pMsgQInfo,&oMsg);
        }
    }
    else
    {
        ETG_TRACE_FATAL(("[INFO] setVoltage: Signal not used : eConf_ENABLE_USE_VOLTAGEMANAGER disabled"));
    }
    ETG_TRACE_USR4(("End  : setVoltage"));
#else
    (void)eUsb; //To avoid warnings
    (void)eU60_drop; //To avoid warnings
#endif
}


/*-----------------------------------------------------------------------------*
 * tVoid setHWSignalsFill(UsbPortState *pPortState)                                *
 *-----------------------------------------------------------------------------*/
tBool StateTable::setHWSignalsFill(IN const UsbPortState *pPortState,OUT util_StructMsg &oMsg)
{
    tBool bRet = FALSE;
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWSignals())
    {

        //prepare to send to Q
        oMsg.eMsgType   = enHWSignals;
        oMsg.u16LenCont = sizeof(UsbPortState);

        if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
        {
            ETG_TRACE_FATAL(("ERROR: _setHWSignals: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
            oMsg.u16LenCont=0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            memcpy(&(oMsg.pu8Content[0]),pPortState,sizeof(UsbPortState));
            //send it ok
            bRet = TRUE;
        }
    }

    return bRet;
}


#ifdef WORKAROUND_PRMBUG
/*-----------------------------------------------------------------------------*
 * tVoid _setHWSignals(UsbPortState *pPortState)                                *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::_setHWSignals(const UsbPortState *pPortState)
{
    ETG_TRACE_USR4(("Begin: _setHWSignals"));


    if( pPortState != NULL )
    {
        util_StructMsg oMsg;
        tBool bSend = setHWSignalsFill(IN pPortState,OUT oMsg); //this function has been established to offer unittesting of state table
        //--------------
        //send it
        //--------------
        if(bSend)
        {
            util_StructQInfo    *pMsgQInfo=&m_msgQ;
            util_vSendMsg2Q(pMsgQInfo,&oMsg);

        }
    }
    else
    {
        ETG_TRACE_FATAL(("ERROR: setHWSignals: pMsgQInfo==NULL || pPortState == NULL"));
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
}
#endif//WORKAROUND_PRMBUG



/*-----------------------------------------------------------------------------*
 * tVoid TraceErrorMem(UsbPortState *pPortState)                                *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::TraceErrorMem(UsbPortState* pPortState)
{
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST //To avoid warnings in linuxx86_64 build
    (void)pPortState;
#endif
    ETG_TRACE_FATAL(("StartMonitorLooseBlocking [enHWSignals]: pPortState->u8PortNr: %d",ETG_ENUM(TENSIGNALVALUE,pPortState->u8PortNr) ));
    ETG_TRACE_FATAL(("StartMonitorLooseBlocking [enHWSignals]: pPortState->u8OC    : %d",ETG_ENUM(TENSIGNALVALUE,pPortState->u8OC) ));
    ETG_TRACE_FATAL(("StartMonitorLooseBlocking [enHWSignals]: pPortState->u8PPON  : %d",ETG_ENUM(TENSIGNALVALUE,pPortState->u8PPON) ));

    ETG_TRACE_ERRMEM(("StartMonitorLooseBlocking [enHWSignals]: pPortState->u8PortNr: %d",ETG_ENUM(TENSIGNALVALUE,pPortState->u8PortNr) ));
    ETG_TRACE_ERRMEM(("StartMonitorLooseBlocking [enHWSignals]: pPortState->u8OC    : %d",ETG_ENUM(TENSIGNALVALUE,pPortState->u8OC) ));
    ETG_TRACE_ERRMEM(("StartMonitorLooseBlocking [enHWSignals]: pPortState->u8PPON  : %d",ETG_ENUM(TENSIGNALVALUE,pPortState->u8PPON) ));

}



/*-----------------------------------------------------------------------------*
 * tVoid setHWSignals(UsbPortState *pPortState)                                *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::setHWSignals(UsbPortState *pPortState)
{
    ETG_TRACE_USR4(("Begin: setHWSignals"));
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWSignals())
    {
        UsbPortState oPortState;
        ETG_TRACE_COMP(("->################### setHWSignals #####################"));
        ETG_TRACE_COMP(("setHWSignals:USB%1d     pPortState->u8PortNr=%d",pPortState->u8PortNr,pPortState->u8PortNr));
        ETG_TRACE_COMP(("setHWSignals:USB%1d     pPortState->u8UV    =%d",pPortState->u8PortNr,ETG_ENUM(TENSIGNALVALUE,pPortState->u8UV)));
        ETG_TRACE_COMP(("setHWSignals:USB%1d     pPortState->u8OC    =%d",pPortState->u8PortNr,ETG_ENUM(TENSIGNALVALUE,pPortState->u8OC)));
        ETG_TRACE_COMP(("setHWSignals:USB%1d     pPortState->u8PPON  =%d",pPortState->u8PortNr,ETG_ENUM(TENSIGNALVALUE,pPortState->u8PPON)));

        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_PRM_HWSIGNALS))
        {
    #ifdef WORKAROUND_PRM_U50_USB_RESET
            if(0x00 == pPortState->u8UV) /*SIGNAL_UNDEF*/
            {
                pPortState->u8UV = 0x01; //SIGNAL_FALSE
                ETG_TRACE_ERR(("WORKAROUND: setHWSignals pPortState->u8UV is undef change to false!!!!!1"));
            }
    #endif
            //WORKAROUND_PRMBUG always on //check to clean in config.h
            if( (0x00 /*UNDEF*/ == pPortState->u8OC) && (0x00/*UNDEF*/ == pPortState->u8PPON) )
            {

                ETG_TRACE_FATAL(("StartMonitorLooseBlocking [enHWSignals]: PLATFORM PRM HAS SEND UDEFINED STATE!!!"));
                ETG_TRACE_ERRMEM(("StartMonitorLooseBlocking [enHWSignals]: PLATFORM PRM HAS SEND UDEFINED STATE!!!"));
                TraceErrorMem(pPortState);
                ETG_TRACE_FATAL(("StartMonitorLooseBlocking [enHWSignals]: to ensure device recognition for this ignition cycle: EMERGENCY MODE!" ));
                ETG_TRACE_ERRMEM(("StartMonitorLooseBlocking [enHWSignals]: to ensure device recognition for this ignition cycle: EMERGENCY MODE!" ));

                DVM_NORMAL_M_ASSERT_ALWAYS();

                //copy to local variable in order not to touch something coming from driver
                oPortState.u8PortNr         = pPortState->u8PortNr;
                oPortState.u8OC             = 0x01; //SIGNAL_FALSE;
                oPortState.u8UV             = 0x01; //SIGNAL_FALSE
                oPortState.u8PPON           = 0x02; //SIGNAL_TRUE
                //taken for completness but not yet really used in further callstack
                oPortState.u32OCStartTime   = pPortState->u32OCStartTime;
                oPortState.u32OCEndTime     = pPortState->u32OCEndTime;
                oPortState.u32UVStartTime   = pPortState->u32UVStartTime;
                oPortState.u32UVEndTime     = pPortState->u32UVEndTime;
                oPortState.u32PPONStartTime = pPortState->u32PPONStartTime;
                oPortState.u32PPONEndTime   = pPortState->u32PPONEndTime;

                //nok - workaround
                if((pPortState->u8PortNr < (tU8)eUSB1) || (pPortState->u8PortNr>= (tU8)ARRAYSIZEFORUSB))
                {
                    ETG_TRACE_ERRMEM(("StartMonitorLooseBlocking [enHWSignals]: PLATFORM PRM HAS SEND UDEFINED PORT!!!"));

                    for(tU8 i=(tU8)eUSB1; i < (tU8)ARRAYSIZEFORUSB; i++)
                    {
                        oPortState.u8PortNr  = i;
                        _setHWSignals(&oPortState);
                    }
                }
                //nok - workaround
                else
                {
                    _setHWSignals(&oPortState);
                }

            }
            else if( (pPortState->u8OC != 0x01 /*SIG_FALSE*/) && (pPortState->u8OC != 0x02 /*SIG_TRUE*/) )
            {
                ETG_TRACE_FATAL(("StartMonitorLooseBlocking [enHWSignals]: PLATFORM PRM HAS SEND UDEFINED STATE for OC!!! - IGNORDED"));
                ETG_TRACE_ERRMEM(("StartMonitorLooseBlocking [enHWSignals]: PLATFORM PRM HAS SEND UDEFINED STATE for OC!!!- IGNORDED"));
                TraceErrorMem(pPortState);
            }
            else if( (pPortState->u8PPON != 0x01 /*SIG_FALSE*/) && (pPortState->u8PPON != 0x02 /*SIG_TRUE*/) )
            {
                ETG_TRACE_FATAL(("StartMonitorLooseBlocking [enHWSignals]: PLATFORM PRM HAS SEND UDEFINED STATE for PPON!!! - IGNORDED"));
                ETG_TRACE_ERRMEM(("StartMonitorLooseBlocking [enHWSignals]: PLATFORM PRM HAS SEND UDEFINED STATE for PPON!!!- IGNORDED"));
                TraceErrorMem(pPortState);
            }
            //-----
            //ok
            //----
            else
            {
                _setHWSignals(pPortState);
            }

        }
        else
        {
            ETG_TRACE_FATAL(("[INFO] setHWSignals:  eConf_ENABLE_USE_PRM_HWSIGNALS disabled"));
        }
    }
    ETG_TRACE_USR4(("End  : setHWSignals"));
}



/*-----------------------------------------------------------------------------*
 * tVoid setCardSignals( CardNotInfo* pInfo )                                  *
 *-----------------------------------------------------------------------------*/
tBool StateTable::SetCardSignalsFill(IN tenSignalValue f_enConnected, IN tChar (&f_strDeviceName)[STRING_LENGTH], IN tU16 f_u16MediaType,OUT util_StructMsg &oMsg)
{
    tBool bRet = FALSE;

    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWSignals())
    {
        //prepare to send to Q
        oMsg.eMsgType   = enCardSignals;
        oMsg.u16LenCont = sizeof(tenSignalValue) + sizeof(f_strDeviceName) + sizeof(f_u16MediaType);
        if( oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN )
        {
            ETG_TRACE_FATAL(( "[ERROR]: setCardSignals: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)", oMsg.u16LenCont, (tU16)UTIL_MAX_CONTENT_LEN) );
            oMsg.u16LenCont = 0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            memcpy( &(oMsg.pu8Content[0]),                                                  &f_enConnected, sizeof(tenSignalValue) );
            memcpy( &(oMsg.pu8Content[sizeof(tenSignalValue)]),                            &(f_strDeviceName[0]), sizeof(f_strDeviceName) );
            memcpy( &(oMsg.pu8Content[sizeof(tenSignalValue) + sizeof(f_strDeviceName)]),  &(f_u16MediaType), sizeof(tU16) );
            //to send it is ok
            bRet = TRUE;
        }
    }

    return bRet;
}


/*-----------------------------------------------------------------------------*
 * tVoid setCardSignals( CardNotInfo* pInfo )                                  *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::SetCardSignals(IN tenSignalValue f_enConnected, IN tChar (&f_strDeviceName)[STRING_LENGTH], IN tU16 f_u16MediaType)
{

    ETG_TRACE_USR4(("Begin: setCardSignals"));

    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWSignals())
    {

        ETG_TRACE_COMP(("->################### setCardSignals #####################"));
        ETG_TRACE_USR4(("setCardSignals: f_enConnected           : %d", ETG_ENUM(TENSIGNALVALUE, f_enConnected) ));
        ETG_TRACE_USR4(("setCardSignals: f_u16MediaType          : %d", ETG_ENUM(DVM_PRM_TABLE_STATUS_MEDIA_CHANGE, f_u16MediaType) ));
        ETG_TRACE_USR4(("setCardSignals: f_strDeviceName         : %s", f_strDeviceName ));
        ETG_TRACE_USR4(("setCardSignals: sizeof(f_strDeviceName) : %d", sizeof(f_strDeviceName) ));


        //send to QUEUE of StateTable
        if(f_enConnected != SIG_UNDEF)
        {
            util_StructMsg oMsg;
            tBool bSend = SetCardSignalsFill(IN f_enConnected, IN f_strDeviceName, IN f_u16MediaType,OUT oMsg);
            //--------------
            //send it
            //--------------
            if(bSend)
            {
                util_StructQInfo    *pMsgQInfo=&m_msgQ;
                util_vSendMsg2Q(pMsgQInfo,&oMsg);
            }
        }
        else
        {
            ETG_TRACE_FATAL(( "[ERROR]: setCardSignals: f_enConnected == SIG_UNDEF"));
        }
    }

    ETG_TRACE_USR4(("End  :setCardSignals"));
}



/*-----------------------------------------------------------------------------*
 * tVoid setCardSignalsFill(...)
 *-----------------------------------------------------------------------------*/
tBool StateTable::setCardOverCurrentStatusFill( IN const CardNotInfoOcStatus* pInfo, OUT util_StructMsg &oMsg)
{
    tBool bRet = FALSE;

    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWSignals())
    {
        //prepare to send to Q
        oMsg.eMsgType   = enCardOcStatus;
        oMsg.u16LenCont = sizeof(CardNotInfoOcStatus);
        if( oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN )
        {
            ETG_TRACE_FATAL(( "ERROR: setCardOverCurrentStatus: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)", oMsg.u16LenCont, (tU16)UTIL_MAX_CONTENT_LEN) );
            oMsg.u16LenCont = 0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            memcpy( &(oMsg.pu8Content[0]), pInfo, sizeof(CardNotInfoOcStatus) );
            //send it is ok
            bRet = TRUE;
        }
    }

    return bRet;
}

/*-----------------------------------------------------------------------------*
 * tVoid setCardSignals(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::setCardOverCurrentStatus( const CardNotInfoOcStatus* pInfo )
{
    ETG_TRACE_USR4(("Begin: setCardOverCurrentStatus"));
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWSignals())
    {
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_PRM_SDCARDSIGNALS))
        {
            ETG_TRACE_USR4(("->############### setCardOverCurrentStatus ###############"));
            ETG_TRACE_USR3(("setCardOverCurrentStatus: SD Card %1d,  Overcurrent Active = %d", pInfo->eSlot, pInfo->bOcActive ));

            util_StructMsg oMsg;
            tBool bSend = setCardOverCurrentStatusFill( IN pInfo, OUT oMsg); //this function has been established to offer unittesting of state table
            //--------------
            //send it
            //--------------
            if(bSend)
            {
                util_StructQInfo    *pMsgQInfo=&m_msgQ;
                util_vSendMsg2Q(pMsgQInfo,&oMsg);
            }
        }
        else
        {
            ETG_TRACE_USR4(("End  :setCardOverCurrentStatus: Disabled: eConf_ENABLE_USE_PRM_SDCARDSIGNALS == DVM_OFF"));
        }
    }
    ETG_TRACE_USR4(("End  :setCardOverCurrentStatus"));
}


/*-----------------------------------------------------------------------------*
 * tVoid vShutdown(tVoid)                                                      *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vShutdown(tVoid)
{
    ETG_TRACE_USR4(("Begin: setShutdown"));
    util_StructMsg       oMsg;
    util_StructQInfo    *pMsgQInfo=&m_msgQ;

    /*shutdown thread*/
    //prepare to send to Q
    oMsg.eMsgType   = enShutdown;
    oMsg.u16LenCont = 0;
    util_vSendMsg2Q(pMsgQInfo,&oMsg); //send it
    LOCK_THREAD;
    UNLOCK_THREAD;

    ETG_TRACE_USR4(("End  : setShutdown"));

}


/*-----------------------------------------------------------------------------*
 * tenDevManagerUSBHost GetConnector(CDevice *pCurDevice)                     *
 *-----------------------------------------------------------------------------*/
tenDevManagerUSBHost StateTable::GetConnector( const CDevice *pCurDevice) const
{
    tenDevManagerUSBHost usbConnector = eUSB1;//@todo care for invalid value
    ETG_TRACE_USR4(("Begin: GetConnector(pCurDevice)"));
    //check if this mount poin
    if((pCurDevice->m_iUSBConnector >= USBConnector1) &&
            (pCurDevice->m_iUSBConnector <= USBConnectorLast)
            )
    {
        usbConnector=(tenDevManagerUSBHost)pCurDevice->m_iUSBConnector;
    }
#if defined(BUGFIX_DECOUPLE_SDCARD_PRM) || defined(BUGFIX_DECOUPLE_CDROM_PRM)
    else if(pCurDevice->m_iUSBConnector == USBConnectorUndef)
    {
        usbConnector= eUSBUndef;
    }
#endif //BUGFIX_DECOUPLE_SDCARD_PRM,BUGFIX_DECOUPLE_CDROM_PRM
    else
    {
        ETG_TRACE_FATAL(("ERROR: GetConnector: wrong m_iUSBConnector=%d",pCurDevice->m_iUSBConnector));
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }

    ETG_TRACE_USR4(("End  : GetConnector(pCurDevice)"));
    return usbConnector; //@todo care for invalid value
}


/*-----------------------------------------------------------------------------*
 * tBool checkSendBasedOnConfig(tenDevManagerUSBHost usb,                      *
 *          DEVICE_CONNECTSTATUS_Type connectstatus, tBool bTest)              *
 *-----------------------------------------------------------------------------*/
tBool StateTable::checkSendBasedOnConfig(tenDevManagerUSBHost usb,
                                         DEVICE_CONNECTSTATUS_Type connectstatus, tBool bTest) const
{
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
    (void)usb;//To avoid warnings
#endif
    tBool bSend2Clients = FALSE;

    /*this to support VD_DVM_SIMULATE_MSG2CLIENTS
      in test mode always send signal
    */

    ETG_TRACE_USR1(("checkSendBasedOnConfig:usb%1d connectstatus=0x%x bTest=0x%x",usb,connectstatus,bTest))
            if(TRUE==bTest)
    {
        bSend2Clients = TRUE;
    }
    else
    {
        //------------------------------
        //care for defines in config.h
        //------------------------------
        switch(connectstatus)
        {
        case USB_DEV_WARNING:
            //@todo not used anymore
            break;
        case USB_DEV_UNAVAIL_BAT_LOWVOLT:
        case USB_DEV_UNAVAIL_HW_MALFUNC:
#ifdef BUGFIX_CARE_PERMANENT_OVERCURRENT
        case USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT:
#endif
            bSend2Clients = TRUE;
            break;
        case USB_DEV_UNDEFINED:
        case USB_DEV_CONNECTED:
        case USB_DEV_REMOVED_BY_USR:
            /*not used to send a signal here has been done before (based on 'APPLY')- see code above*/
            break;
        default:
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
    }

    return bSend2Clients;
}

/*-----------------------------------------------------------------------------*
 * tVoid send2Clients(tenDevManagerUSBHost usb,                                *
 *          const voltageFailure_Result_t& result, tBool bTest)                *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::send2Clients(tenDevManagerUSBHost usb,
                               const voltageFailure_Result_t& result, tBool bTest)
{
    tInt  iStateApply                      = 0;
    tInt  iNumOfConnectedDevices           = 0;
    DEVICE_CONNECTSTATUS_Type oldResultUSB = USB_DEV_UNDEFINED;


    ETG_TRACE_COMP(("Begin: send2Clients"));
    ETG_TRACE_COMP(("send2Clients: usb=%d result.resultUSB=%d bTest=0x%x", usb, ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE, result.resultUSB), bTest ));

    /*check devices connected to connector*/
    DeviceListManager::GetInstance()->checkNumOfDevicesAtConnector(DEVLIST_STATETABLE,usb, iNumOfConnectedDevices /*at usb*/,iStateApply );

    if(iNumOfConnectedDevices > 0)
    {
        ETG_TRACE_COMP(("send2Clients: iStateApply=%d",iStateApply));
        ETG_TRACE_COMP(("send2Clients: m_result[usb%1d].resultUSB=%d ", usb, ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE, m_result[usb].resultUSB) ));
        if(    (iStateApply>0)                                /*devices plugged to either USB1 or USB2 apply for connect or disconnect*/
               || (result.resultUSB!=m_result[usb].resultUSB)    /*result of statemachine is different like before thus inform clients*/
               || (TRUE == bTest)
               )
        {
            if(TRUE == bTest)
            {
                oldResultUSB = m_resultLastSendtoClient[usb].resultUSB;
            }
            m_resultLastSendtoClient[usb].resultUSB=result.resultUSB;
            _send2Clients(usb,result,bTest);

            if(TRUE == bTest)
            {
                m_resultLastSendtoClient[usb].resultUSB = oldResultUSB;
            }

        }
    }
    else
    {
        //check if any device is connected already
        tInt iAlldevicesConnected = 0;
        tInt iAllApplyStates      = 0;
        for( tInt i = (tInt)eUSBUndef; i < ARRAYSIZEFORUSB; i++ )
        {
            DeviceListManager::GetInstance()->checkNumOfDevicesAtConnector(DEVLIST_STATETABLE,(tenDevManagerUSBHost)i, iNumOfConnectedDevices /*at usb*/,iStateApply );
            iAllApplyStates      += iStateApply;
            iAlldevicesConnected += iNumOfConnectedDevices;

        }
        ETG_TRACE_COMP(("send2Clients: iAlldevicesConnected: %d ",iAlldevicesConnected));
        ETG_TRACE_COMP(("send2Clients: iAllApplyStates     : %d ",iAllApplyStates));

        //if there are no device connected and no devices in Applystate then  at least send HW-signals
        if((iAlldevicesConnected == 0) && (iAllApplyStates == 0))
        {
            //BUGFIX_REDUNDNANTMSGS_GM - simple GM specific solution will be replaced if vCASEenTimerExpOld won't be used anymore
            if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_SUPPRESS_DIAGNOSISHWSIGNAL))
            {
                ETG_TRACE_USR4(("send2Clients vInformClientsHWSignals suppressed in GM - intermediate solution"));
            }
            else
            {
                //Diagnosis 14003 (notify OC,PPON, Undervoltage)
                DVMGRIF_GENERAL->vInformClientsHWSignals();//Note: HWSignals stored in PortListManager
            }
        }
    }
    ETG_TRACE_COMP(("End  : send2Clients"));
}


/*-----------------------------------------------------------------------------*
 * tVoid vMapDevicePropertiesStore(tenDevManagerUSBHost usb,                                *
 *          const voltageFailure_Result_t& result, tBool bTest)                *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vMapDevicePropertiesStore(IN voltageFailure_Result_t (&f_result)[ARRAYSIZEFORUSB])
{
    ETG_TRACE_COMP(("Begin: vMapDevicePropertiesStore"));

    //Commented for the lint fix
    //tInt  iStateApply                      = 0;
    //tInt  iNumOfConnectedDevices           = 0;

    //------------------------------------------------------------------------
    //transition for devices already in list if overcurrent or critical voltage will be done now
    // USB_DEV_CONNECTED                     => USB_DEV_UNAVAIL_HW_MALFUNC
    // USB_DEV_CONNECTED                     => USB_DEV_UNAVAIL_BAT_LOWVOLT
    //
    //
    // USB_DEV_UNAVAIL_HW_MALFUNC   => USB_DEV_UNAVAIL_BAT_LOWVOLT
    // etc.
    //-------------------------------------------------------------------------
    DeviceListManager::GetInstance()->SetStateAtConnectorsDueToHWSignalsAndVoltage(IN f_result);

    ETG_TRACE_COMP(("End  : vMapDevicePropertiesStore"));
}


/*-----------------------------------------------------------------------------*
 * tVoid _send2Clients(tenDevManagerUSBHost usb,                               *
 *          const voltageFailure_Result_t& result, tBool bTest)                *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::_send2Clients(tenDevManagerUSBHost usb,
                                const voltageFailure_Result_t& result,tBool bTest) const
{
    ETG_TRACE_COMP(("Begin: ._send2Clients"));
    ETG_TRACE_COMP(("_send2Clients: usb=%d result.resultUSB=%d ", usb, ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,result.resultUSB)));

    tUInt iSize = DeviceListManager::GetInstance()->getSizeOfList(DEVLIST_STATETABLE);
    tBool bExists = FALSE;
    structNotifyClients oCurDevice;

    /*state, input & output of state machine*/
    DEVICE_CONNECTSTATUS_Type currState;
    DEVICE_CONNECTSTATUS_Type demandedState;
    tenMsgList_index          msg2send;
    tBool bDeleteLists = FALSE;


    //iterate list of devices to notify clients
    //during iteration objective is to find only devices bound to connector 'usb'
    ETG_TRACE_COMP(("_send2Clients: iSize=%d",iSize));
    for (unsigned int l_uiCount=0; l_uiCount < iSize ;l_uiCount++)
    {

        bExists = DeviceListManager::GetInstance()->getElement(l_uiCount,oCurDevice);
        DVM_NORMAL_M_ASSERT(TRUE == bExists);

        ETG_TRACE_COMP(("_send2Clients: l_uiCount=%d bExists=%d oCurDevice.eUSB=%d oCurDevice.cMountPoint =%s",l_uiCount,bExists,oCurDevice.eUSB,oCurDevice.cMountPoint));
#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
        ETG_TRACE_USR4(("_send2Clients: oCurDevice.m_eFSType=%d",ETG_CENUM( CGlobalEnumerations::FILESYSTEM_TYPE_Type,oCurDevice.eFSType)));
#endif

        if((TRUE == bExists) && (usb == oCurDevice.eUSB))
        {
            ETG_TRACE_COMP(("============================================================================================"));
            demandedState = result.resultUSB;
            currState     = oCurDevice.eConnectStatus;
            ETG_TRACE_COMP(("_send2Clients:  demandedState=%d            ",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,demandedState)));
            ETG_TRACE_COMP(("_send2Clients:  currState    =%d            ",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,currState)));

            //--------------------------------------------------------------------------------
            //case TEST: use e.g. VD_DVM_SIMULATE_MSG2CLIENTS USB1 USB_DEV_UNAVAIL_HW_MALFUNC
            //--------------------------------------------------------------------------------
            if(TRUE == bTest)
            {
                oCurDevice.eConnectStatus = demandedState;
                DVMGRIF_GENERAL->vInformClients(oCurDevice,bTest);/*HWSignals stored in PortListManager Service takes use of it*/
                oCurDevice.eConnectStatus = currState;
            }
            //--------------------------------------------------------------------------------
            //case NORMAL EXECUTION
            //--------------------------------------------------------------------------------
            else
            {
                if(((tInt)demandedState<MAXDEMANDED))
                {
                    msg2send = m_stateTableInformClients[currState].demandedState[demandedState];
                    ETG_TRACE_COMP(("_send2Clients: msglist_InformClients[%d]",ETG_ENUM(MSGLIST_INDEX,msg2send)));


                    ETG_TRACE_COMP(("_send2Clients: numOfMsgs:%d [msg1:%d msg2:%d msg3:%d ] ",
                                    m_msgListInformClients[msg2send].u8NumOfMsgs,
                                    ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,m_msgListInformClients[msg2send].msgList[0]),
                                    ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,m_msgListInformClients[msg2send].msgList[1]),
                                    ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,m_msgListInformClients[msg2send].msgList[2])));


                    for(tInt i = 0; i<m_msgListInformClients[msg2send].u8NumOfMsgs; i++)
                    {
                        tInt iVal = m_msgListInformClients[msg2send].msgList[i];

                        /*check if cast is allowed*/
                        if(   (-1 != iVal)
                              && (iVal<=(tInt)USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT)
                              && (iVal>=(tInt)USB_DEV_UNDEFINED)
                              )
                        {
                            oCurDevice.eConnectStatus = (DEVICE_CONNECTSTATUS_Type)m_msgListInformClients[msg2send].msgList[i];
                            //-------------------------------------------------------------------------------------
                            //special case overtemperature for CDRom has been notified before CDROM has been inserted and mounted
                            //-------------------------------------------------------------------------------------
                            if(    (oCurDevice.eDeviceType    == CGlobalEnumerations::DTY_CDROM)  //Roadmap 13035 OverTemperature
                                   && (oCurDevice.eConnectStatus == USB_DEV_CONNECTED)
                                   && (m_bOverTemperature == TRUE))
                            {


                                ETG_TRACE_USR2(("_send2Clients: DTY_CDROM: Overtemperature: adjust eConnectStatus:USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE"));
                                oCurDevice.eConnectStatus = USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE;
                                // Roadmap 14003 (notify PortStates) HWSignals stored in PortListManager Service takes use of it
                                DVMGRIF_GENERAL->vInformClientsCDDriveOvertemp(oCurDevice); //Roadmap_13035_Overtemp
                            }
                            //-------------------------------------------------------------------------------------
                            // normal execution to reach notification
                            //-------------------------------------------------------------------------------------
                            else
                            {
                                // Roadmap 14003 (notify PortStates) HWSignals stored in PortListManager Service takes use of it
                                DVMGRIF_GENERAL->vInformClients(oCurDevice,/*bTest=*/FALSE); //DeviceListManager::GetInstance()->Set_eConnectStatus will be done in fct InformClients
                            }
                        }
                        else
                        {
                            if(iVal != -1) //is allowed value see 'm_msgListInformClients' means nothing to be send
                            {
                                ETG_TRACE_FATAL(("ERROR: _send2Clients: ERROR: CHECK YOUR m_msgListInformClients[]: iVal=%d",iVal));
                                DVM_NORMAL_M_ASSERT_ALWAYS();
                            }
                        }
                    }
                    /*care that all lists will be deleted after messages have been send to clients*/
                    if(eMALFUNC == msg2send)
                    {
                        bDeleteLists = TRUE;
                    }
                    ETG_TRACE_COMP(("============================================================================================"));

                }
            }
        }
    }

    /*DELETE ALL LISTS of VD_DEVICEMANAGER e.g. after HW_MALFUNCTION*/
    if(   (TRUE == bDeleteLists)
          &&(TRUE == DeviceListManager::GetInstance()->getPlatformEventsLocked(usb))
          )
    {
        ETG_TRACE_SYS(("_send2Clients: !!!!!!!!!!!!/DELETE LIST USB%1d USB_DEV_UNAVAIL_HW_MALFUNC!!!!!!!!!!!!!!!!!!!! ",usb));
        DeviceListManager::GetInstance()->deleteLists(usb); //already deleted - to be sure that it is really empty to fulfill start condition after uvolt
        ETG_TRACE_SYS(("_send2Clients: !!!!!!!!!!!!!DELETE LIST USB%1d USB_DEV_UNAVAIL_HW_MALFUNC/!!!!!!!!!!!!!!!!!!!! ",usb));
    }

    ETG_TRACE_COMP(("End  : _send2Clients:"));
}

/*-----------------------------------------------------------------------------*
 * tVoid send2ClientsTest(tenDevManagerUSBHost usb,                            *
 *          DEVICE_CONNECTSTATUS_Type  eConnectionStatus)                      *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::send2ClientsTest(tenDevManagerUSBHost usb,
                                   DEVICE_CONNECTSTATUS_Type  eConnectionStatus)
{
    util_StructMsg            oMsg;
    util_StructQInfo         *pMsgQInfo=&m_msgQ;

    ETG_TRACE_COMP(("Begin: send2ClientsTest"));

    for(tInt i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
    {
        ETG_TRACE_USR1(("send2ClientsTest:m_result[USB%1d].resultUSB=%d",
                        i,ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,m_result[i].resultUSB)));
    }
    if(USB_DEV_CONNECTED !=m_result[usb].resultUSB)
    {
        ETG_TRACE_FATAL(("ERROR:-------------------------------------------------------------------------------------------------------"));
        ETG_TRACE_FATAL(("ERROR: NOTE:for testing an USB device must be connected to the corresponding usb port you want to test"));
        ETG_TRACE_FATAL(("ERROR:-------------------------------------------------------------------------------------------------------"));
    }
    else
    {

        //prepare to send to Q
        oMsg.eMsgType   = enTestSend2Client;
        oMsg.u16LenCont = sizeof(tenDevManagerUSBHost/*eUsb*/)+ sizeof(DEVICE_CONNECTSTATUS_Type);
        if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
        {
            ETG_TRACE_FATAL(("ERROR: send2ClientsTest: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
            oMsg.u16LenCont=0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            memcpy(&(oMsg.pu8Content[0]),&usb,sizeof(tenDevManagerUSBHost/*eUsb*/));
            memcpy(&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)]),&eConnectionStatus,sizeof(DEVICE_CONNECTSTATUS_Type));
            //send it
            util_vSendMsg2Q(pMsgQInfo,&oMsg);
        }

    }

    ETG_TRACE_COMP(("End  : send2ClientsTest"));
}


/*-----------------------------------------------------------------------------*
 * tVoid getLastMsgSendtoClients(tenDevManagerUSBHost usb,                     *
 *          voltageFailure_Result_t *pMessage)                                 *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::getLastMsgSendtoClients(tenDevManagerUSBHost usb,
                                          voltageFailure_Result_t *pMessage) const
{
    ETG_TRACE_USR4(("Begin: getLastMsgSendtoClients"));
    if(NULL!=pMessage)
    {
        pMessage->resultUSB=m_resultLastSendtoClient[usb].resultUSB;
    }
    ETG_TRACE_USR4(("End  : getLastMsgSendtoClients"));
}

/*-----------------------------------------------------------------------------*
 * StateTable* GetInstance()                 *
 *-----------------------------------------------------------------------------*/
StateTable *StateTable::GetInstance()
{
    ETG_TRACE_USR4(("Begin: GetInstance"));
    StateTable::m_singelton.lock();
    if(NULL == m_pStateTableManager)
    {
        m_pStateTableManager = new StateTable();
    }
    StateTable::m_singelton.unlock();
    ETG_TRACE_USR4(("End  : GetInstance"));

    return m_pStateTableManager;
}

/*-----------------------------------------------------------------------------*
 * void DestroyInstance()                                                      *
 *-----------------------------------------------------------------------------*/
void StateTable::DestroyInstance()
{
    ETG_TRACE_USR4(("Begin: DestroyInstance"));

    //---------/Finish Thread of ThreadFactory----------
    ETG_TRACE_USR4(("DestroyInstance: ask to stop thread"));
#ifdef USE_STATETABLESTOPS_VOLTAGETHREAD  ///@todo make this redundant by checkin gin WorkThread the shutdown sequence
    if(TRUE == VoltageManager::GetInstance()->bStopThread())
    {
        ETG_TRACE_USR4(("DestroyInstance: thread stopped"));
    }
    else
    {
        ETG_TRACE_USR4(("DestroyInstance: bStopThread returned with timout"));
    }
#endif
    //------------------------------------------------

    StateTable::m_singelton.lock();
    if(NULL != m_pStateTableManager)
    {
        if(m_pStateTableManager)
        {
            delete m_pStateTableManager;
            m_pStateTableManager = NULL;
        }
    }
    else
    {
        //do nothing
    }
    StateTable::m_singelton.unlock();
    ETG_TRACE_USR4(("End  : DestroyInstance"));
}

/*-----------------------------------------------------------------------------*
 * int Initialize(tVoid)                                                       *
 *-----------------------------------------------------------------------------*/
int StateTable::Initialize(tVoid)
{
    tS32 s32Result = OSAL_OK;

    m_u32CommonIntervalTimer_ms = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_STATETABLE_EXECUTION_TIME_MS);
    m_u32ConnectIntervalTimer_ms = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_STATETABLE_CONNECT_EXECUTION_TIME_MS);

    ETG_TRACE_COMP(("m_u32CommonIntervalTimer_ms=%d     ",m_u32CommonIntervalTimer_ms));
    ETG_TRACE_COMP(("m_u32ConnectIntervalTimer_ms=%d    ",m_u32ConnectIntervalTimer_ms));

    if(NULL != m_pStateTableManager)
    {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST //thread should not start for unit tests
        tInt iThreadIndex = ThreadFactoryDVM::GetThreadFactory()->Do(IN this, (int)StateTable::eThread_StateTable, NULL); //starts thread eThread_SystemVolt - see 'Do'-function above
        ETG_TRACE_COMP(("StateTable: iThreadIndex:%d",iThreadIndex));
#endif
    }
    else
    {
        s32Result = OSAL_ERROR;
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }

    fillTestDevices(); //clean prm mount then this can be cleaned

    return s32Result;
}

/*-----------------------------------------------------------------------------*
 * tVoid fillTestDevices(tVoid)                                                *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::fillTestDevices(tVoid)
{
    ETG_TRACE_USR4(("Begin: fillTestDevices"));

    //---------------------------------------------------------------------------------------------------
    //Objective: used for internal test
    //Test device 1 used for automatic tests to simulate prm and udev input
    //client connection must be disconnected otherwhise e.g. MPlayer would try to use a device which is not connected yet
    //---------------------------------------------------------------------------------------------------
    m_TestDevice[eUSB1].m_cDevnode             = "/dev/sda1";
    m_TestDevice[eUSB1].m_iVendorID            = 0x0951;
    m_TestDevice[eUSB1].m_iProductID           = 0x1642;
    m_TestDevice[eUSB1].m_cSerialID            = "Kingston_DT_100_G2_001CC0EC2F24BAC015F90096-0:0";
    m_TestDevice[eUSB1].m_cShortSerial         = "001CC0EC2F24BAC015F90096";
    m_TestDevice[eUSB1].m_cFSType              = "vfat";
    m_TestDevice[eUSB1].m_iIsMounted           = 1;
    m_TestDevice[eUSB1].m_cMountPoint          = "/dev/media/0522-378A_TEST";
    m_TestDevice[eUSB1].m_cDeviceName          = "TEST1-KINGSTON";
    m_TestDevice[eUSB1].m_cAccessoryName       = "";
    m_TestDevice[eUSB1].m_cDeviceVersion       = "PMAP";
    m_TestDevice[eUSB1].m_iDevNUM              = 2;
    m_TestDevice[eUSB1].m_cParentSerialId      = "Linux_2.6.34.10-01185-g9d4e37b_ehci_hcd_EHCI_Host_Controller_0000:00:13.1";
    m_TestDevice[eUSB1].m_bIsSdCardDevice      = false;
    m_TestDevice[eUSB1].m_bIsConnected         = true;
    m_TestDevice[eUSB1].m_iHubIndex            = 0x0;
    m_TestDevice[eUSB1].m_iUSBConnector        = 1;
    m_TestDevice[eUSB1].m_iPortNumber          = 1;
    m_TestDevice[eUSB1].m_lFreeSpace           = 395244392;
    m_TestDevice[eUSB1].m_lUsedSpace           = 51200000;
    m_TestDevice[eUSB1].m_lTotalSize           = 4000; /*MByte*/
    m_TestDevice[eUSB1].m_cDeviceUUID          = "0522-378A";
    m_TestDevice[eUSB1].m_cManufacturer        = "TEST:Kingston";
    m_TestDevice[eUSB1].m_u64Size              = 4194304000ULL;
    m_TestDevice[eUSB1].m_eDeviceType          = CGlobalEnumerations::DTY_USB;
    m_TestDevice[eUSB1].m_cUSBPort             = "";
    m_TestDevice[eUSB1].m_eConnectStatus       = USB_DEV_UNDEFINED;
    //used for remove
    m_TestDevice[eUSB1].eRemoveAction=CGlobalEnumerations::SINGLE;
    m_TestDevice[eUSB1].cRemoveDeviceNode="/dev/bus/usb/001/008";

    //------------------------------
    //test device 2
    //------------------------------
    m_TestDevice[eUSB2].m_cDevnode             = "/dev/sdb1";
    m_TestDevice[eUSB2].m_iVendorID            = 0x0951;
    m_TestDevice[eUSB2].m_iProductID           = 0x1642;
    m_TestDevice[eUSB2].m_cSerialID            = "Kingston_DataTraveler_G2_001CC0EC3449EA5086B902B3-0:0";
    m_TestDevice[eUSB2].m_cShortSerial         = "001CC0EC3449EA5086B902B3";
    m_TestDevice[eUSB2].m_cFSType              = "vfat";
    m_TestDevice[eUSB2].m_iIsMounted           = 1;
    m_TestDevice[eUSB2].m_cMountPoint          = "/dev/media/30A4-F7BC_TEST";
    m_TestDevice[eUSB2].m_cDeviceName          = "TEST2-KINGSTON";
    m_TestDevice[eUSB2].m_cAccessoryName       = "";
    m_TestDevice[eUSB2].m_cDeviceVersion       = "PMAP";
    m_TestDevice[eUSB2].m_iDevNUM              = 1;
    m_TestDevice[eUSB2].m_cParentSerialId      ="Linux_2.6.34.10-01185-g9d4e37b_ehci_hcd_EHCI_Host_Controller_0000:00:13.1";
    m_TestDevice[eUSB2].m_bIsSdCardDevice      = false;
    m_TestDevice[eUSB2].m_bIsConnected         = true;
    m_TestDevice[eUSB2].m_iHubIndex            = 0x0;
    m_TestDevice[eUSB2].m_iUSBConnector        = 2;
    m_TestDevice[eUSB2].m_iPortNumber          = 2;
    m_TestDevice[eUSB2].m_lFreeSpace           = 325790976;
    m_TestDevice[eUSB2].m_lUsedSpace           = 163635200;
    m_TestDevice[eUSB2].m_lTotalSize           = 3500; /*MByte*/
    m_TestDevice[eUSB2].m_cDeviceUUID          = "30A4-F7BC";
    m_TestDevice[eUSB2].m_cManufacturer        = "TEST:Kingston";
    m_TestDevice[eUSB2].m_u64Size              = 4194304000ULL;
    m_TestDevice[eUSB2].m_eDeviceType          = CGlobalEnumerations::DTY_USB;
    m_TestDevice[eUSB2].m_cUSBPort             = "";
    m_TestDevice[eUSB2].m_eConnectStatus       = USB_DEV_UNDEFINED;
    //used for remove
    m_TestDevice[eUSB2].eRemoveAction=CGlobalEnumerations::SINGLE;
    m_TestDevice[eUSB2].cRemoveDeviceNode="/dev/bus/usb/001/009";

    //------------------------------
    //test device 3
    //------------------------------
    m_TestDevice[eUSB3].m_cDevnode = "/dev/sdb1";
    m_TestDevice[eUSB3].m_iVendorID = 0x0951;
    m_TestDevice[eUSB3].m_iProductID = 0x1642;
    m_TestDevice[eUSB3].m_cSerialID = "Kingston_DataTraveler_G2_214DF0E45TRA5086RT4532-0:0";
    m_TestDevice[eUSB3].m_cShortSerial = "214DF0E45TRA5086RT4532";
    m_TestDevice[eUSB3].m_cFSType = "vfat";
    m_TestDevice[eUSB3].m_iIsMounted = 1;
    m_TestDevice[eUSB3].m_cMountPoint = "/dev/media/63T4-DRTQ_TEST";
    m_TestDevice[eUSB3].m_cDeviceName = "TEST3-KINGSTON";
    m_TestDevice[eUSB3].m_cAccessoryName = "";
    m_TestDevice[eUSB3].m_cDeviceVersion = "PMAP";
    m_TestDevice[eUSB3].m_iDevNUM = 1;
    m_TestDevice[eUSB3].m_cParentSerialId = "Linux_2.6.34.10-01185-g9d4e37b_ehci_hcd_EHCI_Host_Controller_0000:00:13.1";
    m_TestDevice[eUSB3].m_bIsSdCardDevice = false;
    m_TestDevice[eUSB3].m_bIsConnected = true;
    m_TestDevice[eUSB3].m_iHubIndex = 0x0;
    m_TestDevice[eUSB3].m_iUSBConnector = 2;
    m_TestDevice[eUSB3].m_iPortNumber = 2;
    m_TestDevice[eUSB3].m_lFreeSpace = 325790976;
    m_TestDevice[eUSB3].m_lUsedSpace = 163635200;
    m_TestDevice[eUSB3].m_lTotalSize = 3500; /*MByte*/
    m_TestDevice[eUSB3].m_cDeviceUUID = "63T4-DRTQ";
    m_TestDevice[eUSB3].m_cManufacturer = "TEST:Kingston";
    m_TestDevice[eUSB3].m_u64Size = 4194304000ULL;
    m_TestDevice[eUSB3].m_eDeviceType = CGlobalEnumerations::DTY_USB;
    m_TestDevice[eUSB3].m_cUSBPort = "";
    m_TestDevice[eUSB3].m_eConnectStatus = USB_DEV_UNDEFINED;
    //used for remove
    m_TestDevice[eUSB3].eRemoveAction = CGlobalEnumerations::SINGLE;
    m_TestDevice[eUSB3].cRemoveDeviceNode = "/dev/bus/usb/001/009";
#ifdef USE_FOURTH_USB_CONNECTOR
    //------------------------------
    //test device 4
    //------------------------------
    m_TestDevice[eUSB4].m_cDevnode             = "/dev/sdb1";
    m_TestDevice[eUSB4].m_iVendorID            = 0x0951;
    m_TestDevice[eUSB4].m_iProductID           = 0x1642;
    m_TestDevice[eUSB4].m_cSerialID            = "Kingston_DataTraveler_G2_CC2233449EA5086RT33543-0:0";
    m_TestDevice[eUSB4].m_cShortSerial         = "CC2233449EA5086RT33543";
    m_TestDevice[eUSB4].m_cFSType              = "vfat";
    m_TestDevice[eUSB4].m_iIsMounted           = 1;
    m_TestDevice[eUSB4].m_cMountPoint          = "/dev/media/12B4-G8BD_TEST";
    m_TestDevice[eUSB4].m_cDeviceName          = "TEST4-KINGSTON";
    m_TestDevice[eUSB4].m_cAccessoryName       = "";
    m_TestDevice[eUSB4].m_cDeviceVersion       = "PMAP";
    m_TestDevice[eUSB4].m_iDevNUM              = 1;
    m_TestDevice[eUSB4].m_cParentSerialId      ="Linux_2.6.34.10-01185-g9d4e37b_ehci_hcd_EHCI_Host_Controller_0000:00:13.1";
    m_TestDevice[eUSB4].m_bIsSdCardDevice      = false;
    m_TestDevice[eUSB4].m_bIsConnected         = true;
    m_TestDevice[eUSB4].m_iHubIndex            = 0x0;
    m_TestDevice[eUSB4].m_iUSBConnector        = 2;
    m_TestDevice[eUSB4].m_iPortNumber          = 2;
    m_TestDevice[eUSB4].m_lFreeSpace           = 325790976;
    m_TestDevice[eUSB4].m_lUsedSpace           = 163635200;
    m_TestDevice[eUSB4].m_lTotalSize           = 3500; /*MByte*/
    m_TestDevice[eUSB4].m_cDeviceUUID          = "12B4-G8BD";
    m_TestDevice[eUSB4].m_cManufacturer        = "TEST:Kingston";
    m_TestDevice[eUSB4].m_u64Size              = 4194304000ULL;
    m_TestDevice[eUSB4].m_eDeviceType          = CGlobalEnumerations::DTY_USB;
    m_TestDevice[eUSB4].m_cUSBPort             = "";
    m_TestDevice[eUSB4].m_eConnectStatus       = USB_DEV_UNDEFINED;
    //used for remove
    m_TestDevice[eUSB4].eRemoveAction=CGlobalEnumerations::SINGLE;
    m_TestDevice[eUSB4].cRemoveDeviceNode="/dev/bus/usb/001/009";
#endif//USE_FOURTH_USB_CONNECTOR


    ETG_TRACE_SYS(("fillTestDevices:m_TestDevice[eUSB1].m_cMountPoint: %s",m_TestDevice[eUSB1].m_cMountPoint.toStdString().c_str()));
    ETG_TRACE_SYS(("fillTestDevices:m_TestDevice[eUSB2].m_cMountPoint: %s",m_TestDevice[eUSB2].m_cMountPoint.toStdString().c_str()));
    ETG_TRACE_SYS(("fillTestDevices:m_TestDevice[eUSB3].m_cMountPoint: %s", m_TestDevice[eUSB3].m_cMountPoint.toStdString().c_str()));
#ifdef USE_FOURTH_USB_CONNECTOR
    ETG_TRACE_SYS(("fillTestDevices:m_TestDevice[eUSB4].m_cMountPoint: %s",m_TestDevice[eUSB4].m_cMountPoint.toStdString().c_str()));
#endif//USE_FOURTH_USB_CONNECTOR
    ETG_TRACE_USR4(("End  : fillTestDevices"));
}

/*-----------------------------------------------------------------------------*
 * tBool bChkSendMyselfPrmMount(CGlobalEnumerations::DEVICE_TYPE_Type m_eDeviceType) *
 *-----------------------------------------------------------------------------*/
///@todo check for cleanup
tBool StateTable::bChkSendMyselfPrmMount(CGlobalEnumerations::DEVICE_TYPE_Type m_eDeviceType) const
{

    tBool bRet = TRUE;
    (void)m_eDeviceType;
    return bRet;
}

/*-----------------------------------------------------------------------------*
 * tVoid enableExecutionTimer(tBool bEnable)                                   *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::enableExecutionTimer(tBool bEnable)
{
    ETG_TRACE_USR4(("Begin: enableExecutionTimer 0x%x",bEnable));
    m_bEnableExecutionTimer = bEnable;
    ETG_TRACE_USR4(("End  : enableExecutionTimer"));
}

/*-----------------------------------------------------------------------------*
 * void GetAllConnectedDevices(vector<structNotifyClients> &f_vConnectedDevices)*
 *-----------------------------------------------------------------------------*/
void StateTable::GetAllConnectedDevices(vector<structNotifyClients> &f_vConnectedDevices)
{
    ETG_TRACE_USR4(("Begin: GetAllConnectedDevices"));
    ETG_TRACE_COMP(("GetAllConnectedDevices:m_bIsActive = true => enabled client notification "));
    m_bIsActive = true;

    DeviceListManager::GetInstance()->getAllConnectedDevices(DEVLIST_STATETABLE,f_vConnectedDevices);

    ETG_TRACE_USR4(("End  : GetAllConnectedDevices"));
}


/*-----------------------------------------------------------------------------*
 * StateTable::storeOverTemperature(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vStoreOverTemperature(tBool bOverTemperature) //Roadmap 13035 Over temperature
{
    ETG_TRACE_USR2(("vStoreOverTemperature: Old:0x%x  New:0x%x",m_bOverTemperature,bOverTemperature));
    m_bOverTemperature = bOverTemperature;
}

/*-----------------------------------------------------------------------------*
 * StateTable::vSetOverTemperatureCDDrive(...)
 *-----------------------------------------------------------------------------*/
IN tVoid StateTable::vSetOverTemperatureCDDrive(IN tBool bOverTemperature) //Roadmap 13035 Over temperature
{
    ETG_TRACE_USR4(("Begin: IN vSetOverTemperatureCDDrive"));

    util_StructMsg       oMsg;
    util_StructQInfo    *pMsgQInfo=&m_msgQ;  //is never changed after realisation hence function should be reintrand

    if(m_bOverTemperature != bOverTemperature)
    {
        vStoreOverTemperature(bOverTemperature);
        ETG_TRACE_COMP(("->################### vSetOverTemperatureCDDrive:bOverTemperature,0x%x #####################",bOverTemperature));

        /*send to MsgQ received in StateTable::vThreadFunction */

        //prepare to send to Q
        oMsg.eMsgType   = enCDDriveOverTemp;
        oMsg.u16LenCont = sizeof(tBool/*bOverTemperature*/);
        if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
        {
            ETG_TRACE_FATAL(("ERROR: vSetOverTemperatureCDDrive: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
            oMsg.u16LenCont=0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            memcpy(&(oMsg.pu8Content[0]),                                   &bOverTemperature,  sizeof(tBool));
            //send it
            util_vSendMsg2Q(pMsgQInfo,&oMsg);
        }

    }
    else
    {
        ETG_TRACE_USR2(("vSetOverTemperatureCDDrive: bOverTemperature:0x%x same like before",bOverTemperature));
    }

    ETG_TRACE_USR4(("End  : IN vSetOverTemperatureCDDrive"));
}

/*-----------------------------------------------------------------------------*
 * StateTable::vDiagMountCDRom(...)
 *-----------------------------------------------------------------------------*/
IN tVoid StateTable::vDiagMountCDRom(IN tBool bMount, IN const std::string &strDeviceName /*e.g. /dev/sr0*/) //RoadMap 14002 MountCDROM (MixedModeDiag)
{
    ETG_TRACE_USR4(("Begin: vDiagMountCDRom"));
    util_StructMsg       oMsg;
    util_StructQInfo    *pMsgQInfo=&m_msgQ;  //is never changed after realisation henve function should be reintrand

    tBool bSend;
    tChar cDeviceName[LEN_cDeviceName];

    memset(cDeviceName,0,sizeof(cDeviceName));

    ETG_TRACE_COMP(("->################### vDiagMountCDRom:bMount:0x%x,strDeviceName:%s #####################",
                    bMount,
                    strDeviceName.c_str()));

    if((tU32)(strDeviceName.length()/*number of characters of string*/+1/*terminating '\0'*/) >=(tU32)sizeof(cDeviceName))
    {
        ETG_TRACE_FATAL(("ERROR: vDiagMountCDRom:[dest  ]sizeof(cDeviceName)     =%d  ",sizeof(cDeviceName) ));
        ETG_TRACE_FATAL(("ERROR: vDiagMountCDRom:[source]strDeviceName.length()-1=%d  ",strDeviceName.size()-1    ));
        bSend = FALSE;
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {
        strcpy(cDeviceName,strDeviceName.c_str());
        ETG_TRACE_USR4(("vDiagMountCDRom:cDeviceName:%s ",cDeviceName))
                bSend = TRUE;
    }


    /*send to MsgQ received in StateTable::vThreadFunction */
    if(bSend==TRUE)
    {
        //prepare to send to Q
        oMsg.eMsgType   = enDiagMountCDRom;
        oMsg.u16LenCont = sizeof(tBool/*bMount*/) + (tU16)LEN_cDeviceName/*strDeviceName*/;
        if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
        {
            ETG_TRACE_FATAL(("ERROR: setMount: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
            oMsg.u16LenCont=0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            memcpy(&(oMsg.pu8Content[0]),                        &bMount,        sizeof(tBool));
            memcpy(&(oMsg.pu8Content[sizeof(tBool/*bMount*/)]),&cDeviceName[0],LEN_cDeviceName);
            //send it
            util_vSendMsg2Q(pMsgQInfo,&oMsg);
        }
    }
    ETG_TRACE_USR4(("End  : vDiagMountCDRom"));
}




bool StateTable::bOnTimeoutSignalAccumulationTimer(timer_t timerID , void* instance ,const void *userData)
{
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
    (void)timerID;//To avoid warnings
#endif
    ETG_TRACE_USR4(("Begin: bOnTimeoutSignalAccumulationTimer"));

    char*         l_strNameOfTimer = (char*)userData;

    if(l_strNameOfTimer)
    {
        ETG_TRACE_USR4(("l_pStateTable::bOnTimeoutSignalAccumulationTimer:timerID: %p, l_strNameOfTimer: %s",timerID,l_strNameOfTimer));
    }

    vOnTimeoutSignalAccumulationTimer(instance);

    ETG_TRACE_USR4(("End  : bOnTimeoutSignalAccumulationTimer"));
    return TRUE;

}



/*-----------------------------------------------------------------------------*
 * void StateTable::vOnTimeoutSignalAccumulationTimer(...)
 *-----------------------------------------------------------------------------*/
void StateTable::vOnTimeoutSignalAccumulationTimer(tPVoid arg )
{
    ETG_TRACE_USR4(("Begin: vOnTimeoutSignalAccumulationTimer"));

    StateTable*          l_pStateTable = (StateTable*)arg;
    setTimerExpired(l_pStateTable);

    ETG_TRACE_USR4(("End : vOnTimeoutSignalAccumulationTimer"));
}




#ifdef USE_SENT_ALL_CHANGES

bool StateTable::bOnTimeoutUsbRecognitionAfterClvEvent(timer_t timerID , void* instance ,const void *userData)
{
    ETG_TRACE_USR4(("Begin: bOnTimeoutUsbRecognitionAfterClvEvent"));
    char*         l_strNameOfTimer = (char*)userData;

    if(l_strNameOfTimer)
    {
        ETG_TRACE_USR4(("l_pStateTable::bOnTimeoutUsbRecognitionAfterClvEvent:timerID: %d, l_strNameOfTimer: %s",timerID,l_strNameOfTimer));
    }

    vOnTimeoutUsbRecognitionAfterClvEvent(instance);


    ETG_TRACE_USR4(("End : bOnTimeoutUsbRecognitionAfterClvEvent"));
}

void StateTable::vOnTimeoutUsbRecognitionAfterClvEvent( tPVoid arg )
{
    util_StructMsg       oMsg;
    StateTable*          pStateTable = (StateTable*)arg;

    if( pStateTable )
    {
        util_StructQInfo*    pMsgQInfo = &( pStateTable->m_msgQ );
        ETG_TRACE_USR4(( "vOnTimeoutUsbRecognitionAfterClvEvent( ): Begin" ));

        //prepare to send to Q
        oMsg.eMsgType   = enDevRecAfterClv;
        oMsg.u16LenCont = 0;
        //send it
        pStateTable->util_vSendMsg2Q( pMsgQInfo,&oMsg);
        ETG_TRACE_USR4(( "vOnTimeoutUsbRecognitionAfterClvEvent( ): call util_vSendMsg2Q()" ));
    }
}

#endif //#if USE_SENT_ALL_CHANGES

/*-----------------------------------------------------------------------------*
 * tVoid setTimerExpired(...)
 * this is called
 *-----------------------------------------------------------------------------*/
tVoid StateTable::setTimerExpired(StateTable *f_pStateTable)
{
    ETG_TRACE_USR4(("Begin: setTimerExpired"));
    util_StructMsg       oMsg;
    MessageQueueDVM     f_MessageQueueDVM;

    StateTable *l_pStateTable = f_pStateTable;

    if( l_pStateTable )
    {
        util_StructQInfo*    pMsgQInfo = &( l_pStateTable->m_msgQ );
        ETG_TRACE_USR4(( "setTimerExpired: called by vOnTimeoutSignalAccumulationTimer( )" ));

        //prepare to send to Q
        oMsg.eMsgType   = enTimerExp;
        oMsg.u16LenCont = 0;
        //send it

        f_pStateTable->util_vSendMsg2Q( pMsgQInfo,&oMsg);


        ETG_TRACE_USR4(( "vOnTimeoutSignalAccumulationTimer( ): call util_vSendMsg2Q()" ));


    }

    ETG_TRACE_USR4(("End  : setTimerExpired"));
}




/******************************************************************************
FUNCTION:      bStartTimer( );
DESCRIPTION:   starts the timer
PARAMETER:     void
RETURNVALUE:   void
*******************************************************************************/
#ifdef USE_SENT_ALL_CHANGES
tBool StateTable::bStartTimer( )
{
    tBool    bRetVal = FALSE;

    ETG_TRACE_USR4(( "Begin: bStartTimer" ));

    if(TimerDVM::OK==m_TimerDvm1UsbRecognitionAfterClvEvent.iTimerStart( 7000, 0 ,(void*)this,&bOnTimeoutUsbRecognitionAfterClvEvent, TIMER1_STETBL ))
    {
        bRetVal = TRUE;
    }

    ETG_TRACE_USR4(( "End: bStartTimer: bRetVal:0x%x",bRetVal ));
    return bRetVal;
}
#endif //#if USE_SENT_ALL_CHANGES


/************************************************************************
FUNCTION:      bStopTimer( )
DESCRIPTION:   stops the timer to supervise the connection
PARAMETER:     void
RETURNVALUE:   tBool
************************************************************************/
#ifdef USE_SENT_ALL_CHANGES
tBool StateTable::bStopTimer( )
{
    ETG_TRACE_USR4(( "Begin: bStopTimer" ));
    tBool    bRetVal = FALSE;

    ETG_TRACE_USR1(( "bStopTimer( ): Stop timer" ));
    if(TimerDVM::OK==m_TimerDvm1UsbRecognitionAfterClvEvent.iTimerStop())
    {
        bRetVal = TRUE;
    }

    ETG_TRACE_USR4(( "End  : bStopTimer: 0x%x" ,bRetVal));
    return ( bRetVal );
}
#endif //#if USE_SENT_ALL_CHANGES


/* *****************************************************************************

   FUNCTION:      vDeleteNoThrow

   DESCRIPTION:   Deletes memory without throwing an exception.

   PARAMETERS:    rfpArg: reference of pointer to memory, to be deleted

   RETURN TYPE:   void

   HINT:          Why this function? If delete is called inside the destructor,
                  Lint complains with warning 1551 that delete might throw an
                  execption, which is not caught.

                  But try / catch must not be used, and delete does not throw
                  an exception, anyway. To prevent a Lint warning deactivation,
                  this function guarantees that no exception is thrown.
                  Furthermore, it sets the given pointer to 0, and Lint is
                  happy.

                  It is a template, because two different memory types have to
                  be deleted inside this class.

----------------------------------------------------------------------------- */
template< class T > void StateTable::vDeleteNoThrow( T*& rfpArg ) throw()
{
    delete rfpArg;
    rfpArg = 0;
}


/*-----------------------------------------------------------------------------*
 *tVoid StateTable::vMapHWSignals(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vMapAndStoreHWSignals(IN const voltageFailure_HWSignalsAll_t  (&f_rSignals)[ARRAYSIZEFORUSB],OUT tBool &bDiffersFromPreviousStored) const
{
    ETG_TRACE_USR4(("Begin: vMapAndStoreHWSignals"));
    trPortStates rArrPortStates[ARRAYSIZEFORUSB];

    //these entries are marked invalid
    rArrPortStates[eUSBUndef].u8USBPortNo = (tU8)eUSBUndef;

    //eUSB1...eUSBx are marked valid
    for(tUInt i = (tUInt)eUSB1; i< ARRAYSIZEFORUSB; i++)
    {
        rArrPortStates[i].u8USBPortNo            = (tU8)i;
        rArrPortStates[i].bOverCurrent           = FALSE;
        rArrPortStates[i].bUndervoltage          = FALSE;
        rArrPortStates[i].bHubConnected          = FALSE;
        rArrPortStates[i].bOpenCircuit           = FALSE;
        rArrPortStates[i].bElectricalFailure     = FALSE;
        rArrPortStates[i].bUSBPowerON            = TRUE;
        rArrPortStates[i].bUSBPortConfiguredUsed = FALSE;

        if( ( DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue((tenDevManagerConfigValue)((tUInt)eCONF_ENABLE_HW_USB1+(i-1))) ) ||
            ( DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue((tenDevManagerConfigValue)((tUInt)eConf_ENABLE_TELEMATICSBOX_USB1+(i-1))) )
          )
        {
            rArrPortStates[i].bUSBPortConfiguredUsed = TRUE;

        }

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST  //intermediate
        if( (DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_VOLTAGEMANAGER))
            &&
            (true == DeviceManagerInterface::GetInstance()->IsCriticalVoltage())
          )
        {
            rArrPortStates[i].bUndervoltage   = TRUE;
        }
#endif//VARIANT_S_FTR_ENABLE_UNITTEST

        //Udrop60 has prio over U50 which is not used in Gen3
        if(f_rSignals[i].U60_drop == SIG_TRUE)
        {
            //printf("f_rSignals[i].U60_drop == SIG_TRUE\n");
            rArrPortStates[i].bUndervoltage = TRUE;
        }

        if(f_rSignals[i].U50_USB_Reset == SIG_TRUE)
        {
            rArrPortStates[i].bUndervoltage = TRUE;
        }
        //in this way intermediate states where OC and PPON are the same are ignored/filtered
        if((f_rSignals[i].OC == SIG_TRUE) && (f_rSignals[i].PPON == SIG_FALSE))
        {
            rArrPortStates[i].bOverCurrent       = TRUE;
            rArrPortStates[i].bElectricalFailure = TRUE;
            rArrPortStates[i].bUSBPowerON        = FALSE;
        }
        else
        {
            if( ( DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue((tenDevManagerConfigValue)((tUInt)eCONF_ENABLE_observeDTC_HUBatUSB1+(i-1))) )
                    ||
                ( DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue((tenDevManagerConfigValue)((tUInt)eConf_ENABLE_TELEMATICSBOX_USB1+(i-1))) )
              )
            {
                rArrPortStates[i].bOpenCircuit = TRUE;//either customer  external Hub or Telematic box is expected.
            }

            if( DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue((tenDevManagerConfigValue)((tUInt)eCONF_ENABLE_observeDTC_HUBatUSB1+(i-1))))
            {
                rArrPortStates[i].bHubConnected = TRUE;//according to configuration the hub is expected to be connected

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST  //intermediate
                if(TRUE == ConfigurationManager::GetInstance()->bExpectedExternalHubIsConnected((tenDevManagerUSBHost)((tUInt)CGlobalEnumerations::HUB_1 + i-1)))
                {
                    rArrPortStates[i].bOpenCircuit = FALSE;//by finding the hub is connected at the port,bOpenCircuit is set to FALSE
                }
#endif//VARIANT_S_FTR_ENABLE_UNITTEST
            }


            if(( DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue((tenDevManagerConfigValue)((tUInt)eConf_ENABLE_TELEMATICSBOX_USB1+(i-1))) ))
            {
                if( TRUE ==  DeviceListManager::GetInstance()->isDeviceTypeConnected(DEVLIST_UDEVMGR,(tenDevManagerUSBHost)i,CGlobalEnumerations::DTY_BTA ))
                {
                    rArrPortStates[i].bOpenCircuit = FALSE;
                }
            }

            if((f_rSignals[i].OC == SIG_TRUE) || (f_rSignals[i].PPON == SIG_FALSE))
            {
                ETG_TRACE_COMP(("[IGNORED OK] vMapAndStoreHWSignals:'INFO: m_signal[%d].OC: %d  m_signal[%d].PPON: %d ",i,f_rSignals[i].OC,i,f_rSignals[i].PPON));
            }

        }
    }

    //store if different
    if(TRUE == PortListManager::GetInstance()->GetIsDifferentHardwareSignals(rArrPortStates))
    {
        PortListManager::GetInstance()->vSetHardwareSignals(rArrPortStates);
        bDiffersFromPreviousStored = TRUE;
    }
    else
    {
        bDiffersFromPreviousStored = FALSE;
    }
    PortListManager::GetInstance()->vShowHardwareSignals();
    ETG_TRACE_COMP(("vMapAndStoreHWSignals: bDiffersFromPreviousStored: 0x%x",bDiffersFromPreviousStored));

    ETG_TRACE_USR4(("End  : vMapAndStoreHWSignals"));
}

//tbd.: continue to refactor to get more overview
//===============================================================================
// function called by thread StartMonitorLooseblocking() in switch case
//===============================================================================

/*-----------------------------------------------------------------------------*
 *tVoid vSubCASEenDiagMountCDRom(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vSubCASEenDiagMountCDRom(IN const GENSTRING &strDeviceName)  //Roadmap 14002 MountCDROM (DiagMixeMode)
{
    ETG_TRACE_USR4(("Begin:vCASEenDiagMountCDRom strDeviceName: %s", strDeviceName.toStdString().c_str()));

    tInt             iRes          = -1;
    tBool            bMount        = TRUE; //this functions wants to mount
    tBool            bMountedOk    = FALSE;
    tBool            bConnected;

    if(strDeviceName.isEmpty())
    {
        ETG_TRACE_FATAL(("vCASEenDiagMountCDRom: empty strDeviceName - solution not yet implemented"));
    }

    bConnected = DeviceListManager::GetInstance()->IsAlreadyConnected(strDeviceName);
    if(FALSE == bConnected) //ok since it is a MixedModeDiagnosis CD it is not yet mounted
    {

        rmdir(CDROMDIAG_MOUNTPOINT); //in case it is still there it#ll be removed - if unmount has not been called properly by diagnosis
        //dr-x-w-r-t   or  drwxr-xr-x ?    777 would be drwxrwxrwx
        iRes = mkdir(CDROMDIAG_MOUNTPOINT, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
        if(iRes == 0)
        {
            ETG_TRACE_FATAL(("[OK] vCASEenDiagMountCDRom: dir created: %s",CDROMDIAG_MOUNTPOINT));
            //-------------------------------
            // mount the cdrom
            //-------------------------------
            //mount command deduced from olf mount script: /etc/udev/scripts/mount.sh:
            // mount -t is09660 -o sync,ro /dev/sr0 /media/cdrom
            //unmount:
            //umount -l /dev/sr0
            //iRes = mount(strDeviceName.toStdString().c_str(),CDROMDIAG_MOUNTPOINT,CDROMDIAG_FILESYSTEMTYPE_TESTWITHUSBSTICK,MS_RDONLY, "" /*no options*/); //to test with USB-stick
            iRes = mount(strDeviceName.toStdString().c_str(),CDROMDIAG_MOUNTPOINT,CDROMDIAG_FILESYSTEMTYPE,MS_RDONLY, "" /*no options*/);

            if(iRes == 0 || EBUSY == iRes)
            {
                bMountedOk = TRUE;
                ETG_TRACE_FATAL(("[OK] vCASEenDiagMountCDRom: mounted cdrom: MountPoint: %s",CDROMDIAG_MOUNTPOINT));
            }
            else
            {
                ETG_TRACE_FATAL(("[ERROR] vCASEenDiagMountCDRom: Error: %d, could not mount cdrom %s",iRes,CDROMDIAG_MOUNTPOINT));
            }
        }
        else
        {

            ETG_TRACE_FATAL(("[WARNING] vCASEenDiagMountCDRom: Error: %d, could not mkdir: %s",iRes,CDROMDIAG_MOUNTPOINT));
        }
    }
    else
    {
        bMountedOk = TRUE;
        ETG_TRACE_FATAL(("vCASEenDiagMountCDRom: Can't mount device already connected: %s",strDeviceName.toStdString().c_str()));
    }

    // store status
    if(bMountedOk == TRUE)
    {
        m_bMountedCDRomDiag = TRUE;
    }
    //===============
    //Send to Interface
    //===============
    ETG_TRACE_USR4(("vCASEenDiagMountCDRom: bMountedOk         : 0x%x",bMountedOk));
    ETG_TRACE_USR4(("vCASEenDiagMountCDRom: m_bMountedCDRomDiag: 0x%x",m_bMountedCDRomDiag));
    DVMGRIF_DIAGNOSIS->vDiagMountCDRomResult(bMountedOk,
                                             bMount,
                                             strDeviceName.toStdString().c_str() /*e.g. /dev/sr0*/,
                                             CDROMDIAG_MOUNTPOINT /*Mount point*/); //Roadmap 14002 MountCDROM (diagMixeMode)

    //=============================================
    //send to UdevManager to treat it like usal device notifications
    //=============================================
    UDEVMGRIF_INTERNALINPUT->vSendMountDevice(IN bMount,IN strDeviceName, IN CDROMDIAG_MOUNTPOINT);

    ETG_TRACE_USR4(("End  :vCASEenDiagMountCDRom"));
}

/*-----------------------------------------------------------------------------*
 *tVoid vSubCASEenDiagUnMountCDRom(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vSubCASEenDiagUnMountCDRom(IN const GENSTRING &strDeviceName) //Roadmap 14002 MountCDROM (DiagMixeMode)
{
    ETG_TRACE_USR4(("Begin:vCASEenDiagUnMountCDRom  strDeviceName: %s", strDeviceName.toStdString().c_str()));

    tInt        iRes          = -1;
    tBool       bMount        = FALSE; //this functions wants to umount
    tBool       bUmountedOk   = FALSE;
    tBool       bConnected;

    if(strDeviceName.isEmpty())
    {
        ETG_TRACE_FATAL(("vCASEenDiagUnMountCDRom: empty strDeviceName - solution not yet implemented"));
    }

    bConnected = DeviceListManager::GetInstance()->IsAlreadyConnected(strDeviceName);  //here it checks e.g. if /dev/sr0 is there if yes basis to umount CDROMDIAG_MOUNTPOINT is given

    if(bConnected && m_bMountedCDRomDiag) //ok MixedModeDiagnosis CD ihas been mounted before
    {
        //-------------------------------
        // umount the cdrom
        //-------------------------------
        //mount command deduced from olf mount script: /etc/udev/scripts/mount.sh:
        //unmount:
        //umount -l /dev/sr0 CDROMDIAG_MOUNTPOINT
        iRes = umount2(CDROMDIAG_MOUNTPOINT,MNT_DETACH);
        if(iRes == 0)
        {
            ETG_TRACE_FATAL(("[OK] vCASEenDiagMountCDRom: umounted cdrom: MountPoint: %s",CDROMDIAG_MOUNTPOINT));
            bUmountedOk   = TRUE;
            iRes = rmdir(CDROMDIAG_MOUNTPOINT);
            if(iRes != 0)
            {
                ETG_TRACE_FATAL(("[WARNING] vCASEenDiagMountCDRom: could not remove %s",CDROMDIAG_MOUNTPOINT));
                bUmountedOk   = FALSE;
            }

        }
        else
        {
            ETG_TRACE_FATAL(("[WARNING] vCASEenDiagMountCDRom: Error: %d, could not umount2 cdrom %s , try system commad!",iRes, CDROMDIAG_MOUNTPOINT));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("vCASEenDiagMountCDRom: bConnected:0x%x  m_bMountedCDRomDiag=0x%x",bConnected,m_bMountedCDRomDiag));
        ETG_TRACE_FATAL(("vCASEenDiagMountCDRom: Can't umount device already connected: %s",strDeviceName.toStdString().c_str()));
    }

    // store status
    if(bUmountedOk == TRUE) {m_bMountedCDRomDiag = FALSE;}
    //===============
    //Send to Interface
    //===============
    DVMGRIF_DIAGNOSIS->vDiagMountCDRomResult(bUmountedOk,
                                             bMount,
                                             strDeviceName.toStdString().c_str() /*e.g. /dev/sr0*/,
                                             CDROMDIAG_MOUNTPOINT /*Mount point*/); //Roadmap 14002 MountCDROM (diagMixeMode)


    //=============================================
    //send to UdevManager to treat it like usal device notifications
    //=============================================
    UDEVMGRIF_INTERNALINPUT->vSendMountDevice(IN bMount,IN strDeviceName, IN CDROMDIAG_MOUNTPOINT);

    ETG_TRACE_USR4(("End  :vCASEenDiagUnMountCDRom"));
}


/*-----------------------------------------------------------------------------*
 *tVoid vCASEenMountUdev(...)
 * 1. this case is used to add a new device and mark it 'apply connect'
 * 2. this case is used to mark a device 'apply remove'
 * 3. vTriggerTimer() is called which leads to call of vCASEenTriggerTimer there timer is started if not yet started
 * 4. after execution vCASEenTimerExp() is called
 * 5. as a result service is informed which sends portList, DevpropertyList and undervoltage state as property update
 *------------------------------------------l-----------------------------------*/
tVoid StateTable::vCASEenMountUdev(IN const util_StructMsg &oMsg, tU64 u64TestValue /*only for test*/)
{
    INFORM_IF_TESTMODE((char*)"vCASEenMountUdev",u64TestValue);
    ETG_TRACE_COMP(("************->case enMountUdev**********************"));

    DEVICE_CONNECTSTATUS_Type eApply;
    structNotifyClients       resultCDevice;
    tBool bUSBOk = FALSE;

    voltageFailure_HWSignalsAll_t oSignal;
    tenSignalValue                eMount = SIG_UNDEF;
    tenDevManagerUSBHost          eUsb;

    //initialize local oSignal - SUZUKI-22274 - valgrind analysis
    //before it could happen that in function getSignals oSignal.usb could be set occasionally to eUSB1 and eUSB2
    //and in automatic tests  even saw oSignal.PPON=600 could be seen
    //in other words: such values could have interfer normal evaluation for eUSB1&2 devices
    //and devices would not be detected
    oSignal.usb           = eUSBUndef;
    oSignal.OC            = SIG_FALSE;
    oSignal.PPON          = SIG_TRUE;
    oSignal.U60_drop      = SIG_FALSE;
    oSignal.mountedUSB    = SIG_FALSE;
    oSignal.mountedUSBref = SIG_FALSE;
    oSignal.U50_USB_Reset = SIG_FALSE;

    //copy gain for which eUsb message has been sen
    memcpy(&eUsb,  &(oMsg.pu8Content[0]),sizeof(tenDevManagerUSBHost/*eUsb*/)); //unmarshal

    //------------
    //error check
    //------------
    if(eUsb == eUSBUndef)
    {
        bUSBOk = FALSE;
#if defined(BUGFIX_DECOUPLE_SDCARD_PRM) || defined(BUGFIX_DECOUPLE_CDROM_PRM)
        bUSBOk = TRUE;
#endif
    }
    else if((eUsb<eUSB1) || ((tInt)eUsb>=ARRAYSIZEFORUSB))
    {
        bUSBOk = FALSE;
    }
    else
    {
        bUSBOk = TRUE;
    }

    //---------------------
    //apply mount
    //--------------------
    if(bUSBOk)
    {
        //@todo in course of two hub bug check to use vector here
        memcpy(&eMount,&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)]),sizeof(tenSignalValue/*eMount*/)); //unmarhsal

        ETG_TRACE_COMP(("vCASEenMountUdev:eMount=%d",ETG_ENUM(TENSIGNALVALUE,eMount)));
        if( (SIG_TRUE==eMount) || (SIG_FALSE==eMount))
        {
            memcpy(&resultCDevice,&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)+sizeof(tenSignalValue/*eMount*/)]),sizeof(structNotifyClients));

            //========================
            // mounted
            //========================
            if(SIG_TRUE ==eMount)  //@todo double info concerning eConnectStatus
            {
                ETG_TRACE_COMP(("vCASEenMountUdev: check ListAddDevice"));
#ifdef TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
                tU64 u64ConnectTimeStamp = ConfigurationManager::GetInstance()->GetEclapsedTime_ms(); if(u64TestValue != 0){ u64ConnectTimeStamp = u64TestValue;}
                resultCDevice.u64TimeStamp_ApplyForConnect = u64ConnectTimeStamp;
                DeviceListManager::GetInstance()->vStoreConnectTimeStamp(resultCDevice);

#endif//TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
                if( (DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_DELAY_NOTIFY_MTP_DEVICES)) &&
                                (CGlobalEnumerations::DTY_MTP == resultCDevice.eDeviceType)
                  )
                {
                    resultCDevice.eDeviceType = CGlobalEnumerations::DTY_NOT_SUPPORTED;
                    ETG_TRACE_COMP(("vCASEenMountUdev: map the device type to DTY_NOT_SUPPORTED"));
                    resultCDevice.u64TimeStamp_ConnectTimeStampForRetry = ConfigurationManager::GetInstance()->GetEclapsedTime_ms();
                    resultCDevice.eDeviceUnsupportedReason = NotSupportedByDVM;
                }


                DeviceListManager::GetInstance()->ListAddDevice(DEVLIST_STATETABLE,eUsb,resultCDevice); //immediately add to the list - not added if already in list
                eApply = USB_DEV_INTERNAL_APPLY_CONNECT;
#ifdef MSD_BIGGEST_PARTITON_FEATURE

                if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MSD_WAIT_FOR_PARTITIONS_ALL))
                {
                    //Updating the connect status to USB_DEV_INTERNAL_APPLY_CONNECT_SUPPRESSED for mass storage devices that are part of same block device
                   (resultCDevice.u8TotalValidPartitons>1)?(eApply=USB_DEV_INTERNAL_APPLY_CONNECT_SUPPRESSED):(eApply = USB_DEV_INTERNAL_APPLY_CONNECT);
                }
#endif
            }
            //========================
            // umounted
            //========================
            else
            {
#ifdef TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
                if (DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
                {
                    tU64 u64RemoveTimestamp = ConfigurationManager::GetInstance()->GetEclapsedTime_ms();if(u64TestValue != 0){u64RemoveTimestamp = u64TestValue;} //adjusted in testmode

                    resultCDevice.u64TimeStamp_ApplyForRemove = u64RemoveTimestamp;
                    DeviceListManager::GetInstance()->vStoreRemoveTimeStamp(resultCDevice);
                }
#endif//TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
                eApply = USB_DEV_INTERNAL_APPLY_REMOVED_BY_USR; //mark new device for notification to clients
            }
            /*mark device apply for connect or apply disconnect*/
            DeviceListManager::GetInstance()->ListApplyConnectDevice(DEVLIST_STATETABLE,eUsb,eApply,resultCDevice); //takes state malfuncton into account

            ETG_TRACE_USR4(("vCASEenMountUdev: cSerialID:         %s",resultCDevice.cSerialID));
            ETG_TRACE_USR4(("vCASEenMountUdev: cUSBPort:          %s",resultCDevice.cUSBPort));
            ETG_TRACE_USR4(("vCASEenMountUdev: cDeviceVersion:    %s",resultCDevice.cDeviceVersion));
            ETG_TRACE_USR4(("vCASEenMountUdev: cDeviceName:       %s",resultCDevice.cDeviceName));
            ETG_TRACE_USR4(("vCASEenMountUdev: cAccessoryName:    %s",resultCDevice.cAccessoryName));
            ETG_TRACE_USR4(("vCASEenMountUdev: cMountPoint:       %s",resultCDevice.cMountPoint));
            ETG_TRACE_USR4(("vCASEenMountUdev: cDevPath:          %s",resultCDevice.cDevPath));
            ETG_TRACE_USR4(("vCASEenMountUdev: cDevNode:          %s",resultCDevice.cDevNode));
            ETG_TRACE_USR4(("vCASEenMountUdev: eDeviceType:       %d",ETG_ENUM(DVM_DEVICE_TYPE,resultCDevice.eDeviceType)));
            ETG_TRACE_USR4(("vCASEenMountUdev: eConnectStatus:    %d",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,resultCDevice.eConnectStatus)));
            ETG_TRACE_USR4(("vCASEenMountUdev: cManufacturer:     %s",resultCDevice.cManufacturer));
            ETG_TRACE_USR4(("vCASEenMountUdev: iVendorID:         0x%04x",resultCDevice.iVendorID));
            ETG_TRACE_USR4(("vCASEenMountUdev: iProductID:        0x%04x",resultCDevice.iProductID));
            ETG_TRACE_USR4(("vCASEenMountUdev: u64Size [KB]:      %u",(resultCDevice.u64Size/1024) ));
#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
            ETG_TRACE_SYS(("vCASEenMountUdev: m_eFSType           %d",
                           ETG_CENUM(CGlobalEnumerations::FILESYSTEM_TYPE_Type,resultCDevice.eFSType) ));
#endif
#ifdef USE_TOTAL_USED_FREE_SIZE
            ETG_TRACE_SYS(("vCASEenMountUdev: m_u64TotalSize_KB   %d",resultCDevice.u64TotalSize_KB ));
            ETG_TRACE_SYS(("vCASEenMountUdev: m_u64UsedSize_KB    %d",resultCDevice.u64UsedSize_KB  ));
            ETG_TRACE_SYS(("vCASEenMountUdev: m_u64FreeSize_KB    %d",resultCDevice.u64FreeSize_KB ));
#endif
#ifdef USE_PARITIONNUMBER
            ETG_TRACE_SYS(("vCASEenMountUdev: m_iValidPartitionNo %d",resultCDevice.u8ValidPartitionNo ));
#endif
#ifdef MSD_BIGGEST_PARTITON_FEATURE
            ETG_TRACE_SYS(("vCASEenMountUdev: cAccessoryName2 %s",resultCDevice.cAccessoryName2 ));
#endif


            ETG_TRACE_USR1(("vCASEenMountUdev:enMountUdev: USB%d    eMount=%d   resultCDevice.cDeviceName=%s",
                            eUsb,ETG_ENUM(TENSIGNALVALUE,eMount), resultCDevice.cDeviceName));

            switch(eMount)
            {
            case SIG_TRUE:
            case SIG_FALSE:

                this->getSignals(eUsb,&oSignal);    //get current signal

                oSignal.mountedUSBref=eMount;  //change mount
                //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                //special case if it is not a  MASS STORAGE DEVICE because PRM notifies mass storage only
                //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                if(TRUE==bChkSendMyselfPrmMount(resultCDevice.eDeviceType))
                {
                    oSignal.mountedUSB =eMount;
                }
                this->setSignals(oSignal);
                if(SIG_TRUE ==eMount)
                {
                    this->vTriggerTimer(true/*This is for a device connection*/);
                }
                else
                {
                    this->vTriggerTimer();
                }
                break;
            case SIG_UNDEF:
                /*trigger timer that it at least does care for a device which has been
                                          a) added additionally to hub where already one or more device are connected
                                          b) removed from a hub but where other more device still connected
                                          in this manned case 'enTimerExp' of this function will be called to this job
                                       */

                this->vTriggerTimer();
                break;
            case SIG_ANY:
            case SIG_UNUSED:
                DVM_NORMAL_M_ASSERT_ALWAYS();
                break;
            default:
                DVM_NORMAL_M_ASSERT_ALWAYS();
                break;
            }
        }
        else
        {
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
    }
    else
    {
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    ETG_TRACE_COMP(("************case enMountUdev<-**********************"));
}


/*-----------------------------------------------------------------------------*
 *tVoid vCASEenMountUdev(...)
 * 1. this case is used to add a new device and mark it 'apply connect'
 * 2. this case is used to mark a device 'apply remove'
 * 3. vTriggerTimer() is called which leads to call of vCASEenTriggerTimer there timer is started if not yet started
 * 4. after execution vCASEenTimerExp() is called
 * 5. as a result service is informed which sends portList, DevpropertyList and undervoltage state as property update
 *-----------------------------------------------------------------------------*/

tVoid StateTable::vCASEenCDDANotified(IN const util_StructMsg &oMsg,tU64 u64TestValue /*only for test*/)
{
    ETG_TRACE_COMP(("************->Begin case enCDDANotified**********************"));
    DEVICE_CONNECTSTATUS_Type eApply;
    structNotifyClients       resultCDevice;
    tBool bUSBOk = FALSE;

    voltageFailure_HWSignalsAll_t oSignal;
    tenSignalValue                eMount = SIG_UNDEF;
    tenDevManagerUSBHost          eUsb;

    //initialize local oSignal - SUZUKI-22274 - valgrind analysis
    //before it could happen that in function getSignals oSignal.usb could be set occasionally to eUSB1 and eUSB2
    //and in automatic tests  even saw oSignal.PPON=600 could be seen
    //in other words: such values could have interfer normal evaluation for eUSB1&2 devices
    //and devices would not be detected
    oSignal.usb           = eUSBUndef;
    oSignal.OC            = SIG_FALSE;
    oSignal.PPON          = SIG_TRUE;
    oSignal.U60_drop      = SIG_FALSE;
    oSignal.mountedUSB    = SIG_FALSE;
    oSignal.mountedUSBref = SIG_FALSE;
    oSignal.U50_USB_Reset = SIG_FALSE;

    //copy gain for which eUsb message has been sen
    memcpy(&eUsb,  &(oMsg.pu8Content[0]),sizeof(tenDevManagerUSBHost/*eUsb*/)); //unmarshal

    //------------
    //error check
    //------------
    if(eUsb == eUSBUndef)
    {
        bUSBOk = TRUE;
    }


    //---------------------
    //apply mount
    //--------------------
    if(TRUE == bUSBOk)
    {
        //@todo in course of two hub bug check to use vector here
        memcpy(&eMount,&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)]),sizeof(tenSignalValue/*eMount*/)); //unmarhsal

        ETG_TRACE_COMP(("vCASEenCDDANotified:eMount=%d",ETG_ENUM(TENSIGNALVALUE,eMount)));
        if( (SIG_TRUE==eMount) || (SIG_FALSE==eMount))
        {
            memcpy(&resultCDevice,&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)+sizeof(tenSignalValue/*eMount*/)]),sizeof(structNotifyClients));

            if(SIG_TRUE ==eMount)  //@todo double info concerning eConnectStatus
            {
                ETG_TRACE_COMP(("vCASEenMountUdev: check ListAddDevice"));

#ifdef TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
                tU64 u64ConnectTimeStamp = ConfigurationManager::GetInstance()->GetEclapsedTime_ms(); if(u64TestValue != 0){ u64ConnectTimeStamp = u64TestValue;}
                resultCDevice.u64TimeStamp_ApplyForConnect = u64ConnectTimeStamp;
                DeviceListManager::GetInstance()->vStoreConnectTimeStamp(resultCDevice);
#endif//TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
                DeviceListManager::GetInstance()->ListAddDevice(DEVLIST_STATETABLE,eUsb,resultCDevice); //immediately add to the list


                eApply = USB_DEV_INTERNAL_APPLY_CONNECT; //mark new device for notification to clients
            }
            else
            {
#ifdef TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
                if (DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
                {
                    tU64 u64RemoveTimestamp = ConfigurationManager::GetInstance()->GetEclapsedTime_ms();if(u64TestValue != 0){u64RemoveTimestamp = u64TestValue;} //adjusted in testmode

                    resultCDevice.u64TimeStamp_ApplyForRemove = u64RemoveTimestamp;
                    DeviceListManager::GetInstance()->vStoreRemoveTimeStamp(resultCDevice);
                }
#endif//TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
                eApply = USB_DEV_INTERNAL_APPLY_REMOVED_BY_USR; //mark new device for notification to clients
            }
            /*mark device apply for connect or apply disconnect*/

            DeviceListManager::GetInstance()->ListApplyConnectDevice(DEVLIST_STATETABLE,eUsb,eApply,resultCDevice); //takes previously set state malfunction into account

            ETG_TRACE_USR4(("vCASEenCDDANotified: cSerialID:         %s",resultCDevice.cSerialID));
            ETG_TRACE_USR4(("vCASEenCDDANotified: cUSBPort:          %s",resultCDevice.cUSBPort));
            ETG_TRACE_USR4(("vCASEenCDDANotified: cDeviceVersion:    %s",resultCDevice.cDeviceVersion));
            ETG_TRACE_USR4(("vCASEenCDDANotified: cDeviceName:       %s",resultCDevice.cDeviceName));
            ETG_TRACE_USR4(("vCASEenCDDANotified: cAccessoryName:    %s",resultCDevice.cAccessoryName));
            ETG_TRACE_USR4(("vCASEenCDDANotified: cMountPoint:       %s",resultCDevice.cMountPoint));
            ETG_TRACE_USR4(("vCASEenCDDANotified: eDeviceType:       %d",ETG_ENUM(DVM_DEVICE_TYPE,resultCDevice.eDeviceType)));
            ETG_TRACE_USR4(("vCASEenCDDANotified: eConnectStatus:    %d",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,resultCDevice.eConnectStatus)));
            ETG_TRACE_USR4(("vCASEenCDDANotified: cManufacturer:     %s",resultCDevice.cManufacturer));
            ETG_TRACE_USR4(("vCASEenCDDANotified: iVendorID:         0x%04x",resultCDevice.iVendorID));
            ETG_TRACE_USR4(("vCASEenCDDANotified: iProductID:        0x%04x",resultCDevice.iProductID));
            ETG_TRACE_USR4(("vCASEenCDDANotified: u64Size [KB]:      %u",(resultCDevice.u64Size/1024) ));
#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
            ETG_TRACE_SYS(("vCASEenCDDANotified: m_eFSType           %d",
                           ETG_CENUM(CGlobalEnumerations::FILESYSTEM_TYPE_Type,resultCDevice.eFSType) ));
#endif
#ifdef USE_TOTAL_USED_FREE_SIZE
            ETG_TRACE_SYS(("vCASEenCDDANotified: m_u64TotalSize_KB   %d",resultCDevice.u64TotalSize_KB ));
            ETG_TRACE_SYS(("vCASEenCDDANotified: m_u64UsedSize_KB    %d",resultCDevice.u64UsedSize_KB  ));
            ETG_TRACE_SYS(("vCASEenCDDANotified: m_u64FreeSize_KB    %d",resultCDevice.u64FreeSize_KB ));
#endif
#ifdef USE_PARITIONNUMBER
            ETG_TRACE_SYS(("vCASEenCDDANotified: m_iValidPartitionNo %d",resultCDevice.u8ValidPartitionNo ));
#endif


            ETG_TRACE_USR1(("vCASEenCDDANotified:enMountUdev: USB%d    eMount=%d   resultCDevice.cDeviceName=%s",
                            eUsb,ETG_ENUM(TENSIGNALVALUE,eMount), resultCDevice.cDeviceName));

            switch(eMount)
            {
            case SIG_TRUE:
            case SIG_FALSE:

                this->getSignals(eUsb,&oSignal);    //get current signal

                oSignal.mountedUSBref=eMount;  //change mount
                //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                //special case if it is not a  MASS STORAGE DEVICE because PRM notifies mass storage only
                //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                if(TRUE==bChkSendMyselfPrmMount(resultCDevice.eDeviceType))
                {
                    oSignal.mountedUSB =eMount;
                }
                this->setSignals(oSignal);
                this->vTriggerTimer();
                break;
            case SIG_UNDEF:
                /*trigger timer that it at least does care for a device which has been
                                              a) added additionally to hub where already one or more device are connected
                                              b) removed from a hub but where other more device still connected
                                              in this manned case 'enTimerExp' of this function will be called to this job
                                           */

                this->vTriggerTimer();
                break;
            case SIG_ANY:
            case SIG_UNUSED:
                DVM_NORMAL_M_ASSERT_ALWAYS();
                break;
            default:
                DVM_NORMAL_M_ASSERT_ALWAYS();
                break;
            }
        }
        else
        {
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
    }
    else
    {
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }

    ETG_TRACE_COMP(("************End case enCDDANotified<-**********************"));

}


/*-----------------------------------------------------------------------------*
 *tVoid vCASEenTimerExp(...)
*
* reasons to trigger this:
*        1. Voltage message send                       - immediately since setTimerExpired() is called leads directly to vCASEenTimerExp()
*        2. HW signals send (for overcurrent)      - not immediately vTriggerTimer() is called leads to vCASEenTriggerTimer() afterwards vCASEenTimerExp()
*        3. Mount send                                           not immediately vTriggerTimer() is called leads to vCASEenTriggerTimer()  afterwards vCASEenTimerExp()
*
*    then we hae two cases to take into account
*    a) Devices are connected to USBConnectors of target directly e.g. USB1, USB2
*    b) Devices are connected to a HUB which is connected to USBConnectors of target directly e.g. USB1, USB2
*
*  Current solution:
*     1. getResultfunction return  for certain USBConnector such an entry
             USB_DEV_UNDEFINED
             USB_DEV_CONNECTED
             USB_DEV_REMOVED_BY_USR
             USB_DEV_UNAVAIL_BAT_LOWVOLT
             USB_DEV_UNAVAIL_HW_MALFUNC  (e.g. due to overcurrent)

             //this values are not returned but used in other functions
             USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT
             USB_DEV_INTERNAL_APPLY_CONNECT  -
             USB_DEV_INTERNAL_APPLY_REMOVED_BY_USR
             USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE
*     2.

*
* Note:  we also have to think about makeing the code more generic for CDROM and SDCARD here
*             * CDROM may behave concerning undervoltage in another way
*
 *-----------------------------------------------------------------------------*/

tVoid StateTable::vCASEenTimerExp(tU64 u64TestValue)
{
    INFORM_IF_TESTMODE((char*)"StateTable::vCASEenTimerExp",u64TestValue);
    ETG_TRACE_COMP(("************->case enTimerExp**********************"));

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST  //intermediate
    HWMALFUNCTIONHISTORY.AddToHistory(GENSTRING("vCASEenTimerExp()"),NULL);
#endif
    //Commented for Lint fix
    //tenDevManagerUSBHost usb;
    //voltageFailure_Result_t result[ARRAYSIZEFORUSB];
    tBool bHWSignalsDiffersFromPreviousStored = FALSE;
    DEVICE_CONNECTSTATUS_E l_eConnectStatus;
    tInt iSend = 0;


    //tbd.: We need to check of portListmanager is used by another entity than this StateTable
    //-------------------------------------------
    // update current HW signals in PortListManager - not send yet
    //-------------------------------------------
    vMapAndStoreHWSignals(IN m_signal, OUT bHWSignalsDiffersFromPreviousStored); //Diagnosis 14003 (notify OC,PPON, Undervoltage) - //from this service derives sending also undervoltage


    //----------------------------------------------------------------------------------------
    //To update the Optical Drive Over Temperature
    //for the CDROM or CDDA Devices if m_bOverTemperature is TRUE then update the connect state as follows
    //USB_DEV_INTERNAL_APPLY_CONNECT  => USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE
    //----------------------------------------------------------------------------------------
    if(TRUE == m_bOverTemperature)
    {
        DeviceListManager::GetInstance()->SetStateAtConnectorsDueToOverTemperature();
    }

    //-------------------------------------------------------------------
    //transition for devices already in list will be done now:
    //USB_DEV_INTERNAL_APPLY_CONNECT               => USB_DEV_CONNECTED
    //USB_DEV_INTERNAL_APPLY_REMOVED_BY_USR => USB_DEV_REMOVED_BY_USR
    //-------------------------------------------------------------------
    DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);

#ifdef USE_HIGHRISK4USB_HWMALFUNCTION
    if(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
    {
        DeviceListManager::GetInstance()->CheckSetStateAtConnectorsDueToApplyAllDevices();
    }
#else
    DeviceListManager::GetInstance()->CheckSetStateAtConnectorsDueToApplyAllDevices();
#endif

    //==============================================================================================
    //==============================================================================================
    // OLD mechanism using HW signals
    //==============================================================================================
    //==============================================================================================
    if(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
    {
        ETG_TRACE_USR4(("vCASEenTimerExp: HANDLE_TEMPORARY_UNAVAILABLE disabled"));
        //-------------------------------------------------------------------
        //due to HW signals PPON, OC each USB connector has a certain usable/unusable state
        //this plus if a device is connected to such ocnnector (eUSB1, eUSB2,eUSB3)
        //a resulting connect state will be calculated:
        // see StateTable::m_voltageFailureStateTable_USB
        //-------------------------------------------------------------------
        voltageFailure_HWSignalsAll_t    oCurrSignal;
        voltageFailure_Result_t          result[ARRAYSIZEFORUSB];

        //
        for(tInt i=(tInt)eUSB1; i<ARRAYSIZEFORUSB; i++)
        {
            oCurrSignal.usb              = m_signal[tenDevManagerUSBHost(i)].usb;
            oCurrSignal.U60_drop         = m_signal[tenDevManagerUSBHost(i)].U60_drop;
            oCurrSignal.U50_USB_Reset    = m_signal[tenDevManagerUSBHost(i)].U50_USB_Reset;
            oCurrSignal.OC               = m_signal[tenDevManagerUSBHost(i)].OC;
            oCurrSignal.PPON             = m_signal[tenDevManagerUSBHost(i)].PPON;

            //one or more devices connected :

            if(true == DeviceListManager::GetInstance()->IsDeviceAtConnector(tenDevManagerUSBHost(i),DEVLIST_STATETABLE))
            {
                //printf("At connectorUsb%d \n",i);
                ETG_TRACE_USR4(("vCASEenTimerExp: Device(s) found at eUSB%d",i));
                oCurrSignal.mountedUSB = SIG_TRUE;
            }
            //no device connected:
            else
            {
                ETG_TRACE_USR4(("vCASEenTimerExp: No Device(s) found at eUSB%d",i));
                oCurrSignal.mountedUSB = SIG_FALSE;
            }
            oCurrSignal.mountedUSBref = oCurrSignal.mountedUSB; //@todo mountedUSB is bound to prm mount clean this from code later

            //according to m_voltageFailureStateTable_USB, current HWSignals, current voltage state and current mount state a resulting state is calculated
            CalcStateTableResult(IN (tenDevManagerUSBHost)i,IN oCurrSignal, OUT &result[i]);
        }



        DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);

        //----------------------------------------------------------------------
        //according to result of CalcStateTableResult devices in DeviceListManager are updated
        //----------------------------------------------------------------------
        vMapDevicePropertiesStore(IN result);

        //-----------------------------------------------
        //check in comparison to already send messages if
        // - HW-Signals (PPON, OC or voltage) changed
        // - anything in device list is changed
        //-----------------------------------------------

        if(bHWSignalsDiffersFromPreviousStored)
        {
            ETG_TRACE_USR4(("vCASEenTimerExp: PortList: HWSignals have changed"));
            iSend++;
        }


        DeviceListManager::GetInstance()->ShowList(IN DEVLIST_DEVICEMGRSERVICE);
        DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);
        if(FALSE == DeviceListManager::GetInstance()->bGetIsListEqual(IN DEVLIST_DEVICEMGRSERVICE, IN DEVLIST_STATETABLE))
        {
            ETG_TRACE_USR4(("vCASEenTimerExp: DeviceList of StateTable and Service are different"));
            iSend++;
        }

    }

    //==============================================================================================
    //==============================================================================================
    // new  mechanism using Malfunction
    //==============================================================================================
    //==============================================================================================
    else
    {

        DeviceListManager::GetInstance()->ShowList(IN DEVLIST_DEVICEMGRSERVICE);
        DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);


        //+++++++++++++++++++++++++++++++++++++++++
        //checking malfunction for devices bound to USB connectors
        //+++++++++++++++++++++++++++++++++++++++++
#ifdef USE_HIGHRISK4USB_HWMALFUNCTION
       DeviceListManager::GetInstance()->CheckSetStateTemporaryNotAvailableAllDevices(u64TestValue);
       DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);

       DeviceListManager::GetInstance()->CheckSetStateConnectAfterTemporaryNotAvailableAllDevices();
       DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);

       DeviceListManager::GetInstance()->CheckSetStatePermanentlyNotAvailableAllDevices();
       DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);

       DeviceListManager::GetInstance()->CheckSetStateAtConnectorsDueToApplyAllDevices();
       DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);

       //-------------------------------------
       //
       //-------------------------------------
#else //USE_HIGHRISK4USB_HWMALFUNCTION
        m_bHasMalfunctionUsbConnector = FALSE;
        for(tInt eusb=(tInt)eUSB1; eusb<ARRAYSIZEFORUSB; eusb++)
        {
            //checking whether the removal is caused by malfunction.
            //This function intern will call DeviceListManager function check whether the time stamp of malfunction is set or not
            if(TRUE == bIsRemovedCausedByMalfunction((tenDevManagerUSBHost) eusb)) //tbd.: there is no check for malfunction
            {
                //This will start the Malfunction permanent timer
                m_bHasMalfunctionUsbConnector             = TRUE;
                m_oNotifyMalfunction[eusb].eUSB           = (tenDevManagerUSBHost)eusb;
                m_oNotifyMalfunction[eusb].bIsMalfunction = TRUE;
    #ifdef TEMPORARY_UNAVAILABLE_INTERMEDIATE_SOLUTION
                DeviceListManager::GetInstance()->ResetMalfunctionTimeStamp((tenDevManagerUSBHost)eusb);//This will reset the malfunction timestamp for all the devices connected to port
    #endif
            }
            else
            {
                m_oNotifyMalfunction[eusb].eUSB           = (tenDevManagerUSBHost)eusb;
                m_oNotifyMalfunction[eusb].bIsMalfunction = FALSE;
            }
            //Decide the connect status based on the malfunction status at the usb connectors
            vDecideConnectStatusUsbConnector(IN (tenDevManagerUSBHost)eusb,OUT l_eConnectStatus);
            if(USB_DEV_UNDEFINED != l_eConnectStatus)
            {
                //Update the connection Status
                DeviceListManager::GetInstance()->SetStateAtConnectorsDueToMalfunction((tenDevManagerUSBHost)eusb,l_eConnectStatus);
            }

        }

#endif //USE_HIGHRISK4USB_HWMALFUNCTION


        //++++++++++++++++++++++++++++++
        //checking the malfunction at optical disc
        //++++++++++++++++++++++++++++++
        CGlobalEnumerations::DEVICE_TYPE_Type l_eDeviceType;
        vSetOpticalDiscDeviceType(l_eDeviceType);
        if(TRUE == bIsMalfunctionOccuredAtDevices(l_eDeviceType))
        {
            ETG_TRACE_USR4(("vCASEenTimerExp: Malfunction occurred at optical disc"));
            //This will start the monitoring for permanent malfunction when the thread expires at the timeout of message queue wait
            m_bHasMalfunctionOpticalDisc = TRUE;
        }
        else
        {
            m_bHasMalfunctionOpticalDisc = FALSE;
        }

        //Decide the connect status based on the malfunction status at optical disc connected
        vDecideConnectStatusDevices(l_eDeviceType,l_eConnectStatus);
        if(USB_DEV_UNDEFINED != l_eConnectStatus)
        {
            //Update the connection Status
            DeviceListManager::GetInstance()->SetStateAtConnectorsDueToMalfunction(l_eDeviceType,l_eConnectStatus);
        }

        //++++++++++++++++++++++++++++++
        //checking the malfunction at SD NTERNAL
        //++++++++++++++++++++++++++++++
#ifndef USE_HIGHRISK4USB_HWMALFUNCTION

        vSetSDInternalDeviceType(l_eDeviceType);
        if(TRUE == bIsMalfunctionOccuredAtDevices(l_eDeviceType))
        {
            ETG_TRACE_USR4(("vCASEenTimerExp: Malfunction occurred at SD Internal"));
            //This will start the monitoring for permanent malfunction when the thread expires at the timeout of message queue wait
            m_bHasMalfunctionSDInternal = TRUE;
        }
        else
        {
            m_bHasMalfunctionSDInternal = FALSE;
        }

        //Decide the connect status based on the malfunction status at SD Internal
        vDecideConnectStatusDevices(l_eDeviceType,l_eConnectStatus);
        if(USB_DEV_UNDEFINED != l_eConnectStatus)
        {
            //Update the connection Status
            DeviceListManager::GetInstance()->SetStateAtConnectorsDueToMalfunction(l_eDeviceType,l_eConnectStatus);
        }
        DeviceListManager::GetInstance()->ShowList(IN DEVLIST_DEVICEMGRSERVICE);
        DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);
#endif//USE_HIGHRISK4USB_HWMALFUNCTION






        if(FALSE == DeviceListManager::GetInstance()->bGetIsListEqual(IN DEVLIST_DEVICEMGRSERVICE, IN DEVLIST_STATETABLE))
        {
            ETG_TRACE_USR4(("vCASEenTimerExp: DeviceList of StateTable and Service are different"));
            iSend++;
        }
    }

    //====================================
    //SEND TO SERVICE (send it to clients) if changed
    //===================================
    ETG_TRACE_COMP(("vCASEenTimerExp: iSend: %d",iSend));
#ifdef MSD_BIGGEST_PARTITON_FEATURE
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MSD_WAIT_FOR_PARTITIONS_ALL))
        {
            ETG_TRACE_COMP(("vCASEenTimerExp: PlatformHasAllPartitionsofDeviceNotified"));
            if(FALSE == DeviceListManager::GetInstance()->PlatformHasAllPartitionsofDeviceNotified())
            {
                ETG_TRACE_COMP(("vCASEenTimerExp: Platform did not notify all the partitons"));

            }
        }
#endif//MSD_BIGGEST_PARTITON_FEATURE

    if(iSend>0)
    {

        DeviceListManager::GetInstance()->ShowList(IN DEVLIST_DEVICEMGRSERVICE);
        DeviceListManager::GetInstance()->UpdateList(OUT DEVLIST_DEVICEMGRSERVICE, IN DEVLIST_STATETABLE );
        DeviceListManager::GetInstance()->ShowList(IN DEVLIST_DEVICEMGRSERVICE);

        //---------------------------------------------------
        //this call is a blocking call i.e. returns if information has send
        //---------------------------------------------------
        DVMGRIF_GENERAL->vInformClients(); /*trigger to send undervoltage, HWSignalList, DeviceList to clients*/ //after this has called Service has copied content of PortListManager and DeviceListManager already to FI object. I.e. this thread is allowded to changes it afterwards

        if(!m_bTestHookNoErase)
        {
            DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);
            DeviceListManager::GetInstance()->ShowList(IN DEVLIST_DEVICEMGRSERVICE);

            DeviceListManager::GetInstance()->vEraseFromListRemovedDevices(IN DEVLIST_STATETABLE);
            DeviceListManager::GetInstance()->UpdateList(OUT DEVLIST_DEVICEMGRSERVICE, IN DEVLIST_STATETABLE ); //samelike DEVLIST_STATETABLE now


            DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);
            DeviceListManager::GetInstance()->ShowList(IN DEVLIST_DEVICEMGRSERVICE);
        }
        else
        {
            ETG_TRACE_FATAL(("[INFO]: m_bTestHookNoErase is active"));
        }

    }

    //Reset the corresponding timer flag
    if(m_bCommonTimerStarted)
    {
        m_bCommonTimerStarted = FALSE;
    }
    else
    {
        m_bConnectTimerStarted = FALSE;
    }
    ETG_TRACE_COMP(("************case enTimerExp<-**********************"));

}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenTimerExpOld(...)
*-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenTimerExpOld(tVoid)
{
    ETG_TRACE_COMP(("************->case vCASEenTimerExpOld**********************"));

    ETG_TRACE_COMP(("++++->vCASEenTimerExpOld: DeviceList before evaluation+++++++++"));
    DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);
    DeviceListManager::GetInstance()->ShowList(IN DEVLIST_DEVICEMGRSERVICE);
    ETG_TRACE_COMP(("++++vCASEenTimerExpOld<-: DeviceList before evaluation-+++++++++"));




    voltageFailure_Result_t result[ARRAYSIZEFORUSB];
    tBool bHWSignalsDiffersFromPreviousStored = FALSE;

    /*care for result if it is different then before*/
    for(tInt i=(tInt)eUSB1; i<ARRAYSIZEFORUSB;i++)
    {
        tenDevManagerUSBHost usb = (tenDevManagerUSBHost)i;
        ETG_TRACE_USR4(("vCASEenTimerExpOld:USB%1d",i));

        //----------------------
        //result for Usb1,2... derived from current input signals
        //----------------------
        this->getResult(usb,&result[usb]);

        //ListGetDevicesAtConnector(usb,&f_vConnectedDevices[usb]);

        ETG_TRACE_SYS(("vCASEenTimerExpOld: NEW CALCULATED:result[USB%1d].resultUSB=%d PREVIOUS:m_result[USB%1d].resultUSB=%d ",
                       usb,ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,  result[usb].resultUSB),
                       usb,ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,m_result[usb].resultUSB)
                       ));

        //------------------------
        //exceptional case: new case conected but old case unavail due to lowbat or overcurrent
        // //@todo has been made for GEN2 need to check if this is still neccessary
        //------------------------
#ifdef ADJUST_OUTPUTAFTERDRITVOLT  //
        if((USB_DEV_CONNECTED == result[usb].resultUSB)
                &&(  (USB_DEV_UNAVAIL_BAT_LOWVOLT == m_result[usb].resultUSB)
                     ||(USB_DEV_UNAVAIL_HW_MALFUNC  == m_result[usb].resultUSB)
             #ifdef BUGFIX_CARE_PERMANENT_OVERCURRENT
                     ||(USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT == m_result[usb].resultUSB)
             #endif
                     ))
        {
            result[usb].resultUSB = USB_DEV_UNDEFINED;
        }
#endif


        //-------------------------------------------
        // update current HW signals in PortListManager - not send yet
        //-------------------------------------------
        vMapAndStoreHWSignals(IN m_signal, OUT bHWSignalsDiffersFromPreviousStored); //Diagnosis 14003 (notify OC,PPON, Undervoltage) - //from this service derives sending also undervoltage

        ETG_TRACE_COMP(("vCASEenTimerExpOld: send2Clients"));
        send2Clients(usb,result[i]);


        //-------------------------------------------------
        //store new state of connector in corresponding class member
        //-------------------------------------------------
        m_result[usb].resultUSB = result[usb].resultUSB; //store current result @todo check if this variable is still necessary


        //------------------------------------------
        //delete all devices which have state 'removed' and update
        //------------------------------------------
        ETG_TRACE_COMP(("vCASEenTimerExpOld: ListChkDeleteDevice"));
        DeviceListManager::GetInstance()->ListChkDeleteDevice(DEVLIST_STATETABLE,usb); //this is suspicious code  if below defines work


    }

    //-------------------------------
    //care for devices which are eUSBUndef like SDCard Internal and CDROMInternal which are not bount to
    //-------------------------------

#if defined(BUGFIX_DECOUPLE_SDCARD_PRM) || defined(BUGFIX_DECOUPLE_CDROM_PRM)
    ETG_TRACE_COMP(("vCASEenTimerExpOld: Internal CDROM,SDCARD or CDDA"));
            tBool bExists;
    tBool bSend;
    tUInt iSize = DeviceListManager::GetInstance()->getSizeOfList(DEVLIST_STATETABLE);
    structNotifyClients l_oCurDevice;

    for (unsigned int l_uiCount=0; l_uiCount < iSize ;l_uiCount++)
    {
        bExists = DeviceListManager::GetInstance()->getElement(l_uiCount,OUT l_oCurDevice);
        if(TRUE == bExists)
        {
            bSend = TRUE;

            //these are not bound to prm-signals - in future these should be bound
            if((CGlobalEnumerations::DTY_CDROM == l_oCurDevice.eDeviceType) || (CGlobalEnumerations::DTY_SD_INTERNAL == l_oCurDevice.eDeviceType)
                    || (CGlobalEnumerations::DTY_CDDA == l_oCurDevice.eDeviceType)
                    )
            {
                ETG_TRACE_COMP(("vCASEenTimerExpOld: l_uiCount=%d bExists=%d l_oCurDevice.eUSB=%d l_oCurDevice.eConnectStatus=%d l_oCurDevice.cMountPoint=%s",l_uiCount,bExists,l_oCurDevice.eUSB,ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,l_oCurDevice.eConnectStatus),l_oCurDevice.cMountPoint));

                if(l_oCurDevice.eConnectStatus == USB_DEV_INTERNAL_APPLY_CONNECT)
                {
                    l_oCurDevice.eConnectStatus = USB_DEV_CONNECTED;
                }
                else if(l_oCurDevice.eConnectStatus == USB_DEV_INTERNAL_APPLY_REMOVED_BY_USR)
                {
                    l_oCurDevice.eConnectStatus = USB_DEV_REMOVED_BY_USR;
                }
                else
                {
                    bSend = FALSE;
                }

                if(bSend)
                {
                    DVMGRIF_GENERAL->vInformClients(l_oCurDevice,/*bTest=*/FALSE);
                    DeviceListManager::GetInstance()->ListChkDeleteDevice(DEVLIST_STATETABLE,l_oCurDevice.eUSB); //clear removed from list
                }
            }
        }
        else
        {
            //Do nothing
        }
    }
#endif //BUGFIX_DECOUPLE_SDCARD_PRM,BUGFIX_DECOUPLE_CDROM_PRM


    //Reset the corresponding timer flag
    if(m_bCommonTimerStarted)
    {
        m_bCommonTimerStarted = FALSE;
    }
    else
    {
        m_bConnectTimerStarted = FALSE;
    }

    ETG_TRACE_COMP(("++++->vCASEenTimerExpOld: DeviceList after evaluation+++++++++"));
    DeviceListManager::GetInstance()->ShowList(IN DEVLIST_STATETABLE);
    DeviceListManager::GetInstance()->ShowList(IN DEVLIST_DEVICEMGRSERVICE);
    ETG_TRACE_COMP(("++++vCASEenTimerExpOld<-: DeviceList after evaluation-+++++++++"));


    ETG_TRACE_COMP(("************case enTimerExp<-**********************"));
}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenHWSignals(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenHWSignals(IN const util_StructMsg &oMsg)
{
    ETG_TRACE_COMP(("************->case enHWSignals**********************"));
#ifdef EOL_DELAY_AFTEROVERCURRENT
    tInt                          delay_ms;
    tBool                         bDelay;
#endif
    UsbPortState                  oPortState;
    OSAL_tMSecond                 timeout_ms = OSAL_C_TIMEOUT_FOREVER;
    tenDevManagerUSBHost          eUsb;
    voltageFailure_HWSignalsAll_t oSignal;

    memcpy(&oPortState,&(oMsg.pu8Content[0]),sizeof(UsbPortState)); //unmarshal
    eUsb = (tenDevManagerUSBHost)oPortState.u8PortNr;
    ETG_TRACE_USR2(("vCASEenHWSignals USB%1d: oPortState.u8PortNr = %2d",eUsb,oPortState.u8PortNr));
    ETG_TRACE_USR2(("vCASEenHWSignals USB%1d: oPortState.u8OC     = %d",eUsb,ETG_ENUM(TENSIGNALVALUE,oPortState.u8OC)));
    ETG_TRACE_USR2(("vCASEenHWSignals USB%1d: oPortState.u8UV     = %d",eUsb,ETG_ENUM(TENSIGNALVALUE,oPortState.u8UV)));
    ETG_TRACE_USR2(("vCASEenHWSignals USB%1d: oPortState.u8PPON   = %d",eUsb,ETG_ENUM(TENSIGNALVALUE,oPortState.u8PPON)));


    if((eUsb<eUSB1) || ((tInt)eUsb>=ARRAYSIZEFORUSB))
    {
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {


        this->getSignals(eUsb,&oSignal); //copy current signals to oSignal

        if(oPortState.u8UV != ((tU8)SIG_ANY))
            oSignal.U50_USB_Reset =(tenSignalValue)oPortState.u8UV;

        if(oPortState.u8OC != ((tU8)SIG_ANY))
            oSignal.OC =(tenSignalValue)oPortState.u8OC;

        if(oPortState.u8PPON != ((tU8)SIG_ANY))
            oSignal.PPON =(tenSignalValue)oPortState.u8PPON;

        this->setSignals(oSignal); //OTPUT of this function


#ifdef MONITOR_PERMANENT_HW_FAILURE
        if(  ((tU8)SIG_TRUE == oPortState.u8OC )
             &&(           0 == m_u32CountPermanentOvercurrent[eUsb]))
        {
            ETG_TRACE_SYS(("!!!!!!!!!!!!/MONITOR_PERMANENT_HW_FAILURE - ENABLE!!!!!!!!!!!!!!!!!"));
            ETG_TRACE_SYS(("vCASEenHWSignals: USB%1d: monitor enabled - timout:%d sec",
                           eUsb,MONITOR_PERMANENT_HW_FAILURE));
            ETG_TRACE_SYS(("!!!!!!!!!!!!!MONITOR_PERMANENT_HW_FAILURE - ENABLE/!!!!!!!!!!!!!!!!"));

            timeout_ms = MONITOR_PERMANENT_HW_FAILURE *1000;
            m_u32CountPermanentOvercurrent[eUsb] = 1;
        }
        else if((tU8)SIG_FALSE == oPortState.u8OC )
        {
            m_u32CountPermanentOvercurrent[eUsb] = 0;
        }
        else
        {
            ETG_TRACE_FATAL(("ERROR vCASEenHWSignals: USB%1d MONITOR_PERMANENT_HW_FAILURE - SIG_UNDEF",eUsb));
        }

        tInt iOvercur = 0;
        for(tInt i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
        {
            iOvercur += (tInt)m_u32CountPermanentOvercurrent[i];
        }
        if(0 == iOvercur)
        {
            if(OSAL_C_TIMEOUT_FOREVER != timeout_ms) //do if necessary only
            {
                ETG_TRACE_SYS(("!!!!!!!!!!!!/MONITOR_PERMANENT_HW_FAILURE - DISABLE!!!!!!!!!!!!!!!!!"));
                ETG_TRACE_SYS(("vCASEenHWSignals:         monitor disabled                 "));
                ETG_TRACE_SYS(("!!!!!!!!!!!!!MONITOR_PERMANENT_HW_FAILURE - DISABLE/!!!!!!!!!!!!!!!!"));
                timeout_ms = OSAL_C_TIMEOUT_FOREVER;
            }
        }

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST  //elaborate better solution here to be able to use real mocking here
        DVMGRIF_DIAGNOSIS->vDiaglogStartUsbOcTimer( ); // Start timer to get the actual status after 3s of no changes this comes from Nissan project therer diaglog itc's have been send triggered from here
        //in contradiction in GM every seconds actial state is checked - i.e. polling on errors

#endif //VARIANT_S_FTR_ENABLE_UNITTEST
#endif //MONITOR_PERMANENT_HW_FAILURE



#ifdef IMPROVE_CRITVOLT
        //-------------------------------------------------------------------------------------------
        //Check: End of critical voltage:
        //check if udev events could be taken again to fill list because USB-connector enabled again
        //-------------------------------------------------------------------------------------------
        if(TRUE == DeviceListManager::GetInstance()->getPlatformEventsLocked(eUsb))
        {
            if(    ((tU8)SIG_TRUE  == oPortState.u8PPON )
                   && ((tU8)SIG_FALSE == oPortState.u8OC   )
                   && ((tU8)SIG_TRUE  != oPortState.u8UV   )
                   )
            {
                ETG_TRACE_SYS(("vCASEenHWSignals: !!!!!!!!!!!!/USB%1d UNLOCK PLATFORM EVENTS!!!!!!!!!!!!!!!!!!!! ",eUsb));
                DeviceListManager::GetInstance()->deleteLists(eUsb); //already deleted - to be sure that it is really empty to fulfill start condition after uvolt
#ifdef EOL_DELAY_AFTEROVERCURRENT
                delay_ms = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_USB_VOLTAGE_RECOVERY_AUTOPLAY_DELAY_TIME);
                ETG_TRACE_FATAL(("[ok] vCASEenHWSignals: delay_ms = %d",delay_ms));
                if(delay_ms >0 /*ms*/)
                {
                    bDelay = TRUE;
                    for(tU8 i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
                    {
                        if( FALSE == DeviceListManager::GetInstance()->getPlatformEventsLocked((tenDevManagerUSBHost)i) )
                        {
                            ETG_TRACE_FATAL(("[ok] vCASEenHWSignals: No extra delay - USB%1d unlocked",i));
                            bDelay = FALSE;
                        }
                    }
                    if(TRUE == bDelay)
                    {
                        ETG_TRACE_FATAL(("[ok] !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
                        ETG_TRACE_FATAL(("[ok] ! EOL: DELAY NOTIFICATION for all CLIENTS after critVolt"));
                        ETG_TRACE_FATAL(("[ok] ! for delay_ms=%d ms                               ",delay_ms));
                        ETG_TRACE_FATAL(("[ok] !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));

                        //simple solution this will supress execution of this thread
                        //since the thread is responible to trigger the notification to clients
                        usleep( (useconds_t)(delay_ms * 1000) );
                        ETG_TRACE_FATAL(("[ok] ! delay done!"));
                    }
                }
                DeviceListManager::GetInstance()->unlockPlatformEvents(eUsb);
#endif //EOL_DELAY_AFTEROVERCURRENT
                ETG_TRACE_SYS(("vCASEenHWSignals: USB%1d - Connector events unlocked ",eUsb));
                ETG_TRACE_SYS(("vCASEenHWSignals: !!!!!!!!!!!!USB%1d UNLOCK PLATFORM EVENTS\!!!!!!!!!!!!!!!!!!!! ",eUsb));
            }
        }
        else
        {
            if(    ((tU8)SIG_FALSE == oPortState.u8PPON )
                   || ((tU8)SIG_TRUE  == oPortState.u8OC   )
                   || ((tU8)SIG_TRUE  == oPortState.u8UV   )
                   )
            {
                ETG_TRACE_SYS(("send2Clients: !!!!!!!!!!!!/USB%1d LOCK PLATFORM EVENTS!!!!!!!!!!!!!!!!!!!! ",eUsb));
                /*care that platform events for l_pCurDevice->eUSB is ignored as long as HW does not work a */
                DeviceListManager::GetInstance()->lockPlatformEvents(eUsb);
                ETG_TRACE_SYS(("send2Clients: USB%1d - Connector events locked ",eUsb));
                ETG_TRACE_SYS(("send2Clients: !!!!!!!!!!!!USB%1d LOCK PLATFORM EVENTS\!!!!!!!!!!!!!!!!!!!! ",eUsb));
            }
        }

#endif


        ETG_TRACE_USR4(("vCASEenHWSignals:timeout_ms=%d",timeout_ms));
        this->vTriggerTimer();

    }
    ETG_TRACE_COMP(("************case enHWSignals<-**********************"));


}


/*-----------------------------------------------------------------------------*
 *tVoid vCASEenCardSignals(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenCardSignals(IN const util_StructMsg &oMsg) const
{
    ETG_TRACE_COMP(("************->case enCardSignals**********************"));

    CDeviceCard    oDeviceCard;
    tenSignalValue l_enConnected;
    tChar          l_strDeviceName[STRING_LENGTH];
    tU16           l_u16MediaType;
    tBool          l_bCardStateAvailable = FALSE;
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
    (void)l_bCardStateAvailable;//To avoid warnings
#endif

    if(m_pIPrmManagerCard)
    {
        memcpy( &l_enConnected        , &(oMsg.pu8Content[0])                                               , sizeof(tenSignalValue) );
        memcpy( &(l_strDeviceName[0]), &(oMsg.pu8Content[sizeof(tenSignalValue)])                          , sizeof(l_strDeviceName) );
        memcpy( &l_u16MediaType      , &(oMsg.pu8Content[sizeof(tenSignalValue) + sizeof(l_strDeviceName)]), sizeof(tU16) );

        //in connect case do ask osal driver about card info
        if(SIG_TRUE == l_enConnected)
        {
            l_bCardStateAvailable = m_pIPrmManagerCard->bGetSDCardState(OUT oDeviceCard,IN l_strDeviceName);
            oDeviceCard.m_eSlot             = eCard0;                   //hardcoded until there is a project with 2 cards
            oDeviceCard.m_u16MediaState     = OSAL_C_U16_DEVICE_READY;  //hardocded until there is a project which want to have e.g. a non-card insert notified e.g. coin in slot
            oDeviceCard.m_u16MediaType      = l_u16MediaType;
            oDeviceCard.m_strUUIDDeviceName = l_strDeviceName;
            oDeviceCard.m_strMountPoint     = GENSTRING("/media/") + oDeviceCard.m_strUUIDDeviceName;
            oDeviceCard.m_eConnected        = l_enConnected;
        }
        else
        {
            oDeviceCard.vSetErrorValues();
        }
        ETG_TRACE_COMP(("vCASEenCardSignals: l_bCardStateAvailable;0x%x",l_bCardStateAvailable));
        oDeviceCard.Show();
        DeviceListManager::GetInstance()->setCardInfo(oDeviceCard);
        DVMGRIF_GENERAL->vInformClientsCard();

    }
    else
    {
        ETG_TRACE_COMP(("[INFO] m_pIPrmManager not available (PrmManagerInterface)"));
    }

    ETG_TRACE_COMP(("************case enCardSignals<-********************"));

}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenOpticalDiscSloteStateNotified(...)
 * 1. this case is used to update the clients about the optical disc slot state
 * 2. vTriggerTimer() is called which leads to call of vCASEenTriggerTimer there timer is started if not yet started
 * 3. after execution vCASEenTimerExp() is called
 * 4. as a result service is informed which send the slot state as property update
 *-----------------------------------------------------------------------------*/

tVoid StateTable::vCASEenOpticalDiscSloteStateNotified(IN const util_StructMsg &oMsg)
{
    ETG_TRACE_COMP(("************->case enOptDiscSlotStateNotified********************"));

    tDMOpticalDiscSlotState   eOpticalDiscSlotState;
    memcpy( & eOpticalDiscSlotState  , &oMsg.pu8Content[0],sizeof(tDMOpticalDiscSlotState));
    ETG_TRACE_USR4(("vCASEenOpticalDiscSloteStateNotified: Filling the slot state: %d",ETG_CENUM(tDMOpticalDiscSlotState, eOpticalDiscSlotState)));

    //this checking is done to help the unit test, during the unit tests, the DVMGRIF_GENERAL will be NULL, see the macro
    //VARIANT_S_FTR_ENABLE_UNITTEST for details
    if(DVMGRIF_GENERAL)
    {
        ETG_TRACE_USR4(("Sending the CDDA Slot state"));
        DVMGRIF_GENERAL->vInformClientsOpticalDiscSlotState( eOpticalDiscSlotState);
    }



    ETG_TRACE_COMP(("************case enOptDiscSlotStateNotified<-********************"));
}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenOpticalDiscCDInfoNotified(...)
 * 1. this case is used to update the clients about the optical disc CD Info
 * 2. vTriggerTimer() is called which leads to call of vCASEenTriggerTimer there timer is started if not yet started
 * 3. after execution vCASEenTimerExp() is called
 * 4. as a result service is informed which send the slot state as property update
 *-----------------------------------------------------------------------------*/

tVoid StateTable::vCASEenOpticalDiscCDInfoNotified(IN const util_StructMsg &oMsg)
{
    ETG_TRACE_COMP(("************->case enOptDiscCDInfoNotified********************"));

    trOpticalDiskCDInfo l_OpticalDiskCDInfo;
    memcpy( &l_OpticalDiskCDInfo  , &oMsg.pu8Content[0],sizeof(trOpticalDiskCDInfo));
    ETG_TRACE_USR4(("vCASEenOpticalDiscCDInfoNotified: Filling the CDInfo"));

    //this checking is done to help the unit test, during the unit tests, the DVMGRIF_GENERAL will be NULL, see the macro
    //VARIANT_S_FTR_ENABLE_UNITTEST for details
    if(DVMGRIF_GENERAL)
    {
        ETG_TRACE_USR4(("Sending the CD Info"));
        DVMGRIF_GENERAL->vInformClientsOpticalDiscCDInfo(l_OpticalDiskCDInfo);}


    ETG_TRACE_COMP(("************case enOptDiscCDInfoNotified<-********************"));
}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenCardOcStatus(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenCardOcStatus(IN const util_StructMsg &oMsg) const
{
    ETG_TRACE_COMP(("************->case enCardOcStatus*********************"));

    CardNotInfoOcStatus oCardOcStatus;
    tenSlot             eCard;

    memcpy( &oCardOcStatus, &(oMsg.pu8Content[0]), sizeof(CardNotInfoOcStatus) );
    eCard = oCardOcStatus.eSlot;
    if( (eCard < eCard0) || ((tInt)eCard>=ARRAYSIZEFORCARD) )
    {
        ETG_TRACE_ERR(( "vCASEenCardOcStatus SD Card %d: OC status for wrong SD Card slot : %d",   ETG_ENUM(DVM_CARD_SLOT, eCard), eCard  ));
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {
        ETG_TRACE_USR2(( "vCASEenCardOcStatus SD Card %d: oCardOcStatus .u16Type = %d", ETG_ENUM(DVM_CARD_SLOT, eCard), ETG_ENUM(BOOL, oCardOcStatus.bOcActive) ));
        // DeviceListManager -> store data
        DeviceListManager* pDevListMgr = DeviceListManager::GetInstance();
        if( pDevListMgr )
        {
            CDeviceCard     oCard;
            pDevListMgr->getCardInfo( &oCard, eCard );          // First get all other actual SD Card data
            // Now copy new over current status for SD Card
            if( oCard.m_bSlotEnable )
            {
                oCard.m_bOverCurrent = oCardOcStatus.bOcActive;
                pDevListMgr->setCardInfo( oCard );              // Store actual SD Card status

                DVMGRIF_GENERAL->vInformClientsCard( );// Send update info to CCA clients

                if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_PRM_SDCARDSIGNALS))
                {
                    // Now care about ITC for SD Card over current
                    DVMGRIF_DIAGNOSIS->vDiaglogStartUsbOcTimer();
                }

            }
            else // if( oCard.m_bSlotEnable )
            {
                ETG_TRACE_ERR(( "vCASEenCardOcStatus: ERROR: SD Card %d: This SD Card slot is disabled", ETG_ENUM(DVM_CARD_SLOT, eCard) ));
            }
        }
        else // if( pDevListMgr )
        {
            ETG_TRACE_ERR(( "vCASEenCardOcStatus: Fail to get instance <DeviceListManager::GetInstance()>" ));
        }
    }
    ETG_TRACE_COMP(("************case enCardOcStatus<-**********************"));

}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenVoltWarning(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenVoltWarning(IN const util_StructMsg &oMsg)
{
    ETG_TRACE_COMP(("************->case enVoltWarning**********************"));

    if(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
    {
        tenSignalValue                eU60_drop    = SIG_UNDEF;
        tenDevManagerUSBHost          eUsb;
        voltageFailure_HWSignalsAll_t oSignal;

        memcpy(&eUsb,  &(oMsg.pu8Content[0]),sizeof(tenDevManagerUSBHost/*eUsb*/));
        if(eUsb == eUSBAll)
        {
            memcpy(&eU60_drop,&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)]),sizeof(tenSignalValue/*eU60_drop*/));
            ETG_TRACE_USR1(("vCASEenVoltWarning:enVoltWarning: USB%d    eU60_drop=%d    ",eUsb,ETG_ENUM(TENSIGNALVALUE,eU60_drop)));

            //warning has been received for all USBConnectors adjust U60_drop in all tables
            for(tInt i = (tInt)eUSB1; i < (tInt)eUSBAll; i++)
            {
                if(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
                {
                    this->getSignals(IN (tenDevManagerUSBHost)i,OUT &oSignal);   //get current signal
                    oSignal.U60_drop=eU60_drop;                //change eU60_drop
                    this->setSignals(OUT oSignal);            //set new values in overall table
                }
            }
            //-------------------------------------------------------------------------------------------
            //Check: End of critical voltage:
            //check if udev events could be taken again to fill list because USB-connector enabled again
            //-------------------------------------------------------------------------------------------
            for(tInt iUsb = (tInt)eUSB1; iUsb < (tInt)eUSBAll; iUsb++)
            {
                ETG_TRACE_USR4(("vCASEenVoltWarning: eUSB%1d",iUsb));
                if( DeviceListManager::GetInstance()->getPlatformEventsLocked((tenDevManagerUSBHost)iUsb) )
                {

                    if(( SIG_FALSE == oSignal.U60_drop ) )
                    {

                        ETG_TRACE_SYS(( "vCASEenVoltWarning: !!!!!!!/USB%1d UNLOCK PLATFORM EVENTS!!!!!!!!!!!!!!!! ", iUsb ));
    #ifndef USE_SENT_ALL_CHANGES
                        DeviceListManager::GetInstance()->deleteLists( (tenDevManagerUSBHost)iUsb); ///???????? //already deleted - to be sure that it is really empty to fulfill start condition after uvolt
    #endif //#if USE_SENT_ALL_CHANGES
                        DeviceListManager::GetInstance()->unlockPlatformEvents((tenDevManagerUSBHost)iUsb);

                        ETG_TRACE_SYS(("vCASEenVoltWarning: !!!!!!!!USB%1d UNLOCKED PLATFORM EVENTS \!!!!!!!!!!!!!!! ",iUsb));
    #ifdef USE_SENT_ALL_CHANGES
                        this->bStartTimer();         // Start timer to check after the timeout if the USB devices are recognized again.
    #endif //#if USE_SENT_ALL_CHANGES
                    }
                }

                else if((  SIG_TRUE == oSignal.U60_drop  ))
                {
                    ETG_TRACE_SYS(("vCASEenVoltWarning: !!!!!!!!/USB%1d LOCK PLATFORM EVENTS (SPM-CLV)!!!!!!!!!!!!!!!! ",iUsb));
                    // care that platform events for l_pCurDevice->eUSB is ignored as long as HW does not work a
                    DeviceListManager::GetInstance()->lockPlatformEvents((tenDevManagerUSBHost)iUsb);

                    ETG_TRACE_SYS(("vCASEenVoltWarning: !!!!!!!!USB%1d LOCKED PLATFORM EVENTS (SPM-CLV)\!!!!!!!!!!!!!! ",iUsb));
    #ifdef USE_SENT_ALL_CHANGES
                    this->bStopTimer();                             // Stop the timer 'check if USB devic recognized again after CLV End'
                    setTimerExpired(this);                        // Start CLV could be notified without delay //this->vTriggerTimer();
    #endif //#if USE_SENT_ALL_CHANGES
                }
            }
    #ifndef USE_SENT_ALL_CHANGES
            //-----------------------------------------
            //trigger vCASEenTimerExp to be called immediately
            //-----------------------------------------
            setTimerExpired(this);
    #endif //#if USE_SENT_ALL_CHANGES
        }
        else
        {
            ETG_TRACE_FATAL(("vCASEenVoltWarning: eUsb != eUSBAll"));
        }
    }
    ETG_TRACE_COMP(("************->case enVoltWarning**********************"));
}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenTestSend2Client(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenTestSend2Client(IN const util_StructMsg &oMsg)
{
    ETG_TRACE_COMP(("************->case enTestSend2Client**********************"));

    tenDevManagerUSBHost      eUsb;
    voltageFailure_Result_t   testResult;
    DEVICE_CONNECTSTATUS_Type eTestConnectStatus;

    memcpy(&eUsb,  &(oMsg.pu8Content[0]),sizeof(tenDevManagerUSBHost/*eUsb*/)); //unmarshal
    if((eUsb<eUSB1) || ((tInt)eUsb>=ARRAYSIZEFORUSB)) //error check
    {
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {
        memcpy(&eTestConnectStatus,&(oMsg.pu8Content[sizeof(tenDevManagerUSBHost/*eUsb*/)]),sizeof(DEVICE_CONNECTSTATUS_Type/*eTestConnectStatus*/));
        ETG_TRACE_USR1(("vCASEenTestSend2Client:enTestSend2Client: USB%d    eTestConnectStatus=%d    ",eUsb,ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,eTestConnectStatus)));
        testResult.resultUSB = eTestConnectStatus;
        send2Clients(eUsb,testResult,TRUE /*=bTest*/);
    }
    ETG_TRACE_COMP(("************case enTestSend2Client<-**********************"));

}


/*-----------------------------------------------------------------------------*
 *tVoid vCASEenCDDriveOverTemp(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenCDDriveOverTemp(IN const util_StructMsg &oMsg) const
{
    ETG_TRACE_COMP(("************->case enCDRomOverTemp**********************"));

    tUInt               iSize;
    tBool               bExists;
    tBool               bOverTemperature;
    structNotifyClients l_oCurDevice;

    memcpy(&bOverTemperature,  &(oMsg.pu8Content[0]),sizeof(tBool/*bOverTemperature*/));

    iSize = DeviceListManager::GetInstance()->getSizeOfList(DEVLIST_STATETABLE);
    for (tUInt l_uiCount=0; l_uiCount < iSize ;l_uiCount++)
    {
        bExists = DeviceListManager::GetInstance()->getElement(l_uiCount,l_oCurDevice);
        DVM_NORMAL_M_ASSERT(TRUE == bExists);
        if(CGlobalEnumerations::DTY_CDROM == l_oCurDevice.eDeviceType || CGlobalEnumerations::DTY_CDDA == l_oCurDevice.eDeviceType )
        {
            ETG_TRACE_USR1(("vCASEenCDriveOvertemp: DTY_CDROM or DTY_CDDA found: eConnectStatus=%d",ETG_CENUM(DEVICE_CONNECTSTATUS_Type,l_oCurDevice.eConnectStatus)));

            //this part works only if the device already connected. If it is not yet connected then enTimerExp is responsible
            // to notify in dependency of m_bOverTemperature
            if(   (USB_DEV_CONNECTED                   == l_oCurDevice.eConnectStatus)
                  ||(USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE == l_oCurDevice.eConnectStatus))
            {
                ETG_TRACE_USR1(("vCASEenCDriveOvertemp: bOverTemperature=0x%x",bOverTemperature));
                if(TRUE == bOverTemperature)
                {
                    l_oCurDevice.eConnectStatus = USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE;

                }
                else
                {
                    l_oCurDevice.eConnectStatus = USB_DEV_CONNECTED;
                }
                //DeviceListManager::GetInstance()->Set_eConnectStatus(DEVLIST_UDEVMGR,f_pNotifyClients); //let it in state connected to support that remove works fine
                DeviceListManager::GetInstance()->Set_eConnectStatus(DEVLIST_STATETABLE,&l_oCurDevice);       //State table and
                DeviceListManager::GetInstance()->Set_eConnectStatus(DEVLIST_DEVICEMGRSERVICE,&l_oCurDevice); //service should get the new value

                //---------------------------------------------------
                // TRIGGER TO SEND TO CLIENTS
                //---------------------------------------------------
                DVMGRIF_GENERAL->vInformClientsCDDriveOvertemp(l_oCurDevice);

            }
        }
    }

    ETG_TRACE_COMP(("************case enCDRomOverTemp<-**********************"));
}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenDiagMountCDRom(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenDiagMountCDRom(IN const util_StructMsg &oMsg)   //Roadmap 14002 MOuntCDROM (MixedModeDiag)
{
    ETG_TRACE_COMP(("************->case enDiagMountCDRom**********************"));

    tBool     bMount;
    tChar     cDeviceName[LEN_cDeviceName];
    std::string strCDROMDeviceName;
    GENSTRING   _strCDROMDeviceName; //wil be replaced in the future by standardstring

    //unmarshal 2 parameters
    memcpy(&bMount,      &(oMsg.pu8Content[0]),sizeof(tBool/*bMount*/));
    memcpy(cDeviceName,  &(oMsg.pu8Content[0+ sizeof(tBool/*bMount*/)]),sizeof(cDeviceName));

    ETG_TRACE_USR4(("vCASEenDiagMountCDRom: bMount     : 0x%x",bMount));
    ETG_TRACE_USR4(("vCASEenDiagMountCDRom: cDeviceName: %s"  ,cDeviceName));

    strCDROMDeviceName = cDeviceName;
    if(strCDROMDeviceName.empty())
    {
        ETG_TRACE_USR2(("strCDROMDeviceName: isEmpty replace get val from ConfigurationManager"));
        //tbd.: continue here later
        ConfigurationManager::GetInstance()->vGetSpecificBlockDevName(IN CGlobalEnumerations::DTY_CDROM, OUT strCDROMDeviceName);

    }
    _strCDROMDeviceName = strCDROMDeviceName.c_str();

    if(TRUE == bMount)
    {
        vSubCASEenDiagMountCDRom(IN _strCDROMDeviceName);
    }
    else
    {
        vSubCASEenDiagUnMountCDRom(IN _strCDROMDeviceName);
    }

    ETG_TRACE_COMP(("************case enDiagMountCDRom<-**********************"));
}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenDevRecAfterClv(...)
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenDevRecAfterClv()
{

    ETG_TRACE_COMP(( "************->case enDevRecAfterClv**********************" ));

    voltageFailure_Result_t result[ARRAYSIZEFORUSB];
    tenDevManagerUSBHost eUsb;

    for( tInt i = (tInt)eUSB1; i < ARRAYSIZEFORUSB; i++ )
    {
        eUsb = (tenDevManagerUSBHost)i;
        ETG_TRACE_USR4(( "vCASEenDevRecAfterClv: Timer after CLV event expired: Check USB%1d", i ));
        if( m_result[eUsb].resultUSB == USB_DEV_UNAVAIL_BAT_LOWVOLT )
        {
            ETG_TRACE_USR4(( "vCASEenDevRecAfterClv: Device: USB%1d not recognized again after CLV End. -> Change ConnectionStatus to USB_DEV_REMOVED_BY_USR", i ));
            // If the device is still not recognized again after CLV End it was probably removed.
            result[eUsb].resultUSB = USB_DEV_REMOVED_BY_USR;
            send2Clients( eUsb, result[i] );
            m_result[eUsb].resultUSB = result[eUsb].resultUSB;                //store current result @todo check if this variable is still necessary
            DeviceListManager::GetInstance()->ListChkDeleteDevice( DEVLIST_STATETABLE, eUsb);
        }
    }

}

/*-----------------------------------------------------------------------------*
 *tVoid vCASEenTriggerTimer()
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenTriggerTimer(IN const util_StructMsg &oMsg)
{
    ETG_TRACE_COMP(("************->case enTriggerTimer**********************"));
    tBool isDeviceConnection = false;
    memcpy(&isDeviceConnection,&(oMsg.pu8Content[0]),sizeof(isDeviceConnection));

    this->vChkTriggerTimer(isDeviceConnection);
    ETG_TRACE_COMP(("************case enTriggerTimer<-**********************"));
}

/*-----------------------------------------------------------------------------*
 *tVoid StateTable::vCASEenMalfunctionUsbConnector(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenMalfunctionUsbConnector(IN const util_StructMsg &oMsg, IN tU64 u64TestValue /*used in tests only*/)
{
    INFORM_IF_TESTMODE((char*)"StateTable::vCASEenMalfunctionUsbConnector",u64TestValue);
    ETG_TRACE_COMP(("************->case enMalfunctionUsbConnector**********************"));

    structNotifyMalfunction          oNotifyMalfunction;

    memcpy(&oNotifyMalfunction,&(oMsg.pu8Content[0]),sizeof(structNotifyMalfunction)); //unmarshal

    tBool                bHasMalfunction     = oNotifyMalfunction.bIsMalfunction;
    tenDevManagerUSBHost eUsb                = oNotifyMalfunction.eUSB;
    tenTypeOFMalfunction eTypeOFMalfunction  = oNotifyMalfunction.eTypeOFMalfunction;

    ETG_TRACE_USR2(("vCASEenMalfunctionUsbConnector  oNotifyMalfunction.eUSB               = %d",ETG_ENUM(tenDevManagerUSBHost,eUsb)));
    ETG_TRACE_USR2(("vCASEenMalfunctionUsbConnector  oNotifyMalfunction.bIsMalfunction     = %d",ETG_ENUM(BOOL,bHasMalfunction)));
    ETG_TRACE_USR2(("vCASEenMalfunctionUsbConnector  oNotifyMalfunction.eTypeOFMalfunction = %d",ETG_ENUM(tenTypeOFMalfunction,eTypeOFMalfunction)));

       if((eUsb< eUSB1) || ((tInt)eUsb>=eUSBAll))
       {
           DVM_NORMAL_M_ASSERT_ALWAYS();
       }
       else
       {

#ifdef USE_HIGHRISK4USB_HWMALFUNCTION
           //todo: both function parts below do the same.
           // check to add DeviceListManager::GetInstance()->vStoreMalfunctionTimeStamp(eUsb,u64MalfunctionTimeStamp,eTypeOFMalfunction)
           //if this saves codelines
           //------------------------------------------------
           // platform has notified that dependent hardware has failed
           //------------------------------------------------
           if(eIsMalfunction == eTypeOFMalfunction)
           {
               if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
               {
                   //set timestamp of malfunction
                   if(TRUE == bHasMalfunction)
                   {
                       tU64 u64MalfunctionTimeStamp = ConfigurationManager::GetInstance()->GetEclapsedTime_ms(); if(u64TestValue != 0){u64MalfunctionTimeStamp = u64TestValue;}//adjusted in test mode

                      //this  stores the malfunction time stamp it will be deleted
                      //if in vCASETimerExp an apply remove has to be mapped to hwmalfunction (temporary not available)
                      //of if hwmalfunction is mapped to hwmalfunction permanent

                      DeviceListManager::GetInstance()->vStoreMalfunctionTimeStamp(eUsb,u64MalfunctionTimeStamp);

                      //Note: Expiration function 'this->vTriggerTimer();'  is not triggered  since a resulting remove will do this
                   }

                   //-----------------------------------------------
                   //check if any device is connected if not send trigger
                   //Special scenario only offered for diagnosis use case
                   //where no device is connected but USBPortListValues are expected ok
                   //
                   //Use Case: USB1 device is connected, shortcircuit at USB2
                   //=>no USBPortList change would be send for USB2
                   //
                   //Use Case USB1 device connected, short circuit at USB1
                   //=> USBPortList would also show correct result in PortList because if device remove happens then PortList is mapped and send
                   //      malfunction 'no' should not happen before TimerExpiration is called triggered by remove
                   //
                   //Use Case USB2  device connected, short circuit at USB1
                   //=>no USBPortList change would be send for USB1
                   //
                   //Use Case USB2 device connected, short circuit at USB2
                   //=> USBPortList would also show correct result in PortList because if device remove happens then PortList is mapped and send
                   //      malfunction 'no' should not happen before TimerExpiration is called triggered by remove
                   //
                   //We first decide for this solution because in this manner no unwanted side effects will be done for existing UseCases bound to
                   //malfunction mechanism (temporarily not available mechanism)
                   //clarification about exact use case neccessary with diagnosis
                   //
                   //The alternative will be to take USBPortList to its own property which means to change code in Diagnosis
                   //discussion necessary with diagnosis
                   //-----------------------------------------------
                   int iCountConnectedDevicesAllConnectors= 0;
                   for(int i = (tInt)eUSB1; i<(int)eUSBAll; i++)
                   {
                       if(TRUE == DeviceListManager::GetInstance()->IsDeviceAtConnector((tenDevManagerUSBHost)i,DEVLIST_STATETABLE,true /*consider only playable devices*/))
                       {
                           iCountConnectedDevicesAllConnectors++;
                       }
                   }
                   ETG_TRACE_USR1(("vCASEenMalfunctionUsbConnector: iCountConnectedDevicesAllConnectors; %d",iCountConnectedDevicesAllConnectors));
                   if(0 == iCountConnectedDevicesAllConnectors)
                   {
                       this->vTriggerTimer();
                   }


               }
           }
           //------------------------------------------------
           // platform has notified that dependent hardware has failed
           //------------------------------------------------
           else if(eIsHighRiskForMalfunction == eTypeOFMalfunction)
           {
               if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
               {
                   //set timestamp of malfunction
                   if(TRUE == bHasMalfunction)
                   {
                       tU64 u64highRiskForMalfunctionTimeStamp = ConfigurationManager::GetInstance()->GetEclapsedTime_ms(); if(u64TestValue != 0){u64highRiskForMalfunctionTimeStamp = u64TestValue;}//adjusted in test mode
                       DeviceListManager::GetInstance()->vStoreHighRiskForMalfunctionTimeStamp(u64highRiskForMalfunctionTimeStamp);
                       this->vTriggerTimer();
                   }
               }
           }

#else //USE_HIGHRISK4USB_HWMALFUNCTION

           //------------------------------------------------
           // platform has notified that dependent hardware has failed
           //------------------------------------------------
           if(eIsMalfunction == eTypeOFMalfunction)
           {
               StoreMalfunctionUSBConnectorWithTimeStamp(IN bHasMalfunction,IN eUsb);

               if(TRUE == bHasMalfunction)
               {
                   ETG_TRACE_SYS(("vCASEenMalfunctionUsbConnector: !!!!!!!!!!!!/USB%1d LOCK PLATFORM EVENTS!!!!!!!!!!!!!!!!!!!! ",eUsb));


                   DeviceListManager::GetInstance()->lockPlatformEvents(eUsb);
                   ETG_TRACE_SYS(("vCASEenMalfunctionUsbConnector: USB%1d - Connector events locked ",eUsb));
                   ETG_TRACE_SYS(("vCASEenMalfunctionUsbConnector: !!!!!!!!!!!!USB%1d LOCK PLATFORM EVENTS\!!!!!!!!!!!!!!!!!!!! ",eUsb));
               }
               else
               {
                   ETG_TRACE_SYS(("vCASEenMalfunctionUsbConnector: !!!!!!!!!!!!/USB%1d UNLOCK PLATFORM EVENTS!!!!!!!!!!!!!!!!!!!! ",eUsb));
                   //DeviceListManager::GetInstance()->deleteLists(eUsb); //already deleted - to be sure that it is really empty to full fill start condition after uvolt
    #ifdef EOL_DELAY_AFTEROVERCURRENT
                    tInt delay_ms = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_USB_VOLTAGE_RECOVERY_AUTOPLAY_DELAY_TIME);
                    ETG_TRACE_FATAL(("[ok] vCASEenMalfunctionUsbConnector: delay_ms = %d",delay_ms));
                    if(delay_ms >0 /*ms*/)
                    {
                     tBool bDelay = TRUE;
                     for(tU8 i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
                     {
                         if( FALSE == DeviceListManager::GetInstance()->getPlatformEventsLocked((tenDevManagerUSBHost)i) )
                         {
                             ETG_TRACE_FATAL(("[ok] vCASEenMalfunctionUsbConnector: No extra delay - USB%1d unlocked",i));
                             bDelay = FALSE;
                         }
                     }
                     if(TRUE == bDelay)
                     {
                         ETG_TRACE_FATAL(("[ok] !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
                         ETG_TRACE_FATAL(("[ok] ! EOL: DELAY NOTIFICATION for all CLIENTS after critVolt"));
                         ETG_TRACE_FATAL(("[ok] ! for delay_ms=%d ms                               ",delay_ms));
                         ETG_TRACE_FATAL(("[ok] !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));

                         //simple solution this will supress execution of this thread
                         //since the thread is responible to trigger the notification to clients
                         usleep( (useconds_t)(delay_ms * 1000) );
                         ETG_TRACE_FATAL(("[ok] ! delay done!"));
                     }
                    }
                   DeviceListManager::GetInstance()->unlockPlatformEvents(eUsb);
    #endif //EOL_DELAY_AFTEROVERCURRENT
                   ETG_TRACE_SYS(("vCASEenHWSignals: USB%1d - Connector events unlocked ",eUsb));
                   ETG_TRACE_SYS(("vCASEenHWSignals: !!!!!!!!!!!!USB%1d UNLOCK PLATFORM EVENTS\!!!!!!!!!!!!!!!!!!!! ",eUsb));
               }


               this->vTriggerTimer();
           }
#endif //ifndef USE_HIGHRISK4USB_HWMALFUNCTION
           else
           {
                ETG_TRACE_FATAL(("[ERROR] wrong parameter"));
           }

       }
       ETG_TRACE_COMP(("************case enMalfunctionUsbConnector<-**********************"));
}



/*-----------------------------------------------------------------------------*
 *tVoid StateTable::vCASEenMalfunctionOpticalDisc(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenMalfunctionOpticalDisc(IN const util_StructMsg &oMsg)
{
    ETG_TRACE_COMP(("************->case vCASEenMalfunctionOpticalDisc**********************"));
    structNotifyMalfunction          oNotifyMalfunction;
    tS32 s32MalfunctionElapsedTime_sec;
    memcpy(&oNotifyMalfunction,&(oMsg.pu8Content[0]),sizeof(structNotifyMalfunction)); //unmarshal
    tBool bHasMalfunction = oNotifyMalfunction.bIsMalfunction;

    ETG_TRACE_USR2(("vCASEenMalfunctionOpticalDisc  oNotifyMalfunction.eUSB = %d",oNotifyMalfunction.eUSB));
    ETG_TRACE_USR2(("vCASEenMalfunctionOpticalDisc  oNotifyMalfunction.bIsMalfunction = %d",bHasMalfunction));
    if(eUSBUndef == oNotifyMalfunction.eUSB)
    {

        CGlobalEnumerations::DEVICE_TYPE_Type l_eDeviceType;
        vSetOpticalDiscDeviceType(l_eDeviceType);

        if(TRUE == bHasMalfunction)
        {
            //todo check with Christian whether we have to lock PlatformEvents
            //ETG_TRACE_SYS(("vCASEenMalfunctionUsbConnector: !!!!!!!!!!!!/USB%1d LOCK PLATFORM EVENTS!!!!!!!!!!!!!!!!!!!! ",eUsb));
            // DeviceListManager::GetInstance()->lockPlatformEvents(eUsb);
            //ETG_TRACE_SYS(("vCASEenMalfunctionUsbConnector: USB%1d - Connector events locked ",eUsb));
            //ETG_TRACE_SYS(("vCASEenMalfunctionUsbConnector: !!!!!!!!!!!!USB%1d LOCK PLATFORM EVENTS\!!!!!!!!!!!!!!!!!!!! ",eUsb));
            if(TRUE == DeviceListManager::GetInstance()->GetMalfunctionTimeStampForDevices(IN  l_eDeviceType,OUT s32MalfunctionElapsedTime_sec))
            {
                if(s32MalfunctionElapsedTime_sec != MALFUNCTION_NO)
                {
                    s32MalfunctionElapsedTime_sec+= MALFUNCTIONUPDATEINTERVAL;
                }
                else
                {
                    s32MalfunctionElapsedTime_sec = MALFUNCTION_YES;
                }
            }
        }
        else
        {
            //todo check with Christian whether we have to unlock PlatformEvents
            s32MalfunctionElapsedTime_sec = MALFUNCTION_NO;
        }
        DeviceListManager::GetInstance()->UpdateMalfunctionInfoWithTimeStamp(l_eDeviceType,s32MalfunctionElapsedTime_sec);

        this->vTriggerTimer();

    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR]: vCASEenMalfunctionOpticalDisc: expect eUSBUndef"));
    }
    ETG_TRACE_COMP(("************case vCASEenMalfunctionOpticalDisc<-**********************"));
}

/*-----------------------------------------------------------------------------*
 *tVoid StateTable::vCASEenMalfunctionSDCardInternal(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tVoid StateTable::vCASEenMalfunctionSDCardInternal(IN const util_StructMsg &oMsg)
{
    ETG_TRACE_COMP(("************->case vCASEenMalfunctionSDCardInternal**********************"));
    structNotifyMalfunction          oNotifyMalfunction;
    memcpy(&oNotifyMalfunction,&(oMsg.pu8Content[0]),sizeof(structNotifyMalfunction)); //unmarshal

    ETG_TRACE_USR2(("vCASEenMalfunctionOpticalDisc  oNotifyMalfunction.eUSB = %d",oNotifyMalfunction.eUSB));
    ETG_TRACE_USR2(("vCASEenMalfunctionOpticalDisc  oNotifyMalfunction.bIsMalfunction = %d",oNotifyMalfunction.bIsMalfunction));
    if(eUSBUndef == oNotifyMalfunction.eUSB)
    {
#ifdef USE_HIGHRISK4USB_HWMALFUNCTION


#else
        CGlobalEnumerations::DEVICE_TYPE_Type l_eDeviceType;
        tS32 s32MalfunctionElapsedTime_sec;
        vSetSDInternalDeviceType(l_eDeviceType);
        if(TRUE == bHasMalfunction)
        {
            //todo check with Christian whether we have to lock PlatformEvents
            //ETG_TRACE_SYS(("vCASEenMalfunctionSDCardInternal: !!!!!!!!!!!!/USB%1d LOCK PLATFORM EVENTS!!!!!!!!!!!!!!!!!!!! ",eUsb));
            // DeviceListManager::GetInstance()->lockPlatformEvents(eUsb);
            //ETG_TRACE_SYS(("vCASEenMalfunctionSDCardInternal: USB%1d - Connector events locked ",eUsb));
            //ETG_TRACE_SYS(("vCASEenMalfunctionSDCardInternal: !!!!!!!!!!!!USB%1d LOCK PLATFORM EVENTS\!!!!!!!!!!!!!!!!!!!! ",eUsb));
            if(TRUE == DeviceListManager::GetInstance()->GetMalfunctionTimeStampForDevices(IN  l_eDeviceType,OUT s32MalfunctionElapsedTime_sec))
            {
                if(s32MalfunctionElapsedTime_sec != MALFUNCTION_NO)
                {
                    s32MalfunctionElapsedTime_sec+= MALFUNCTIONUPDATEINTERVAL;
                }
                else
                {
                    s32MalfunctionElapsedTime_sec = MALFUNCTION_YES;
                }
            }
        }
        else
        {
            //todo check with Christian whether we have to unlock PlatformEvents
            s32MalfunctionElapsedTime_sec = MALFUNCTION_NO;
        }
        DeviceListManager::GetInstance()->UpdateMalfunctionInfoWithTimeStamp(l_eDeviceType,s32MalfunctionElapsedTime_sec);
#endif
        this->vTriggerTimer();
    }

    ETG_TRACE_COMP(("************case vCASEenMalfunctionSDCardInternal<-**********************"));
}


/*-----------------------------------------------------------------------------*
 * tVoid vThreadFunction()                                                     *
 *-----------------------------------------------------------------------------*/
tVoid  StateTable::vThreadFunction()
{
    ETG_TRACE_USR4(("Begin: vThreadFunction"));

    tS32              s32QWaitResult;
    tBool             bLoop=TRUE;
    util_StructMsg    oMsg;
    util_StructQInfo *pMsgQInfo  = &m_msgQ;
    OSAL_tMSecond     timeout_ms;
    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
    {
        //we are modifying the timeout to monitor for the permanent hardware malfunction
        timeout_ms = STATETABLE_MESSAGE_QUEUE_TIMEOUT_SEC*1000 /*milliseconds*/;//time out for waiting for messages in the message queue
    }
    else
    {
        timeout_ms = OSAL_C_TIMEOUT_FOREVER;//time out for waiting for messages in the message queue
    }


    LOCK_THREAD; //supports shutdown

    //wait on queue
    m_lock.lock();
    ETG_TRACE_COMP(("vThreadFunction: LOCKED"));

    //-----------------------------------------
    //Loop of thread
    //-----------------------------------------
    while(TRUE==bLoop)
    {
        oMsg.eMsgType = enUndefined;
        ETG_TRACE_COMP(("============StateMachine: vThreadFunction - Waiting4Msg===================="));

        m_lock.unlock();
        ETG_TRACE_COMP(("vThreadFunction: UNLOCKED"));

        //-----------------------------------------------------
        // waiting point of thread - waiting for message
        //------------------------------------------------------
        s32QWaitResult = util_s32Wait4Q(pMsgQInfo,&oMsg,timeout_ms);
#ifdef MONITOR_PERMANENT_HW_FAILURE
        if(OSAL_E_TIMEOUT == (tU32)s32QWaitResult)
        {
            ETG_TRACE_COMP(("vThreadFunction: TIMEOUT (%d) util_s32Wait4Q",timeout_ms));
            for(tInt i=(tInt)eUSB1;i<ARRAYSIZEFORUSB;i++)
            {
                if(m_u32CountPermanentOvercurrent[i] >=1)
                {
                    ETG_TRACE_FATAL(("!!!!!!!!!!!!/MONITOR_PERMANENT_HW_FAILURE - EXECUTING!!!!!!!!!!!!!!!!!"));
                    ETG_TRACE_FATAL(("vThreadFunction: USB%1d : PERMANENT OVERCURRENT       ",i));
                    ETG_TRACE_FATAL(("vThreadFunction: USB%1d : Duration: %d sec",i,(m_u32CountPermanentOvercurrent[i]*timeout_ms)/1000/*ms*/));
                    ETG_TRACE_FATAL(("!!!!!!!!!!!!!MONITOR_PERMANENT_HW_FAILURE - EXECUTING/!!!!!!!!!!!!!!!!"));
                    m_u32CountPermanentOvercurrent[i]++;
                    //@todo after extension of CCA-interface send result here:
                }
            }
            if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))
            {
                ETG_TRACE_USR4(("ERROR: vThreadFunction: util_s32Wait4Q"));
                vMonitoringForMalfunctionPermanent();
            }

            /*RETRIAL--Check if all partitions in a multipartition tickets have been mounted*/
            if((DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_MSD_BIGGEST_PARTITION)) || (DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_SORT_PARTITIONS_ALL)))
            {
                ETG_TRACE_USR4(("ERROR: vThreadFunction: util_s32Wait4Q"));
                vRetryForAllPartitionMounted();
            }
            if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_DELAY_NOTIFY_MTP_DEVICES))
            {
                /*We are delaying the connect status of MTP devices for around DEVICETYPE_RETRY_ELAPSED_TIMESEC*/
                vRetryForDeviceTypeConnected(CGlobalEnumerations::DTY_NOT_SUPPORTED);
            }
        }


#endif//MONITOR_PERMANENT_HW_FAILURE
        else if(OSAL_E_NOERROR == (tU32)s32QWaitResult) //blocking function thread normally waits here
        {
            m_lock.lock();
            ETG_TRACE_USR1(("vThreadFunction:LOCKED,  oMsg.eMsgType: %d",ETG_ENUM(TENMSGTYP,oMsg.eMsgType)));

            switch(oMsg.eMsgType)
            {
            //==============================================
            case enTimerExp:       /*OUTPUT*/
                //==============================================
                if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS))
                {
                    vCASEenTimerExp();
                }
                else
                {
                    vCASEenTimerExpOld();
                }
                break;

                //=============================================
            case enTestSend2Client:/*OUTPUT*/
                //=============================================
                vCASEenTestSend2Client(oMsg);
                break;

                //=============================================
            case enCDDriveOverTemp:/*Output*/ //Roadmap 13035_OverTemperature
                //=============================================
                vCASEenCDDriveOverTemp(oMsg);
                break;

                //=============================================
            case enDiagMountCDRom:/*Output*/ /*Roadmap 13002 MountCDROM MixeModeCD*/
                //=============================================
                vCASEenDiagMountCDRom(oMsg);
                break;

                //=============================================
            case  enCDDANotified:    /*INPUT*/ //Roadmap 15002 CDaudio Detection
                //=============================================
                if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_INTERNAL_CDDA))
                {
                    vCASEenCDDANotified(oMsg);
                }
                break;

                //=============================================
            case  enOptDiscSlotStateNotified:    /*INPUT*/ //Roadmap 15002 CDaudio Detection
                //=============================================
                if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_INTERNAL_CDDA))
                {
                    vCASEenOpticalDiscSloteStateNotified(oMsg);
                }
                break;
                //=============================================
            case enOptDiscCDInfoNotified:    // CD Info
                //=============================================
                 vCASEenOpticalDiscCDInfoNotified(oMsg);
                 break;
                //---------------------------------------------------
            case enMountUdev:       /*INPUT*/
                //---------------------------------------------------
                vCASEenMountUdev(oMsg);
                break;

                //---------------------------------------------------
            case enTriggerTimer:    /*INPUT*/
                //---------------------------------------------------
                vCASEenTriggerTimer(oMsg);
                break;

                //---------------------------------------------------
            case enHWSignals:      /*INPUT*/
                //---------------------------------------------------
                vCASEenHWSignals(oMsg);
                break;

                //---------------------------------------------------
            case enCardSignals:    /*INPUT*/
                //---------------------------------------------------
                if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_PRM_SDCARDSIGNALS))
                {
                    vCASEenCardSignals(oMsg);
                }
                break;

                //---------------------------------------------------
            case enCardOcStatus:   /*INPUT*/
                //---------------------------------------------------
                if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_PRM_SDCARDSIGNALS))
                {
                    vCASEenCardOcStatus(oMsg);
                }
                break;

                //---------------------------------------------------
            case enDevRecAfterClv: /*INPUT*/
                //---------------------------------------------------
#ifdef USE_SENT_ALL_CHANGES
                vCASEenDevRecAfterClv();
#endif
                break;

                //---------------------------------------------------
            case enVoltWarning:  /*INPUT*/ //Roadmap 13024_Undervoltage_2
                //---------------------------------------------------
                vCASEenVoltWarning(oMsg);
                break;

                //---------------------------------------------------
            case enTimout:
                //---------------------------------------------------
                break;

                //---------------------------------------------------
            case enShutdown:
                //---------------------------------------------------
                bLoop=FALSE;
                break;

                //---------------------------------------------------
            case enMalfunctionUsbConnector:
                //---------------------------------------------------
                vCASEenMalfunctionUsbConnector(oMsg);
                break;

                //---------------------------------------------------
           case enMalfunctionOpticalDisc:
                //---------------------------------------------------
                vCASEenMalfunctionOpticalDisc(oMsg);
                break;
                //---------------------------------------------------
           case enMalfunctionSDCardInternal:
                //---------------------------------------------------
                vCASEenMalfunctionSDCardInternal(oMsg);
                break;
                //---------------------------------------------------
           case enPortPowerInfoNotified:
                //---------------------------------------------------
                vCASEenPortPowerInfoNotified(oMsg);
                break;
                //---------------------------------------------------

                //---------------------------------------------------
            default:
                //---------------------------------------------------
                DVM_NORMAL_M_ASSERT_ALWAYS();
                break;
            }
        }

    }

    UNLOCK_THREAD;
    ETG_TRACE_USR4(("End  : vThreadFunction"));
}

/*-----------------------------------------------------------------------------*
 *void StateTabler::Do(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
void StateTable::Do(int functionID, void *ptr)
{
    ETG_TRACE_USR4(("Begin:Do"));
            (void) ptr;
    tenThreadFunction eFunctionID = (tenThreadFunction)functionID;
    switch(eFunctionID)
    {
    case StateTable::eThread_StateTable: //execution tree for thread eThread_SystemVolt
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
        ThreadFactoryDVM::GetThreadFactory()->SetName("VD_DVM:eThread_StateTable");
#endif //VARIANT_S_FTR_ENABLE_UNITTEST
        vThreadFunction();
        break;
    default:
        break;
    }
    ETG_TRACE_USR4(("End  :Do"));
}

IN tVoid StateTable::SetPrmManagerCardIF(IPrmManagerCard *f_pIPrmManagerCard)
{
    m_pIPrmManagerCard = f_pIPrmManagerCard;
}






IN void StateTable::SetTestHookNoErase(bool bNoErase)
{
    m_bTestHookNoErase = bNoErase;
}


/*-----------------------------------------------------------------------------*
 *void StateTable::SetMalfunctionUSBConnector(...)                            *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::SetMalfunctionUSBConnector(IN tBool bIsMalfunction, IN tenDevManagerUSBHost eUsbConnectorNum, IN tenTypeOFMalfunction eTypeOFMalfunction)
{
    ETG_TRACE_USR4(("Begin  : SetMalfunctionUSBConnector"));
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
    {
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_USBCONNECTORS))  //double checked see bIsEnabled_IStateTableHWMalfunction -
        {
            ETG_TRACE_COMP(("->################### SetMalfunctionUSBConnector #####################"));
            ETG_TRACE_USR4(("SetMalfunctionUSBConnector: bIsMalfunction          : %d", ETG_ENUM(TBOOL, bIsMalfunction) ));
            ETG_TRACE_USR4(("SetMalfunctionUSBConnector: UsbConnectorNum         : %d", ETG_ENUM(tenDevManagerUSBHost, eUsbConnectorNum) ));
            if((eUsbConnectorNum < eUSB1) || (eUsbConnectorNum >= (tU8)ARRAYSIZEFORUSB))
            {
                ETG_TRACE_ERRMEM(("SetMalfunctionUSBConnector : PLATFORM PRM HAS SEND UNDEFINED PORT!!!"));
            }
            else if(   (eIsHighRiskForMalfunction == eTypeOFMalfunction)
                     &&(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_HIGHRISK4USB_HWMALFUNCTION))
                    )
            {
                ETG_TRACE_COMP(("[INFO] SetMalfunctionUSBConnector : eCONF_ENABLE_HIGHRISK4USB_HWMALFUNCTION is off - suppress signal"));
            }
            else
            {
                util_StructMsg oMsg;
                tBool bSend = SetFillMalfunctionUSBConnector(IN bIsMalfunction,IN eUsbConnectorNum, IN eTypeOFMalfunction, OUT oMsg); //this function has been established to offer unittesting of state table

                //-----------
                //history trace
                //-----------
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST  //intermediate
                char cData[500];
                snprintf(cData,sizeof(cData),"SetMalfunctionUSBConnector(...): bIsMalfunction:0x%x at USB%d, tenTypeOFMalfunction: 0x%x",bIsMalfunction,eUsbConnectorNum, eTypeOFMalfunction);
                HWMALFUNCTIONHISTORY.AddToHistory(GENSTRING(cData),NULL);
#endif
                //--------------
                //send it
                //--------------
                if(bSend)
                {
                    util_StructQInfo    *pMsgQInfo=&m_msgQ;
                    util_vSendMsg2Q(pMsgQInfo,&oMsg);
                }
            }
        }
        else
        {
            ETG_TRACE_USR4(("SetMalfunctionUSBConnector: The Configuration value eConf_ENABLE_MALFUNCTION_USBCONNECTORS is set to OFF. Not doing anything " ));
        }
    }
    ETG_TRACE_USR4(("End    : SetMalfunctionUSBConnector"));
}



/*-----------------------------------------------------------------------------*
 *void StateTabler::SetMalfunctionOpticalDisc(...)                             *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::SetMalfunctionOpticalDisc(IN tBool bIsMalfunction)
{
    ETG_TRACE_USR4(("Begin : SetMalfunctionOpticalDisc"));
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
    {
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_CDROMINTERNAL))
        {
            ETG_TRACE_COMP(("->################### SetMalfunctionOpticalDisc #####################"));
            ETG_TRACE_USR4(("SetMalfunctionOpticalDisc: bIsMalfunction          : %d", ETG_ENUM(TBOOL, bIsMalfunction) ));
            util_StructMsg oMsg;
            tBool bSend = SetFillMalfunctionOpticalDisc(IN bIsMalfunction,OUT oMsg); //this function has been established to offer unittesting of state table

            //-----------
            //history trace
            //-----------
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST  //intermediate
            char cData[500];
            snprintf(cData,sizeof(cData),"SetMalfunctionOpticalDisc(...): bIsMalfunction:0x%x at USB%d, tenTypeOFMalfunction: 0x%x",bIsMalfunction,eUSBUndef, enMalfunctionOpticalDisc);
            HWMALFUNCTIONHISTORY.AddToHistory(GENSTRING(cData),NULL);
#endif

            //--------------
            //send it
            //--------------
            if(bSend)
            {
                util_StructQInfo    *pMsgQInfo=&m_msgQ;
                util_vSendMsg2Q(pMsgQInfo,&oMsg);
            }

        }
        else
        {
            ETG_TRACE_USR4(("SetMalfunctionOpticalDisc: The Configuration value eConf_ENABLE_MALFUNCTION_CDROMINTERNAL is set to OFF. Not doing anything " ));
        }
    }
    ETG_TRACE_USR4(("End   : SetMalfunctionOpticalDisc"));
}
/*-----------------------------------------------------------------------------*
 *void StateTabler::SetMalfunctionSDCardInternal(...)                          *
 *-----------------------------------------------------------------------------*/
tVoid StateTable::SetMalfunctionSDCardInternal(IN tBool bIsMalfunction)
{
    ETG_TRACE_USR4(("Begin : SetMalfunctionSDCardInternal"));
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
    {
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_MALFUNCTION_SDCARDINTERNAL))
        {
            ETG_TRACE_COMP(("->################### SetMalfunctionSDCardInternal #####################"));
            ETG_TRACE_USR4(("SetMalfunctionSDCardInternal: bIsMalfunction          : %d", ETG_ENUM(TBOOL, bIsMalfunction) ));
            util_StructMsg oMsg;
            tBool bSend = SetFillMalfunctionSDCardInternal(IN bIsMalfunction,OUT oMsg); //this function has been established to offer unittesting of state table
            //--------------
            //send it
            //--------------
            if(bSend)
            {
                util_StructQInfo    *pMsgQInfo=&m_msgQ;
                util_vSendMsg2Q(pMsgQInfo,&oMsg);
            }

        }
        else
        {
            ETG_TRACE_USR4(("SetMalfunctionSDCardInternal: The Configuration value eConf_ENABLE_MALFUNCTION_SDCARDINTERNAL is set to OFF. Not doing anything " ));
        }
    }
    ETG_TRACE_USR4(("End   : SetMalfunctionSDCardInternal"));

}

/*-----------------------------------------------------------------------------*
 *tBool StateTabler::SetFillMalfunctionUSBConnector(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tBool StateTable::SetFillMalfunctionUSBConnector(IN tBool bIsMalfunction, IN tenDevManagerUSBHost UsbConnectorNum, IN tenTypeOFMalfunction eTypeOFMalfunction, OUT util_StructMsg &oMsg)
{
    ETG_TRACE_USR4(("Begin : SetFillMalfunctionUSBConnector"));
    tBool bRet = FALSE;
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
    {    structNotifyMalfunction oNotifyMalfunction;
        //prepare to send to Q
        oMsg.eMsgType   = enMalfunctionUsbConnector;
        oMsg.u16LenCont = sizeof(structNotifyMalfunction);
        //The below code is written to support the diagnosis part.
        //statetable will use the struct m_signal to send the OC status to diaglog
        //Only filling the field m_signal[UsbConnectorNum].OC because diaglog needs this info only to set the DTC
        if(eTypeOFMalfunction == eIsMalfunction) //see NCG3D-14362
        {
            if(TRUE == bIsMalfunction)
            {
                m_signal[UsbConnectorNum].OC = SIG_TRUE;
                m_signal[UsbConnectorNum].PPON = SIG_FALSE;

            }
            else
            {
                m_signal[UsbConnectorNum].OC = SIG_FALSE;
                m_signal[UsbConnectorNum].PPON = SIG_TRUE;
            }
            ETG_TRACE_USR4(("SetFillMalfunctionUSBConnector: set  m_signal[%d].OC = %d",(int)UsbConnectorNum,m_signal[UsbConnectorNum].OC));
        }


        if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
        {
            ETG_TRACE_FATAL(("ERROR: SetFillMalfunctionUSBConnector: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
            oMsg.u16LenCont=0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            oNotifyMalfunction.bIsMalfunction     = bIsMalfunction;
            oNotifyMalfunction.eUSB               = UsbConnectorNum;
            oNotifyMalfunction.eTypeOFMalfunction = eTypeOFMalfunction;

            memcpy(&(oMsg.pu8Content[0]),&oNotifyMalfunction,sizeof(structNotifyMalfunction));
            //send it ok
            bRet = TRUE;
        }
    }
    ETG_TRACE_USR4(("End   : SetFillMalfunctionUSBConnector"));
    return bRet;
}



/*-----------------------------------------------------------------------------*
 *tBool StateTabler::SetFillMalfunctionSDCardInternal(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tBool StateTable::SetFillMalfunctionSDCardInternal (IN tBool bIsMalfunction, OUT util_StructMsg &oMsg)
{
    ETG_TRACE_USR4(("Begin : SetFillMalfunctionSDCardInternal"));
    tBool bRet = FALSE;
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
    {
        structNotifyMalfunction oNotifyMalfunction;
        //prepare to send to Q
        oMsg.eMsgType   = enMalfunctionSDCardInternal;
        oMsg.u16LenCont = sizeof(structNotifyMalfunction);

        if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
        {
           ETG_TRACE_FATAL(("ERROR: SetFillMalfunctionSDCardInternal: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
           oMsg.u16LenCont=0;
           DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
           oNotifyMalfunction.bIsMalfunction = bIsMalfunction;
           oNotifyMalfunction.eUSB = eUSBUndef;

           memcpy(&(oMsg.pu8Content[0]),&oNotifyMalfunction,sizeof(structNotifyMalfunction));
           //send it ok
           bRet = TRUE;
        }
    }
    ETG_TRACE_USR4(("End   : SetFillMalfunctionSDCardInternal"));

   return bRet;
}

/*-----------------------------------------------------------------------------*
 *tBool StateTabler::SetFillMalfunctionOpticalDisc(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tBool StateTable::SetFillMalfunctionOpticalDisc(IN tBool bIsMalfunction, OUT util_StructMsg &oMsg)
{
    ETG_TRACE_USR4(("Begin : SetFillMalfunctionOpticalDisc"));
    tBool bRet = FALSE;
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
    {
        structNotifyMalfunction oNotifyMalfunction;
        //prepare to send to Q
        oMsg.eMsgType   = enMalfunctionOpticalDisc;
        oMsg.u16LenCont = sizeof(structNotifyMalfunction);

        if(oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN)
        {
            ETG_TRACE_FATAL(("ERROR: SetFillMalfunctionOpticalDisc: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)",oMsg.u16LenCont,(tU16)UTIL_MAX_CONTENT_LEN));
            oMsg.u16LenCont=0;
            DVM_NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            oNotifyMalfunction.bIsMalfunction = bIsMalfunction;
            oNotifyMalfunction.eUSB = eUSBUndef;

            memcpy(&(oMsg.pu8Content[0]),&oNotifyMalfunction,sizeof(structNotifyMalfunction));
            //send it ok
            bRet = TRUE;
        }
    }
    ETG_TRACE_USR4(("End   : SetFillMalfunctionOpticalDisc"));
    return bRet;
}



#ifndef USE_HIGHRISK4USB_HWMALFUNCTION
/*-----------------------------------------------------------------------------*
 *void StateTabler::StoreMalfunctionUSBConnectorWithTimeStamp(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/

tVoid StateTable::StoreMalfunctionUSBConnectorWithTimeStamp(IN tBool bIsMalfunction,
          IN tenDevManagerUSBHost eusb)
{
    ETG_TRACE_USR4(("Begin : StoreMalfunctionUSBConnectorWithTimeStamp"));

    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
    {

        tS32 s32MalfunctionElapsedTime_sec = MALFUNCTION_NO;
        if(TRUE == bIsMalfunction)
        {
            //check if at corresponding USB connector malfunction has already happened
            if(TRUE == DeviceListManager::GetInstance()->GetMalfunctionTimeStampForDevices(IN  eusb,OUT s32MalfunctionElapsedTime_sec))
            {
                //already malfunction means
                if(s32MalfunctionElapsedTime_sec != MALFUNCTION_NO)
                {
#ifdef USR_BUGFIX_UPDATEMALFUNCTION
                    s32MalfunctionElapsedTime_sec = s32MalfunctionElapsedTime_sec; //i.e. nothing is changed here
#else
                    s32MalfunctionElapsedTime_sec+= MALFUNCTIONUPDATEINTERVAL; //tbd.: check if this is obsolete
#endif
                }
                else
                {
                    s32MalfunctionElapsedTime_sec = MALFUNCTION_YES;
                    tU64 u64MalfunctionTimeStamp = ConfigurationManager::GetInstance()->GetEclapsedTime_ms();
                    DeviceListManager::GetInstance()->vStoreMalfunctionTimeStamp(eusb,u64MalfunctionTimeStamp); //this  stores the malfunction

                }
            }
        }
        DeviceListManager::GetInstance()->UpdateMalfunctionInfoWithTimeStamp(eusb,s32MalfunctionElapsedTime_sec);
    }


    ETG_TRACE_USR4(("End   : StoreMalfunctionUSBConnectorWithTimeStamp"));
}



/*-----------------------------------------------------------------------------*
 *void StateTabler::StoreHighRiskForMalfunctionUSBConnectorWithTimeStamp(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tVoid StateTable::StoreHighRiskForMalfunctionUSBConnectorWithTimeStamp(IN tBool bIsMalfunction)
{
    ETG_TRACE_USR4(("Begin : StoreHighRiskForMalfunctionUSBConnectorWithTimeStamp"));

    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
    {
        if(TRUE == bIsMalfunction)
        {
            tU64 u64highRiskForMalfunctionTimeStamp = ConfigurationManager::GetInstance()->GetEclapsedTime_ms();
            DeviceListManager::GetInstance()->vStoreHighRiskForMalfunctionTimeStamp(u64highRiskForMalfunctionTimeStamp);

            //there might be old malfunction stored with some of the connectors but this trigger e.g. bound to critical voltage reset malfunctionto be started now
            // for all connectors if next time vCASEenTimerExp is called this is taken into account
            for(int eusb=(int)eUSB1; eusb<(int)eUSBAll; eusb++)
            {
                DeviceListManager::GetInstance()->UpdateMalfunctionInfoWithTimeStamp((tenDevManagerUSBHost)eusb, MALFUNCTION_YES);
            }
        }
    }
    ETG_TRACE_USR4(("End   : StoreHighRiskForMalfunctionUSBConnectorWithTimeStamp"));
}

#endif //USE_HIGHRISK4USB_HWMALFUNCTION

/*-----------------------------------------------------------------------------*
 *tVoid StateTable::vMonitoringForMalfunctionPermanent(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tVoid  StateTable::vMonitoringForMalfunctionPermanent()
{
    ETG_TRACE_USR4(("vMonitoringForMalfunctionPermanent: MALFUNCTIONUPDATEINTERVAL: %d",(tU16)MALFUNCTIONUPDATEINTERVAL));


#ifdef USE_HIGHRISK4USB_HWMALFUNCTION

    tBool bHasIncremented = DeviceListManager::GetInstance()->bCheckIncrementMalfunctionEclapsedTimeAllDevices(MALFUNCTIONUPDATEINTERVAL);
    if(bHasIncremented)
    {
        //=========================================================
        //the timer will call the function vCASEenTimerExp, which will Update the clients
        //=========================================================
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
        this->vTriggerTimer();
#endif //VARIANT_S_FTR_ENABLE_UNITTEST
    }
#else //USE_HIGHRISK4USB_HWMALFUNCTION


    CGlobalEnumerations::DEVICE_TYPE_Type l_eDeviceType;
    tInt iSend = 0;
    tS32 s32MalfunctionElapsedTime_sec = MALFUNCTION_NO;
    //---------------------------------------------------------
    //Check whether the Malfunction is present any of the USB connectors
    //---------------------------------------------------------
    if(TRUE == m_bHasMalfunctionUsbConnector)
    {
        //Iterates and find out which USB connector has malfunction
        for(tInt eusb = (tInt)eUSB1; eusb < (tInt)eUSBAll; eusb++)
        {

            if( TRUE == m_oNotifyMalfunction[eusb].bIsMalfunction && eusb == m_oNotifyMalfunction[eusb].eUSB)
            {
                if(TRUE == DeviceListManager::GetInstance()->GetMalfunctionTimeStampForDevices(IN  (tenDevManagerUSBHost)eusb,OUT s32MalfunctionElapsedTime_sec))
                {
                    if(s32MalfunctionElapsedTime_sec != MALFUNCTION_NO)
                    {
                        s32MalfunctionElapsedTime_sec+= MALFUNCTIONUPDATEINTERVAL; //increase value by the time of the monitoring interval
                    }
                    else
                    {
                        s32MalfunctionElapsedTime_sec = MALFUNCTION_YES;
                    }
                }

                //Update the time stamp of malfunction in the devices connected to the port
                DeviceListManager::GetInstance()->UpdateMalfunctionInfoWithTimeStamp((tenDevManagerUSBHost)eusb,s32MalfunctionElapsedTime_sec);
                ETG_TRACE_USR4(("vMonitoringForMalfunctionPermanent Malfunction at port %d, Updating the duration of malfunction ",ETG_ENUM(TENDEVMANAGERUSBHOSTeUSB,eusb)));
                iSend++;
            }
        }

    }

    //---------------------------------------------------------
    // check if  malfunction is preset with optical disc
    //---------------------------------------------------------
    else if(TRUE == m_bHasMalfunctionOpticalDisc)
    {

        //checking the malfunction at optical disc
        vSetOpticalDiscDeviceType(OUT l_eDeviceType);
        if(TRUE == DeviceListManager::GetInstance()->GetMalfunctionTimeStampForDevices(IN  l_eDeviceType,OUT s32MalfunctionElapsedTime_sec))
        {
            if(s32MalfunctionElapsedTime_sec != MALFUNCTION_NO)
            {
                s32MalfunctionElapsedTime_sec+= MALFUNCTIONUPDATEINTERVAL;
            }
            else
            {
                s32MalfunctionElapsedTime_sec = MALFUNCTION_YES;
            }
            iSend++;
        }
        //Update the time stamp of malfunction in the devices connected to the port
        DeviceListManager::GetInstance()->UpdateMalfunctionInfoWithTimeStamp(l_eDeviceType,s32MalfunctionElapsedTime_sec);
        ETG_TRACE_USR4(("vMonitoringForMalfunctionPermanent Malfunction at Optical disc, Updating the duration of malfunction "));


    }

    //---------------------------------------------------------------------------------
    // check if  malfunction is preset with internal SD Card bound to special Card reader (not linked to USB)
    //---------------------------------------------------------------------------------
    else if(TRUE == m_bHasMalfunctionSDInternal)
    {
        //checking the malfunction at SD Card Internal
        vSetSDInternalDeviceType(l_eDeviceType);
        if(TRUE == DeviceListManager::GetInstance()->GetMalfunctionTimeStampForDevices(IN  l_eDeviceType,OUT s32MalfunctionElapsedTime_sec))
        {
            if(s32MalfunctionElapsedTime_sec != MALFUNCTION_NO)
            {
                s32MalfunctionElapsedTime_sec+= MALFUNCTIONUPDATEINTERVAL;
            }
            else
            {
                s32MalfunctionElapsedTime_sec = MALFUNCTION_YES;
            }
            iSend++;
        }
        //Update the time stamp of malfunction in the devices connected to the port
        DeviceListManager::GetInstance()->UpdateMalfunctionInfoWithTimeStamp(l_eDeviceType,s32MalfunctionElapsedTime_sec);
        ETG_TRACE_USR4(("vMonitoringForMalfunctionPermanent Malfunction at SD Internal, Updating the duration of malfunction "));


    }
    //-------------
    //error case
    //------------
    else
    {
        ETG_TRACE_USR4(("vMonitoringForMalfunctionPermanent Should not have come here!!!"));
    }
    if(iSend > 0)
    {
        ETG_TRACE_USR4(("vMonitoringForMalfunctionPermanent Trigger timer for sending Permanent Malfunction."));

        //=========================================================
        //the timer will call the function vCASEenTimerExp, which will Update the clients
        //=========================================================
        this->vTriggerTimer();
    }

#endif //USE_HIGHRISK4USB_HWMALFUNCTION
    ETG_TRACE_USR4(("End  vMonitoringForMalfunctionPermanent "));

}

/*-----------------------------------------------------------------------------*
 *tBool StateTable::isADevicePermanentMalfunction(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tBool StateTable::isADevicePermanentMalfunction(IN tenDevManagerUSBHost eusb)
{
    ETG_TRACE_USR4(("isADevicePermanentMalfunction Fetch the device Updated Malfunction time stamp"));
    tS32 s32MalfunctionElapsedTime_sec;
    tBool bHasMalfunctionPermanent = FALSE;
    tS32 s32MalfunctionPermanentConfigVal = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_TIMOUT_MALFUNCTION_SET_PERMANENT);
    if( DVM_OFF != s32MalfunctionPermanentConfigVal)
    {
        if(TRUE == DeviceListManager::GetInstance()->GetMalfunctionTimeStampForDevices(eusb,s32MalfunctionElapsedTime_sec))
        {
            if(s32MalfunctionElapsedTime_sec > s32MalfunctionPermanentConfigVal)
            {
                ETG_TRACE_USR4(("isADevicePermanentMalfunction Device Connected at the port %d has permanent malfunction!!! ",ETG_ENUM(TENDEVMANAGERUSBHOSTeUSB,eusb)));
                bHasMalfunctionPermanent = TRUE;
            }
        }
    }
    return bHasMalfunctionPermanent;
}


/*-----------------------------------------------------------------------------*
 *tBool StateTable::isADevicePermanentMalfunction(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tBool StateTable::isADevicePermanentMalfunction(IN CGlobalEnumerations::DEVICE_TYPE_Type f_eDeviceType)
{
    ETG_TRACE_USR4(("isADevicePermanentMalfunction Fetch the device Updated Malfunction time stamp"));
    tS32 s32MalfunctionElapsedTime_sec;
    tBool bHasMalfunctionPermanent = FALSE;
    tS32 s32MalfunctionPermanentConfigVal = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_TIMOUT_MALFUNCTION_SET_PERMANENT);
    if( DVM_OFF != s32MalfunctionPermanentConfigVal)
    {
        if(TRUE == DeviceListManager::GetInstance()->GetMalfunctionTimeStampForDevices(f_eDeviceType,s32MalfunctionElapsedTime_sec))
        {
            ETG_TRACE_USR4(("isADevicePermanentMalfunction Device s32MalfunctionElapsedTime_sec %d   s32MalfunctionPermanentConfigVal %d", s32MalfunctionElapsedTime_sec,s32MalfunctionPermanentConfigVal))
            if(s32MalfunctionElapsedTime_sec > s32MalfunctionPermanentConfigVal)
            {
                ETG_TRACE_USR4(("isADevicePermanentMalfunction Device type %d has permanent malfunction!!! ",ETG_ENUM(DVM_DEVICE_TYPE,f_eDeviceType)));
                bHasMalfunctionPermanent = TRUE;
            }
        }
    }
    return bHasMalfunctionPermanent;
}

/*-----------------------------------------------------------------------------*
 *void StateTable::bIsRemovedCausedByMalfunction(...) THREAD FUNCTION
 *-----------------------------------------------------------------------------*/
tBool StateTable::bIsRemovedCausedByMalfunction(IN tenDevManagerUSBHost UsbConnectorNum)
{
    ETG_TRACE_USR4(("Begin : bIsRemovedCausedByMalfunction"));
    tBool bHasMalfunction = FALSE;
    if(ConfigurationManager::GetInstance()->bIsEnabled_IStateTableHWMalfunction())
    {
       bHasMalfunction =  DeviceListManager::GetInstance()->bIsRemovedCausedByMalfunction(UsbConnectorNum);
       ETG_TRACE_USR4(("End   : bIsRemovedCausedByMalfunction"));
    }
    return bHasMalfunction;
}
/*-----------------------------------------------------------------------------*
*tBool StateTable::bIsMalfunctionOccuredAtDevices(...) THREAD FUNCTION
*-----------------------------------------------------------------------------*/
tBool StateTable::bIsMalfunctionOccuredAtDevices(const CGlobalEnumerations::DEVICE_TYPE_Type f_eDeviceType) const
{
   tBool l_bHasMalfunctionOpticalDisc = FALSE;
   ETG_TRACE_USR4(("bIsMalfunctionOccuredAtOpticalDisc: Checking the Malfunction of Devices"));
   tS32 s32MalfunctionElapsedTime_sec = 0;
   if(TRUE == DeviceListManager::GetInstance()->GetMalfunctionTimeStampForDevices(f_eDeviceType,s32MalfunctionElapsedTime_sec))
   {
       if(MALFUNCTION_NO != s32MalfunctionElapsedTime_sec)
       {
           ETG_TRACE_USR4(("bIsMalfunctionOccuredAtOpticalDisc: Malfunction of OpticalDisc started at the %d secs",s32MalfunctionElapsedTime_sec));
           l_bHasMalfunctionOpticalDisc = TRUE;
       }
   }
   return l_bHasMalfunctionOpticalDisc;
}



/*-----------------------------------------------------------------------------*
*tVoid vSetSDInternalDeviceType(...) THREAD FUNCTION
*-----------------------------------------------------------------------------*/
tVoid StateTable::vSetSDInternalDeviceType(OUT CGlobalEnumerations::DEVICE_TYPE_Type &f_eDeviceType)
{
   ETG_TRACE_USR4(("Begin : vSetSDInternalDeviceType"));
   f_eDeviceType = CGlobalEnumerations::DTY_SD_INTERNAL;
   ETG_TRACE_USR4(("End   : vSetSDInternalDeviceType"));
}


/*-----------------------------------------------------------------------------*
*tVoid vSetOpticalDiscDeviceType(...) THREAD FUNCTION
*-----------------------------------------------------------------------------*/
tVoid StateTable::vSetOpticalDiscDeviceType(OUT CGlobalEnumerations::DEVICE_TYPE_Type &f_eDeviceType)
{
   ETG_TRACE_USR4(("Begin : vSetOpticalDiscDeviceType"));
   DeviceListManager::GetInstance()->GetOpticalDiscDeviceType(f_eDeviceType);
   ETG_TRACE_USR4(("End   : vSetOpticalDiscDeviceType"));

}

#ifndef USE_HIGHRISK4USB_HWMALFUNCTION
/*------------------------------------------------------------------*
*void StateTabler::vDecideConnectStatusUsbConnector(...)           *
*------------------------------------------------------------------*/
tVoid StateTable::vDecideConnectStatusUsbConnector(IN tenDevManagerUSBHost eusb,OUT DEVICE_CONNECTSTATUS_E &f_eConnectStatus)
{

    if(TRUE == isADevicePermanentMalfunction(eusb))
    {
        f_eConnectStatus = USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT;
    }
    else if(TRUE == m_oNotifyMalfunction[eusb].bIsMalfunction)
    {
        f_eConnectStatus = USB_DEV_UNAVAIL_HW_MALFUNC;
    }
    else
    {
        f_eConnectStatus = USB_DEV_CONNECTED;
    }
    ETG_TRACE_USR4(("vDecideConnectStatusUsbConnector Connection Status: %d for Usb Connector : %d",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,f_eConnectStatus), ETG_ENUM(TENDEVMANAGERUSBHOST,eusb)));

}


#endif


/*------------------------------------------------------------------*
*void StateTabler::vDecideConnectStatusDevices(...)                 *
*-------------------------------------------------------------------*/
tVoid StateTable::vDecideConnectStatusDevices(IN CGlobalEnumerations::DEVICE_TYPE_Type f_eDeviceType,OUT DEVICE_CONNECTSTATUS_E &f_eConnectStatus)
{

    //Initialize the connect status
    f_eConnectStatus = USB_DEV_UNDEFINED;

    switch(f_eDeviceType)
    {
       case CGlobalEnumerations::DTY_CDROM:
       case CGlobalEnumerations::DTY_CDDA:
       case CGlobalEnumerations::DTY_SD_INTERNAL:
        if(TRUE == isADevicePermanentMalfunction(f_eDeviceType))
        {
            f_eConnectStatus = USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT;
        }
        else if((CGlobalEnumerations::DTY_SD_INTERNAL == f_eDeviceType && TRUE == m_bHasMalfunctionSDInternal)
        ||((CGlobalEnumerations::DTY_CDROM == f_eDeviceType || CGlobalEnumerations::DTY_CDDA == f_eDeviceType)
                &&  TRUE == m_bHasMalfunctionOpticalDisc))
        {
            f_eConnectStatus = USB_DEV_UNAVAIL_HW_MALFUNC;
        }
        else
        {
            f_eConnectStatus = USB_DEV_CONNECTED;
        }
        break;
       default:
           ETG_TRACE_USR4(("vDecideConnectStatusDevices Unexpected Device type : %d", ETG_ENUM(DVM_DEVICE_TYPE,f_eDeviceType)));
           break;
    }
    ETG_TRACE_USR4(("vDecideConnectStatusDevices Connection Status: %d for Device type : %d",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,f_eConnectStatus), ETG_ENUM(DVM_DEVICE_TYPE,f_eDeviceType)));

}


/*------------------------------------------------------------------------------------------------------------------------*
 * tBool setOpticalDiscCDInfoNotifiedFill(...)*
 *------------------------------------------------------------------------------------------------------------------------*/
tBool StateTable::setOpticalDiscCDInfoNotifiedFill(IN tenMsgTyp eMsgType,IN trOpticalDiskCDInfo f_OpticalDiskCDInfo,OUT util_StructMsg &oMsg)
{
    tBool bRet = FALSE;

    //prepare to send to Q
    oMsg.eMsgType   = eMsgType;
    oMsg.u16LenCont = sizeof(trOpticalDiskCDInfo);
    if( oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN )
    {
        ETG_TRACE_FATAL(( "[ERROR]: setOpticalDiscCDInfoNotifiedFill: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)", oMsg.u16LenCont, (tU16)UTIL_MAX_CONTENT_LEN) );
        oMsg.u16LenCont = 0;
        DVM_NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {
        ETG_TRACE_USR4(("Begin: vSetOpticalDiscCDInfoNotified"));
        memcpy( &(oMsg.pu8Content[0]), &f_OpticalDiskCDInfo, sizeof(trOpticalDiskCDInfo) );
        ETG_TRACE_USR4(("setOpticalDiscCDInfoNotifiedFill f_OpticalDiskCDInfo.OpticalDriveVersion:%s",f_OpticalDiskCDInfo.OpticalDriveVersion))
        bRet = TRUE;

    }
    return bRet;
}

/*-------------------------------------------------------------------------------------------*
tVoid vSetOpticalDiscCDInfoNotified(...) *
*--------------------------------------------------------------------------------------------*/

tVoid StateTable::vSetOpticalDiscCDInfoNotified(IN tenMsgTyp eMsgType, IN trOpticalDiskCDInfo f_OpticalDiskCDInfo)
{

    util_StructQInfo    *pMsgQInfo=&m_msgQ;

    ETG_TRACE_USR4(("Begin: vSetOpticalDiscCDInfoNotified"));
    ETG_TRACE_COMP(("->################### vSetOpticalDiscCDInfoNotified:,%d,%d #####################",
                    ETG_ENUM(TENMSGTYP,eMsgType),
                    ETG_ENUM(VD_DVM_OPTDISC_DEVICESTATE,f_OpticalDiskCDInfo.OpticalDeviceState)));

    ETG_TRACE_USR4(("vSetOpticalDiscCDInfoNotified f_OpticalDiskCDInfo.OpticalDriveVersion:%s",f_OpticalDiskCDInfo.OpticalDriveVersion))


    /*send to MsgQ received in StateTable::vThreadFunction */

    util_StructMsg oMsg;
    tBool bSend = setOpticalDiscCDInfoNotifiedFill(IN eMsgType, IN  f_OpticalDiskCDInfo,OUT oMsg);
    //--------------
    //send it
    //--------------
    if(bSend)
    {
        pMsgQInfo=&m_msgQ;
        util_vSendMsg2Q(pMsgQInfo,&oMsg);
        ETG_TRACE_USR4(("vSetOpticalDiscCDInfoNotified Sending util_vSendMsg2Q "));
    }

    ETG_TRACE_USR4(("End  : vSetOpticalDiscCDInfoNotified"));
}

/*------------------------------------------------------------------------------*
tVoid vSetPortPowerStateNotified(...)                                                   *
*-------------------------------------------------------------------------------*/
tVoid StateTable::vSetPortPowerStateNotified(IN tenMsgTyp eMsgType, IN const trPortStates &f_rPortState)
{
    util_StructQInfo    *pMsgQInfo=&m_msgQ;

    ETG_TRACE_USR4(("Begin: vSetPortPowerStateNotified"));
    ETG_TRACE_COMP(("->################### vSetPortPowerStateNotified:,%d,USBPORT=%d IsPowerON=%d #####################",
                    ETG_ENUM(TENMSGTYP,eMsgType),
                    ETG_ENUM(USBCONNECTOR,f_rPortState.u8USBPortNo),
                    ETG_ENUM(TBOOL,f_rPortState.bUSBPowerON)));




    /*send to MsgQ received in StateTable::vThreadFunction */

    util_StructMsg oMsg;
    tBool bSend = SetPortPowerStateNotifiedFill(IN eMsgType, IN  f_rPortState,OUT oMsg);
    //--------------
    //send it
    //--------------
    if(bSend)
    {
        pMsgQInfo=&m_msgQ;
        util_vSendMsg2Q(pMsgQInfo,&oMsg);
        ETG_TRACE_USR4(("vSetPortPowerStateNotified Sending util_vSendMsg2Q "));
    }

    ETG_TRACE_USR4(("End  : vSetPortPowerStateNotified"));

}

/*------------------------------------------------------------------------------*
tVoid SetPortPowerStateNotifiedFill(...)                                                   *
*-------------------------------------------------------------------------------*/
tBool StateTable::SetPortPowerStateNotifiedFill(IN tenMsgTyp eMsgType,IN trPortStates  f_rPortState,OUT util_StructMsg &oMsg)
{
    tBool bRet = FALSE;

     //prepare to send to Q
     oMsg.eMsgType   = eMsgType;
     oMsg.u16LenCont = sizeof(trPortStates);
     if( oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN )
     {
         ETG_TRACE_FATAL(( "[ERROR]: vSetPortPowerStateNotifiedFill: oMsg.u16LenCont>UTIL_MAX_CONTENT_LEN  (%d > %d)", oMsg.u16LenCont, (tU16)UTIL_MAX_CONTENT_LEN) );
         oMsg.u16LenCont = 0;
         DVM_NORMAL_M_ASSERT_ALWAYS();
     }
     else
     {

         memcpy( &(oMsg.pu8Content[0]), &f_rPortState, sizeof(trPortStates) );
         ETG_TRACE_USR4(("vSetPortPowerStateNotifiedFill f_rPortState.u8USBPortNo:%d f_rPortState.bUSBPowerON:%d",ETG_ENUM(USBCONNECTOR,f_rPortState.u8USBPortNo),ETG_ENUM(TBOOL,f_rPortState.bUSBPowerON)))
         bRet = TRUE;

     }
     return bRet;

}

tVoid StateTable::vCASEenPortPowerInfoNotified(IN const util_StructMsg &oMsg)
{
    ETG_TRACE_COMP(("************->case enPortPowerInfoNotified********************"));

    trPortStates   l_rPortState;
    memcpy( &l_rPortState  , &oMsg.pu8Content[0],sizeof(trPortStates));
    ETG_TRACE_USR4(("vCASEenPortPowerInfoNotified: Filling the port power state: l_rPortState.u8USBPortNo:%d l_rPortState.bUSBPowerON:%d",ETG_ENUM(USBCONNECTOR,l_rPortState.u8USBPortNo),ETG_ENUM(TBOOL,l_rPortState.bUSBPowerON)));
    if( ( DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue((tenDevManagerConfigValue)((tUInt)eCONF_ENABLE_HW_USB1+(l_rPortState.u8USBPortNo-1))) ) ||
        ( DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue((tenDevManagerConfigValue)((tUInt)eConf_ENABLE_TELEMATICSBOX_USB1+(l_rPortState.u8USBPortNo-1))) )
      )
    {
        l_rPortState.bUSBPortConfiguredUsed = TRUE;
    }


    PortListManager::GetInstance()->vSetPortPowerState(l_rPortState);

    PortListManager::GetInstance()->vShowHardwareSignals();




    ETG_TRACE_COMP(("************case enPortPowerInfoNotified<-********************"));

}


/*-------------------------------------------------------------------------------------------*
tVoid vRetryForAllPartitionMounted(...) *
*--------------------------------------------------------------------------------------------*/

tVoid StateTable::vRetryForAllPartitionMounted()
{

    ETG_TRACE_USR4(("Begin: vRetryForAllPartitionMounted"));

    if(TRUE == DeviceListManager::GetInstance()->isAllPartitionsRetried())
    {
        ETG_TRACE_USR4(("vRetryForAllPartitionMounted isAllPartitionsRetried = TRUE"));
        vTriggerTimer();
    }
    else
    {
        ETG_TRACE_USR4(("vRetryForAllPartitionMounted isAllPartitionsRetried = FALSE"));
    }

    ETG_TRACE_USR4(("End  : vRetryForAllPartitionMounted"));
}
/*-------------------------------------------------------------------------------------------*
tVoid vRetryForDeviceTypeConnected(...) *
*--------------------------------------------------------------------------------------------*/
tVoid StateTable::vRetryForDeviceTypeConnected(IN  CGlobalEnumerations::DEVICE_TYPE_Type f_eDeviceType)
{
    ETG_TRACE_USR4(("Begin: vRetryForDeviceTypeConnected"));

    if(TRUE == DeviceListManager::GetInstance()->UpdateDeviceTypeIfRetryCompleted(f_eDeviceType,ConfigurationManager::GetInstance()->GetEclapsedTime_ms()))
    {
        ETG_TRACE_USR4(("vRetryForDeviceTypeConnected isRetryCompletedForDeviceType = TRUE"));
        vTriggerTimer();
    }
    ETG_TRACE_USR4(("End: vRetryForDeviceTypeConnected"));

}
/*-------------------------------------------------------------------------------------------*
tVoid vStopRetryForDevice(IN GENSTRING fSerialID)
*--------------------------------------------------------------------------------------------*/
tVoid StateTable::vStopRetryForDevice(IN GENSTRING fSerialID)
{
    ETG_TRACE_USR4(("Begin: vStopRetryForDevice"));
    if(TRUE == DeviceListManager::GetInstance()->vStopRetryForDevice(fSerialID))
    {
        ETG_TRACE_USR4(("vStopRetryForDevice stopped the retrial of the device(s)"));
        vTriggerTimer();

    }

    ETG_TRACE_USR4(("End: vStopRetryForDevice"));
}
////////////////////////////////////////////////////////////////////////////////
// <EOF>
