/*-----------------------------------------------------------------------------*
 * IStateTableHWSignals.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IStateTableHWSignals.h
 *
 * \brief Interface used by VoltageManager to inform StateTable
 *
 * \version 25.09.2014, Koechling Christian (CM-AI/ECD1), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef INTERFCACE_STATETABLE_HARDWARESIGNALS_H
#define INTERFCACE_STATETABLE_HARDWARESIGNALS_H  


/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace prmmgr;


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class IStateTableHWSignals
 */

class IStateTableHWSignals
{
    public:

        /*!
         * \brief Destructor
         */
        virtual ~IStateTableHWSignals(){};


        /*!
         * \brief Get latest output of state machine for a certain usb connector.
         *
         * This output is used as basis to inform clients about the new state
         * of all devices connected to that connector.
         *
         * \param [in]  usb      connector i.e. usb1 or usb2 ...
         * \param [out] pMessage value will be filled for caller with latest result
         */
        virtual tVoid getLastMsgSendtoClients(tenDevManagerUSBHost usb,voltageFailure_Result_t *pMessage) const = 0;


        /*!
         * \brief show current HW signals
         *
         * \param [in]  usb      provide result for connector usb i.e.USB1 or USB2 ...
         * \param [out] pSignal  current state will be copied to this (i.e.
         *               holds return value)
         */
        virtual tVoid getSignals(tenDevManagerUSBHost usb,voltageFailure_HWSignalsAll_t *pSignal) = 0;


        /*!
         * \brief Used by prm to set HW signals i.e. these are written into a
         *        queue and this queue is read by StartMonitorFunction of this
         *        component - see see 'case enHWSignals'
         *
         *  \param [in] pPortState
         */
        virtual tVoid setHWSignals(UsbPortState *pPortState) = 0;

        /*!
         * \brief Used by prm to set Card signals i.e. these are written into a
         *        queue and this queue is read by StartMonitorFunction of this
         *        component - see see 'case enCardSignals'
         *
         *  \param [in] f_enConnected: SIG_TRUE: connected SG_FALSE:ejected
         *  \param [in] f_strDeviceName: UUID
         *  \param[IN] f_u16MediaType received from prm
         */

        virtual tVoid SetCardSignals(IN tenSignalValue f_enConnected, IN tChar (&f_strDeviceName)[STRING_LENGTH],tU16 f_u16MediaType) = 0;

        /*!
              * \brief Used by GPIOIF to notifiy overcurrent for internal SDCard i.e. SDCard at internal Card reader
              *  \param[IN] pInfo : card and status
              */

        virtual tVoid setCardOverCurrentStatus( const CardNotInfoOcStatus* pInfo ) = 0;


    protected:
        
           virtual tBool setHWSignalsFill(IN const UsbPortState *pPortState, OUT util_StructMsg &oMsg) = 0;

           virtual tBool SetCardSignalsFill(IN tenSignalValue f_enConnected, IN tChar (&f_strDeviceName)[STRING_LENGTH], IN tU16 f_u16MediaType,OUT util_StructMsg &oMsg) = 0;

           virtual tBool setCardOverCurrentStatusFill( IN const CardNotInfoOcStatus* pInfo, util_StructMsg &oMsg) = 0;


};
// class IStateTableHWSignals

#endif // INTERFCACE_STATETABLE_HARDWARESIGNALS_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

