/*-----------------------------------------------------------------------------*
 * IStateTableMount.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ISateTableHWMalfunction.h
 *
 * \brief Interface used by components to inform StateTable about the hw malfunction
 *
 * \version 07.08.2014, Rajeev Narayanan Sambhu (RBEI/ECS1), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */


#ifndef INTERFCACE_STATETABLE_HWMALFUNCTIONS_H
#define INTERFCACE_STATETABLE_HWMALFUNCTIONS_H  


/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace prmmgr;


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class IStateTableHWMalfunction
 */

class IStateTableHWMalfunction
{
    public:

       

        /*!
         * \brief Destructor
         */
        virtual ~IStateTableHWMalfunction(){};

        //==========================================================================
        //for devices connected through USB-connectors
        //==========================================================================
        /*!
         * \brief Sets the malfunction of USB connector
         * \param [in] UsbConnectorNum usb connectors
         * \param [in] bIsMalfunction True means the Malfunction is present
         * \param [IN] tenTypeOFMalfunction. Some platform triggers give a risk for malfunction to happen only could be set alternatively to the default value
         */
        virtual tVoid SetMalfunctionUSBConnector(IN tBool bIsMalfunction, IN tenDevManagerUSBHost eUsbConnectorNum, IN tenTypeOFMalfunction eTypeOFMalfunction = eIsMalfunction) = 0;

        
        //==========================================================================
        //for optical discs
        //==========================================================================

        /*!
         * \brief Sets the malfunction of OpticalDisc
         * \param [in] bIsMalfunction True means the Malfunction is present
         */
        virtual tVoid SetMalfunctionOpticalDisc(IN tBool bIsMalfunction) = 0;

        //==========================================================================
        //for SDCard Reader 
        //==========================================================================
        /*!
         * \brief Sets the malfunction of SDCard internal
         * \param [in] bIsMalfunction True means the Malfunction is present
         */
        virtual tVoid SetMalfunctionSDCardInternal(IN tBool bIsMalfunction) = 0;


  


    protected:

      /*!
          * \brief function to check if a Malfunction is already a permanent malfunction 
          */
        virtual tVoid vMonitoringForMalfunctionPermanent() = 0;
      
      /*!
	   * \brief helperfunction used by public SetMalfunctionUSBConnector function. function is mentioned here to emphasis binding to SetMalfunctionUSBConnector-function.
	   *  In unit tests no threads are used. if SetMalfunctionUSBConnector is called then this normally calls the StoreMalfunctionUSBConnectorWithTimeStamp . The unit test does call directly the corresponding vCase-function. I.e. it does what the thread does but
	   *  same function are involved to be as close as possible at what happens with the thread
	   *
	   */
       virtual tBool SetFillMalfunctionUSBConnector(IN tBool bIsMalfunction, IN tenDevManagerUSBHost UsbConnectorNum, IN tenTypeOFMalfunction eTypeOFMalfunction, OUT util_StructMsg &oMsg) = 0;


#ifndef USE_HIGHRISK4USB_HWMALFUNCTION

       /*!
 	   * \brief helperfunction used by public SetFillMalfunctionUSBConnector function. function is mentioned here to emphasis binding to SetFillMalfunctionUSBConnector-function.
 	   *  In unit tests no threads are used. if StoreMalfunctionUSBConnectorWithTimeStamp is called then this normally fills a message queue. A Thread is waiting for that message and calls correspoding vCase-function
 	   *  Hence in unit tests below function is used which fills msg-content. The unit test does call directly the corresponding vCase-function. I.e. it does what the thread does but
 	   *  same function are involved to be as close as possible at what happens with the thread
 	   *
 	   */
        
       virtual tVoid StoreMalfunctionUSBConnectorWithTimeStamp(IN tBool bIsMalfunction ,IN tenDevManagerUSBHost UsbConnectorNum) = 0;
       virtual tVoid StoreHighRiskForMalfunctionUSBConnectorWithTimeStamp(IN tBool bIsMalfunction) = 0; //intermediate adjust StoreMalfunctionUSBConnectorWithTimeStamp

#endif
       /*!
 	   * \brief helperfunction used by the vCASEenTimerExp to decide whether the remove of USB device is associated with malfunction
 	   *
 	   */

       virtual tBool bIsRemovedCausedByMalfunction(IN tenDevManagerUSBHost UsbConnectorNum) = 0;

       /*!
        * \brief helperfunction used by public SetMalfunctionSDCardInternal function. function is mentioned here to emphasis binding to SetMalfunctionSDCardInternal-function.
        *  In unit tests no threads are used. if SetMalfunctionSDCardInternal is called then this normally calls the StoreMalfunctionSDCardInternalWithTimeStamp . The unit test does call directly the corresponding vCase-function. I.e. it does what the thread does but
        *  same function are involved to be as close as possible at what happens with the thread
        *
        */
        
       virtual tBool SetFillMalfunctionSDCardInternal (IN tBool bIsMalfunction, OUT util_StructMsg &oMsg) = 0;





       /*!
 	   * \brief helperfunction used by public SetMalfunctionOpticalDisc function. function is mentioned here to emphasis binding to SetFillMalfunctionUSBConnector-function.
 	   *  In unit tests no threads are used. if SetMalfunctionOpticalDisc is called then this normally fills a message queue. A Thread is waiting for that message and calls correspoding vCase-function
 	   *  Hence in unit tests below function is used which fills msg-content. The unit test does call directly the corresponding vCase-function. I.e. it does what the thread does but
 	   *  same function are involved to be as close as possible at what happens with the thread
 	   *
 	   */
         
       virtual tBool SetFillMalfunctionOpticalDisc(IN tBool bIsMalfunction, OUT util_StructMsg &oMsg) = 0;



		

};
// class IStateTableHWMalfunction

#endif // INTERFCACE_STATETABLE_HWMALFUNCTIONS_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

