/*-----------------------------------------------------------------------------*
 * ReaderDatapool.cpp                                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                   *
 * COPYRIGHT   : (c) 2012 - 2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ReaderDatapool.cpp
 *
 * \brief Implementation to  read Datapool.
 *
 * \version 27.01.2016, Rajeev Narayanan Sambhu (RBEI/ECS1) <Rajeev.NarayananSambhu@in.bosch.com>, version 1.0
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"



#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#define INCLUDE_VD_DVM_EOLLIB
#endif // #ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

#include "Common.h"
#include "Enums.h"

#include "config/IConfigurationPersistent.h"
#include "config/ReaderDatapool.h"
#include "config/ConfigurationBase.h"


/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_CONFIGMANAGER
#include "trcGenProj/Header/ReaderDatapool.cpp.trc.h"
#endif
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

// Includes all header files for FI of DP-component
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_devicemanager_if.h"

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
ReaderDataPool::ReaderDataPool()
{
    ETG_TRACE_USR4(("Begin:ReaderDataPool"));

    ETG_TRACE_USR4(("End  :ReaderDataPool"));

}// ReaderDataPool::ReaderDataPool()


/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
ReaderDataPool::~ReaderDataPool()
{
    ETG_TRACE_USR4(("Begin:~ReaderDataPool"));

    ETG_TRACE_USR4(("End  :~ReaderDataPool"));
} // ReaderDataPool::~ReaderDataPool()

/*-----------------------------------------------------------------------------*
 * tBool bReadDataPool(tU16,tU16)
 *-----------------------------------------------------------------------------*/
tBool ReaderDataPool::bReadDataPool(IN tU16 eTypeOfConfigValue, OUT tU16 &u16ConfigValue  )
{
    ETG_TRACE_USR4(("Begin:bReadDataPool"));
    tBool bRet = TRUE;
    tBool bFound = TRUE;
    dp_tclBaseElement myDpElem;
    int iRetVal;

    switch(eTypeOfConfigValue)
    {
    case eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1:
    {
        dp_tcldevicemanagerDPeCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 dpelemnt;
        iRetVal = dpelemnt.u8GetData(u16ConfigValue);
        if(DP_S32_NO_ERR > iRetVal)
        {
            ETG_TRACE_USR4(("bReadDataPool Error in fetching the configuration param %d. The error code obtained %d",eTypeOfConfigValue,iRetVal));
            bRet = FALSE;
        }
        else
        {
            ETG_TRACE_USR4(("bReadDataPool fetching the configuration param %d and the value obtained is %d",eTypeOfConfigValue,u16ConfigValue));
        }
        break;
    }
    case eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2:
    {
        dp_tcldevicemanagerDPeCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2 dpelemnt;
        iRetVal = dpelemnt.u8GetData(u16ConfigValue);
        if(DP_S32_NO_ERR > iRetVal)
        {
            ETG_TRACE_USR4(("bReadDataPool Error in fetching the configuration param %d. The error code obtained %d",eTypeOfConfigValue,iRetVal));
            bRet = FALSE;
        }
        else
        {
            ETG_TRACE_USR4(("bReadDataPool fetching the configuration param %d and the value obtained is %d",eTypeOfConfigValue,u16ConfigValue));
        }
        break;
    }
    case eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB3:
    {
        dp_tcldevicemanagerDPeCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB3 dpelemnt;
        iRetVal = dpelemnt.u8GetData(u16ConfigValue);
        if(DP_S32_NO_ERR > iRetVal)
        {
            ETG_TRACE_USR4(("bReadDataPool Error in fetching the configuration param %d. The error code obtained %d",eTypeOfConfigValue,iRetVal));
            bRet = FALSE;
        }
        else
        {
            ETG_TRACE_USR4(("bReadDataPool fetching the configuration param %d and the value obtained is %d",eTypeOfConfigValue,u16ConfigValue));
        }
        break;
    }
    case eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4:
    {
        dp_tcldevicemanagerDPeCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4 dpelemnt;
        iRetVal = dpelemnt.u8GetData(u16ConfigValue);
        if(DP_S32_NO_ERR > iRetVal)
        {
            ETG_TRACE_USR4(("bReadDataPool Error in fetching the configuration param %d. The error code obtained %d",eTypeOfConfigValue,iRetVal));
            bRet = FALSE;
        }
        else
        {
            ETG_TRACE_USR4(("bReadDataPool fetching the configuration param %d and the value obtained is %d",eTypeOfConfigValue,u16ConfigValue));

        }
        break;
    }
    default:
    {
        ETG_TRACE_USR4(("bReadDataPool Configuration param %d is not allowed for fetch ",eTypeOfConfigValue));
        break;
    }

    }
    ETG_TRACE_USR4(("End:bReadDataPool"));
    return bRet;
}

/*-----------------------------------------------------------------------------*
 * tBool bReadDataPool(trExternalHubInfo,tU8)
 *-----------------------------------------------------------------------------*/
tBool ReaderDataPool::bReadDataPool(OUT trExternalHubInfo f_uiExternalHubInfo [], OUT tU8 &f_uiNumberOfExternalHubsUsed )
{
    ETG_TRACE_USR4(("Begin:bReadDataPool"));
    tBool bRet = TRUE;
    int iRetVal;

    dp_tcldevicemanagerDPEXTERNALHUB_DETAILS dpelement;
    dp_tcldevicemanagerDPEXTERNALHUB_COUNT dpelementcount;
    trDPExternalHubInfo l_DPExternalHubInfo[10];

    memset(f_uiExternalHubInfo, 0, sizeof(trExternalHubInfo));
    f_uiNumberOfExternalHubsUsed=0;

    iRetVal = dpelementcount.s32GetData(f_uiNumberOfExternalHubsUsed);
    if(DP_S32_NO_ERR > iRetVal)
    {
        ETG_TRACE_USR4(("bReadDataPool Error in reading the ExternalHub param. The error code obtained is %d",iRetVal));
        bRet = FALSE;
    }
    else
    {
        ETG_TRACE_USR4(("bReadDataPool  f_uiNumberOfExternalHubsUsed : %d",f_uiNumberOfExternalHubsUsed));
        if(f_uiNumberOfExternalHubsUsed)
        {
            iRetVal = dpelement.s32GetData(l_DPExternalHubInfo,(sizeof(l_DPExternalHubInfo)/sizeof(l_DPExternalHubInfo[0])));
            if(DP_S32_NO_ERR > iRetVal)
            {
                ETG_TRACE_USR4(("bReadDataPool Error in reading the ExternalHub param. The error code obtained is %d",iRetVal));
                bRet = FALSE;
            }
            else
            {
                for(int i=0; i <f_uiNumberOfExternalHubsUsed ; i++ )
                {
                    f_uiExternalHubInfo[i].iVendorID=l_DPExternalHubInfo[i].u16VendorID;
                    f_uiExternalHubInfo[i].iProductID=l_DPExternalHubInfo[i].u16ProductID;
                    f_uiExternalHubInfo[i].eUsb=(statetbl::tenDevManagerUSBHost)l_DPExternalHubInfo[i].u16USBConnector;
                }
            }
        }
    }

    ETG_TRACE_USR4(("***********************bReadDataPool ExternalHub f_uiExternalHubInfo***********************"));
    for(int i=0 ; i<f_uiNumberOfExternalHubsUsed ; i++)
    {
        ETG_TRACE_USR4(("ExternalHub in array: f_uiExternalHubInfo count: %d",i));
        ETG_TRACE_USR4(("ExternalHub in array: f_uiExternalHubInfo[%d].iVendorID = 0x%x",i,f_uiExternalHubInfo[i].iVendorID));
        ETG_TRACE_USR4(("ExternalHub in array: f_uiExternalHubInfo[%d].iProductID = 0x%x",i,f_uiExternalHubInfo[i].iProductID));
        ETG_TRACE_USR4(("ExternalHub in array: f_uiExternalHubInfo[%d].eUsb = %d",i,f_uiExternalHubInfo[i].eUsb));
        ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
    }
    ETG_TRACE_USR4(("End:bReadDataPool"));
    return bRet;
}

/*-----------------------------------------------------------------------------*
 * tBool bReadDataPool(trTelematicsBoxDeviceInfo,tU8)
 *-----------------------------------------------------------------------------*/
tBool ReaderDataPool::bReadDataPool(OUT trTelematicsBoxDeviceInfo f_uiTelematicsBoxDeviceInfo [], OUT tU8 &f_uiNumberOfTelematicBoxesUsed )
{
    ETG_TRACE_USR4(("Begin:bReadDataPool"));
    tBool bRet = TRUE;
    int iRetVal;

    dp_tcldevicemanagerDPTELEMATICSBOXDEVICE_DETAILS dpelement;
    dp_tcldevicemanagerDPTELEMATICSBOXDEVICE_COUNT dpelementcount;
    trDPTelematicsBoxDeviceInfo l_DPTelematicsBoxDeviceInfo[10];

    memset(f_uiTelematicsBoxDeviceInfo, 0, (sizeof(trTelematicsBoxDeviceInfo)*iMaxSizeOfArray));
    f_uiNumberOfTelematicBoxesUsed=0;

    iRetVal = dpelementcount.s32GetData(f_uiNumberOfTelematicBoxesUsed);
    if(DP_S32_NO_ERR > iRetVal)
    {
        ETG_TRACE_USR4(("bReadDataPool Error in reading the ExternalHub param. The error code obtained is %d",iRetVal));
        bRet = FALSE;
    }
    else
    {
        ETG_TRACE_USR4(("bReadDataPool  f_uiNumberOfTelematicBoxesUsed : %d",f_uiNumberOfTelematicBoxesUsed));
        if(f_uiNumberOfTelematicBoxesUsed)
        {
            iRetVal = dpelement.s32GetData(l_DPTelematicsBoxDeviceInfo,(sizeof(l_DPTelematicsBoxDeviceInfo)/sizeof(l_DPTelematicsBoxDeviceInfo[0])));
            if(DP_S32_NO_ERR > iRetVal)
            {
                ETG_TRACE_USR4(("bReadDataPool Error in reading the ExternalHub param. The error code obtained is %d",iRetVal));
                bRet = FALSE;
            }
            else
            {
                for(int i=0; i <f_uiNumberOfTelematicBoxesUsed ; i++ )
                {
                    f_uiTelematicsBoxDeviceInfo[i].iVendorID=l_DPTelematicsBoxDeviceInfo[i].u16VendorID;
                    f_uiTelematicsBoxDeviceInfo[i].iProductID=l_DPTelematicsBoxDeviceInfo[i].u16ProductID;
                    f_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected=l_DPTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected;
                    f_uiTelematicsBoxDeviceInfo[i].eUsb=(statetbl::tenDevManagerUSBHost)l_DPTelematicsBoxDeviceInfo[i].u16USBConnector;
                }
            }
        }
    }

    ETG_TRACE_USR4(("***********************bReadDataPool TelematicBoxesUsed f_uiTelematicsBoxDeviceInfo***********************"));
    for(int i=0 ; i<f_uiNumberOfTelematicBoxesUsed ; i++)
    {
        ETG_TRACE_USR4(("TelematicsHubDevice in array: f_uiTelematicsBoxDeviceInfo[i].iVendorID = 0x%x",f_uiTelematicsBoxDeviceInfo[i].iVendorID));
        ETG_TRACE_USR4(("TelematicsHubDevice in array: f_uiTelematicsBoxDeviceInfo[i].iProductID = 0x%x",f_uiTelematicsBoxDeviceInfo[i].iProductID));
        ETG_TRACE_USR4(("TelematicsHubDevice in array: f_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected = %d",f_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected));
        ETG_TRACE_USR4(("TelematicsHubDevice in array: f_uiTelematicsBoxDeviceInfo[i].eUsb = %d",f_uiTelematicsBoxDeviceInfo[i].eUsb));
        ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
    }

    ETG_TRACE_USR4(("End:bReadDataPool"));
    return bRet;

}


int ReaderDataPool::GetTypeOfReader()
{
    return (int)eReader_ReaderDataPool;
}


