/*-----------------------------------------------------------------------------*
 * IConfigurationManagerFilter.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IConfigurationManagerFilter.h
 *
 * \brief Implementation to open, read and close persistent configuration
 *
 * \version 05.03.2014, Koechling Christian (CM-AI/ECD1), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef IF_CONFIGURATION_MANAGER_FILTER_H
#define IF_CONFIGURATION_MANAGER_FILTER_H  

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class IConfigurationManagerFilter
 */

class IConfigurationManagerFilter
{
    public:


        /*!
         * \brief Destructor
         */
        virtual ~IConfigurationManagerFilter(){};


        
        /*!
         * \brief This function checks the deice against the EOL parameters
         *
         * \param [in] f_pCurDevice the device
         *
         * \returns DEVICEMANAGER_DEVICE_DETECTED in case of success
         */
        virtual int  FilterWithConfiguration( INOUT CDevice* f_pCurDevice) const = 0;


        /*!
        * \brief  Osal device notifies USB-sticks and SDCards this function helps to filter for SDCards only. SDCard means those connected to the internal SDCardReader bound to /dev/mmcblk0
        *
        * \param [in]  f_strcUUIDDeviceName cUUIDDeviceName delivered by platform callback. 
        *
        * \return true: is SDCard interna false: not SDCard interna
        */
        virtual bool bIsOsalNotifiedDeviceSDCardInternal(IN GENSTRING f_strcUUIDDeviceName) const = 0;


};
// class IConfigurationManagerFilter

#endif // IF_CONFIGURATION_MANAGER_FILTER_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

