/*
 * \brief Implementation of Configuration interface bound to either EOL, KDS, DATAPOOL
 *
 * \version 06.11.2013, Christian K�chling (Bosch), version 1.0
 *          Initial version

 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */


#ifndef CONFIGURATION_PRODUCT_H
#define CONFIGURATION_PRODUCT_H

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/


///--------------------------------------------------------------
//see fct. GetSubversion(),teSubversionType,trSubVersionValueDescription
//these entries differ from those Mediaplayer uses with respect to hardware
   //GMP = Genric Media Player
   //IVI = In vehicle Infotainment
   //SC2_Nis = Scope 2 Nissan
   //SC2.1_Nis = Scope 2.1 Nissan
   //SC2.1_Ren = Scope 2.1 Renault
   //PIVI_Nis = P-IVI Nissan
   //1P = 1 USB port
   //2P = 2 USB ports
   //3P = 3 USB ports
   //nH = no internal Hub
   //wH = with internal Hub
   //TCU = TCU unit connected
   //ETC = ETC (DSRC) unit connected

typedef enum SubversionTypes_E
{
    eSubType_GMP_Undefined                   = 0,
    eSubType_GMP_NisScope1                   = 1,
    eSubType_GMP_NisScope2                   = 2, //project: planned not to be called anymore
    eSubType_GMP_NisScope2_1AIVI             = 3, //project: planned not to be called anymore
    eSubType_GMP_NisScope2_1RENAULT          = 4, //project: planned not to be called anymore
    eSubType_GMP_NIS_PIVI                    = 5, //project: planned not to be called anymore
    eSubType_GMP_IVI_SC2_Nis_1P_nH       = 6,
    eSubType_GMP_IVI_SC2_Nis_2P_nH_TCU   = 7,
    eSubType_GMP_IVI_SC2_Nis_2P_wH_TCU   = 8,
    eSubType_GMP_IVI_SC2_Nis_2P_nH_ETC   = 9,
    eSubType_GMP_IVI_SC2_Nis_2P_wH_ETC   = 10,
    eSubType_GMP_IVI_SC2_Nis_3P_wH       = 11,
    eSubType_GMP_IVI_SC2_1_Nis_1P_nH     = 12,
    eSubType_GMP_IVI_SC2_1_Nis_2P_nH_TCU = 13,
    eSubType_GMP_IVI_SC2_1_Nis_2P_wH_TCU = 14,
    eSubType_GMP_IVI_SC2_1_Nis_2P_nH_ETC = 15,
    eSubType_GMP_IVI_SC2_1_Nis_2P_wH_ETC = 16,
    eSubType_GMP_IVI_SC2_1_Nis_2P_nH_ATB = 17,
    eSubType_GMP_IVI_SC2_1_Nis_3P_wH     = 18,
    eSubType_GMP_IVI_SC2_1_Nis_3P_wH_ATB = 19,
    eSubType_GMP_IVI_SC2_1_Ren_1P_nH     = 20,
    eSubType_GMP_IVI_SC2_1_Ren_2P_nH_TCU = 21,
    eSubType_GMP_IVI_SC2_1_Ren_2P_wH_TCU = 22,
    eSubType_GMP_IVI_SC2_1_Ren_2P_nH_ETC = 23,
    eSubType_GMP_IVI_SC2_1_Ren_2P_wH_ETC = 24,
    eSubType_GMP_IVI_SC2_1_Ren_2P_nH_ATB = 25,
    eSubType_GMP_IVI_SC2_1_Ren_3P_wH     = 26,
    eSubType_GMP_IVI_SC2_1_Ren_3P_wH_ATB = 27,
    eSubType_GMP_IVI_PIVI_Nis_1P_nH      = 28,
    eSubType_GMP_IVI_PIVI_Nis_2P_nH_TCU  = 29,
    eSubType_GMP_IVI_PIVI_Nis_2P_wH_TCU  = 30,
    eSubType_GMP_IVI_PIVI_Nis_2P_nH_ETC  = 31,
    eSubType_GMP_IVI_PIVI_Nis_2P_wH_ETC  = 32,
    eSubType_GMP_IVI_PIVI_Nis_2P_nH_ATB  = 33,
    eSubType_GMP_IVI_PIVI_Nis_3P_wH      = 34,
    eSubType_GMP_IVI_PIVI_Nis_3P_wH_ATB  = 35,
    eSubType_GMP_IVI_SC3_Nis_1P_nH       = 36,
    eSubType_GMP_IVI_SC3_Nis_2P_nH_TCU   = 37,
    eSubType_GMP_IVI_SC3_Nis_2P_wH_TCU   = 38,
    eSubType_GMP_IVI_SC3_Nis_2P_nH_ETC   = 39,
    eSubType_GMP_IVI_SC3_Nis_2P_wH_ETC   = 40,
    eSubType_GMP_IVI_SC3_Nis_2P_nH_ATB   = 41,
    eSubType_GMP_IVI_SC3_Nis_3P_wH       = 42,
    eSubType_GMP_IVI_SC3_Nis_3P_wH_ATB   = 43,
    eSubType_GMP_IVI_SC3_Ren_1P_nH       = 44,
    eSubType_GMP_IVI_SC3_Ren_2P_nH_TCU   = 45,
    eSubType_GMP_IVI_SC3_Ren_2P_wH_TCU   = 46,
    eSubType_GMP_IVI_SC3_Ren_2P_nH_ETC   = 47,
    eSubType_GMP_IVI_SC3_Ren_2P_wH_ETC   = 48,
    eSubType_GMP_IVI_SC3_Ren_2P_nH_ATB   = 49,
    eSubType_GMP_IVI_SC3_Ren_3P_wH       = 50,
    eSubType_GMP_IVI_SC3_Ren_3P_wH_ATB   = 51,
    eSubTypeLastElem                     = 52,
}teSubversionType;

typedef struct
{
    teSubversionType                  enSubType;
    std::string                       strBoundRegistryValue;
    std::string                       strDescription;
    tBool                             bUseRegistry; //is set then instead of the versions hardcoded - reegistry will be read to update values.
    int                               iHardwareHasInternalHUB; //-1:undefined, 0: No internal HUB IMX-connector direct connected, 1:  Has internal Hub to realise USB2, USB3
} trSubVersionValueDescription;
//-------------------------------------------------------------------


/*-----------------------------------------------------------------------------*
 * Forward declarations                                                        *
 *-----------------------------------------------------------------------------*/
class IConfigurationPersistent;

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/

class ConfigurationProduct : public ConfigurationBase   //@todo check if it makes sense to make another child which does care for singleton behaviour only
{
    public:
        ConfigurationProduct();
        virtual ~ConfigurationProduct(){};


         /*!
           * \brief especially interesting if customer values are written into KDS, EOL-Memory.
           *           This command triggers to use it alternative would be a restart of the system
           * \return
           */
         void  vInitCustomerValues(); //these values are set e.g. reading KDS, EOL or
         void  vInitCustomerValuesPersistent(); //these values are set after reading dependencies from KDS, EOL - this function is used for customer specific values. G3G values see e.g. CommonReadRoutinesKds
         void  vInitCustomerValuesPostPersistent(); //these values are set after vInitCustomerValuesPersistent() has been called. In dependencies of values set with call of vInitCustomerValuesPersistent()  other congifuration values will be set

         /*!
          * \brief Reads the KDS address and configure the USB connectors to be enabled or disabled
          *  Used by PSARCC
          * \return
          */

         void vConfigureUSBConnectors();

#ifdef USE_OLD_GETSYSPATH

#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC) || defined(USE_TEST_GMWITH3PORTSFORPSA)

         /*!
          * \brief function overwritten from base to care for 3 rd USB connector
          * \return
          */
         virtual tVoid vGetUSBConnectorFromSysPath(OUT tenDevManagerUSBHost &eUsb, IN const std::string &strSysPath) const;

#endif

#endif //USE_OLD_GETSYSPATH


#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_PSARCC) || defined(USE_TEST_GMWITH3PORTSFORPSA)

        /*!
          * \brief Reads the KDS address and configure the BTA Box connected to the target
          *  Used by PSARCC. If the value present in KDS  address is enabled the BTA specific ITCs will be send.
          * \return
          */
         void vConfigureBTADevice();
#endif

        /*!
          * \Load Configuration values from KDS based on Subvariants
          */
         void vLoadCustomerValuesBySubVersion();


    protected:

        IConfigurationPersistent *m_pIFConfPersistent;
        tBool bInterfaceConfPersistentFactoryMethod(); //e.g. GM overwrites it to access EOL VAG to access KDS

        /*
        * \Functions to Load configurations based on Subvariants
        */
        void vLoadCustomerValues_SubType_NisScope1();
        void vLoadCustomerValues_SubType_NisScope2_1RENAULT();
        void vLoadCustomerValues_SubType_NIS_PIVI();

        void vLoadCustomerValues_SubType_Generic(unsigned int numOfPorts, unsigned int withInternalHub,unsigned int withTelematicsBox,unsigned int withEletronicTollCollectBox,unsigned int withATBox);
        int  iGetHardwareHasInternalHubFromSubversion(teSubversionType eSubversion);




        /*
        * \Function to get subversion from persistent memory
        */
        unsigned int GetSubversion(OUT std::string &strSubstring);

        /*
          * \Function which helps to derive generic entries from subversion string if subversion type is not been set yet
          */

        void vUseGenericDefaultSetting(IN std::string strSubversion,OUT unsigned int &numOfPorts,OUT unsigned int &withInternalHub,OUT unsigned int &withTelematicsBox,OUT unsigned int &withEletronicTollCollectBox);


        static trSubVersionValueDescription m_rSubVersionValueDescriptions[eSubTypeLastElem];
        teSubversionType mSubVersion;

};

#endif // CONFIGURATION_PRODUCT_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

