/*-----------------------------------------------------------------------------*
 * ConfigurationBase.cpp                                                        *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ConfigurationBase.h
 *
 * \brief Implementation of Configuration interface bound to either EOL, KDS, DATAPOOL
 *
 * \version 06.11.2013, Christian Koechling (Bosch), version 1.0
 *          Initial version

 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#define INCLUDE_VD_DVM_EOLLIB
#endif // #ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EOL
#endif //VARIANT_S_FTR_ENABLE_UNITTEST
//#define INCLUDE_VD_DVM_QTDBUS
#include "Common.h"
#include "Enums.h"
#include <vector>
#include <sstream>
#include <boost/algorithm/string.hpp>

#include "config/ConfigurationBase.h"

#include "config/IConfigurationPersistent.h"
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
#include "config/WriterDatapool.h"//for writing the persistent data
#include "config/ReaderDatapool.h"//for reading the persistent data
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
/*-----------------------------------------------------------------------------*
 * ERROR COMPILE CHECK
 *-----------------------------------------------------------------------------*/
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_KDS) && defined(VARIANT_S_FTR_ENABLE_DEVMGR_EOL)
#error "[ERROR] FEATURE SWITCHES: EOL AND KDS CAN'T BE USED AT THE SAME TIME "
#error " see VARIANT_S_FTR_ENABLE_DEVMGR_KDS, VARIANT_S_FTR_ENABLE_DEVMGR_EOL in .prod.xml"
#endif

#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS) && defined(VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS)
#error "[ERROR] FEATURE SWITCHES: diagnosis trigger mechanism - either of two possible"
#error " see VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS, VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS in .prod.xml & config.h"
#endif
/* check setting for devmgrcore g3g
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE) && !defined(USE_EXTERNAL_UNSUPPORTED_DEVICES)
    #error "[ERROR] FEATURE SWITCHES: Unsupported devices "
    #error " see VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE, USE_EXTERNAL_UNSUPPORTED_DEVICES in .prod.xml & config.h"
#endif
*/

/*-----------------------------------------------------------------------------*
 * namespace                                                                     *
 *-----------------------------------------------------------------------------*/
using namespace configmgr;

/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_CONFIGMANAGER
#include "trcGenProj/Header/ConfigurationBase.cpp.trc.h"
#endif
#include "ETGTrace.h"
//the below defines is placed in inside the macro VARIANT_S_FTR_ENABLE_UNITTEST to avoid dependency with unit tests
#include "Device.h"
#include "DeviceCard.h"
#include "device/DeviceListManager.h"
#include "usbutils.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

#include "config/ConfigurationBase.h"

#define EOL TRUE
#define KDS
#define USB_DEVICES_VID_PID_FILE_COMMENTCHAR '#'
/*
typedef struct
{
    tenDevManagerConfigValue          enConfigValue;
    std::string                       strInternal;
    std::string                       strRange;
    std::string                       strConfigValue;
    std::string                       strConfigurableProductionLine;
    std::string                       strVarianSwitchToWhichItIsbound;
    std::string                       strDescriptionOfValues;
    tBool                             bIsConfigurableFromOutside;//if the value is TRUE, then this tenDevManagerConfigValue can be configured from the external CCA interface
} trConfigValueDescription;
*/

trConfigValueDescription ConfigurationBase::m_rConfigValueDescription[eCONF_LAST_ELEMENT] =
{
    //-------------GM specific---------------------------- //although it has been fully replaced I'll keep this in order not to confuse GM-Testers who are used to corresponding TTFIS command their are used to
    {eCONF_USB_1_HUB_ENABLE                                       , "no" ,"0 or 1", "eCONF_USB_1_HUB_ENABLE"                                      ,eNO, "GM only:EOL based: Allow a HUB to be connected at USB1", "-",FALSE},
    {eCONF_USB_2_HUB_ENABLE                                       , "no" ,"0 or 1", "eCONF_USB_2_HUB_ENABLE"                                      ,eNO, "GM only:EOL based: Allow a HUB to be connected at USB2", "-",FALSE},
    {eCONF_USB_1_HUB_MAX_PORTS                                    , "no" ,"0...8 ", "eCONF_USB_1_HUB_MAX_PORTS"                                   ,eNO, "GM only:EOL based: HUB at USB1 has e.g. 4 ports then MAX_PORTS=4 ","-",FALSE},
    {eCONF_USB_2_HUB_MAX_PORTS                                    , "no" ,"0...8 ", "eCONF_USB_2_HUB_MAX_PORTS"                                   ,eNO, "GM only:EOL based: HUB at USB1 has e.g. 4 ports then MAX_PORTS=4 ","-",FALSE},
    {eCONF_SYSTEM_OFFERING_BYTE1                                  , "no" ,"added ", "eCONF_SYSTEM_OFFERING_BYTE1"                                 ,eNO, "GM only:EOL based: Combination of the next values","-",FALSE},//this is used also to store l_Byte19_Bit6And7 of VAGMIBE project
    {eCONF_SYSTEM_OFFERING_BYTE1Bit3_USB2HubPresent               , "no" ,"0 or 1", "eCONF_SYSTEM_OFFERING_BYTE1Bit3_USB2HubPresent"              ,eNO, "GM only:EOL based: If set GM HUB has been added in GM production line at USB2. Bound to diaglog ITC_USB2_HUB_NOT_DETECTED. ","-",FALSE},
    {eCONF_SYSTEM_OFFERING_BYTE1Bit4_USB1HubPresent               , "no" ,"0 or 1", "eCONF_SYSTEM_OFFERING_BYTE1Bit4_USB1HubPresent"              ,eNO, "GM only:EOL based: If set GM HUB has been added in GM production line at US12. Bound to diaglog ITC_USB1_HUB_NOT_DETECTED. ","-",FALSE},
    {eCONF_SYSTEM_OFFERING_BYTE1Bit5_SDPresent                    , "no" ,"0 or 1", "eCONF_SYSTEM_OFFERING_BYTE1Bit5_SDPresent"                   ,eNO, "GM only:EOL based: Allow SD Card e.g. SDCard slot at GM HUB","-",FALSE},
    {eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present                  , "no" ,"0 or 1", "eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present"                 ,eNO, "GM only:EOL based: Allow Devices at USB2","-",FALSE},
    {eCONF_SYSTEM_OFFERING_BYTE1Bit7_USB1Present                  , "no" ,"0 or 1", "eCONF_SYSTEM_OFFERING_BYTE1Bit7_USB1Present"                 ,eNO, "GM only:EOL based: Allow Devices at USB1","-",FALSE},
    {eCONF_ENABLE_MTP_DEVICES                                     , "no" ,"0 or 1", "eCONF_ENABLE_MTP_DEVICES"                                    ,eNO, "GM only:EOL based: Allow MTP devices","-",FALSE},
    {eCONF_USB_VOLTAGE_RECOVERY_AUTOPLAY_DELAY_TIME               , "no" ,"0 or 1", "eCONF_USB_VOLTAGE_RECOVERY_AUTOPLAY_DELAY_TIME"              ,eNO, "GM only:EOL based: After low voltage delay before notifiying devices again","-",FALSE},
    {eCONF_MARKETING_REGION                                       , "no" ,"0 or 1", "eCONF_MARKETING_REGION"                                      ,eNO, "GM only:EOL based: Marketing region (not used by VD_DVM)","-",FALSE},
    {eCONF_USB_UNUSED_BITS                                        , "no" ,"0 or 1", "eCONF_USB_UNUSED_BITS"                                       ,eNO, "GM only:EOL based: placeholder (not used by VD_DVM)","-",FALSE},
    //-------------generic part ---------------------------- //here the part begins which also replaces the above poart but serves all projects since it is more generic
    {eCONF_ENABLE_EXTERNAL_SD                                     , "no" ,"0 or 1", "eCONF_ENABLE_EXTERNAL_SD"                                    ,eNO , "Support SD card e.g. connected to HUB or via adapter to USB Connector","VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_SDCARD_DEVICES",FALSE},
    {eCONF_ENABLE_EXTERNAL_USB                                    , "no" ,"0 or 1", "eCONF_ENABLE_EXTERNAL_USB"                                   ,eNO , "Support USB mass storage device","VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_USBMSC_DEVICES",FALSE},
    {eCONF_ENABLE_EXTERNAL_MTP                                    , "no" ,"0 or 1", "eCONF_ENABLE_EXTERNAL_MTP"                                   ,eNO , "Support MTP device ","VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_MTP_DEVICES",FALSE},
    {eCONF_ENABLE_EXTERNAL_IPOD                                   , "no" ,"0 or 1", "eCONF_ENABLE_EXTERNAL_IPOD"                                  ,eNO , "Support IPOD","VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES",FALSE},
    {eCONF_ENABLE_EXTERNAL_IPAD                                   , "no" ,"0 or 1", "eCONF_ENABLE_EXTERNAL_IPAD"                                  ,eNO , "Support IPAD","VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES,VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS",FALSE },
    {eCONF_ENABLE_EXTERNAL_IPHONE                                 , "no" ,"0 or 1", "eCONF_ENABLE_EXTERNAL_IPHONE"                                ,eNO , "Support IPHONE","VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES" ,FALSE                                                 },
    {eCONF_ENABLE_INTERNAL_CDROM                                  , "no" ,"0 or 1", "eCONF_ENABLE_INTERNAL_CDROM"                                 ,eNO , "Support optical discs with internal drive","VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE"  ,FALSE                                                 },
    {eCONF_ENABLE_INTERNAL_CDDA                                   , "no" ,"0 or 1", "eCONF_ENABLE_INTERNAL_CDDA"                                  ,eNO , "Support  CDDA (Audio CD) with internal card reader","VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDDA_DEVICE"   ,FALSE                                               },
    {eCONF_ENABLE_INTERNAL_SDCARD                                 , "no" ,"0 or 1", "eCONF_ENABLE_INTERNAL_SDCARD"                                ,eNO , "Support sd cards with internal card reader","VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_SDCARD_DEVICE" ,FALSE                                                 },
    {eConf_ENABLE_EXTERNAL_DIGIAUX                                , "no" ,"0 or 1", "eConf_ENABLE_EXTERNAL_DIGIAUX"                               ,eNO , "Support DIGIAUX i.e. HUB with AUXIN which converts it to USB","VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_DIGIAUX_DEVICE"    ,FALSE                                             },
    {eConf_ENABLE_EXTERNAL_BTA                                    , "no" ,"0 or 1", "eConf_ENABLE_EXTERNAL_BTA"                                   ,eNO , "Support Telematics Box","VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_BTA_DEVICE"  ,FALSE                                                   },
    {eConf_ENABLE_EXTERNAL_HUB                                    , "no" ,"0 or 1", "eConf_ENABLE_EXTERNAL_HUB"                                   ,eNO , "Support External Hub as Device"  ,"-",FALSE},
    {eConf_ENABLE_INTERNAL_DVD_DRIVE                              , "no" ,"0 or 1", "eConf_ENABLE_INTERNAL_DVD_DRIVE"                             ,eNO , "Support Internal DVD Drive connected to USB connector availabel inside e.g. PIVI. As a result DTY_DVD_DRIVE is notified, DTY_CDROM (CDDA, DVD-Video/Audio is handeled in mediaplayer)","-",FALSE},
    {eCONF_ENABLE_EXTERNAL_UNSUPPORTED                            , "y"  ,"0 or 1", "eCONF_ENABLE_EXTERNAL_UNSUPPORTED"                           ,eNO , "Unsupported devices notified to clients otherwhise suppressed at all (always set)","-",FALSE},

    /*if disabled VD_DVM supporesses notification to clients*/
    {eCONF_ENABLE_USB1                                            , "no" ,"0 or 1", "eCONF_ENABLE_USB1"                                           ,eNO , "Support devices at USB1","-",FALSE}, //similar to eCONF_SYSTEM_OFFERING_BYTE1Bit7_USB1Present
    {eCONF_ENABLE_USB2                                            , "no" ,"0 or 1", "eCONF_ENABLE_USB2"                                           ,eNO , "Support devices at USB2","-",FALSE}, //similar to eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present
    {eCONF_ENABLE_USB3                                            , "no" ,"0 or 1", "eCONF_ENABLE_USB3"                                           ,eNO , "Support devices at USB3","-",FALSE},
    {eCONF_ENABLE_USB4                                            , "y " ,"0 or 1", "eCONF_ENABLE_USB4"                                           ,eNO , "not used","-",FALSE},
    /*if disabled VD_DVM supresses notfication of devices connected to a HUB*/
    {eCONF_ENABLE_HUBandPORTSatUSB1                               , "no" ,"0...8", "eCONF_ENABLE_HUBandPORTSatUSB1"                               ,eNO , "Allow HUB at USB1 with certain number of ports","-",TRUE},  //number >0 means enabled for number of max ports
    {eCONF_ENABLE_HUBandPORTSatUSB2                               , "no" ,"0...8", "eCONF_ENABLE_HUBandPORTSatUSB2"                               ,eNO , "Allow HUB at USB2 with certain number of ports","-",TRUE},  //number >0 means enabled for number of max ports
    {eCONF_ENABLE_HUBandPORTSatUSB3                               , "no" ,"0...8", "eCONF_ENABLE_HUBandPORTSatUSB3"                               ,eNO , "Allow HUB at USB3 with certain number of ports","-",TRUE},  //number >0 means enabled for number of max ports
    {eCONF_ENABLE_HUBandPORTSatUSB4                               , "y" , "0...8", "eCONF_ENABLE_HUBandPORTSatUSB4"                               ,eNO , "not used","-",FALSE},  //number >0 means enabled for number of max ports
    /*if enabled HUBs will be observed for open circuit and overcurrent*/
    {eCONF_ENABLE_observeDTC_HUBatUSB1                            , "no" ,"0 or 1", "eCONF_ENABLE_observeDTC_HUBatUSB1"                           ,eNO , "If set customer HUB has been added in the production line at USB1. Bound to diaglog ITC_USB1_HUB_NOT_DETECTED","-",FALSE},
    {eCONF_ENABLE_observeDTC_HUBatUSB2                            , "no" ,"0 or 1", "eCONF_ENABLE_observeDTC_HUBatUSB2"                           ,eNO , "If set customer HUB has been added in the production line at USB2. Bound to diaglog ITC_USB2_HUB_NOT_DETECTED","-",FALSE},
    {eCONF_ENABLE_observeDTC_HUBatUSB3                            , "no" ,"0 or 1", "eCONF_ENABLE_observeDTC_HUBatUSB3"                           ,eNO , "If set customer HUB has been added in the production line at USB3. Bound to diaglog ITC_USB3_HUB_NOT_DETECTED","-",FALSE},
    {eCONF_ENABLE_observeDTC_HUBatUSB4                            , "y " ,"0 or 1", "eCONF_ENABLE_observeDTC_HUBatUSB4"                           ,eNO , "not used","-",FALSE},
    /*if diabled physically USB connector will be switched off*/      ///@todo question to Tomas Mehring has been posted if this should be done here or more down in the code
    {eCONF_ENABLE_HW_USB1                                         , "no" ,"0 or 1", "eCONF_ENABLE_HW_USB1"                                        ,eNO , "USB1 VBUS can be configured to be switched off. Dependency: eConf_ENABLE_USR_PRM_HWCTRLUSB has to be enabled ","-",FALSE},
    {eCONF_ENABLE_HW_USB2                                         , "no" ,"0 or 1", "eCONF_ENABLE_HW_USB2"                                        ,eNO , "USB2 VBUS can be configured to be switched off. Dependency: eConf_ENABLE_USR_PRM_HWCTRLUSB has to be enabled ","-",FALSE},
    {eCONF_ENABLE_HW_USB3                                         , "no" ,"0 or 1", "eCONF_ENABLE_HW_USB3"                                        ,eNO , "USB3 VBUS can be configured to be switched off. Dependency: eConf_ENABLE_USR_PRM_HWCTRLUSB has to be enabled ","-",FALSE},
    {eCONF_ENABLE_HW_USB4                                         , "y " ,"0 or 1", "eCONF_ENABLE_HW_USB4"                                        ,eNO , "not used","-",FALSE},

    //If the values are enabled, the hardware signals from the PRM will be used for the USB ports
    {eCONF_HWSIGNAL_SOURCE_USB1                                   , "no" ,"PRM1/2/3 or HUBINTERNAL", "eCONF_HWSIGNAL_SOURCE_USB1"                 ,eNO , "if customer dependent numbering of USBConnectors is used this is used to map HW signals correctly","-",FALSE},
    {eCONF_HWSIGNAL_SOURCE_USB2                                   , "no" ,"PRM1/2/3 or HUBINTERNAL", "eCONF_HWSIGNAL_SOURCE_USB2"                 ,eNO , "same like. Note: DVM_PRMPORT1_USED: 0xC1(193), DVM_PRMPORT2_USED: 0xC2(194), DVM_PRMPORT3_USED: 0xC3(195)","-",FALSE},
    {eCONF_HWSIGNAL_SOURCE_USB3                                   , "no" ,"PRM1/2/3 or HUBINTERNAL", "eCONF_HWSIGNAL_SOURCE_USB3"                 ,eNO , "same like. Note: DVM_HUBINTERNAL_USED 0xB0(176) ","-",FALSE},
    {eCONF_HWSIGNAL_SOURCE_USB4                                   , "y " ,"      ", "eCONF_HWSIGNAL_SOURCE_USB4"                                  ,eNO , "not used","-",FALSE},

    //If the value is enabled. It is assumed that there is an internal HUB. It'll be asked based on a time intervall if disturbance like over current has happened
    {eCONF_HUB_HWSIGNAL_MONITOR_INTERVAL                          , "no" ,"x sec", "eCONF_HUB_HWSIGNAL_MONITOR_INTERVAL"                          ,eNO , "Thread is triggered every x seconds to communicate to target internal HUB for HW signals or libusb speed for BTA (such HUB is used to provide e.g. 3 USBConnectors)","-",FALSE},

    //filesystems - note normal philosophy is to allow as most as possible and supported by platform but in Mediaplayer certain will be suppressed
    {eCONF_ENABLE_FILESYSTEM_FAT                                  , "no" ,"0 or 1", "eCONF_ENABLE_FILESYSTEM_FAT"                                 ,eNO , "support mass storage devices with filesystem FAT","VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_FAT",FALSE                                                             },
    {eCONF_ENABLE_FILESYSTEM_NTFS                                 , "no" ,"0 or 1", "eCONF_ENABLE_FILESYSTEM_NTFS"                                ,eNO , "support mass storage devices with filesystem NTFS","VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_NTFS" ,FALSE                                                           },
    {eCONF_ENABLE_FILESYSTEM_EXTFAT                               , "no" ,"0 or 1", "eCONF_ENABLE_FILESYSTEM_EXTFAT"                              ,eNO , "support mass storage devices with filesystem EXTFAT","VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXTFAT"    ,FALSE                                                      },
    {eCONF_ENABLE_FILESYSTEM_HFSPLUS                              , "no" ,"0 or 1", "eCONF_ENABLE_FILESYSTEM_HFSPLUS"                             ,eNO , "support mass storage devices with filesystem HFSPLUS","VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_HFSPLUS"  ,FALSE                                                       },
    {eCONF_ENABLE_FILESYSTEM_EXT_3_4_FS                           , "no" ,"0 or 1", "eCONF_ENABLE_FILESYSTEM_EXT_3_4_FS"                          ,eNO , "support mass storage devices with filesystem EXT 3,4","VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXT_3_4_FS"   ,FALSE                                                   },
    {eCONF_ENABLE_FILESYSTEM_ISO9660                              , "no" ,"0 or 1", "eCONF_ENABLE_FILESYSTEM_ISO9660"                             ,eNO , "support optical disc with ISO9660","VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE"   ,FALSE                                                },
    {eCONF_ENABLE_FILESYSTEM_UDF                                  , "no" ,"0 or 1", "eCONF_ENABLE_FILESYSTEM_UDF"                                 ,eNO , "support optical disc with UDF","VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE"      ,FALSE                                             },

    //-------------others---------------------------
    {eCONF_ENABLE_LIMIT_SIZE_MSD                                  , "no" ,"0 or 1", "eCONF_ENABLE_LIMIT_SIZE_MSD"                                 ,eNO , "Limit the size of Massstorage devices GigaByte                 ","-",FALSE},
    {eCONF_ENABLE_CHARGE_APPLEDEVS                                , "no" ,"0 or 1", "eCONF_ENABLE_CHARGE_APPLEDEVS"                               ,eNO , "Sends message to IPOD, IPAD, IPHONE to take +500mA i.e. 1Ampere","VARIANT_S_FTR_ENABLE_DEVMGR_CHARGE_APPLE_DEVICES",FALSE},

    {eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE                      , "no" ,"0 or 1", "eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE"                     ,eNO , "notify to clients devices which have been detected unsupported","VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE",FALSE                                              },
    {eCONF_ENABLE_NOTIFY_UNSUPPORTED_FILESYSTEM                   , "no" ,"0 or 1", "eCONF_ENABLE_NOTIFY_UNSUPPORTED_FILESYSTEM"                  ,eNO , "notify to clients devices with unsupported file systems","VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_FILESYSTEM",FALSE                                          },
    {eCONF_ENABLE_NOTIFY_UNSUPPORTED_HUB                          , "y " ,"0 or 1", "eCONF_ENABLE_NOTIFY_UNSUPPORTED_HUB"                         ,eNO , "notify to clients unsupported hubs ","VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE",FALSE                                             },  //under contruction

    {eCONF_STATETABLE_EXECUTION_TIME_MS                           , "no" ,"200...500ms", "eCONF_STATETABLE_EXECUTION_TIME_MS"                     ,eNO , "Statetable has a time window where it waits that HW signals and SPM to settle to final state","-",FALSE},  //statetable has a time window where it waits that HW signals and SPM to settle to final state

    {eConf_ENABLE_NOTIFY_PARTITIONS_ALL                           , "no" ,"0 or 1", "eConf_ENABLE_NOTIFY_PARTITIONS_ALL"                          ,eNO , "notify to clients either first partition or all partitions of a mass storage device","VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_PARTITIONS_ALL",FALSE                                                   },  //all partitions of a usb stick  or sd card will be notified
    {eConf_ENABLE_NOTIFY_IPAD_AS_IPOD                             , "no" ,"0 or 1", "eConf_ENABLE_NOTIFY_IPAD_AS_IPOD"                            ,eNO , "notify to clients IPAD as IPOD","VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_AS_IPOD",FALSE                                                     },  //IPAD will be notified a to clients as IPOD
    {eConf_ENABLE_NOTIFY_SDINT_AS_SD                              , "no" ,"0 or 1", "eConf_ENABLE_NOTIFY_SDINT_AS_SD"                             ,eNO , "notify to clients SD card at internal SD Card Reader as general SD Card (DTY_SD instead DTY_SD_INTERNAL)","VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_SDINT_AS_SD",FALSE                                                      },  //internal SD Card will be notifiede to clients like an SDCard in external Card Reader connected via USB
    {eConf_ENABLE_NOTIFY_CDROM_AS_USB                             , "y " ,"0 or 1", "eConf_ENABLE_NOTIFY_CDROM_AS_USB"                            ,eNO , "notify to clients CDROM as USB (DTY_CDROM as DTY_USB) - this was used for testing","VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_CDROM_AS_USBMSC" ,FALSE                                                 },  //cdrom will be notified as USB-device up till now used for test only
    {eConf_ENABLE_CYCLIC_DIAGNOSIS                                , "no" ,"0 or 1", "eConf_ENABLE_CYCLIC_DIAGNOSIS"                               ,eNO , "If enabled an internal diagnosis thread collects every second information to provide ITCs to diaglog in case of changes","VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS" ,FALSE                                           },  //cyclic check of connected devices and HUBS and Overcurrent to inform FC_diagnosis if something goes wrong

    {eConf_ENABLE_USE_VOLTAGEMANAGER                              , "no" ,"0 or 1", "eConf_ENABLE_USE_VOLTAGEMANAGER"                             ,eNO , "DRV_VOLT used to be informed critical voltage e.g. in som eprojects at that . ","VARIANT_S_FTR_ENABLE_DEVMGR_USE_DRV_VOLT" ,FALSE                                                           }, //use events of voltage manager - other customer products
    {eConf_ENABLE_USE_PRM_HWSIGNALS                               , "no" ,"0 or 1", "eConf_ENABLE_USE_PRM_HWSIGNALS"                              ,eNO , "Osal driver prm sends if USB connector is switched off due to critical voltage or over current this is used to set devices not available","VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED" ,FALSE                                                               }, //use callbacks of prm telling if there is overcurrent etc.
    {eConf_ENABLE_USE_PRM_SDCARDSIGNALS                           , "no" ,"0 or 1", "eConf_ENABLE_USE_PRM_SDCARDSIGNALS"                          ,eNO , "Offer special information for diagnosis (see FI of VD_DVM) by connecting to sd card interface of prm bound to internal card reader","VARIANT_S_FTR_ENABLE_DEVMGR_HW_SDCARD",FALSE                                                             }, //for FC-diagnosis we need special information about internal SDCard (internal reader not connected via USB) that#s why we rely on PRM notification of card
    {eConf_ENABLE_USR_PRM_HWCTRLUSB                               , "no" ,"0 or 1", "eConf_ENABLE_USR_PRM_HWCTRLUSB"                              ,eNO , "Allow FC_Diagnosis to switch on/off VBUS of USB connectors","VARIANT_S_FTR_ENABLE_DEVMGR_USBHWCTRL",FALSE                                                               }, //it is possible to switch on off the voltage (VBUS) of USBConnectors this can be defined here
    {eConf_ENABLE_USE_GPIO_INTERFACE                              , "no" ,"0 or 1", "eConf_ENABLE_USE_GPIO_INTERFACE"                             ,eNO , "Check GPIOs to get if internal Card reader has overcurrent ","-",FALSE}, //e.g. for getting overcurrent at internal SDCard reader it is neccessary to check a certain GPIO
    {eConf_ENABLE_DIAGLOG_DTC_TRIGGERED_HWSIGNALS                 , "y" , "0 or 1", "eConf_ENABLE_DIAGLOG_DTC_TRIGGERED_HWSIGNALS"                ,eNO , "not used - thougth to be an alternative for eConf_ENABLE_CYCLIC_DIAGNOSIS ","VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS",FALSE                                  }, //in GM these are triggered due to cyclic diagnosis this offers to send it directly //@todo check what happens if both are switched on eventuelly don't allow it
    {eCONF_ENABLE_FAKE_SDCARD                                     , "y " ,"0 or 1", "eCONF_ENABLE_FAKE_SDCARD"                                    ,eNO , "For LSIM environment it is possible to fake a SDCard with an USB-stick with a FILE 'SDCARD","-",FALSE}, //For LSIM environment it is possible to fake a SDCard with an USB-stick with a FILE 'SDCARD'
    {eConf_ENABLE_DEVICES_ALWAYS_AT_USB1                          , "y " ,"0 or 1", "eConf_ENABLE_DEVICES_ALWAYS_AT_USB1"                         ,eNO , "For LSIM environemnt it is possible that all devices are connected to the same port even devices connected to a hub","-",FALSE}, //For LSIM environemnt it is possible that all devices are connected to the same port even devices connected to a hub
    {eConf_ENABLE_USE_ROOTDAEMON                                  , "no" ,"0 or 1", "eConf_ENABLE_USE_ROOTDAEMON"                                 ,eNO , "system commands are send to ROOTDAEMON as part of the security concept. VD_DVM then does not have root rights","VARIANT_S_FTR_ENABLE_USAGE_ROOTDEAMON",FALSE                                                               }, //due to new security concept Linux commands have to go via Rootdaemon
    {eConf_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP                    , "y"  ,"0 or 1", "eConf_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP"                   ,eNO , "unknown message send at startup (will get obsolete if eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS will be enabled)","VARIANT_S_FTR_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP",FALSE                                                   }, //it is possible to notifyinstead of empty vector an unknown element at startup - used in GM only
    {eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS                        , "y"  ,"0 or 1", "eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS"                       ,eNO , "Interface of VD_DVM sends latest changes always spread i na vector holding containing device information. Last change not at vector[0](dependencies will have to be released)","VARIANT_S_FTR_ENABLE_NOTIFY_NO_REDUNDAND_MSGS" ,FALSE                                                      }, //output of state table adjusted in order not to send same messages several times. This hs an effect at the interface of VD_DVM thus its made configurable
    {eConf_ENABLE_SUPPRESS_DIAGNOSISHWSIGNAL                      , "y " ,"0 or 1", "eConf_ENABLE_SUPPRESS_DIAGNOSISHWSIGNAL"                     ,eNO , "Intermediate solution until eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS will be enabled for all projects","-",FALSE}, //GM specific: Intermediate solution until eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS is fully used and tested
    {eConf_ENABLE_ITC_OVERCURRENT_SUPPRESSED_IFCRITVOLT           , "no" ,"0 or 1", "eConf_ENABLE_ITC_OVERCURRENT_SUPPRESSED_IFCRITVOLT"          ,eNO , "ITC_USB1,2,3_OVERCURRENT not send if critical voltage has been received by drv_volt","-",FALSE}, //Sending ITC for OVERCURRENT via diaglog is suppressed if system has critical voltage. Reason because of the Hardware it is not really possible to make a distinction between overcurrent and critical voltage.
    {eConf_ENABLE_ITC_OVERCURRENT_TRIGGERS_ITC_POWER_SUPPLY_FAULT , "no" ,"0 or 1", "eConf_ENABLE_ITC_OVERCURRENT_TRIGGERS_ITC_POWER_SUPPLY_FAULT",eNO , "If VD_DVM sends ITC_USB1,2,3_OVERCURRENT it sends ITC_USB1,2,3_POWER_SUPPLY_FAULT too","-",FALSE}, //special solution currently used in PSA all ITC's which mark that USB HW does not work should be send - this is for ITC_POWER_SUPPLY_FAULT
    {eConf_ENABLE_MISSINGTELEMATICSBOX_TRIGGERS_ITC_USB_OPEN      , "no" ,"0 or 1", "eConf_ENABLE_MISSINGTELEMATICSBOX_TRIGGERS_ITC_USB_OPEN"     ,eNO , "If VD_DVM sends ITC_USB1,2,3_OVERCURRENT it sends ITC_USB1,2,3_OPEN too","-",FALSE}, //special solution currently used in PSA all ITC's which mark that USB HW does not work should be send - this is for ITC_USB_OPEN

    {eConf_ENABLE_TELEMATICSBOX_USB1                              , "no" ,"0 or 1", "eConf_ENABLE_TELEMATICSBOX_USB1"                             ,eNO , "Telematics box (BTA) expected at USB1 (customer configured numbering)","-",FALSE}, //PSA and RNAIVI use a TelematicsBox at one USB connector - mark it to be bound to USB1
    {eConf_ENABLE_TELEMATICSBOX_USB2                              , "no" ,"0 or 1", "eConf_ENABLE_TELEMATICSBOX_USB2"                             ,eNO , "Telematics box (BTA) expected at USB2 (customer configured numbering)","-",FALSE}, //PSA and RNAIVI use a TelematicsBox at one USB connector - mark it to be bound to USB2
    {eConf_ENABLE_TELEMATICSBOX_USB3                              , "no" ,"0 or 1", "eConf_ENABLE_TELEMATICSBOX_USB3"                             ,eNO , "Telematics box (BTA) expected at USB3 (customer configured numbering)","-",FALSE}, //PSA and RNAIVI use a TelematicsBox at one USB connector - mark it to be bound to USB3
    {eConf_ENABLE_TELEMATICSBOX_USB4                              , "no" ,"0 or 1", "eConf_ENABLE_TELEMATICSBOX_USB4"                             ,eNO , "Telematics box (BTA) expected at USB4 (customer configured numbering)","-",FALSE}, //PSA and RNAIVI use a TelematicsBox at one USB connector - mark it to be bound to USB4
    {eCONF_ENABLE_TELEMATICSBOX_MONITORING                        , "no" ,"0 or 1", "eCONF_ENABLE_TELEMATICSBOX_MONITORING"                       ,eNO , "ITC's bound to availability of Telematics Box (BTA), FC_ATB has to inform VD_DVM about availability of BTA","VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_BTA_DEVICE",FALSE                                                         }, //PSA and RNAIVI use a TelematicsBox. The FC_ATP will update the VD_DVM if the connection to the BTA Box to application layer is active
    {eCONF_ENABLE_TESTMODE_SETUSBHARDWARECONNECTOR                , "no" ,"0 or 1", "eCONF_ENABLE_TESTMODE_SETUSBHARDWARECONNECTOR"               ,eNO , "function PrmManager::bSetUSBHardwareConnector() is used to enable/disable VBUS of correspodning USB connector. E.g. PSA VBUS for all 3 connectors is switched off at once &&TTFIS gets hence with this value VBUS is switched on again to analyse traces","-",FALSE},  //PSA due to customer based numbering of USB connectors plus one chip responsible for VBUS of all USB connectors e.g. OC1,PPON1 is used for USB3,2,1 such scenario is configurable
    {eCONF_ENABLE_NOTIFY_FIRST_SUPPORTED_PARTITION                , "no" ,"0 or 1", "eCONF_ENABLE_NOTIFY_FIRST_SUPPORTED_PARTITION"               ,eNO , "Select first valid parition supported by the project provided the USB stick has more than one partitions","-",FALSE},  //Sending the first supported partition to the clients provided the USB supports more than one partitions.
    {eConf_ENABLE_MALFUNCTION_USBCONNECTORS                       , "no" ,"0 or 1", "eConf_ENABLE_MALFUNCTION_USBCONNECTORS"                      ,eNO , "Used to block/unblock usage of corresponding functions of IStateTableHWMalfunction","VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED",FALSE},  //Used to block/unblock usage of corresponding functions of IStateTableHWMalfunction and it is bound to VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED
    {eCONF_TIMOUT_MALFUNCTION_SET_PERMANENT                       , "no" ,"10...30s","eCONF_TIMOUT_MALFUNCTION_SET_PERMANENT"                     ,eNO , "If a device is set MALFUNCTION then mechanism to monitor if the malfunction is started to check if time of malfunction exceeds this configurable value. In this manner  MALFUNCTION_PERMANENT could be send to clients","-",FALSE},
    {eCONF_USBCOMPARETIME_MALFUNCTION_OR_REMOVE                   , "no" ,"400...2000ms",  "eCONF_USBCOMPARETIME_MALFUNCTION_OR_REMOVE"           ,eNO , "Occurrences malfunction are send to DeviceManager which stores it with time stamp. If it receives a ‘device removed’ it uses this configurable ‘compare time’ to decide if the remove has to be adjusted to MALFUNCTION to be send to clients","-",FALSE},
    {eConf_ENABLE_MALFUNCTION_SDCARDINTERNAL                      , "no" ,"0 or 1",  "eConf_ENABLE_MALFUNCTION_SDCARDINTERNAL"                    ,eNO , "Used to block/unblock usage of corresponding functions of IStateTableHWMalfunction ","VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_SDCARD_DEVICE,VARIANT_S_FTR_ENABLE_DEVMGR_HW_SDCARD ",FALSE},
    {eConf_ENABLE_MALFUNCTION_CDROMINTERNAL                       , "no" ,"0 or 1",  "eConf_ENABLE_MALFUNCTION_CDROMINTERNAL"                     ,eNO , "Used to block/unblock usage of corresponding functions of IStateTableHWMalfunction ","VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM",FALSE},
    {eConf_ENABLE_MSD_WAIT_FOR_PARTITIONS_ALL                     , "no" ,"0 or 1",  "eConf_ENABLE_MSD_WAIT_FOR_PARTITIONS_ALL"                   ,eNO , "Find the All the partitions of the MSD devices such as USB sticks and SD card.","-",FALSE},
    {eConf_MAXIMUM_SUPPORTED_PARTITIONS_MSD                       , "no" ,"0...0xff",  "eConf_MAXIMUM_SUPPORTED_PARTITIONS_MSD"                   ,eNO , "Number of partitions supported by MSD devices such as USB sticks and SD card","-",FALSE},
    {eCONF_ENABLE_HWInternalHUBRealizesUSB1                       , "no" ,"0 or 1",  "eCONF_ENABLE_HWInternalHUBRealizesUSB1"                     ,eNO , "Support devices at USB1 connected through internal hub","-",FALSE},
    {eCONF_ENABLE_HWInternalHUBRealizesUSB2                       , "no" ,"0 or 1",  "eCONF_ENABLE_HWInternalHUBRealizesUSB2"                     ,eNO , "Support devices at USB2 connected through internal hub","-",FALSE},
    {eCONF_ENABLE_HWInternalHUBRealizesUSB3                       , "no" ,"0 or 1",  "eCONF_ENABLE_HWInternalHUBRealizesUSB3"                     ,eNO , "Support devices at USB3 connected through internal hub","-",FALSE},
    {eCONF_ENABLE_HWInternalHUBRealizesUSB4                       , "no" ,"0 or 1",  "eCONF_ENABLE_HWInternalHUBRealizesUSB4"                     ,eNO , "Support devices at USB4 connected through internal hub","-",FALSE},
    {eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1                 , "no" ,"0...8",  "eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1"                ,eNO , "Allow HUB at Hub at USB1 with certain number of ports","-",TRUE},
    {eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2                 , "no" ,"0...8",  "eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2"                ,eNO , "Allow HUB at Hub at USB2 with certain number of ports","-",TRUE},
    {eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB3                 , "no" ,"0...8",  "eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB3"                ,eNO , "Allow HUB at Hub at USB3 with certain number of ports","-",TRUE},
    {eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4                 , "no" ,"0...8",  "eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4"                ,eNO , "Allow HUB at Hub at USB4 with certain number of ports","-",TRUE},
    {eCONF_ENABLE_HUBconnectedToHUBPermanent                      , "no" ,"0 or 1",  "eCONF_ENABLE_HUBconnectedToHUBPermanent"                    ,eNO , "Internal value used by the class to enable permanent hub to hub feature","-",FALSE},
    {eCONF_TIMEOUT_ITC_USB_OPEN_CIRCUIT                           , "no" ,"10...120s","eCONF_TIMEOUT_ITC_USB_OPEN_CIRCUIT"                        ,eNO , "Time out used to decide whether to change the value of ITC USB - Circuit open","-",FALSE},
    {eCONF_ENABLE_MSD_BIGGEST_PARTITION                           , "no" ,"0 or 1", "eCONF_ENABLE_MSD_BIGGEST_PARTITION"                          ,eNO , "Find the Biggest of all the partitions of the MSD devices such as USB sticks and SD card.","-",FALSE},
    {eCONF_ENABLE_SORT_PARTITIONS_ALL                             , "no" ,"0 or 1", "eCONF_ENABLE_SORT_PARTITIONS_ALL"                            ,eNO , "Sorts all the partitions of the MSD devices such as USB sticks and SD card based on its size.","-",FALSE},
    {eCONF_ENABLE_HWSIGNALS_SWAPPING                              , "no" ,"0 or 1", "eCONF_ENABLE_HWSIGNALS_SWAPPING"                             ,eNO  , "!!!OBSOLETE!!! Replaced by eCONF_HWSIGNAL_SOURCE_USB(Swaps the source of hardware signals for example CAF projects needs different naming for ports)","-",FALSE},
    {eCONF_ENABLE_GETMSC_FREE_USED_SIZE                           , "no" ,"0 or 1", "eCONF_ENABLE_GETMSC_FREE_USED_SIZE"                          ,eNO  , "RNAIVI startup could be speeded up if statfs (or df) is not called to get free, used and total size","-",FALSE},
    {eCONF_ENABLE_AUTOMOUNTER_SHAREDLIBIF                         , "no" ,"0 or 1", "eCONF_ENABLE_AUTOMOUNTER_SHAREDLIBIF"                        ,eNO  , "Enable to AutmounterAdapter to use shared lib interface instead of text based interface in /tmp/.autmounter","-",FALSE},
    {eCONF_ENABLE_PERSISTENT_STORAGE_FOR_CONFIG_PARAMS            , "no" ,"0 or 1", "eCONF_ENABLE_PERSISTENT_STORAGE_FOR_CONFIG_PARAMS"           ,eNO  , "PSA they need to store the configuration values in persistent memory to enable the hub to hub connection. DVM using datapool to write the values to persistent memory","-",FALSE},
    {eCONF_ENABLE_observeDTC_INTERVALL                            , "no" ,"0 or 1", "eCONF_ENABLE_observeDTC_INTERVALL"                           ,eNO  , "A thread is executing in dependency of this time intervall to collect diagnosis values to send it to diaglog. Dependency: see  eCONF_ENABLE_observeDTC for USB1, USB2 ...","-",FALSE},
    {eCONF_ENABLE_DTC_HUB_NUMOFPORTS_MISMATCH_VARIANT2            , "no" ,"0 or 1", "eCONF_ENABLE_DTC_HUB_NUMOFPORTS_MISMATCH_VARIANT2"           ,eNO  , "For RNAIVI: KDS used but not directly num of ports are written by the customer. PASSED is send if found ports of connected HUB are >=configured num of ports","-",FALSE},
    {eCONF_ENABLE_IMX_HOST_USB_2184200_ALLOWHUB                   , "no" ,"0 or 1", "eCONF_ENABLE_IMX_HOST_USB_2184200_ALLOWHUB"                  ,eNO  , "Routines in CommonReadTourinesKDS refer to IMX connectors not to Connectors visible at the outside -for this reason an intermediate setting of these values help to set others - used with gen3 architectur","-",FALSE},
    {eCONF_ENABLE_IMX_OTG__USB_2184000_ALLOWHUB                   , "no" ,"0 or 1", "eCONF_ENABLE_IMX_OTG__USB_2184000_ALLOWHUB"                  ,eNO  , "Routines in CommonReadTourinesKDS refer to IMX connectors not to Connectors visible at the outside -for this reason an intermediate setting of these values help to set others - used with gen3 architectur","-",FALSE},
    {eCONF_ENABLE_HIGHRISK4USB_HWMALFUNCTION                      , "no" ,"0 or 1", "eCONF_ENABLE_HIGHRISK4USB_HWMALFUNCTION"                     ,eNO  , "beside using directly HW signals which tell �f USB connectors fail or not it is possible to use critical voltage as input to set HWMALFUNCTION (temporary not available) for connected devices to Mediaplayer (RNAIVI is first customer)","-",FALSE},
    {eCONF_ENABLE_ITC_DATA_LINE_FAULT                             , "no" ,"0 or 1", "eCONF_ENABLE_ITC_DATA_LINE_FAULT"                            ,eNO  , "PSA needs to set the ITC ITC_DATA_LINE_FAULT for telematic boxes, if vd_devicemanager identifies a wrond device(older telematics box not present in the configurationn) or an invalid device like USB or iPod devices to configured usb port(PSARCC is first customer)","-",FALSE},
    {eCONF_ENABLE_DIAG_ITC_USB_LINK_DISABLED                      , "no" ,"0 or 1", "eCONF_ENABLE_DIAG_ITC_USB_LINK_DISABLED"                     ,eNO  , "RNAIVI needs the ITC LINK_DISABLED to be set when the hub is not present. The hub details are stored statically in the configuration files or in the persistent files. The dependency for setting the ITC LINK_DISABLED is eCONF_ENABLE_observeDTC_HUBatUSB1, eCONF_ENABLE_observeDTC_HUBatUSB2,eCONF_ENABLE_observeDTC_HUBatUSB3 and eCONF_ENABLE_observeDTC_HUBatUSB4","-",FALSE},
    {eCONF_ENABLE_NOTIFY_CUSTOMER_HUBS                            , "no" ,"0 or 1", "eCONF_ENABLE_NOTIFY_CUSTOMER_HUBS "                          ,eNO  , "Added for USBComplianceFor if enabled, Customer Hub or not...unsupportedreason of deviceproperty is filled","-",FALSE},
    {eCONF_ENABLE_NOTIFY_UNKNOWN_DEVICES                          , "no" ,"0 or 1", "eCONF_ENABLE_NOTIFY_UNKNOWN_DEVICES "                        ,eNO  , "Added for USBComplianceFor if enabled, Supported USb device or not...unsupportedreason of deviceproperty is filled","-",FALSE},
    {eCONF_ENABLE_LIBUSB_ATSTARTUP_SHOWALLDEVICES                 , "no" ,"0 or 1", "eCONF_ENABLE_LIBUSB_ATSTARTUP_SHOWALLDEVICES "               ,eNO  , "Formerly always part of the software to see inconsistency between libusb & udev. Now disabled  to reduce load. Disabled: Less communication at usb-bus and prevent access to devices where root is demanded","-",FALSE},
    {eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT           , "no" ,"0 or 1", "eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT "         ,eNO  , "if VD_DVM and VD_MMGR are fully started but user has pressed eject before start of these components. VD_DVM checks at startup if such eject and does care for it","-",FALSE},
    {eCONF_ENABLE_NOTIFY_DEVPATH                                  , "no" ,"0 or 1", "eCONF_ENABLE_NOTIFY_DEVPATH "                                ,eNO  , "Notify clients about the devpath,i.e., syspath of the device connected at port","-",FALSE},
    {eCONF_ENABLE_DELAY_NOTIFY_MTP_DEVICES                        , "no" ,"0 or 1", "eCONF_ENABLE_DELAY_NOTIFY_MTP_DEVICES "                      ,eNO  , "PSARCC - This will delay the notification  of MTP devices till the SPI updates that  delaying the MTP devices  is not needed for a device or the configured timeout(DEVICETYPE_RETRY_ELAPSED_TIMESEC) is reached.","-",FALSE},
    {eConf_ENABLE_DTC_MAP_TCU_OC_PORT3                            , "no" ,"0 or 1", "eConf_ENABLE_DTC_MAP_TCU_OC_PORT3 "                          ,eNO  , "RNAIVI expects TCU  (Telematics box) always to be bound to USB3. This is valid also for targets which do have only two external USB connectors. Hence a mapping is necessary.","-",FALSE},
    {eConf_ENABLE_DTC_MAP_ETC_OC_PORT2                            , "no" ,"0 or 1", "eConf_ENABLE_DTC_MAP_ETC_OC_PORT2 "                          ,eNO  , "RNAIVI expects ETC  (Eletronic toll collect ) always to be bound to USB2..","-",FALSE},
    {eCONF_ENABLE_TRISTATE_DIAGNOSIS                               , "no" ,"0 or 1", "eCONF_ENABLE_TRISTATE_DIAGNOSIS "                             ,eNO  , "This will enable the tristate logic in checking mediastatusbits in Diagnosis IOControl. If not enabled, backward compatible code is used.","-",FALSE},
    {eCONF_ENABLE_MEDIAMANAGER_CLIENTHANDLER                      , "no" ,"0 or 1", "eCONF_ENABLE_MEDIAMANAGER_CLIENTHANDLER "                     ,eNO  , "This will enable the MediaManager Cliethandler to receive CD related updates from Mediamanager","-",FALSE},
    {eCONF_STATETABLE_CONNECT_EXECUTION_TIME_MS                   , "no" ,"0...300ms", "eCONF_STATETABLE_CONNECT_EXECUTION_TIME_MS"               ,eNO , "Statetable has a time window where it waits so that multiple connects can be sent in a single update","-",FALSE},
    {eCONF_ENABLE_SUPPRESS_APPLE_DEVICE_WITHOUT_CUSTOMERHUB       , "no" ,"0 or 1", "eCONF_ENABLE_SUPPRESS_APPLE_DEVICE_WITHOUT_CUSTOMERHUB"      ,eNO , "For INF4CV, apple devices should be notified as unsupported if it is not connected through a customer hub","-",FALSE}
   //----------------------------------------------------------------

/*-----------------------------------------------------------------------------------------------------------------------------------------*/
};

ConfigurationBase::ConfigurationBase()
{
    vClear(); //sets most values to DVM_OFF
    vInitBaseConfig(); //inits in dependency of VarianSwitches see ai_mediaplayer_prod.xml
    bCheckConsistencyOfConfigValuesDescription();//Used to check all of configuration parameters described properly in the struct m_rConfigValueDescription

    /*Note:
          consistency check of parameters initialised in ConfigurationProduct is called in contructor of ConfigurationManager
          Base class constructors are always called in the derived class constructors.
          Whenever you create derived class object, first the base class default constructor is executed and then the derived class's constructor finishes execution.
      */
}

void ConfigurationBase::TracestrSysPathEntryUSBPortAdressForUSBConnector()
{
    for(int i= (int)eUSB1;i < (int)eUSBAll; i++)
    {
#ifdef USE_OLD_GETSYSPATH
        ETG_TRACE_USR4(("ConfigurationBase: m_strSysPathEntryUSBPortAdressForUSBConnector[eUSB%d] : %s",i, m_strSysPathEntryUSBPortAdressForUSBConnector[i].c_str()));
#else
            ETG_TRACE_USR4(("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"));
            ETG_TRACE_USR4(("ConfigurationBase: m_rCustomerUSBConnectorConfig[eUSB%d].eConnectorInfo                                : %d",i, m_rCustomerUSBConnectorConfig[i].eConnectorInfo));
            ETG_TRACE_USR4(("ConfigurationBase: m_rCustomerUSBConnectorConfig[eUSB%d].m_strSysPathEntryUSBPortAdressForUSBConnector : %s",i, m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortAdressForUSBConnector.c_str()));
            ETG_TRACE_USR4(("ConfigurationBase: m_rCustomerUSBConnectorConfig[eUSB%d].m_strSysPathEntryUSBPortHubForUSBConnector    : %s",i, m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortHubForUSBConnector.c_str()));
            ETG_TRACE_USR4(("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"));
#endif
    }
}

void ConfigurationBase::vInitBaseConfig()
{
    tUInt i;

   //>------------------------------------------------------------------
   strMatchers[eMatcherEmpty]                               = "";

   //gen3 IMX
#ifdef USE_TMP_WORKAROUND_CLEO2
//gen4 Renesas
   strMatchers[eMatcherGen3UsbImxOtgConnector]              = "/ee080100.usb/"; //OTG (name used in platform)
   //go into this direction:  strMatchers[eMatcherGen3UsbRenesasOtgConnector]          = "/ee080100.usb/"; //OTG (name used in platform)
#else
   strMatchers[eMatcherGen3UsbImxOtgConnector]              = "/2184000.usb/"; //OTG (name used in platform)
#endif
   strMatchers[eMatcherGen3UsbImxHostConnector]             = "/2184200.usb/";  //Host without external HUB (name used in platform)
   strMatchers[eMatcherGen3UsbImxHostConnectorIntHubPort1]  = "2-1.1";
   strMatchers[eMatcherGen3UsbImxHostConnectorIntHubPort2]  = "2-1.2";
   strMatchers[eMatcherGen3UsbImxHostConnectorIntHubPort3]  = "2-1.3";

   strMatchers[eMatcherNotUsedText]                         = "IS#NOT#USED#HERE";


   //<------------------------------------------------------------------

    m_eCustomer = eLastCustomer; //eLastCustomer means like undefined. set real value in ConfigurationProduct_gen3_<Customer>

    //Note: add new entry if tenCustomer will be extended
    m_strAllCustomerNames[eG3G]         = "G3G";
    m_strAllCustomerNames[eGMMY16]      = "GMMY16";
    m_strAllCustomerNames[eJACCII]      = "JACCII";
    m_strAllCustomerNames[ePSARCC]      = "PSARCC";
    m_strAllCustomerNames[eRNAIVI]      = "RNAIVI";
    m_strAllCustomerNames[eSUZSLN]      = "SUZSLN";
    m_strAllCustomerNames[eSPINUP]      = "SPINUP";
    m_strAllCustomerNames[eCAF]         = "CAF";
    m_strAllCustomerNames[eCHERY]       = "eCHERY";
    m_strAllCustomerNames[eVAGMIBE]     = "VAGMIBE";
    m_strAllCustomerNames[eWHITELABEL]  = "WHITELABEL";
    m_strAllCustomerNames[eLESS]        = "LESS";

    bUseMArketingRegion = FALSE;

    m_strBlockDevNameSDCardInternalWithoutDev           = "mmcblk0";
    m_strBlockDevNameCDROMInternalWithoutDev            = "sr0";
    m_strBlockDevNameDVDInternalUSBConnectedWithoutDev  = "sr0";


    m_strBlockDevNameSDCardInternal           = "/dev/mmcblk0";
    m_strBlockDevNameCDROMInternalPart            = "/dev/sr";
    m_strBlockDevNameDVDInternalUSBConnectedPart  = "/dev/sr";


    /*bound to eConf_ENABLE_EXTERNAL_BTA (Box Telematic Automous) - see e.g. ConfigurationProduct for PSAARCC and RNAIVI*/
    for(i = 0; i< iMaxSizeOfArray; i++)
    {
        m_uiTelematicsBoxDeviceInfo[i].iVendorID            = DVM_OFF;
        m_uiTelematicsBoxDeviceInfo[i].iProductID           = DVM_OFF;
        m_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected = FALSE;

    }
    m_uiNumberOfTelematicBoxesUsed = 0;

    /*bound to eConf_ENABLE_EXTERNAL_DIGIAUX (auxin) - see e.g. ConfigurationProduct for GM*/
    for(i = 0; i< iMaxSizeOfArray; i++)
    {
        m_uiDigitalAuxinDeviceInfo[i].iVendorID            = DVM_OFF;
        m_uiDigitalAuxinDeviceInfo[i].iProductID           = DVM_OFF;
    }
    m_uiNumberOfDigitalAuxinDevicesUsed = 0;



    for(i= (tUInt)eUSB1; i<(tUInt)eUSBAll;i++)
    {
        m_eUSBPresent[i]                      = (tenDevManagerConfigValue)((tUInt)eCONF_ENABLE_USB1              +(i-1));
        m_eHUBAndPortsEnable[i]               = (tenDevManagerConfigValue)((tUInt)eCONF_ENABLE_HUBandPORTSatUSB1 +(i-1));
        m_eHUBconnectedToHUBAndPortsEnable[i] = (tenDevManagerConfigValue)((tUInt)eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 +(i-1));
    }


#ifdef USE_OLD_GETSYSPATH
    m_strSysPathEntryUSBPortAdressForUSBConnector[(tUInt)eUSB1] = "/2184200.usb/";  //IMXConnectorUSB1      //Host without external HUB (name used in platform)
    m_strSysPathEntryUSBPortAdressForUSBConnector[(tUInt)eUSB2] = "/2184000.usb/";  //IMXConnectorUSB2     //OTG (name used in platform)
    m_strSysPathEntryUSBPortAdressForUSBConnector[(tUInt)eUSB3] = "IS#NOT#USED#HERE";  //see ConfigurationProduct_Gen3_PSA it defines a third one. Note: Reason for change. After change for USB3  this test failed  ConfigurationManagerTestFixture.02_2_vGetUSBConnectorFromSysPath_SyspathContainsPortAdressUnknown_ReturnUSBUndef
#else
    //USB1
    m_rCustomerUSBConnectorConfig[eUSB1].eConnectorInfo = eConnectorRealisedDirect;
#ifdef USE_SYSPATH_MATCHER
    m_rCustomerUSBConnectorConfig[eUSB1].m_strSysPathEntryUSBPortAdressForUSBConnector = strMatchers[eMatcherGen3UsbImxHostConnector];  //IMXConnectorUSB1      //Host without external HUB (name used in platform)
    m_rCustomerUSBConnectorConfig[eUSB1].m_strSysPathEntryUSBPortHubForUSBConnector   =  strMatchers[eMatcherEmpty];
#else
    m_rCustomerUSBConnectorConfig[eUSB1].m_strSysPathEntryUSBPortAdressForUSBConnector = "/2184200.usb/";  //IMXConnectorUSB1      //Host without external HUB (name used in platform)
    m_rCustomerUSBConnectorConfig[eUSB1].m_strSysPathEntryUSBPortHubForUSBConnector   = "";
#endif //USE_SYSPATH_MATCHER

    //USB2
    m_rCustomerUSBConnectorConfig[eUSB2].eConnectorInfo = eConnectorRealisedDirect;
#ifdef USE_SYSPATH_MATCHER
    m_rCustomerUSBConnectorConfig[eUSB2].m_strSysPathEntryUSBPortAdressForUSBConnector = strMatchers[eMatcherGen3UsbImxOtgConnector];  //IMXConnectorUSB2     //OTG (name used in platform)
    m_rCustomerUSBConnectorConfig[eUSB2].m_strSysPathEntryUSBPortHubForUSBConnector    = strMatchers[eMatcherEmpty];
#else
    m_rCustomerUSBConnectorConfig[eUSB2].m_strSysPathEntryUSBPortAdressForUSBConnector = "/2184000.usb/";  //IMXConnectorUSB2     //OTG (name used in platform)
    m_rCustomerUSBConnectorConfig[eUSB2].m_strSysPathEntryUSBPortHubForUSBConnector   = "";
#endif

    //USB3 - not used in default configuration //  //Note: Some targets use an internal HUB to create a 3rd USB i.e. 2 are connected through the HUB one is directly connected to IMX
    m_rCustomerUSBConnectorConfig[eUSB3].eConnectorInfo = eConnectorUnused;
#ifdef USE_SYSPATH_MATCHER
    m_rCustomerUSBConnectorConfig[eUSB3].m_strSysPathEntryUSBPortAdressForUSBConnector = strMatchers[eMatcherNotUsedText];  //see ConfigurationProduct_Gen3_PSA it defines a third one. Note: Reason for change. After change for USB3  this test failed  ConfigurationManagerTestFixture.02_2_vGetUSBConnectorFromSysPath_SyspathContainsPortAdressUnknown_ReturnUSBUndef
    m_rCustomerUSBConnectorConfig[eUSB3].m_strSysPathEntryUSBPortHubForUSBConnector    = strMatchers[eMatcherEmpty];
#else
    m_rCustomerUSBConnectorConfig[eUSB3].m_strSysPathEntryUSBPortAdressForUSBConnector = "IS#NOT#USED#HERE";  //see ConfigurationProduct_Gen3_PSA it defines a third one. Note: Reason for change. After change for USB3  this test failed  ConfigurationManagerTestFixture.02_2_vGetUSBConnectorFromSysPath_SyspathContainsPortAdressUnknown_ReturnUSBUndef
    m_rCustomerUSBConnectorConfig[eUSB3].m_strSysPathEntryUSBPortHubForUSBConnector    = "";
#endif

#endif


    //note this could be made more generic but in this way it gives a check if build in ok
    m_eDeviceType[eCONF_ENABLE_EXTERNAL_SD]               = CGlobalEnumerations::DTY_SD;
    m_eDeviceType[eCONF_ENABLE_EXTERNAL_USB]              = CGlobalEnumerations::DTY_USB;
    m_eDeviceType[eCONF_ENABLE_EXTERNAL_MTP]              = CGlobalEnumerations::DTY_MTP;
    m_eDeviceType[eCONF_ENABLE_EXTERNAL_IPOD]             = CGlobalEnumerations::DTY_IPOD;
    m_eDeviceType[eCONF_ENABLE_EXTERNAL_IPAD]             = CGlobalEnumerations::DTY_IPAD;
    m_eDeviceType[eCONF_ENABLE_EXTERNAL_IPHONE]           = CGlobalEnumerations::DTY_IPHONE;
    m_eDeviceType[eCONF_ENABLE_INTERNAL_CDROM]            = CGlobalEnumerations::DTY_CDROM;
    m_eDeviceType[eCONF_ENABLE_INTERNAL_CDDA]             = CGlobalEnumerations::DTY_CDDA;
    m_eDeviceType[eCONF_ENABLE_INTERNAL_SDCARD]           = CGlobalEnumerations::DTY_SD_INTERNAL;
    m_eDeviceType[eConf_ENABLE_EXTERNAL_DIGIAUX]          = CGlobalEnumerations::DTY_DIGIAUX;
    m_eDeviceType[eConf_ENABLE_EXTERNAL_BTA]              = CGlobalEnumerations::DTY_BTA;
    m_eDeviceType[eConf_ENABLE_EXTERNAL_HUB]              = CGlobalEnumerations::DTY_HUB;
    m_eDeviceType[eConf_ENABLE_INTERNAL_DVD_DRIVE]        = CGlobalEnumerations::DTY_DVD_DRIVE; //Roadmap 1615 Internal DVD Drive

    m_eDeviceType[eCONF_ENABLE_EXTERNAL_UNSUPPORTED]      = CGlobalEnumerations::DTY_NOT_SUPPORTED;

    m_eFileSystemType[eCONF_ENABLE_FILESYSTEM_FAT]        = CGlobalEnumerations::FSTY_FAT;
    m_eFileSystemType[eCONF_ENABLE_FILESYSTEM_NTFS]       = CGlobalEnumerations::FSTY_NTFS;
    m_eFileSystemType[eCONF_ENABLE_FILESYSTEM_EXTFAT]     = CGlobalEnumerations::FSTY_EXFAT;
    m_eFileSystemType[eCONF_ENABLE_FILESYSTEM_HFSPLUS]    = CGlobalEnumerations::FSTY_HFS;
    m_eFileSystemType[eCONF_ENABLE_FILESYSTEM_EXT_3_4_FS] = CGlobalEnumerations::FSTY_EXT3_4;
    m_eFileSystemType[eCONF_ENABLE_FILESYSTEM_ISO9660]    = CGlobalEnumerations::FSTY_ISO9660;
    m_eFileSystemType[eCONF_ENABLE_FILESYSTEM_UDF]        = CGlobalEnumerations::FSTY_UDF;


    //--------------------------------------------
    //enable device types
    //--------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_SDCARD_DEVICES
    m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_SD]                         = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_USBMSC_DEVICES
    m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_USB]                        = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_MTP_DEVICES
    m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_MTP]                        = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_APPLE_DEVICES
    m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPOD]                       = DVM_ON;
#ifndef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS
    m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPAD]                       = DVM_ON;
#endif //VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS
    m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPHONE]                     = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE
    m_u16ConfigurationValue[eCONF_ENABLE_INTERNAL_CDROM]                      = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_SDCARD_DEVICE
    m_u16ConfigurationValue[eCONF_ENABLE_INTERNAL_SDCARD]                     = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_DIGIAUX_DEVICE
    m_u16ConfigurationValue[eConf_ENABLE_EXTERNAL_DIGIAUX]                    = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_BTA_DEVICE
    m_u16ConfigurationValue[eConf_ENABLE_EXTERNAL_BTA]                        = DVM_ON;
    m_u16ConfigurationValue[eCONF_ENABLE_TELEMATICSBOX_MONITORING]            = DVM_TELEMATICSBOX_MONITOR_INTERVAL_SEC;
    m_u16ConfigurationValue[eConf_ENABLE_DTC_MAP_TCU_OC_PORT3]                = DVM_OFF;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_EXTERNAL_ETC_DEVICE  //not set currently - code prepared fo the future
/*
m_u16ConfigurationValue[eConf_ENABLE_EXTERNAL_ETC]                                 = DVM_ON;
m_u16ConfigurationValue[eConf_ENABLE_DTC_MAP_ETC_OC_PORT2]                = DVM_OFF;
*/
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDDA_DEVICE

    m_u16ConfigurationValue[eCONF_ENABLE_INTERNAL_CDDA]                       = DVM_ON;
#endif

    //--------------------------------------------
    //enable USB connector
    //--------------------------------------------
    m_u16ConfigurationValue[eCONF_ENABLE_HW_USB1]                             = DVM_ON;
    m_u16ConfigurationValue[eCONF_ENABLE_HW_USB2]                             = DVM_ON;
    m_u16ConfigurationValue[eCONF_ENABLE_HW_USB3]                             = DVM_OFF;
    m_u16ConfigurationValue[eCONF_ENABLE_HW_USB4]                             = DVM_OFF;

    //if disabled the ports connected to port will not be monitored for OC
    m_u16ConfigurationValue[eCONF_HUB_HWSIGNAL_MONITOR_INTERVAL]              = DVM_OFF;

    //--------------------------------------------
    //if disabled VD_DVM suppresses notification to clients
    //--------------------------------------------
    m_u16ConfigurationValue[eCONF_ENABLE_USB1]                                = DVM_ON; //similar to eCONF_SYSTEM_OFFERING_BYTE1Bit7_USB1Present //@todo cleanup code
    m_u16ConfigurationValue[eCONF_ENABLE_USB2]                                = DVM_ON; //similar to eCONF_SYSTEM_OFFERING_BYTE1Bit6_USB2Present //@todo cleanup code
    m_u16ConfigurationValue[eCONF_ENABLE_USB3]                                = DVM_OFF;
    m_u16ConfigurationValue[eCONF_ENABLE_USB4]                                = DVM_OFF;

    //--------------------------------------------
    //if disabled VD_DVM supresses notfication of devices connected to a HUB
    //--------------------------------------------
    m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]                   = DVM_ON;
    m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB2]                   = DVM_ON;
    m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB3]                   = DVM_OFF;
    m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB4]                   = DVM_OFF;


    //--------------------------------------------
    //if enabled HUBs will be observed for open circuit and overcurrent
    //--------------------------------------------
    m_u16ConfigurationValue[eCONF_ENABLE_observeDTC_HUBatUSB1]                = DVM_OFF;
    m_u16ConfigurationValue[eCONF_ENABLE_observeDTC_HUBatUSB2]                = DVM_OFF;
    m_u16ConfigurationValue[eCONF_ENABLE_observeDTC_HUBatUSB3]                = DVM_OFF;
    m_u16ConfigurationValue[eCONF_ENABLE_observeDTC_HUBatUSB4]                = DVM_OFF;


    //--------------------------------------------
    //If the values are enabled, the hardware signals from the PRM will be used for the USB ports
    //--------------------------------------------
    m_u16ConfigurationValue[eCONF_HWSIGNAL_SOURCE_USB1]                       = DVM_PRMPORT1_USED;
    m_u16ConfigurationValue[eCONF_HWSIGNAL_SOURCE_USB2]                       = DVM_PRMPORT2_USED;
    m_u16ConfigurationValue[eCONF_HWSIGNAL_SOURCE_USB3]                       = DVM_OFF;
    m_u16ConfigurationValue[eCONF_HWSIGNAL_SOURCE_USB4]                       = DVM_OFF;


    //--------------------------------------------
    // configuration to support certain filesystem types
    //--------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_FAT
    m_u16ConfigurationValue[eCONF_ENABLE_FILESYSTEM_FAT]                      = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_NTFS
    m_u16ConfigurationValue[eCONF_ENABLE_FILESYSTEM_NTFS]                     = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXTFAT
    m_u16ConfigurationValue[eCONF_ENABLE_FILESYSTEM_EXTFAT]                   = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_HFSPLUS
    m_u16ConfigurationValue[eCONF_ENABLE_FILESYSTEM_HFSPLUS]                  = DVM_ON;
#endif
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_SUPPORT_EXT_3_4_FS
    m_u16ConfigurationValue[eCONF_ENABLE_FILESYSTEM_EXT_3_4_FS]               = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_INTERNAL_CDROM_DEVICE
    m_u16ConfigurationValue[eCONF_ENABLE_FILESYSTEM_ISO9660]                  = DVM_ON;
    m_u16ConfigurationValue[eCONF_ENABLE_FILESYSTEM_UDF]                      = DVM_ON;
#endif

    m_u16ConfigurationValue[eCONF_ENABLE_LIMIT_SIZE_MSD]                      = DVM_OFF;

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_CHARGE_APPLE_DEVICES
    m_u16ConfigurationValue[eCONF_ENABLE_CHARGE_APPLEDEVS]                    = DVM_ON;
#endif

#ifdef USE_EXTERNAL_UNSUPPORTED_DEVICES
    m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_UNSUPPORTED]                = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_DEVTYPE
    m_u16ConfigurationValue[eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE]          = DVM_ON;
    m_u16ConfigurationValue[eCONF_ENABLE_NOTIFY_UNSUPPORTED_HUB]              = DVM_ON; //Under construction
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_UNSUPPORTED_FILESYSTEM
    m_u16ConfigurationValue[eCONF_ENABLE_NOTIFY_UNSUPPORTED_FILESYSTEM]       = DVM_ON;
#endif

    m_u16ConfigurationValue[eCONF_STATETABLE_EXECUTION_TIME_MS]               = STATETABLE_EXECUTION_TIME_MS;
    m_u16ConfigurationValue[eCONF_STATETABLE_CONNECT_EXECUTION_TIME_MS]       = STATETABLE_CONNECT_EXECUTION_TIME_MS;

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_PARTITIONS_ALL
    m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_PARTITIONS_ALL]               = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_AS_IPOD
#ifndef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_IPAD_SUPPRESS
    m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_IPAD_AS_IPOD]                 = DVM_ON;
#endif
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_SDINT_AS_SD
    m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_SDINT_AS_SD]                  = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_NOTIFY_CDROM_AS_USBMSC
    m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_CDROM_AS_USB]                 = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_CYCLIC_DIAGNOSIS
    m_u16ConfigurationValue[eConf_ENABLE_CYCLIC_DIAGNOSIS]                    = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USE_DRV_VOLT
    m_u16ConfigurationValue[eConf_ENABLE_USE_VOLTAGEMANAGER]                    = DVM_ON;
    m_u16ConfigurationValue[eConf_ENABLE_ITC_OVERCURRENT_SUPPRESSED_IFCRITVOLT] = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_PRM_USED
    m_u16ConfigurationValue[eConf_ENABLE_USE_PRM_HWSIGNALS]                   = DVM_ON;
#endif



#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_HW_SDCARD
    m_u16ConfigurationValue[eConf_ENABLE_USE_PRM_SDCARDSIGNALS]               = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USBHWCTRL
    m_u16ConfigurationValue[eConf_ENABLE_USR_PRM_HWCTRLUSB]                   = DVM_ON;
#endif

#ifdef USE_ENABLE_DEVMGR_GPIOIF
    m_u16ConfigurationValue[eConf_ENABLE_USE_GPIO_INTERFACE]                  = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DIAGLOG_DTC_USB_TRIGGERED_BY_HWSIGNALS
    m_u16ConfigurationValue[eConf_ENABLE_DIAGLOG_DTC_TRIGGERED_HWSIGNALS]     = DVM_ON;
#endif

    //for LSIM only
#if defined(GEN3X86)
    m_u16ConfigurationValue[eCONF_ENABLE_FAKE_SDCARD]                       = DVM_ON;
    m_u16ConfigurationValue[eConf_ENABLE_DEVICES_ALWAYS_AT_USB1]            = DVM_ON;
    m_u16ConfigurationValue[eConf_ENABLE_USE_PRM_HWSIGNALS]                 = DVM_OFF; //switch does appear above but not usable for LSIM
    m_u16ConfigurationValue[eConf_ENABLE_USE_VOLTAGEMANAGER]                = DVM_OFF; //switch does appear above but not usable for LSIM
#endif

#ifdef VARIANT_S_FTR_ENABLE_USAGE_ROOTDEAMON
    m_u16ConfigurationValue[eConf_ENABLE_USE_ROOTDAEMON]                    = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP
    m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP]      = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_IMPROVEDIF_NO_REDUNDAND_MSGS
    m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS]          = DVM_ON;
    m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP]      = DVM_OFF;
#endif

    m_u16ConfigurationValue[eCONF_ENABLE_GETMSC_FREE_USED_SIZE]             = DVM_ON;

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USE_AUTOMOUNTER_SHAREDLIBIF
    m_u16ConfigurationValue[eCONF_ENABLE_AUTOMOUNTER_SHAREDLIBIF]           = DVM_ON;
#endif

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
    m_u16ConfigurationValue[eCONF_ENABLE_PERSISTENT_STORAGE_FOR_CONFIG_PARAMS]= DVM_ON;
#endif

   m_u16ConfigurationValue[eCONF_ENABLE_observeDTC_INTERVALL] = (tU16)VD_CLIENTHANDLER_DIAGLOG_TIMER_TICK_INTERVAL_SEC;

   m_u16ConfigurationValue[eCONF_ENABLE_DTC_HUB_NUMOFPORTS_MISMATCH_VARIANT2] = DVM_ON;

   m_u16ConfigurationValue[eCONF_ENABLE_LIBUSB_ATSTARTUP_SHOWALLDEVICES]      = DVM_OFF;

   m_u16ConfigurationValue[eConf_ENABLE_INTERNAL_DVD_DRIVE]                            = DVM_OFF;

   //If enabled, mediamanager notificaitons are processed
   m_u16ConfigurationValue[eCONF_ENABLE_MEDIAMANAGER_CLIENTHANDLER]          = DVM_ON;


#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_USE_SPM_HISTORYTRIGGER_EJECT
   m_u16ConfigurationValue[eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT]= DVM_ON;
#endif

}


void ConfigurationBase::vClear()
{
    tInt i;

    bUseMArketingRegion = FALSE;

    m_strBlockDevNameSDCardInternal = "";
    m_strBlockDevNameCDROMInternalPart  = "";

    for(i=0;i<(tInt)eUSBAll;i++)
    {
        m_eHUBAndPortsEnable[i]                          = eCONF_LAST_ELEMENT;
        m_eHUBconnectedToHUBAndPortsEnable[i]            = eCONF_LAST_ELEMENT;
        m_eUSBPresent[i]                                 = eCONF_LAST_ELEMENT;
#ifdef USE_OLD_GETSYSPATH
        m_strSysPathEntryUSBPortAdressForUSBConnector[i] = "";
#else

        m_rCustomerUSBConnectorConfig[i].eConnectorInfo = eConnectorUnused;
        m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortAdressForUSBConnector = "";
        m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortHubForUSBConnector    = "";
#endif
    }

    for(i=0;i<=(tInt)eCONF_ENABLE_EXTERNAL_UNSUPPORTED;i++)
    {
        m_eDeviceType[i] = CGlobalEnumerations::DTY_UNKNOWN;
    }

    for(i=0;i<=(tInt)eCONF_ENABLE_FILESYSTEM_UDF;i++)
    {
        m_eFileSystemType[i] = CGlobalEnumerations::FSTY_UNKNOWN;
    }

    for(i=0;i<(tInt)eCONF_LAST_ELEMENT;i++)
    {
        m_u16ConfigurationValue[i] = DVM_OFF;
    }


}

tBool ConfigurationBase::bCheckConsistencyOfConfigValuesDescription()
{
    ETG_TRACE_USR4(("Begin: bCheckConsistencyOfConfigValuesDescription"));
    tBool bRet = TRUE;
    for(unsigned int i = 0; i< (unsigned int)eCONF_LAST_ELEMENT; i++)
    {
        if(i != (unsigned int)m_rConfigValueDescription[i].enConfigValue)
        {
            ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
            ETG_TRACE_FATAL(("bCheckConsistencyOfConfigValuesDescription: ERROR: m_rConfigValueDescription[index:%d].enConfigValue:%d",i,m_rConfigValueDescription[i].enConfigValue));
            ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
            bRet = FALSE;
            break;
        }
    }
    ETG_TRACE_USR4(("End  : bCheckConsistencyOfConfigValuesDescription: return:0x%x:bRet",bRet));
    return bRet;
}


tVoid ConfigurationBase::vGetUSBConnectorFromSysPath(OUT tenDevManagerUSBHost &eUsb, IN const std::string &strSysPath) const
{
    ETG_TRACE_USR4(("Begin: vGetUSBConnectorFromSysPath"));

    eUsb = eUSBUndef;

    std::size_t found;
    ETG_TRACE_USR2(("vGetUSBConnectorFromSysPath: strSysPath:%s",strSysPath.c_str()));

    //special case currently used for LSIM - see ConfigurationBase::vInitBaseConfig if product also want this then overwrite funtion
    if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_DEVICES_ALWAYS_AT_USB1])
    {
        ETG_TRACE_USR4(("vGetUSBConnectorFromSysPath: eConf_ENABLE_DEVICES_ALWAYS_AT_USB1 set DVM_ON all devices mapped to eUSB1"));
        eUsb = eUSB1;
    }
    //normal case e.g. used in GMMY16, SUZSLN, RNAIVI - PSA has to overwrite this funtion
    else
    {
        for(tInt i=(tInt)eUSB1;i<(tInt)eUSBAll;i++)
        {
#ifdef USE_OLD_GETSYSPATH
             ETG_TRACE_USR4(("vGetUSBConnectorFromSysPath: check :eUSB%d try search %s",i,m_strSysPathEntryUSBPortAdressForUSBConnector[i].c_str()));
             found = strSysPath.find(m_strSysPathEntryUSBPortAdressForUSBConnector[i]);

             if(found!=std::string::npos) //found it
             {
                 eUsb = (tenDevManagerUSBHost)i;
                 break;
             }
#else
             ETG_TRACE_USR4(("vGetUSBConnectorFromSysPath: check :eUSB%d try search %s",i,m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortAdressForUSBConnector.c_str()));
             found = strSysPath.find(m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortAdressForUSBConnector);

             //found IMX-string
             if(found!=std::string::npos)
             {
                 ETG_TRACE_USR4(("vGetUSBConnectorFromSysPath: eConnectorInfo: %d",m_rCustomerUSBConnectorConfig[i].eConnectorInfo));
                 switch (m_rCustomerUSBConnectorConfig[i].eConnectorInfo)
                 {
                     case eConnectorRealisedDirect:
                         eUsb = (tenDevManagerUSBHost)i;
                         break;
                     case eConnectorRealisedIntHub:
                         //check to adjust for eUSB3
                         found = strSysPath.find(m_rCustomerUSBConnectorConfig[i].m_strSysPathEntryUSBPortHubForUSBConnector);
                         if(found!=std::string::npos)
                         {
                             eUsb = (tenDevManagerUSBHost)i;
                         }
                         break;
                     case eConnectorUnused:
                         break;
                     default:
                         ETG_TRACE_FATAL(("[ERROR] vGetUSBConnectorFromSysPath: Unexpected value %d",(int)m_rCustomerUSBConnectorConfig[i].eConnectorInfo))
                         break;
                 }
                 if (found != std::string::npos) // If Internal Hub and is first entry with syspath
                 {
                     break;
                 }


             }
#endif

        }
    }

    ETG_TRACE_USR4(("End  : vGetUSBConnectorFromSysPath: result: eUSB %d",(int)eUsb));
}

tBool ConfigurationBase::bFilterIsTelematicsBox(IN unsigned int iVendorID, IN unsigned int iProductID)
{
    ETG_TRACE_USR4(("Begin: bFilterIsTelematicsBox iVendorID:%d, iProductID:%d",iVendorID,iProductID));
    tBool bRetVal = FALSE;

    if(m_uiNumberOfTelematicBoxesUsed <= iMaxSizeOfArray)
    {
        if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_EXTERNAL_BTA])
        {
            for( unsigned int i=0; i<m_uiNumberOfTelematicBoxesUsed; i++)
            {

                if( (iVendorID == m_uiTelematicsBoxDeviceInfo[i].iVendorID ) && (iProductID == m_uiTelematicsBoxDeviceInfo[i].iProductID) )
                {
                    bRetVal = TRUE;
                    break;
                }
            }
        }
    }
    else
    {
        ETG_TRACE_ERRMEM(("bFilterIsTelematicsBox: check configuration of bFilterIsTelematicsBox with iMaxSizeOfArray"));
        ETG_TRACE_FATAL(("bFilterIsTelematicsBox: check configuration of bFilterIsTelematicsBox with iMaxSizeOfArray"));
    }


    ETG_TRACE_USR4(("End  : bFilterIsTelematicsBox: bRetVal: 0x%x ",bRetVal));
    return bRetVal;
}


tBool ConfigurationBase::bFilterIsDigitalAuxInDevice(IN unsigned int iVendorID, IN unsigned int iProductID)
{
     ETG_TRACE_USR4(("Begin: bFilterIsDigitalAuxInDevice iVendorID:%d, iProductID:%d",iVendorID,iProductID));
    tBool bRetVal = FALSE;

    if(m_uiNumberOfDigitalAuxinDevicesUsed <= iMaxSizeOfArray)
    {
        if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_EXTERNAL_DIGIAUX])
        {
            for( unsigned int i=0; i<m_uiNumberOfDigitalAuxinDevicesUsed; i++)
            {

                if( (iVendorID == m_uiDigitalAuxinDeviceInfo[i].iVendorID ) && (iProductID == m_uiDigitalAuxinDeviceInfo[i].iProductID) )
                {
                    bRetVal = TRUE;
                    break;
                }
            }
        }
    }
    else
    {
        ETG_TRACE_ERRMEM(("bFilterIsDigitalAuxInDevice: check configuration of bFilterIsDigitalAuxInDevice with iMaxSizeOfArray"));
        ETG_TRACE_FATAL(("bFilterIsDigitalAuxInDevice: check configuration of bFilterIsDigitalAuxInDevice with iMaxSizeOfArray"));
    }


    ETG_TRACE_USR4(("End  : bFilterIsDigitalAuxInDevice: bRetVal: 0x%x ",bRetVal));
    return bRetVal;
}


tBool ConfigurationBase::vFillDeviceSpeed(IN tenDevManagerUSBHost eUsb,INOUT tBool &bHighSpeedDeviceExpected)
{
    ETG_TRACE_USR4(("Begin: vFillDeviceSpeed eUSB%d bHighSpeedDeviceExpected:%d",eUsb,bHighSpeedDeviceExpected));

    tBool bFound = FALSE;

    if(m_uiNumberOfTelematicBoxesUsed <= iMaxSizeOfArray)
    {
        if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_EXTERNAL_BTA])
        {
            for( unsigned int i=0; i<m_uiNumberOfTelematicBoxesUsed; i++)
            {

                if( eUsb == m_uiTelematicsBoxDeviceInfo[i].eUsb  )
                {
                    //the below functions is placed in inside the macro VARIANT_S_FTR_ENABLE_UNITTEST to avoid dependency with unit tests
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
                    bHighSpeedDeviceExpected=FALSE;
#else
                    //Additionally check whether the BTA device configured is connected or not
                    if(TRUE == DeviceListManager::GetInstance()->isDeviceConnected(m_uiTelematicsBoxDeviceInfo[i].iVendorID,m_uiTelematicsBoxDeviceInfo[i].iProductID,CGlobalEnumerations::DTY_BTA))
                    {
                        ETG_TRACE_USR4(("Begin: vFillDeviceSpeed eUSB%d",eUsb));
                        bFound = TRUE;
                        bHighSpeedDeviceExpected = m_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected;
                        break;
                    }
#endif //VARIANT_S_FTR_ENABLE_UNITTEST
                }
            }
        }
    }
    else
    {
        ETG_TRACE_ERRMEM(("vFillDeviceSpeed: check configuration of bFilterIsTelematicsBox with iMaxSizeOfArray"));
        ETG_TRACE_FATAL(("bFilterIsTelematicsBox: check configuration of bFilterIsTelematicsBox with iMaxSizeOfArray"));
    }
    ETG_TRACE_USR4(("Leaving  : vFillDeviceSpeed eUSB%d bHighSpeedDeviceExpected:%d",eUsb,bHighSpeedDeviceExpected));
    return bFound;
}

tBool ConfigurationBase::bFilterTelematicsBoxExpectedAtConnector(IN tenDevManagerUSBHost eUsb)
{
    ETG_TRACE_USR4(("Begin: bFilterTelematicsBoxExpectedAtConnector eUSB%d",eUsb));
    tBool bRet = FALSE;
    if(m_uiNumberOfTelematicBoxesUsed>0)
    {
        switch(eUsb)
        {
            case eUSB1:
                if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_TELEMATICSBOX_USB1])
                {
                    bRet = TRUE;
                }
                break;
            case eUSB2:
                if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_TELEMATICSBOX_USB2])
                {
                    bRet = TRUE;
                }
                break;
            case eUSB3:
                if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_TELEMATICSBOX_USB3])
                {

                    bRet = TRUE;
                }
                break;
#ifdef USE_FOURTH_USB_CONNECTOR
            case eUSB4:
                if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_TELEMATICSBOX_USB4])
                {

                    bRet = TRUE;
                }
                break;
#endif

             case eUSBAll:
             case eUSBUndef:
                {
                    ETG_TRACE_USR4(("bFilterTelematicsBoxExpectedAtConnector: for eUSBALL no setting possible"));
                }
                break;
        }
    }

    ETG_TRACE_USR4(("End  : bFilterTelematicsBoxExpectedAtConnector       "));

    return bRet;

}

tBool ConfigurationBase::bIsAppleDeviceSupported()
{
    ETG_TRACE_USR4(("Begin: bIsAppleDeviceSupported"));
    tBool bRetVal = FALSE;
    //If all Apple device related configs are disabled then Apple devices are not supported.
    if((DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPOD])
        || (DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPAD])
            || (DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPHONE]))
    {
        bRetVal = TRUE;//Apple devices are supported
    }

    ETG_TRACE_USR4(("End: bIsAppleDeviceSupported bRetVal: %d",bRetVal));
    return bRetVal;
}

tVoid ConfigurationBase::vEnableAppleDeviceSupport(tBool bEnable)
{
    ETG_TRACE_USR4(("Begin: vEnableAppleDeviceSupport bEnable: %d",bEnable));

    if(TRUE == bEnable)
    {
        m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPOD]                       = DVM_ON;
        m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPAD]                       = DVM_ON;
        m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPHONE]                     = DVM_ON;
    }
    else
    {
        m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPOD]                       = DVM_OFF;
        m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPAD]                       = DVM_OFF;
        m_u16ConfigurationValue[eCONF_ENABLE_EXTERNAL_IPHONE]                     = DVM_OFF;
    }

    ETG_TRACE_USR4(("End: vEnableAppleDeviceSupport"));
}

tVoid ConfigurationBase::vEnableHubConnectedToHubPermanent(tBool bEnable)
{
    ETG_TRACE_USR4(("Begin: vEnableHubConnectedToHubPermanent "));

    //If it is enabled hub connected to hub will be enabled for all the ports
    if(TRUE == bEnable)
    {
        //USB HW switched  on - all
        m_u16ConfigurationValue[eCONF_ENABLE_HW_USB1]                           = DVM_ON;
        m_u16ConfigurationValue[eCONF_ENABLE_HW_USB2]                           = DVM_ON;
        m_u16ConfigurationValue[eCONF_ENABLE_HW_USB3]                           = DVM_ON;
        m_u16ConfigurationValue[eCONF_ENABLE_HW_USB4]                           = DVM_ON;

        //enable all USB connector
        m_u16ConfigurationValue[eCONF_ENABLE_USB1]                              = DVM_ON;
        m_u16ConfigurationValue[eCONF_ENABLE_USB2]                              = DVM_ON;
        m_u16ConfigurationValue[eCONF_ENABLE_USB3]                              = DVM_ON;
        m_u16ConfigurationValue[eCONF_ENABLE_USB4]                              = DVM_ON;

        //enable 8 ports for connected HUB
        m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]                 = DVM_ON_8PORTS;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB2]                 = DVM_ON_8PORTS;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB3]                 = DVM_ON_8PORTS;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB4]                 = DVM_ON_8PORTS;

        //enable 8 ports for HUB connected to HUB
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1]   = DVM_ON_8PORTS;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2]   = DVM_ON_8PORTS;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB3]   = DVM_ON_8PORTS;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4]   = DVM_ON_8PORTS;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBPermanent]        = DVM_ON;


        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HW_USB1]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HW_USB1]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HW_USB2]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HW_USB2]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HW_USB3]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HW_USB3]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HW_USB4]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HW_USB4]));

        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_USB1]: %d", m_u16ConfigurationValue[eCONF_ENABLE_USB1]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_USB2]: %d", m_u16ConfigurationValue[eCONF_ENABLE_USB2]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_USB3]: %d", m_u16ConfigurationValue[eCONF_ENABLE_USB3]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_USB4]: %d", m_u16ConfigurationValue[eCONF_ENABLE_USB4]));

        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HUBandPORTSatUSB1]));


        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB3]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1]));
        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1]));

        ETG_TRACE_FATAL((" m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBPermanent]: %d", m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBPermanent]));

    }
    else
    {
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1]    = DVM_OFF;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB2]    = DVM_OFF;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB3]    = DVM_OFF;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB4]    = DVM_OFF;
        m_u16ConfigurationValue[eCONF_ENABLE_HUBconnectedToHUBPermanent]         = DVM_OFF;
    }
    //the variable m_eHUBconnectedToHUBAndPortsEnable is used in vFilterForConnectorsAndHubs
    for(unsigned int i= (tUInt)eUSB1; i<(tUInt)eUSBAll;i++)
    {
        m_eHUBconnectedToHUBAndPortsEnable[i] = (tenDevManagerConfigValue)((tUInt)eCONF_ENABLE_HUBconnectedToHUBandPORTSatUSB1 +(i-1));
    }



    ETG_TRACE_USR4(("End: vEnableHubConnectedToHubPermanent "));
}


tBool ConfigurationBase::isHubConnectedToHubPermanentEnabled()
{
    tBool bSend = FALSE;
    FILE *l_pAllowItFile;
    l_pAllowItFile = fopen (USE_HUB_CONNECTED_TO_HUB_ALLOW_IT_FILE, "r");
    if(NULL != l_pAllowItFile)
    {
        bSend = TRUE;
        fclose(l_pAllowItFile);
    }
    ETG_TRACE_USR4(("isHubConnectedToHubPermanentEnabled bSend : %d",ETG_ENUM(BOOL,bSend)));
    return bSend;
}


tBool ConfigurationBase::bFilterIsInternalHub(IN unsigned int iVendorID, IN unsigned int iProductID)
{
    ETG_TRACE_USR4(("Begin: bFilterIsInternalHub iVendorID:0x%x, iProductID:0x%x",iVendorID,iProductID));
    tBool bRetVal = FALSE;

    if(DVM_OFF != m_u16ConfigurationValue[eCONF_HUB_HWSIGNAL_MONITOR_INTERVAL])
    {
        if( (iProductID == m_uiInternalHubProductID) && (iVendorID == m_uiInternalHubVendorID) )
        {
            ETG_TRACE_USR4(("bFilterIsInternalHub: Internal Hub found"));
            bRetVal = TRUE;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("bFilterIsInternalHub: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
        ETG_TRACE_FATAL(("bFilterIsInternalHub: this function is not expected to be called"));
        ETG_TRACE_FATAL(("bFilterIsInternalHub: check configuration of eCONF_HUB_HWSIGNAL_MONITOR_INTERVAL"));
        ETG_TRACE_FATAL(("bFilterIsInternalHub: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
    }


    ETG_TRACE_USR4(("End  : bFilterIsInternalHub: bRetVal: 0x%x ",bRetVal));
    return bRetVal;

}

tBool ConfigurationBase::bFilterIsInternalDvdDrive(IN unsigned int iVendorID, IN unsigned int iProductID)
{
    ETG_TRACE_USR4(("Begin: bFilterIsInternalDvdDrive iVendorID:0x%x, iProductID:0x%x",iVendorID,iProductID));
    tBool bRetVal = FALSE;

    if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_INTERNAL_DVD_DRIVE])
    {
        if( (iProductID == m_uiInternalDvdDriveProductID) && (iVendorID == m_uiInternalDvdDriveVendorID ))
        {
            ETG_TRACE_USR4(("bFilterIsInternalDvdDrive: Internal DVD Drive found"));
            bRetVal = TRUE;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("bFilterIsInternalDvdDrive: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
        ETG_TRACE_FATAL(("bFilterIsInternalDvdDrive: this function is not expected to be called"));
        ETG_TRACE_FATAL(("bFilterIsInternalDvdDrive: check configuration of eConf_ENABLE_INTERNAL_DVD_DRIVE"));
        ETG_TRACE_FATAL(("bFilterIsInternalDvdDrive: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
    }


    ETG_TRACE_USR4(("End  : bFilterIsInternalDvdDrive: bRetVal: 0x%x ",bRetVal));
    return bRetVal;

}

tBool ConfigurationBase::bFilterIsCdDrive(IN std::string strVendor, IN std::string strModel)
{
    ETG_TRACE_USR4(("Begin: bFilterIsCdDrive strVendor:%s",strVendor));
    ETG_TRACE_USR4(("Begin: bFilterIsCdDrive strModel:%s",strModel));
    tBool bRetVal = FALSE;

    if(DVM_OFF == m_u16ConfigurationValue[eConf_ENABLE_INTERNAL_DVD_DRIVE])
    {
        if( (strModel == m_strCdDriveModel) && (strVendor == m_strCdDriveVendor) )
        {
            ETG_TRACE_USR4(("bFilterIsCdDrive: CD Drive found"));
            bRetVal = TRUE;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("bFilterIsCdDrive: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
        ETG_TRACE_FATAL(("bFilterIsCdDrive: this function is not expected to be called"));
        ETG_TRACE_FATAL(("bFilterIsCdDrive: check configuration of eConf_ENABLE_INTERNAL_DVD_DRIVE"));
        ETG_TRACE_FATAL(("bFilterIsCdDrive: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
    }

    ETG_TRACE_USR4(("End  : bFilterIsCdDrive: bRetVal: 0x%x ",bRetVal));
    return bRetVal;
}

tBool ConfigurationBase::bCheckConsistencyOfConfigValues()
{
    tBool bRes = TRUE;


    if(   (DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_NOTIFY_FIRST_SUPPORTED_PARTITION])
        &&(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_PARTITIONS_ALL])
     )
    {
        ETG_TRACE_FATAL(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_NOTIFY_FIRST_SUPPORTED_PARTITION and eConf_ENABLE_NOTIFY_PARTITIONS_ALL"));
        ETG_TRACE_ERRMEM(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_NOTIFY_FIRST_SUPPORTED_PARTITION and eConf_ENABLE_NOTIFY_PARTITIONS_ALL"));
        bRes=FALSE;
    }
    if(DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS] && DVM_ON == m_u16ConfigurationValue[eConf_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP])

    {
        ETG_TRACE_FATAL(("bCheckConsistencyOfConfigValues: Contradiction with eConf_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP and eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS"));
        ETG_TRACE_ERRMEM(("bCheckConsistencyOfConfigValues: Contradiction with eConf_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP and eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS"));
        bRes=FALSE;
    }

    if(  (DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_MSD_BIGGEST_PARTITION])
       &&(DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_SORT_PARTITIONS_ALL])
     )
    {
        ETG_TRACE_FATAL(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_MSD_BIGGEST_PARTITION and eCONF_ENABLE_SORT_PARTITIONS_ALL"));
        ETG_TRACE_ERRMEM(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_MSD_BIGGEST_PARTITION and eCONF_ENABLE_SORT_PARTITIONS_ALL"));
        bRes=FALSE;

    }

    if(   (DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_NOTIFY_UNKNOWN_DEVICES])
        &&(DVM_OFF == m_u16ConfigurationValue[eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE])
     )
    {
        ETG_TRACE_FATAL(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_NOTIFY_UNKNOWN_DEVICES and eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE"));
        ETG_TRACE_ERRMEM(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_NOTIFY_UNKNOWN_DEVICES and eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE"));
        bRes=FALSE;
    }



    if(    (DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT])
        && (DVM_OFF == m_u16ConfigurationValue[eCONF_ENABLE_INTERNAL_CDROM])
    )
    {
        ETG_TRACE_FATAL(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_INTERNAL_CDROM and eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT"));
        ETG_TRACE_ERRMEM(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_INTERNAL_CDROM and eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT"));
    }


    if(    (DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT])
        && (DVM_OFF == m_u16ConfigurationValue[eCONF_ENABLE_INTERNAL_CDDA])
    )
    {
        ETG_TRACE_FATAL(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_INTERNAL_CDDA and eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT"));
        ETG_TRACE_ERRMEM(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_INTERNAL_CDDA and eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT"));
    }


    if(    (DVM_ON == m_u16ConfigurationValue[eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT])
        && (DVM_OFF == m_u16ConfigurationValue[eConf_ENABLE_INTERNAL_DVD_DRIVE])
    )
    {
        ETG_TRACE_FATAL(("bCheckConsistencyOfConfigValues: Contradiction with eCONF_ENABLE_DVD_DRIVE and eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT"));
        ETG_TRACE_ERRMEM(("bCheckConsistencyOfConfigValues: Contradiction with eConf_ENABLE_INTERNAL_DVD_DRIVE and eCONF_ENABLE_USE_SPM_HISTORYTRIGGER_FOR_EARLYEJECT"));
    }

    return bRes;
}

/*-----------------------------------------------------------------------------*
 * tBool  ConfigurationBase::isDeviceAssociatedWithHub(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationBase::isDeviceAssociatedWithHub(const uint16_t &vendorID, const uint16_t &productID) const
{
    tBool bRetVal = FALSE;

#if (defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_INF4CV) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_SMART) || defined(VARIANT_S_FTR_ENABLE_UNITTEST))
    ETG_TRACE_USR4(("Begin: ConfigurationBase::isDeviceAssociatedWithHub iVendorID:%d, iProductID:%d",vendorID,productID));
    for(vector<UsbDeviceInfo>::const_iterator iter = externalHubAssociatedDeviceInfo.begin(); iter != externalHubAssociatedDeviceInfo.end(); iter++)
    {
        if((vendorID == iter->iVendorID ) && (productID == iter->iProductID))
        {
            bRetVal = TRUE;
            break;
        }
    }
#else
    (void)vendorID;
    (void)productID;
    ETG_TRACE_FATAL(("ConfigurationBase::isDeviceAssociatedWithHub: externalHubAssociatedDeviceInfo not filled for this project."));
#endif
    ETG_TRACE_USR4(("End  : isDeviceAssociatedWithHub: bRetVal: 0x%x ",bRetVal));
    return bRetVal;
}


/*-----------------------------------------------------------------------------*
 * tBool bExpectedExternalHubIsConnected(IN tenDevManagerUSBHost eUsb)                                     *
 *-----------------------------------------------------------------------------*/
tBool ConfigurationBase::bExpectedExternalHubIsConnected(IN tenDevManagerUSBHost eUsb)
{
    ETG_TRACE_USR4(("Begin: bExpectedExternalHubIsConnected eUSB%d",eUsb));
    tBool bRetVal = FALSE;

    if(m_uiNumberOfExternalHubsUsed <= iMaxSizeOfArray)
    {
        for( unsigned int i=0; i<m_uiNumberOfExternalHubsUsed; i++)
        {
            if(eUsb == m_uiExternalHubInfo[i].eUsb)
            {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
                bRetVal = isDeviceConnected(m_uiExternalHubInfo[i].iVendorID,m_uiExternalHubInfo[i].iProductID);
                if(TRUE == bRetVal)
                {
                    break;
                }
#endif//VARIANT_S_FTR_ENABLE_UNITTEST
            }
        }

    }
    else
    {
        ETG_TRACE_ERRMEM(("bExpectedExternalHubIsConnected: check configuration of m_uiExternalHubInfo with iMaxSizeOfArray"));
        ETG_TRACE_FATAL(("bExpectedExternalHubIsConnected: check configuration of m_uiExternalHubInfo with iMaxSizeOfArray"));
    }


    ETG_TRACE_USR4(("End  : bExpectedExternalHubIsConnected: bRetVal: 0x%x ",bRetVal));
    return bRetVal;
}

bool ConfigurationBase::isExternalHub(IN const tenDevManagerUSBHost& eUsb, IN const unsigned int& iVendorID, IN const unsigned int& iProductID)
{

    ETG_TRACE_USR4(("Begin: isExternalHub eUSB%d iVendorID:%d, iProductID:%d", eUsb, iVendorID,iProductID));
    bool bRetVal = FALSE;

    if(m_uiNumberOfExternalHubsUsed <= iMaxSizeOfArray)
    {
        for( unsigned int iterator=0; iterator<m_uiNumberOfExternalHubsUsed; ++iterator)
        {
            if((eUsb == m_uiExternalHubInfo[iterator].eUsb) && (iVendorID == m_uiExternalHubInfo[iterator].iVendorID) && (iProductID == m_uiExternalHubInfo[iterator].iProductID))
            {
                bRetVal = TRUE;
                break;
            }
        }
    }
    else
    {
        ETG_TRACE_ERR(("isExternalHub: check configuration of isExternalHub with iMaxSizeOfArray"));
    }

    ETG_TRACE_USR4(("End  : isExternalHub: bRetVal: 0x%x ",bRetVal));
    return bRetVal;
}

/*-----------------------------------------------------------------------------*
 * tBool AddExternalHub(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationBase::AddExternalHub(IN trExternalHubInfo f_AddExternalHubInfo)
{
    ETG_TRACE_USR4(("Begin: AddExternalHub"));
    tBool bRetVal = TRUE;
    tBool bAddNewDevice = TRUE;  //If new Hub is to be added
    tBool bUpdateDevice = TRUE;  // Update in array...Write to DP required
    ETG_TRACE_USR4(("AddExternalHub ExternalHub to be updated: f_AddExternalHubInfo.iVendorID = 0x%x",f_AddExternalHubInfo.iVendorID));
    ETG_TRACE_USR4(("AddExternalHub ExternalHub to be updated: f_AddExternalHubInfo.iProductID = 0x%x",f_AddExternalHubInfo.iProductID));
    ETG_TRACE_USR4(("AddExternalHub ExternalHub to be updated: f_AddExternalHubInfo.eUsb = %d",f_AddExternalHubInfo.eUsb));
    trExternalHubInfo l_uiExternalHubInfo [iMaxSizeOfArray];
    tU8 l_uiNumberOfExternalHubsUsed = 0;

    //Read from datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
    IConfigurationPersistent *l_pIFConfPersistentDataReader = NULL;
    l_pIFConfPersistentDataReader = (IConfigurationPersistent*)new ReaderDataPool();
    if(l_pIFConfPersistentDataReader && FALSE == l_pIFConfPersistentDataReader->bReadDataPool(l_uiExternalHubInfo,l_uiNumberOfExternalHubsUsed))
    {
        ETG_TRACE_FATAL(("ReadExternalHub: Error while reading the ExternalHub parameter in persistent memory"));
        bRetVal = FALSE;
    }
    if(l_pIFConfPersistentDataReader)
    {
        delete l_pIFConfPersistentDataReader;
        l_pIFConfPersistentDataReader = NULL;
    }
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL

    ETG_TRACE_USR4(("***********************AddExternalHub ExternalHub details (read from datapool)***********************"));
    ETG_TRACE_USR4(("ExternalHub in array COUNT: l_uiNumberOfExternalHubsUsed : %d",l_uiNumberOfExternalHubsUsed));
    for(int i=0 ; i<l_uiNumberOfExternalHubsUsed ; i++)
    {
        ETG_TRACE_USR4(("ExternalHub in array: l_uiExternalHubInfo[i].iVendorID = 0x%x",l_uiExternalHubInfo[i].iVendorID));
        ETG_TRACE_USR4(("ExternalHub in array: l_uiExternalHubInfo[i].iProductID = 0x%x",l_uiExternalHubInfo[i].iProductID));
        ETG_TRACE_USR4(("ExternalHub in array: l_uiExternalHubInfo[i].eUsb = %d",l_uiExternalHubInfo[i].eUsb));
        ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
    }

    if(l_uiNumberOfExternalHubsUsed)
    {
        for(int i=0 ; i<l_uiNumberOfExternalHubsUsed ; i++)
        {
            bAddNewDevice = FALSE;
            bUpdateDevice = FALSE;
            if((l_uiExternalHubInfo[i].iVendorID == f_AddExternalHubInfo.iVendorID) && (l_uiExternalHubInfo[i].iProductID == f_AddExternalHubInfo.iProductID))
            {
                if(l_uiExternalHubInfo[i].eUsb == f_AddExternalHubInfo.eUsb)
                {
                    //Do Nothing
                    break;
                    }
                 else
                 {
                    l_uiExternalHubInfo[i].eUsb = f_AddExternalHubInfo.eUsb;
                    bUpdateDevice = TRUE;  break;   //update DP
                 }
            }
            else
            {
                bAddNewDevice = TRUE;
                bUpdateDevice = TRUE;
            }
        }
    }

    if(bUpdateDevice)
    {
        if(bAddNewDevice)   //New ExternalHub to be added
        {
            l_uiExternalHubInfo[l_uiNumberOfExternalHubsUsed].iVendorID = f_AddExternalHubInfo.iVendorID;
            l_uiExternalHubInfo[l_uiNumberOfExternalHubsUsed].iProductID = f_AddExternalHubInfo.iProductID;
            l_uiExternalHubInfo[l_uiNumberOfExternalHubsUsed].eUsb = f_AddExternalHubInfo.eUsb;
            l_uiNumberOfExternalHubsUsed++;
        }
        ETG_TRACE_USR4(("***********************AddExternalHub ExternalHub to be added(write to datapool)***********************"));
        for(int i=0 ; i<l_uiNumberOfExternalHubsUsed ; i++)
        {
            ETG_TRACE_USR4(("ExternalHub to be added in array: l_uiExternalHubInfo : %d",l_uiNumberOfExternalHubsUsed));
            ETG_TRACE_USR4(("ExternalHub to be added in array: l_uiExternalHubInfo[%d].iVendorID = 0x%x",i,l_uiExternalHubInfo[i].iVendorID));
            ETG_TRACE_USR4(("ExternalHub to be added in array: l_uiExternalHubInfo[%d].iProductID = 0x%x",i,l_uiExternalHubInfo[i].iProductID));
            ETG_TRACE_USR4(("ExternalHub to be added in array: l_uiExternalHubInfo[%d].eUsb = %d",i,l_uiExternalHubInfo[i].eUsb));
            ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
        }

        //write to datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
        IConfigurationPersistent *l_pIFConfPersistentDataWriter = NULL;
        l_pIFConfPersistentDataWriter = (IConfigurationPersistent*)new WriterDataPool();
        if(l_pIFConfPersistentDataWriter && FALSE == l_pIFConfPersistentDataWriter->bWriteDataPool(l_uiExternalHubInfo,l_uiNumberOfExternalHubsUsed))
        {
            ETG_TRACE_FATAL(("AddExternalHub: Error while storing the ExternalHub parameter in persistent memory"));
            bRetVal = FALSE;
        }
        if(l_pIFConfPersistentDataWriter)
        {
            delete l_pIFConfPersistentDataWriter;
            l_pIFConfPersistentDataWriter = NULL;
        }
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
    }
    ETG_TRACE_USR4(("End: AddExternalHub"));
    return bRetVal;
}


/*-----------------------------------------------------------------------------*
 * tBool RemoveExternalHub(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationBase::RemoveExternalHub(IN trExternalHubInfo f_RemoveExternalHubInfo, tBool ClearAllfromDP)
{
    ETG_TRACE_USR4(("Begin: RemoveExternalHub"));
    tBool bRetVal = TRUE;

    tBool bUpdateDevice = FALSE;  // Update in array...Write to DP required
    ETG_TRACE_USR4(("RemoveExternalHub ExternalHub to be removed: f_RemoveExternalHubInfo.iVendorID = 0x%x",f_RemoveExternalHubInfo.iVendorID));
    ETG_TRACE_USR4(("RemoveExternalHub ExternalHub to be removed: f_RemoveExternalHubInfo.iProductID = 0x%x",f_RemoveExternalHubInfo.iProductID));
    ETG_TRACE_USR4(("RemoveExternalHub ExternalHub to be removed: f_RemoveExternalHubInfo.eUsb = %d",f_RemoveExternalHubInfo.eUsb));
    trExternalHubInfo l_uiExternalHubInfo [iMaxSizeOfArray];
    tU8 l_uiNumberOfExternalHubsUsed = 0;

    //Read from datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
    IConfigurationPersistent *l_pIFConfPersistentDataReader = NULL;
    l_pIFConfPersistentDataReader = (IConfigurationPersistent*)new ReaderDataPool();
    if(l_pIFConfPersistentDataReader && FALSE == l_pIFConfPersistentDataReader->bReadDataPool(l_uiExternalHubInfo,l_uiNumberOfExternalHubsUsed))
    {
        ETG_TRACE_FATAL(("ReadExternalHub: Error while reading the ExternalHub parameter in persistent memory"));
        bRetVal = FALSE;
    }
    if(l_pIFConfPersistentDataReader)
    {
        delete l_pIFConfPersistentDataReader;
        l_pIFConfPersistentDataReader = NULL;
    }
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL

    ETG_TRACE_USR4(("***********************AddExternalHub ExternalHub details (read from datapool)***********************"));
    ETG_TRACE_USR4(("ExternalHub in array COUNT: l_uiNumberOfExternalHubsUsed : %d",l_uiNumberOfExternalHubsUsed));
    for(int i=0 ; i<l_uiNumberOfExternalHubsUsed ; i++)
    {
        ETG_TRACE_USR4(("ExternalHub in array: l_uiExternalHubInfo[%d].iVendorID = 0x%x",i,l_uiExternalHubInfo[i].iVendorID));
        ETG_TRACE_USR4(("ExternalHub in array: l_uiExternalHubInfo[%d].iProductID = 0x%x",i,l_uiExternalHubInfo[i].iProductID));
        ETG_TRACE_USR4(("ExternalHub in array: l_uiExternalHubInfo[%d].eUsb = %d",i,l_uiExternalHubInfo[i].eUsb));
        ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
    }

    if(ClearAllfromDP)
    {
        //Clear the datapool
        ETG_TRACE_USR4(("***********************AddExternalHub ExternalHub to be emptied***********************"));
        memset(l_uiExternalHubInfo, 0, sizeof(l_uiExternalHubInfo));
        l_uiNumberOfExternalHubsUsed=0;
        bUpdateDevice = TRUE;
    }
    else
    {
        //remove the required hub from datapool
        if(l_uiNumberOfExternalHubsUsed)
        {
            for(int i=0 ; i<l_uiNumberOfExternalHubsUsed ; i++)
            {
                if((l_uiExternalHubInfo[i].iVendorID == f_RemoveExternalHubInfo.iVendorID) &&
                   (l_uiExternalHubInfo[i].iProductID == f_RemoveExternalHubInfo.iProductID) &&
                   (l_uiExternalHubInfo[i].eUsb == f_RemoveExternalHubInfo.eUsb)
                  )
                {
                    for(int j=i ; j<l_uiNumberOfExternalHubsUsed ; j++)
                    l_uiExternalHubInfo[j] = l_uiExternalHubInfo[j+1];
                    memset(&l_uiExternalHubInfo[l_uiNumberOfExternalHubsUsed-1],0,sizeof(l_uiExternalHubInfo[l_uiNumberOfExternalHubsUsed-1]));
                    l_uiNumberOfExternalHubsUsed--;
                    bUpdateDevice = TRUE;
                    break;
                }
                else
                {
                    if(i == (l_uiNumberOfExternalHubsUsed-1) )
                    {
                        ETG_TRACE_FATAL(("AddExternalHub: Error while removing the ExternalHub device. HUB NOT FOUND IN DATAPOOL..Exiting.."));
                    }
                }
            }
        }
        else
        {
            ETG_TRACE_FATAL(("AddExternalHub: Error while removing the ExternalHub device. NO HUBS IN DATAPOOL..Exiting"));
        }
    }

    if(bUpdateDevice)
    {
        ETG_TRACE_USR4(("***********************AddExternalHub ExternalHub to be written(write to datapool)***********************"));
        for(int i=0 ; i<l_uiNumberOfExternalHubsUsed ; i++)
        {
            ETG_TRACE_USR4(("ExternalHub to be added in array: l_uiExternalHubInfo : %d",l_uiNumberOfExternalHubsUsed));
            ETG_TRACE_USR4(("ExternalHub to be added in array: l_uiExternalHubInfo[%d].iVendorID = %d",i,l_uiExternalHubInfo[i].iVendorID));
            ETG_TRACE_USR4(("ExternalHub to be added in array: l_uiExternalHubInfo[%d].iProductID = %d",i,l_uiExternalHubInfo[i].iProductID));
            ETG_TRACE_USR4(("ExternalHub to be added in array: l_uiExternalHubInfo[%d].eUsb = %d",i,l_uiExternalHubInfo[i].eUsb));
            ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
        }

        //write to datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
        IConfigurationPersistent *l_pIFConfPersistentDataWriter = NULL;
        l_pIFConfPersistentDataWriter = (IConfigurationPersistent*)new WriterDataPool();
        if(l_pIFConfPersistentDataWriter && FALSE == l_pIFConfPersistentDataWriter->bWriteDataPool(l_uiExternalHubInfo,l_uiNumberOfExternalHubsUsed))
        {
            ETG_TRACE_FATAL(("AddExternalHub: Error while storing the ExternalHub parameter in persistent memory"));
            bRetVal = FALSE;
        }
        if(l_pIFConfPersistentDataWriter)
        {
            delete l_pIFConfPersistentDataWriter;
            l_pIFConfPersistentDataWriter = NULL;
        }
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
    }
    ETG_TRACE_USR4(("End: RemoveExternalHub"));
    return bRetVal;
}

/*-----------------------------------------------------------------------------*
 * tBool ReadExternalHub(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationBase::ReadExternalHub(OUT trExternalHubInfo f_uiExternalHubInfo [], OUT tU8 &f_uiNumberOfExternalHubsUsed)
{
    ETG_TRACE_USR4(("Begin: ReadExternalHub"));
    tBool bRetVal = TRUE;

    //Read from datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
    IConfigurationPersistent *l_pIFConfPersistentDataReader = NULL;
    l_pIFConfPersistentDataReader = (IConfigurationPersistent*)new ReaderDataPool();
    if(l_pIFConfPersistentDataReader && FALSE == l_pIFConfPersistentDataReader->bReadDataPool(f_uiExternalHubInfo,f_uiNumberOfExternalHubsUsed))
    {
        ETG_TRACE_FATAL(("ReadExternalHub: Error while storing the ExternalHub parameter in persistent memory"));
        bRetVal = FALSE;
    }
    if(l_pIFConfPersistentDataReader)
    {
        delete l_pIFConfPersistentDataReader;
        l_pIFConfPersistentDataReader = NULL;
    }
#else//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
     ETG_TRACE_USR4(("ReadExternalHub: ACCESS TO DataPool disabled!"));

     for(unsigned int i=0;i<iMaxSizeOfArray;i++)
     {
         f_uiExternalHubInfo[i].iVendorID=0;
         f_uiExternalHubInfo[i].iProductID=0;
         f_uiExternalHubInfo[i].eUsb=eUSBUndef;
     }
     f_uiNumberOfExternalHubsUsed=0;

     bRetVal = FALSE;

#endif
    ETG_TRACE_USR4(("End: ReadExternalHub"));
    return bRetVal;
}

/*-----------------------------------------------------------------------------*
 * tBool AddTelematicsBox(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationBase::AddTelematicsBox(IN trTelematicsBoxDeviceInfo f_AddTelematicsBoxDeviceInfo)
{
    ETG_TRACE_USR4(("Begin: AddTelematicsBox"));
    tBool bRetVal = TRUE;
    tBool bAddNewDevice = TRUE;  //If new TelematicsBox is to be added
    tBool bUpdateDevice = TRUE;  // Update in array...Write to DP required if TRUE
    ETG_TRACE_USR4(("AddTelematicsBox TelematicsBoxDevice to be updated: f_AddTelematicsBoxDeviceInfo.iVendorID = 0x%x",f_AddTelematicsBoxDeviceInfo.iVendorID));
    ETG_TRACE_USR4(("AddTelematicsBox TelematicsBoxDevice to be updated: f_AddTelematicsBoxDeviceInfo.iProductID = 0x%x",f_AddTelematicsBoxDeviceInfo.iProductID));
    ETG_TRACE_USR4(("AddTelematicsBox TelematicsBoxDevice to be updated: f_AddTelematicsBoxDeviceInfo.bIsHighSpeedExpected = 0x%x",f_AddTelematicsBoxDeviceInfo.bIsHighSpeedExpected));
    ETG_TRACE_USR4(("AddTelematicsBox TelematicsBoxDevice to be updated: f_AddTelematicsBoxDeviceInfo.eUsb = 0x%x",f_AddTelematicsBoxDeviceInfo.eUsb));
    trTelematicsBoxDeviceInfo l_uiTelematicsBoxDeviceInfo [iMaxSizeOfArray];
    tU8 l_uiNumberOfTelematicBoxesUsed = 0;

    //Read from datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
    IConfigurationPersistent *l_pIFConfPersistentDataReader = NULL;
    l_pIFConfPersistentDataReader = (IConfigurationPersistent*)new ReaderDataPool();
    if(l_pIFConfPersistentDataReader && FALSE == l_pIFConfPersistentDataReader->bReadDataPool(l_uiTelematicsBoxDeviceInfo,l_uiNumberOfTelematicBoxesUsed))
    {
        ETG_TRACE_FATAL(("ReadTelematicsHubDevice: Error while reading the TelematicsBoxDevice parameter in persistent memory"));
        bRetVal = FALSE;
    }
    if(l_pIFConfPersistentDataReader)
    {
        delete l_pIFConfPersistentDataReader;
        l_pIFConfPersistentDataReader = NULL;
    }
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL

    ETG_TRACE_USR4(("***********************AddTelematicsBox TelematicsBoxDevice details (read from datapool)***********************"));
    ETG_TRACE_USR4(("TelematicsBoxDevice in array COUNT: l_uiNumberOfTelematicBoxesUsed : %d",l_uiNumberOfTelematicBoxesUsed));
    for(int i=0 ; i<l_uiNumberOfTelematicBoxesUsed ; i++)
    {
        ETG_TRACE_USR4(("TelematicsBoxDevice in array: l_uiTelematicsBoxDeviceInfo[%d].iVendorID = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].iVendorID));
        ETG_TRACE_USR4(("TelematicsBoxDevice in array: l_uiTelematicsBoxDeviceInfo[%d].iProductID = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].iProductID));
        ETG_TRACE_USR4(("TelematicsBoxDevice in array: l_uiTelematicsBoxDeviceInfo[%d].bIsHighSpeedExpected = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected));
        ETG_TRACE_USR4(("TelematicsBoxDevice in array: l_uiTelematicsBoxDeviceInfo[%d].eUsb = %d",i,l_uiTelematicsBoxDeviceInfo[i].eUsb));
        ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
    }

    if(l_uiNumberOfTelematicBoxesUsed)
    {
        for(int i=0 ; i<l_uiNumberOfTelematicBoxesUsed ; i++)
        {
            bAddNewDevice = FALSE;
            bUpdateDevice = FALSE;
            if((l_uiTelematicsBoxDeviceInfo[i].iVendorID == f_AddTelematicsBoxDeviceInfo.iVendorID) && (l_uiTelematicsBoxDeviceInfo[i].iProductID == f_AddTelematicsBoxDeviceInfo.iProductID))
            {
                if(l_uiTelematicsBoxDeviceInfo[i].eUsb == f_AddTelematicsBoxDeviceInfo.eUsb)
                {
                    //Do Nothing
                    break;
                    }
                 else
                 {
                    l_uiTelematicsBoxDeviceInfo[i].eUsb = f_AddTelematicsBoxDeviceInfo.eUsb;
                    bUpdateDevice = TRUE;  break;   //update DP
                 }
            }
            else
            {
                bAddNewDevice = TRUE;
                bUpdateDevice = TRUE;
            }
        }
    }

    if(bUpdateDevice)
    {
        if(bAddNewDevice)   //New TelematicsBoxDevice to be added
        {
            l_uiTelematicsBoxDeviceInfo[l_uiNumberOfTelematicBoxesUsed].iVendorID = f_AddTelematicsBoxDeviceInfo.iVendorID;
            l_uiTelematicsBoxDeviceInfo[l_uiNumberOfTelematicBoxesUsed].iProductID = f_AddTelematicsBoxDeviceInfo.iProductID;
            l_uiTelematicsBoxDeviceInfo[l_uiNumberOfTelematicBoxesUsed].bIsHighSpeedExpected = f_AddTelematicsBoxDeviceInfo.bIsHighSpeedExpected;
            l_uiTelematicsBoxDeviceInfo[l_uiNumberOfTelematicBoxesUsed].eUsb = f_AddTelematicsBoxDeviceInfo.eUsb;
            l_uiNumberOfTelematicBoxesUsed++;
        }
        ETG_TRACE_USR4(("***********************AddTelematicsBox TelematicsBoxDevice to be added(write to datapool)***********************"));
        for(int i=0 ; i<l_uiNumberOfTelematicBoxesUsed ; i++)
        {
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo : %p",l_uiTelematicsBoxDeviceInfo));
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo[%d].iVendorID = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].iVendorID));
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo[%d].iProductID = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].iProductID));
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo[%d].bIsHighSpeedExpected = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected));
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo[%d].eUsb = %d",i,l_uiTelematicsBoxDeviceInfo[i].eUsb));
            ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
        }

        //write to datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
        IConfigurationPersistent *l_pIFConfPersistentDataWriter = NULL;
        l_pIFConfPersistentDataWriter = (IConfigurationPersistent*)new WriterDataPool();
        if(l_pIFConfPersistentDataWriter && FALSE == l_pIFConfPersistentDataWriter->bWriteDataPool(l_uiTelematicsBoxDeviceInfo,l_uiNumberOfTelematicBoxesUsed))
        {
            ETG_TRACE_FATAL(("AddTelematicsBox: Error while storing the TelematicsBoxDevice parameter in persistent memory"));
            bRetVal = FALSE;
        }
        if(l_pIFConfPersistentDataWriter)
        {
            delete l_pIFConfPersistentDataWriter;
            l_pIFConfPersistentDataWriter = NULL;
        }
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
    }
    ETG_TRACE_USR4(("End: AddTelematicsBox"));
    return bRetVal;
}

/*-----------------------------------------------------------------------------*
 * tBool RemoveTelematicsBox(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationBase::RemoveTelematicsBox(IN trTelematicsBoxDeviceInfo f_RemoveTelematicsBoxDeviceInfo,tBool ClearAllfromDP)
{
    ETG_TRACE_USR4(("Begin: RemoveTelematicsBox"));
    tBool bRetVal = TRUE;

    tBool bUpdateDevice = FALSE;  // Update in array...Write to DP required if TRUE

    ETG_TRACE_USR4(("RemoveTelematicsBox TelematicsBoxDevice to be updated: f_RemoveTelematicsBoxDeviceInfo.iVendorID = 0x%x",f_RemoveTelematicsBoxDeviceInfo.iVendorID));
    ETG_TRACE_USR4(("RemoveTelematicsBox TelematicsBoxDevice to be updated: f_RemoveTelematicsBoxDeviceInfo.iProductID = 0x%x",f_RemoveTelematicsBoxDeviceInfo.iProductID));
    ETG_TRACE_USR4(("RemoveTelematicsBox TelematicsBoxDevice to be updated: f_RemoveTelematicsBoxDeviceInfo.bIsHighSpeedExpected = 0x%x",f_RemoveTelematicsBoxDeviceInfo.bIsHighSpeedExpected));
    ETG_TRACE_USR4(("RemoveTelematicsBox TelematicsBoxDevice to be updated: f_RemoveTelematicsBoxDeviceInfo.eUsb = %d",f_RemoveTelematicsBoxDeviceInfo.eUsb));
    trTelematicsBoxDeviceInfo l_uiTelematicsBoxDeviceInfo [iMaxSizeOfArray];
    tU8 l_uiNumberOfTelematicBoxesUsed = 0;

    //Read from datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
    IConfigurationPersistent *l_pIFConfPersistentDataReader = NULL;
    l_pIFConfPersistentDataReader = (IConfigurationPersistent*)new ReaderDataPool();
    if(l_pIFConfPersistentDataReader && FALSE == l_pIFConfPersistentDataReader->bReadDataPool(l_uiTelematicsBoxDeviceInfo,l_uiNumberOfTelematicBoxesUsed))
    {
        ETG_TRACE_FATAL(("RemoveTelematicsBox: Error while reading the TelematicsBoxDevice parameter in persistent memory"));
        bRetVal = FALSE;
    }
    if(l_pIFConfPersistentDataReader)
    {
        delete l_pIFConfPersistentDataReader;
        l_pIFConfPersistentDataReader = NULL;
    }
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL

    ETG_TRACE_USR4(("***********************RemoveTelematicsBox TelematicsBoxDevice details (read from datapool)***********************"));
    ETG_TRACE_USR4(("TelematicsBoxDevice in array COUNT: l_uiNumberOfTelematicBoxesUsed : %d",l_uiNumberOfTelematicBoxesUsed));
    for(int i=0 ; i<l_uiNumberOfTelematicBoxesUsed ; i++)
    {
        ETG_TRACE_USR4(("TelematicsBoxDevice in array: l_uiTelematicsBoxDeviceInfo[%d].iVendorID = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].iVendorID));
        ETG_TRACE_USR4(("TelematicsBoxDevice in array: l_uiTelematicsBoxDeviceInfo[%d].iProductID = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].iProductID));
        ETG_TRACE_USR4(("TelematicsBoxDevice in array: l_uiTelematicsBoxDeviceInfo[%d].bIsHighSpeedExpected = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected));
        ETG_TRACE_USR4(("TelematicsBoxDevice in array: l_uiTelematicsBoxDeviceInfo[%d].eUsb = %d",i,l_uiTelematicsBoxDeviceInfo[i].eUsb));
        ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
    }

    if(ClearAllfromDP)
    {
        //Clear the datapool
        ETG_TRACE_USR4(("***********************RemoveTelematicsBox TelematicsBoxDevice  to be emptied***********************"));
        memset(l_uiTelematicsBoxDeviceInfo, 0, sizeof(l_uiTelematicsBoxDeviceInfo));
        l_uiNumberOfTelematicBoxesUsed=0;
        bUpdateDevice = TRUE;
    }
    else
    {
        //remove the required hub from datapool
        if(l_uiNumberOfTelematicBoxesUsed)
        {
            for(int i=0 ; i<l_uiNumberOfTelematicBoxesUsed ; i++)
            {
                if((l_uiTelematicsBoxDeviceInfo[i].iVendorID == f_RemoveTelematicsBoxDeviceInfo.iVendorID) &&
                   (l_uiTelematicsBoxDeviceInfo[i].iProductID == f_RemoveTelematicsBoxDeviceInfo.iProductID) &&
                   (l_uiTelematicsBoxDeviceInfo[i].eUsb == f_RemoveTelematicsBoxDeviceInfo.eUsb) &&
                   (l_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected == f_RemoveTelematicsBoxDeviceInfo.bIsHighSpeedExpected)
                  )
                {
                    for(int j=i ; j<l_uiNumberOfTelematicBoxesUsed ; j++)
                    l_uiTelematicsBoxDeviceInfo[j] = l_uiTelematicsBoxDeviceInfo[j+1];
                    memset(&l_uiTelematicsBoxDeviceInfo[l_uiNumberOfTelematicBoxesUsed-1],0,sizeof(l_uiTelematicsBoxDeviceInfo[l_uiNumberOfTelematicBoxesUsed-1]));
                    l_uiNumberOfTelematicBoxesUsed--;
                    bUpdateDevice = TRUE;
                    break;
                }
                else
                {
                    if(i == (l_uiNumberOfTelematicBoxesUsed-1) )
                    {
                        ETG_TRACE_FATAL(("RemoveTelematicsBox: Error while removing the TelematicsBoxDevice . DEVICE NOT FOUND IN DATAPOOL..Exiting.."));
                    }
                }
            }
        }
        else
        {
            ETG_TRACE_FATAL(("RemoveTelematicsBox: Error while removing the TelematicsBoxDevice . NO DEVICES IN DATAPOOL..Exiting"));
        }
    }

    if(bUpdateDevice)
    {
        ETG_TRACE_USR4(("***********************RemoveTelematicsBox TelematicsBoxDevice to be written(write to datapool)***********************"));
        for(int i=0 ; i<l_uiNumberOfTelematicBoxesUsed ; i++)
        {
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo : %p",l_uiTelematicsBoxDeviceInfo));
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo[%d].iVendorID = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].iVendorID));
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo[%d].iProductID = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].iProductID));
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo[%d].bIsHighSpeedExpected = 0x%x",i,l_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected));
            ETG_TRACE_USR4(("TelematicsBoxDevice to be added in array: l_uiTelematicsBoxDeviceInfo[%d].eUsb = %d",i,l_uiTelematicsBoxDeviceInfo[i].eUsb));
            ETG_TRACE_USR4(("---------------------------------------------------------------------------------------"));
        }

        //write to datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
        IConfigurationPersistent *l_pIFConfPersistentDataWriter = NULL;
        l_pIFConfPersistentDataWriter = (IConfigurationPersistent*)new WriterDataPool();
        if(l_pIFConfPersistentDataWriter && FALSE == l_pIFConfPersistentDataWriter->bWriteDataPool(l_uiTelematicsBoxDeviceInfo,l_uiNumberOfTelematicBoxesUsed))
        {
            ETG_TRACE_FATAL(("RemoveTelematicsBox: Error while storing the TelematicsBoxDevice parameter in persistent memory"));
            bRetVal = FALSE;
        }
        if(l_pIFConfPersistentDataWriter)
        {
            delete l_pIFConfPersistentDataWriter;
            l_pIFConfPersistentDataWriter = NULL;
        }
#endif//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
    }
    ETG_TRACE_USR4(("End: RemoveTelematicsBox"));
    return bRetVal;
}

/*-----------------------------------------------------------------------------*
 * tBool ReadusbDeviceInFromIstream(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationBase::ReadUsbDeviceInfoFromIstream(std::istream &input, vector<UsbDeviceInfo> &usbDeviceInfo, const std::string &usbDeviceType)
{
    tBool bRetVal = TRUE;
#if (defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_INF4CV) || defined(VARIANT_S_FTR_ENABLE_DEVMGR_CONFIGDEFAULT_GEN3_SMART) || defined(VARIANT_S_FTR_ENABLE_UNITTEST))
    ETG_TRACE_USR4(("Begin: ConfigurationBase::ReadUsbDeviceInfoFromIstream usbDeviceType =%s",usbDeviceType.c_str()));
    if(input)
    {
        while((input.rdstate() == std::istream::goodbit))
        {
            std::string line;
            std::getline(input,line);
            boost::trim(line);
            if(!line.empty())
            {
                ETG_TRACE_USR4(("ConfigurationBase::ReadUsbDeviceInfoFromIstream line =%s",line.c_str()));
                UsbDeviceInfo vidPidInfo;

                size_t delim1Pos = line.find(',');
                size_t delim2Pos = line.find(',',delim1Pos+1);
                if(line[0] == USB_DEVICES_VID_PID_FILE_COMMENTCHAR)//Ignore comments
                {
                    continue;
                }
                else if (delim1Pos!=std::string::npos && delim2Pos!=std::string::npos)
                {
                    std::string param1 = line.substr(0,delim1Pos);
                    std::string param2 = line.substr(delim1Pos+1, delim2Pos-delim1Pos-1);
                    std::string param3 = line.substr(delim2Pos+1);

                    std::stringstream usbDeviceTypeRead(param1);
                    std::stringstream vid;
                    std::stringstream pid;
                    //The values are in hex.
                    vid << std::hex << param2;
                    pid << std::hex << param3;

                    if(usbDeviceTypeRead.str() == usbDeviceType)
                    {
                        //Hex string to Integer
                        vid >> vidPidInfo.iVendorID;
                        pid >> vidPidInfo.iProductID;
                        usbDeviceInfo.push_back(vidPidInfo);
                    }
                }
                else
                {
                    ETG_TRACE_FATAL(("ConfigurationBase::ReadUsbDeviceInfoFromIstream: not able to parse vid,pid from file"));
                    bRetVal = false;
                    break;
                }
            }
        }
        if(usbDeviceInfo.size() == 0)
        {
            ETG_TRACE_FATAL(("ConfigurationBase::ReadUsbDeviceInfoFromIstream: vid,pid config file Empty"));
            bRetVal = false;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("ConfigurationBase::ReadUsbDeviceInfoFromIstream: Empty stream"));
        bRetVal = false;
    }
#else
    (void)input;
    (void)usbDeviceInfo;
    (void)usbDeviceType;
    ETG_TRACE_FATAL(("ConfigurationBase::ReadUsbDeviceInfoFromIstream: Read from config not enabled for this project"));
    bRetVal = false;
#endif

    return bRetVal;
}

/*-----------------------------------------------------------------------------*
 * tBool ReadTelematicsBox(...)
 *-----------------------------------------------------------------------------*/
tBool ConfigurationBase::ReadTelematicsBox(OUT trTelematicsBoxDeviceInfo f_uiTelematicsBoxDeviceInfo [], OUT tU8 &f_uiNumberOfTelematicBoxesUsed)
{
    ETG_TRACE_USR4(("Begin: ReadTelematicsBox"));
    tBool bRetVal = TRUE;

    //Read from datapool
#if defined(VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL)  && !defined(VARIANT_S_FTR_ENABLE_UNITTEST)
    IConfigurationPersistent *l_pIFConfPersistentDataReader = NULL;
    l_pIFConfPersistentDataReader = (IConfigurationPersistent*)new ReaderDataPool();
    if(l_pIFConfPersistentDataReader && FALSE == l_pIFConfPersistentDataReader->bReadDataPool(f_uiTelematicsBoxDeviceInfo,f_uiNumberOfTelematicBoxesUsed))
    {
        ETG_TRACE_FATAL(("ReadTelematicsBox: Error while storing the TelematicsBoxDevice parameter in persistent memory"));
        bRetVal = FALSE;
    }
    if(l_pIFConfPersistentDataReader)
    {
        delete l_pIFConfPersistentDataReader;
        l_pIFConfPersistentDataReader = NULL;
    }
#else//VARIANT_S_FTR_ENABLE_DEVMGR_DATAPOOL
         ETG_TRACE_USR4(("ReadTelematicsBox: ACCESS TO DataPool disabled!"));

         for(unsigned int i=0;i<iMaxSizeOfArray;i++)
         {
             f_uiTelematicsBoxDeviceInfo[i].iVendorID=0;
             f_uiTelematicsBoxDeviceInfo[i].iProductID=0;
             f_uiTelematicsBoxDeviceInfo[i].bIsHighSpeedExpected=FALSE;
             f_uiTelematicsBoxDeviceInfo[i].eUsb=eUSBUndef;
         }
         f_uiNumberOfTelematicBoxesUsed=0;

         bRetVal = FALSE;

#endif



    ETG_TRACE_USR4(("ReadTelematicsBox  f_uiNumberOfTelematicBoxesUsed %d",f_uiNumberOfTelematicBoxesUsed));
    return bRetVal;
}


#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
//ConfigurationManager is a signleton thus it is not possible to inherit a tst class with this function.
tVoid ConfigurationBase::setCustomerUSBConnectorConfig(tenDevManagerUSBHost eUsb,int iConnector,std::string strSysPathEntryUSBPortAdressForUSBConnector,std::string strSysPathEntryUSBPortHubForUSBConnector)
{
     m_rCustomerUSBConnectorConfig[(tInt)eUsb].eConnectorInfo=(teConnectorInfo)iConnector;
     m_rCustomerUSBConnectorConfig[(tInt)eUsb].m_strSysPathEntryUSBPortAdressForUSBConnector=strSysPathEntryUSBPortAdressForUSBConnector;
     m_rCustomerUSBConnectorConfig[(tInt)eUsb].m_strSysPathEntryUSBPortHubForUSBConnector=strSysPathEntryUSBPortHubForUSBConnector;

}
#endif

////////////////////////////////////////////////////////////////////////////////
// <EOF>
