/*-----------------------------------------------------------------------------*
 * ConfigurationBase.h                                                         *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: CommonReadRoutinesKds.h                       *
 * PROJECT     : G3G                                                           *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                   *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file CommonReadRoutinesKds.h
 *
 * \brief Cares for values defined for general g3g i.e. those which have to be loaded before any specific customer related values
 *
 * \version 04.03.2016, Christian Koechling (Bosch), version 1.0
 *          Initial version
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

#ifndef _COMMON_READ_ROUTINES_H
#define _COMMON_READ_ROUTINES_H


/*-----------------------------------------------------------------------------*
 * forward declaration                                                           *
 *-----------------------------------------------------------------------------*/
class IConfigurationPersistent;

/*-----------------------------------------------------------------------------*
 * class declaration                                                                *
 *-----------------------------------------------------------------------------*/
class CommonReadRoutinesKds
{

public:

    enum
    {
        enHUBSupported_YES = 0x00,   //Unknown/HUB support (CMUSBExtendedInfoType )
        enHUBSupported_NO  = 0x01,
    };


    //-----------functions-------------------------------

    CommonReadRoutinesKds();
    virtual ~ CommonReadRoutinesKds(){};

    //each customer wants to have its own configuration for USB connectors e.g. PSA wanted to have the one in the middle to be USB1 et. etc.
    //this function will be used in RNAIVI since this project will have several hardware configurations with 1USB, 2, 3 and even more is in discussion
    void vInitCustomerValues_G3G_ConfigureUSBConnectors(IN IConfigurationPersistent *f_pIFConfPersistent, OUT tU16 (&f_u16ConfigurationValue)[eCONF_LAST_ELEMENT]);

    void vInitCustomerValues_G3G_USBExtendedInfo(IN IConfigurationPersistent *f_pIFConfPersistent, OUT tU16 (&f_u16ConfigurationValue)[eCONF_LAST_ELEMENT]);
 
};
#endif // _COMMON_READ_ROUTINES_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

