/**
 * @defgroup ThreadFactoryDVM ThreadFactoryDVM
 * @author Christrian Koechling
 *
 * Public interface for the Thread Factory
 * @{
 */
 
#ifndef _THREADFACTORYDVM_H_
#define _THREADFACTORYDVM_H_

#include "Config.h"
#include "ThreadFactory.h"



class ThreadFactoryDVM
{
    
public:


    //=============/Singleton specific part======================


    /* \brief Get ThreadFactoryDVM object
        *
        * Provides the singleton ThreadFactory object. First invocation of
        * this function creates the object
        *
        * \return [StateTable*] singleton object
        */
    static ThreadFactoryDVM* GetInstance();

    /* \brief Get ThreadFactory object
        *
        * \return [StateTable*] singleton object
        */
    static ThreadFactory* GetThreadFactory();


    /*!
    * \brief Initializes the object
    *
    * \return [int] initialization status OSAL_OK or OSAL_ERROR
    */
    int Initialize() const;

    /*!
    * \brief Destroys the singleton object
    */
    static void  DestroyInstance();


       /*!
     * \brief Assignment Operator
     *
     * Will not be implemented. Avoids Lint Prio 3 warning: Info 1732: new
     * in constructor for class 'StateTable' which has no assignment
     * operator.
     *
     * \note This is a technique to disable the assignment operator for this
     *       class. So if an attempt for the assignment is made compiler
     *       complains.
     */
    ThreadFactoryDVM& operator=(const ThreadFactoryDVM &oClientHandler);

    //=============Singleton specific part/======================

private:

    //=============/Singleton specific part======================
    /**< Singleton object */
    static ThreadFactoryDVM  *m_pThreadFactoryDVM;
    /**< Lock to synchronize singleton object access */
    static LockDVM         m_singelton;

     /**
     * Constructor/Destructor  are  private to make it a singleton
     * 
     */
    ThreadFactoryDVM();
     
     /**
      * Constructor/Destructor  are  private to make it as ingleton
      * 
      */
    virtual ~ThreadFactoryDVM(){};

    //=============Singleton specific part/======================


    ThreadFactory  *m_pThreadFactory;

};

#endif //_THREADFACTORY_H_
/** @} */
