
/*-----------------------------------------------------------------------------*
 * MessageQueueDVM.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file MessageQueueDVM.h
 *
 * \brief Adapter class (Wrapper) to ease replacing osal Message Queue functions, it uses gmp frame work message queue
 *
 * \version 29.01.2015, Rajeev Narayanan Sambhu (RBEI/ECS1), version 1.0 - first implementation.
 *

 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef MESSAGEQUEUEDVM_H
#define MESSAGEQUEUEDVM_H

/*-----------------------------------------------------------------------------*
 * include declaration                                                         *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include "MessageQueue.h"



/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class
 */

enum MessageQueueDVMAccess
{
    VDDVM_EN_READONLY        = 0x0001,
    VDDVM_EN_WRITEONLY       = 0x0002,
    VDDVM_EN_READWRITE       = 0x0004
};


class MessageQueueDVM
{
    public:

           typedef enum
           {
               OK     = 0,
               ERROR  = 1 //in iMessageQueueWait this might be also a timout
           }tenReturn;



        /*!
         * \brief Default constructor
         */
        MessageQueueDVM();

        /*!
         * \brief Destructor
         */
        virtual ~MessageQueueDVM();



    public:
       /*!
        * \brief to replace tS32 OSAL_s32MessageQueueCreate(tCString coszName, tU32 u32MaxMessages, tU32 u32MaxLength,
         OSAL_tenAccess enAccess, OSAL_tMQueueHandle* phMQ)

        * some hint to types:
        * tCString replaced by char*
        * OSAL_tenAccess    replaced by      * tPVoid replaced by void *
        * tU32  replaced by   int
        * found in ai_osal_common this
        * OSAL_tMQueueHandle replaced by   int
       */
        int iInit(const char* pMsgQName, int u32MaxMessages, int u32MaxLength,int enAccess);

        /*!
         * \brief to replace  tS32 OSAL_s32MessageQueuePost(OSAL_tMQueueHandle hMQ, tPCU8 pcou8Msg, tU32 u32Length,
          tU32 u32Prio)
         * tPCU8 replaced by   int*
         * tU32    replaced by  int
         *
         */
        int iMessageQueuePost(const void* pMsg, int iLength,int iPrio);


        /*!
         * \brief to replace  tS32 OSAL_s32MessageQueueWait(OSAL_tMQueueHandle hMQ, tPU8 pu8Buffer, tU32 u32Length,
          tPU32 pu32Prio, OSAL_tMSecond msec)
         * OSAL_tMQueueHandle replaced by   int
         * tPU8 replaced by   int*
         * tU32    replaced by  int
         * OSAL_tMSecond  replaced by  int
         *
         */
        int iMessageQueueWait(void* pu8Buffer, unsigned int &uLength,int pu32Prio /*unused*/, unsigned int time_out_in_ms);


        unsigned int iGetCurMessagesCount();


    protected:
         
           /*!
                  * \brief closes undelying system q
                  * some hint to types:
                  */
           
                 int iDestroy();
                 /*!
                  * \brief to replace  tS32 OSAL_s32MessageQueueClose(OSAL_tMQueueHandle hMQ)
                  * some hint to types:
                  */
           
    private:
           //gmp framework messagequeue specific variables

           //Maximal number of messages
           int m_MaxMessages;
           //message queue maximum length
           int m_MaxLength;

           //message queue options.not used currently
           int m_AccessType;
           //message queue name
           const char *m_pMsgQName;
           //no of messages posted in the message queue.
           int m_CountMsges;

           MessageQueue *m_pMsgQueue;

};
// class MessageQueueDVM

#endif // MESSAGEQUEUEDVM_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>
