
/*-----------------------------------------------------------------------------*
 * LockDVM.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2020  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file LockDVM.h
 *
 * \brief Adapter class (Wrapper) to ease replacing osal lock functions, it uses gmp frame work lock
 *
 * \version 09.11.2015,Koechling Christian (CM/ESC3) <Christian.Koechling@de.bosch.com> , version 1.0 - first implementation to decrease dependency in Lock.h to proceed using the shared lib of gmp
 *

 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2020
 */

#ifndef LOCKDVM_H
#define LOCKDVM_H

#include "Config.h"
#include "Lock.h"

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class
 */



class LockDVM
{
    public:

           typedef enum
           {
               OK     = 0,
               ERROR  = 1 //in iMessageQueueWait this might be also a timout
           }tenReturn;


            /*!
             * \brief Default constructor
             */
            LockDVM();
    
            /*!
             * \brief Destructor
             */
         virtual ~LockDVM();
    
    
       
         int  lock();

         bool lock(unsigned int uiTimout_sec);

         void unlock();
    
         void setTimeout(const unsigned int sec);

        

    private:
        Lock m_Lock;
        

};
// class MessageQueueDVM

#endif // MESSAGEQUEUEDVM_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

