/*-----------------------------------------------------------------------------*
 * ETGTrace.h                                                                  *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*! 
 * \file ETGTrace.h
 *
 * \brief This file holds all sub trace classes bound to this component
 *
 * \version 12.07.2012, Negi, Sunder (Montavista), Created
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 02.08.2012, Negi, Sunder (Montavista), Added new trace class
 *          TR_CLASS_VD_DEVICEMANAGER_HISTORYMANAGER
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef ETGTRACE_H_
#define ETGTRACE_H_

/*!
 * \enum tenTrcTraceClassVD_DeviceManager
 *
 * \brief All the trace classes supported by VD_DeviceManager
 */

enum tenTrcTraceClassVD_DeviceManager     /*lint -e40 -e30*/
{
    TR_CLASS_VD_DEVICEMANAGER_PROCESS               = TR_COMP_MC_MEDIAPLAYER + 64 +  0,  /*0x5740 + 0 = 0x5740*/
        ///< trace class for VD_DeviceManager process
    TR_CLASS_VD_DEVICEMANAGER_APPLICATION           = TR_COMP_MC_MEDIAPLAYER + 64 +  1,  /*0x5740 + 1 = 0x5741*/
        ///< trace class for VD_DeviceManager application
    TR_CLASS_VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER = TR_COMP_MC_MEDIAPLAYER + 64 +  2,  /*             0x5742*/
        ///< trace class for VD_DeviceManager service
    TR_CLASS_VD_DEVICEMANAGER_CLIENTHANDLER_DIAGLOG = TR_COMP_MC_MEDIAPLAYER + 64 +  3,  /*             0x5743*/
        ///< trace class for VD_DeviceManager diagnosis client handler
    TR_CLASS_VD_DEVICEMANAGER_PRMMANAGER            = TR_COMP_MC_MEDIAPLAYER + 64 +  4,  /*             0x5744*/
        ///< trace class for Prm manager
    TR_CLASS_VD_DEVICEMANAGER_UDEVMANAGER           = TR_COMP_MC_MEDIAPLAYER + 64 +  5,  /*             0x5745*/
        ///< trace class for Device processor
    TR_CLASS_VD_DEVICEMANAGER_TRACECMDMANAGER       = TR_COMP_MC_MEDIAPLAYER + 64 +  6,  /*             0x5746*/
        ///< trace class for Trace command handler
    TR_CLASS_VD_DEVICEMANAGER_WORKERTHREAD          = TR_COMP_MC_MEDIAPLAYER + 64 +  7,  /*             0x5747*/
        ///< trace class for Worker thread
    TR_CLASS_VD_DEVICEMANAGER_STATE_TABLE           = TR_COMP_MC_MEDIAPLAYER + 64 +  8,  /*             0x5748*/
        ///< trace class for State table
    TR_CLASS_VD_DEVICEMANAGER_PLATFORMCTRL          = TR_COMP_MC_MEDIAPLAYER + 64 +  9,  /*             0x5749*/ 
        ///< trace class for VD_DeviceManager SPM client handler
    TR_CLASS_VD_DEVICEMANAGER_CALCHASHID            = TR_COMP_MC_MEDIAPLAYER + 64 +  10, /*             0x574A*/  //use this for GSrting or Confiiguration
        ///< trace class for Caclhashid library
    TR_CLASS_VD_DEVICEMANAGER_CONFIGMANAGER         = TR_COMP_MC_MEDIAPLAYER + 64 +  11, /*             0x574B*/
        ///< trace class for Configuration manager
    TR_CLASS_VD_DEVICEMANAGER_LISTMANAGER           = TR_COMP_MC_MEDIAPLAYER + 64 +  12, /*             0x574C*/
        ///< trace class for Device list manager
    TR_CLASS_VD_DEVICEMANAGER_HISTORYMANAGER        = TR_COMP_MC_MEDIAPLAYER + 64 +  13, /*             0x574D*/
        ///< trace class for History manager
    TR_CLASS_VD_DEVICEMANAGER_GPIO_IF               = TR_COMP_MC_MEDIAPLAYER + 64 +  14,  /*             0x574E*/
        ///< trace class for Voltage manager
    TR_CLASS_VD_DEVICEMANAGER_VOLTAGEMANAGER        = TR_COMP_MC_MEDIAPLAYER + 64 +  15,   /*             0x574F*/
       ///< trace class for VD_DeviceManager media manager client handler
    TR_CLASS_VD_DEVICEMANAGER_CLIENTHANDLER_VD_MEDIAMANAGER        = TR_COMP_MC_MEDIAPLAYER + 64 +  16,   /*             0x5750*/
    ///< trace class for VD_DeviceManager SPI client handler
    TR_CLASS_VD_DEVICEMANAGER_CLIENTHANDLER_SPI     =  TR_COMP_MC_MEDIAPLAYER + 64 +  17   /*             0x5751*/
    
    //Note:  in Linux    :di_projects\...\infotainment\FC_Mediaplayer\FC_Mediaplayer_main.h         TR_COMP_MC_MEDIAPLAYER +  0...6          [0x5700...0x5706]
    //Note:  in Linux    :di_projects\...\Av_management\VD_DeviceManager\VD_DeviceManager_main.h    TR_COMP_MC_MEDIAPLAYER +  0 + 7...15    [0x5707...0x570F]
    //Note:  in Linux    :di_projects\...\infotainment\VD_IPodAuth\VD_IPodAuth.trc                  TR_COMP_MC_MEDIAPLAYER + 16 + 0...2     [0x5710...0x5712]
    //Note:  in Tengine:di_projects\...\infotainment\ihl\ihl.trc                                    TR_COMP_MC_MEDIAPLAYER  +16 + 4...8     [0x5714...0x5718]
    //Note:  in Linux    :di_projects\...\di_middleware_server\Infotainment\IPODControl\Inc\IPODControl_Trace_Interface.h
    //                                                                                              TR_COMP_MC_MEDIAPLAYER  + 0 + 31         [0x571F]
};

#endif // ETGTRACE_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
