/*-----------------------------------------------------------------------------*
 * Common.h                                                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*! 
 * \file Common.h
 *
 * \brief Common includes
 *
 * This file holds all the required macros for memory allocation and
 * deallocation. This file also holds common includes used by this component.
 * Furthermore it clusters the includes.
 *
 * \version Initial Version
 * \version 21.11.2011, Koechling, Christian (Bosch), cleanup includes and
 *          intermediate defines to mark bugfixes
 * \version Negi, Sunder (Montavista), Update includes as per new file hierarchy
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 *\version 23.10.2013, Christian Koechling (Bosch) 
 *         -# start tp replace QStrings by replacing QString by define GENSTRING
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef __COMMON_H__
#define __COMMON_H__

#define MAX_USB_HUB_PORT 7

/*!
 * Macro for delete operation
 */
#ifndef DEL_M
    #define DEL_M(pPointer)  if(pPointer) delete pPointer; pPointer = NULL
#endif    // DEL_M

#define MOUNT_PATH      "/tmp/media"

//------------------------------------------------------------
//common defines used by most of .cpp-files of this component
//------------------------------------------------------------

//these definitions are used to decouple code from OSAL without haveing to adjust to many ocurrences in code
//start to replace INCLUDE_VD_DVM_OSAL by this aprt from those classes depdendent from prm and drv_volt
#ifdef INCLUDE_VD_DVM_TYPES
typedef signed char             tS8; 
typedef unsigned char           tU8;
typedef unsigned short          tU16;
typedef const unsigned char*    tPCU8;
typedef unsigned char*          tPU8;
typedef unsigned long           tU32;
typedef int                     tInt;
typedef char                    tChar;
typedef unsigned char           tBool;
#include <stdint.h>
typedef uint64_t                tU64;


#define OSAL_tMSecond           unsigned int  //needs to be replaced later
#define OSAL_tMQueueHandle      int           //needs to be replaced later


#endif //INCLUDE_VD_DVM_TYPES




#ifdef  INCLUDE_VD_DVM_AILAHL
#define AIL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"
#endif

#ifdef INCLUDE_VD_DVM_OSAL
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"
#endif

#ifdef INCLUDE_VD_DVM_EOLLIB
#include <EOLLib.h>
#endif

/* intermediately switched of to check if this dependency is used at all
#ifdef INCLUDE_VD_DVM_QTDBUS
#include <QtDBus/QtDBus>
#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusConnection>
#endif
*/

#ifdef  INCLUDE_VD_DVM_FIDIAG
// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include FI interface of used service
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#include "midw_fi_if.h"
#endif

#ifdef INCLUDE_VD_DVM_READREG
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"
#endif

#ifdef  INCLUDE_VD_DVM_GENERIC
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif



#ifdef INCLUDE_VD_DVM_BASICS
#include <vector>
#include <string>
#include "GenString.h"
#define CASE_SENSITIVE         0
#define CASE_INSENSITIVE       1
#define GENSTRING_NUMBER(iNum) GenString(((int)iNum))
#define TOASCII_SIZE           toAsciiSize()
#define TOASCII_AT(uiIndex)    toAsciiAt((unsigned int)uiIndex)
#define TOASCII                toAscii()
#define TOUTF8                 toUtf8constData()
#define NORMALIZATIONFORMC     1
#define GENSTRING_FROMUTF8(str) l_cTempMetaData.fromUtf8((const char*)str)

#include "LockDVM.h"
#define  DVMLOCK LockDVM

#include "ThreadFactory.h"
#include "ThreadFactoryDVM.h"

#endif //INCLUDE_VD_DVM_BASICS
#endif    // __COMMON_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>
