/************************************************************************
* FILE:         VD_DeviceManager_clienthandler_SPI.h
* PROJECT:      G3G
* SW-COMPONENT: Virtual Device Manager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD_DeviceManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date        | Author                     | Modification
* 17.02.2017  | Rajeev Narayanan Sambhu   | initial version
*
*************************************************************************/

#ifndef _VD_DEVICEMANAGER_CLIENT_HANDLERSPI_H_
#define _VD_DEVICEMANAGER_CLIENT_HANDLERSPI_H_

// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include public FI interface of this service.
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_SERVICEINFO
#include "midw_fi_if.h"


//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "Config.h"

class vd_devicemanager_tclApp;//lint !e763 Info 763;Redundant declaration for symbol 'x'

//-----------------------------------------------------------------------------
// defines,consts
//-----------------------------------------------------------------------------

const int cDelaySpiRetryDeviceList   = 2;//seconds
const int cWaitBeforeStoppingRetrial = 8;//seconds



//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
// ---  the application has one client message handler for each service ---
class vd_devicemanager_clienthandler_SPI : public ahl_tclCallbackBase, public ahl_tclBaseOneThreadClientHandler,public TFThread
{
private:

    vd_devicemanager_tclApp* m_poMainApp;
    tBool m_isServiceAvailble;
    tBool m_isRetryDone;//if the SPI device selection state is FI_EN_DEVICE_NOT_SELECTED, then we have to get the devicelist from SPI after a timeout

    Lock m_RetryDeviceListLock;//Lock for retry devicelist thread. Only one thread should exist at a time
    Lock m_WaitForStopRetrialLock;//Lock for stopping the retry  thread. Only one thread should exist at a time 
    
    typedef enum
    {
        eThread_SPIRETRYDEVICELIST        = 0,// this function id will create a temporary thread that will call SPI DeviceInfoList afte a timeout
        eThread_WAITBEFORESTOPPINGRETRIAL = 1 // this function id will create a temporary thread that will call vStopRetryForDevice after a timeout
    }tenThreadFunction;

    /**
    * This function derives from TFThread and starts a user function in a thread from the thread factory's thread pool.
    * After leaving the function used thread is stopped and released for other users
    *
    * @return void
    */
    virtual void Do(int functionID, void *ptr);


public:


    /*!
    * \brief Parameterized constructor
    *
    * Create an object of the base class ahl_tclBaseOneThreadService with
    * a pointer to this application, the service identifier, the application
    * identifier and the service version as parameters.
    *
    * \see ahl_tclBaseOneThreadService::ahl_tclBaseOneThreadService()
    */

    vd_devicemanager_clienthandler_SPI (vd_devicemanager_tclApp* poMainAppl); // constructor


    /*!
    * \brief Destructor
    *
    * \see ahl_tclBaseOneThreadService::~ahl_tclBaseOneThreadService()
    */
    ~vd_devicemanager_clienthandler_SPI( tVoid );               // Destructor

    //---------------------------------------------------------------------


    /*!
    * \brief Assignment Operator
    *
    * Will not be implemented. Avoids Lint Prio 3 warning: Info 1732: new
    * in constructor for class 'VD_DeviceManager_clienthandler_VD_MediaManager'
    * which has no assignment operator.
    *
    * \note This is a technique to disable the assignment operator for this
    *		class. So if an attempt for the assignment is made compiler
    *			complains.
    */
    vd_devicemanager_clienthandler_SPI& operator=
    (const vd_devicemanager_clienthandler_SPI &oClientHandler);




   /*---------------------------------------------------------------------*
    * Overriding ahl_tclBaseOneThreadClientHandler methods                *
    *---------------------------------------------------------------------*/

    /*!
    * \brief This function is called by the CCA framework when the service
    *        which is offered by this server has become available.
    *
    * \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
    */
    virtual tVoid vOnServiceAvailable();

    /*!
    * \brief This function is called by the CCA framework when the service
    *        which is offered by this server has become unavailable.
    *
    * \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
    */
    virtual tVoid vOnServiceUnavailable();



   
    //---------------------------------------------------------------------

    /*!
    * \brief get the list of devices from SPI service
    *
    *
    *\param [in] poMessage - the message.
    *
    */
    tVoid vHandleReceiveDeviceInfoList(IN  amt_tclServiceData* poMessage );

    /*!
    * \brief request the list of devices from SPI service
    *
    *
    *
    */
    tVoid vRequestDeviceInfoList();


    /*!
    * \brief Request for status of SPI Property DeviceStatusInfo
    *
    * Handle MIDW_SMARTPHONEINTFI_C_U16_DEVICESTATUSINFO - Request for status of SPI Property DeviceStatusInfo.
    * \param [in] poMessage - the message.
    *
    */
    tVoid vHandleDeviceStatusInfoUpdate( IN amt_tclServiceData *poMessage );



    // +++   Enter your public Data and functions here   +++

    DECLARE_MSG_MAP(vd_devicemanager_clienthandler_SPI)

};

#endif // _VD_DEVICEMANAGER_CLIENT_HANDLERSPI_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
