
/*-----------------------------------------------------------------------------*
 * VD_DeviceManager_clienthandler_Diaglog.h                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManager_clienthandler_Diaglog.h
 *
 * \brief CCA client-handler for the service Diaglog
 *
 * \version 05.04.2011, Ramkumar Muniraj (RBEI/ECV1), version 1.0, Initial version
 * \version 12.07.2011, Ramkumar Muniraj (RBEI/ECV1), version 1.1,
 *          Added required prototype of functions to perform DTC tests.
 * \version 12.07.2011, Koechling, Christian (Bosch), version 1.2
 * \version 19.08.2011, Koechling, Christian (Bosch), version 1.3
 *          -# Integrated diag fixes received by Ramkumar Muniraj (RBEI/ECV1)
 *          -# Interface VD_DeviceManager changed, ETG-traces improved, cleanup diagnosis
 * \version 19.01.2012, Koechling, Christian (Bosch), use
 *          'DELAY_DIGANOSISRESULT_CYCLICDIAG  see config spec.fix due
 *          to code review with Lars Plischke
 * \version 07.02.2012, Koechling, Christian (Bosch), added semaphore care for
 *          possible race condition for clearAll diagnosis
 * \version 15.02.2012, Koechling, Christian (Bosch), Diagnosis:    immediate
 *          response on clear all function call (MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT)
 * \version 27.02.2012, Koechling, Christian (Bosch), cleanup: adjusted code not
 *          to use m_bTestResultChanged
 * \version 05.03.2012, Koechling, Christian (Bosch), cleanup: adjusted function
 *          calls
 * \version 07.03.2012, Koechling, Christian (Bosch), merged MV-code Feb27 -
 *          contains issue for startup synchronisation
 * \version 10.03.2012, Koechling, Christian (Bosch), for analysis: add history
 *          of messages send to diaglog (DTC-only)
 * \version 19.07.2012, Koechling, Christian (Bosch), add mechanism to log
 *          histories for analysis to USB-stick
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 02.08.2012, Negi, Sunder (MontaVista),
 *          -# Refactored debug information logging
 *          -# Added History Manager, refer define HISTORY_MANAGER
  * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 * \version 12.08.2012, Negi, Sunder (MontaVista), cleanup HISTORY_MANAGER
 * \version 14.08.2012, Negi, Sunder (MontaVista), cleanup logging to usb
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef _VD_DEVICEMANAGER_CLIENTHANDLER_DIAGLOG_H_
#define _VD_DEVICEMANAGER_CLIENTHANDLER_DIAGLOG_H_

#include "Config.h"
#include "ICyclicDiagnosis.h"
#ifdef USE_ENABLE_VD_DVM_CLH_DIAGLOG_ICYCLICDIAGRECEIVER
#include "ICyclicDiagReceiver.h"
#endif

#ifdef USE_SHIFT_PARTOFDIAG_TO_ADAPTER
#include "DiagnosisTroubleCoder.h"
#endif //USE_SHIFT_PARTOFDIAG_TO_ADAPTER


/*-----------------------------------------------------------------------------*
 * namespaces                                                                     *
 *-----------------------------------------------------------------------------*/

using namespace dvmDiaglog;




/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/
#define NOTCONNECTED 0

#define DEVICE_MANAGER_USB_OVERCURRENT_TIME 0x03 // Number of Secs before declaring Normal current in Ports USB1 & USB2


/*!!!CLEANUP THIS PART IF DIAGNOSIS WILL HAVE PROVIDED DEFINES IN THEIR HEADER FOR ALL PROJECTS Then this code can be cleaned !!!*/

#define DEVICE_MANAGER_TIMEOUT_OC_ITC_USB      (OSAL_tMSecond)3000 // Milli seconds before writing ITC for OC at USB device

#ifdef MARKER_UNUSED_CODE
#define DEVICE_MANAGER_TIMEOUT_OC_ITC_SDC      (OSAL_tMSecond)3000 // Milli seconds before writing ITC for OC at SD Card device
#endif //MARKER_UNUSED_CODE
#define DEVICE_MANAGER_TIMERID_OC_SDC          2                   // Timer ID for USB timeout

#ifdef MARKER_UNUSED_CODE
#define DEVICE_MANAGER_TIMERID_OC_USB          1                   // Timer ID for USB timeout

#define DEVICE_MANAGER_TIMEOUT_CYCLICDIAG_FIRSTTIMOUT (OSAL_tMSecond)3000 
#define DEVICE_MANAGER_TIMEOUT_CYCLICDIAG_INTERVAL    (OSAL_tMSecond)1000 //Milliseconds to check for changes
#define DEVICE_MANAGER_TIMERID_CYCLICDIAG       3                  // Timer ID for cyclic diagnosis
#endif

/*-----------------------------------------------------------------------------*
 * forwards declarationx
 *-----------------------------------------------------------------------------*/
class vd_devicemanager_tclApp;

/*-----------------------------------------------------------------------------*
 * Structs/enums                                                               *
 *-----------------------------------------------------------------------------*/
/*! 
 * \struct diaglog_m_rDtc_error
 *
 * \brief Stores DTC test result.
 */

/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace dvmDiaglog;
using namespace statetbl;

/*-----------------------------------------------------------------------------*
 * Forward declarations                                                        *
 *-----------------------------------------------------------------------------*/
class midw_diaglogfi_tclMsgSaveTestResultMethodStart ;
class ahl_tclBaseOneThreadClientHandler;

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class vd_devicemanager_tclClientHandler_Diaglog
 *
 * \see ahl_tclBaseOneThreadClientHandler
 */
class vd_devicemanager_tclClientHandler_Diaglog: public ahl_tclCallbackBase, public ahl_tclBaseOneThreadClientHandler,ICyclicDiagnosis
#ifdef USE_ENABLE_VD_DVM_CLH_DIAGLOG_ICYCLICDIAGRECEIVER
    ,ICyclicDiagReceiver
#endif

{
public:

    /*!
         * \brief Default constructor
         *
         * \see ahl_tclBaseOneThreadService::ahl_tclBaseOneThreadService()
         */
    vd_devicemanager_tclClientHandler_Diaglog(tVoid);

    /*!
         * \brief Parameterized constructor
         *
         * Create an object of the base class ahl_tclBaseOneThreadService with
         * a pointer to this application, the service identifier, the application
         * identifier and the service version as parameters.
         *
         * \see ahl_tclBaseOneThreadService::ahl_tclBaseOneThreadService()
         */
    vd_devicemanager_tclClientHandler_Diaglog(
            vd_devicemanager_tclApp* poMainAppl);

    /*!
         * \brief Destructor
         *
         * \see ahl_tclBaseOneThreadService::~ahl_tclBaseOneThreadService()
         */
    virtual ~vd_devicemanager_tclClientHandler_Diaglog();

    /*!
         * \brief Assignment Operator
         *
         * Will not be implemented. Avoids Lint Prio 3 warning: Info 1732: new
         * in constructor for class 'vd_devicemanager_tclClientHandler_Diaglog'
         * which has no assignment operator.
         *
         * \note This is a technique to disable the assignment operator for this
         *       class. So if an attempt for the assignment is made compiler
         *       complains.
         */
    vd_devicemanager_tclClientHandler_Diaglog& operator=
    (const vd_devicemanager_tclClientHandler_Diaglog &oClientHandler);

    /*!
         * \brief Timer function
         *
         * This function is called from the superior application of this
         * client-handler in case of the expiration of a timer.
         *
         * Periodically does USB Test 1 & Test 2 and if there is change in Test
         * results, results are sent to VD_Diaglog
         *
         * \param [in] u16TimerId TimerID for doing USB Test1 & Test2
         */
    tVoid vProcessTimer(tU16 u16TimerId);

    /*---------------------------------------------------------------------*
         * Overriding ahl_tclBaseOneThreadClientHandler methods                *
         *---------------------------------------------------------------------*/

    /*!
         * \brief This function is called by the CCA framework when the service
         *        which is offered by this server has become available.
         *
         * \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
         */
    virtual tVoid vOnServiceAvailable();

    /*!
         * \brief This function is called by the CCA framework when the service
         *        which is offered by this server has become unavailable.
         *
         * \see ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable();
         */
    virtual tVoid vOnServiceUnavailable();


    /*!
         * \brief see interface ICyclicDiagnosis - calls Diagnosis functions
         *
         */
    virtual void ProcessDiag(vector<trDtcCodeResult> &ListCyclicDiagResults);

#ifdef USE_DECOUPLE_CYCLICDIAGCCA

#ifndef USE_SHIFT_PARTOFDIAG_TO_ADAPTER
    void vStoreResultInVector(IN tU16 u16DtcCode,IN tU8 u8Result, INOUT vector<trDtcCodeResult> &ListCyclicDiagResults);
#endif //USE_SHIFT_PARTOFDIAG_TO_ADAPTER

    void vCopyResultToVector(vector<trDtcCodeResult> &ListCyclicDiagResults);

        /*!
             * \brief Send message to diag - CyclicDiagThread sends to Internlal Loop of VD_DVM_MAIN/Servoce which uses this function to send it to diagnosis
             *
             * \param  [in] ms test result message object
             */
    void  vSendResultOfCyclicDiag(OUT vector<trDtcCodeResult> ListCyclicDiagResults);

#endif
#ifdef USE_ENABLE_VD_DVM_CLH_DIAGLOG_ICYCLICDIAGRECEIVER
        /*---------------------------------------------------------------------*
         *    ICyclicDiagReceiver *
         *---------------------------------------------------------------------*/
             /*! 
         * \brief description see ICyclicDiagReceiver
         */
        virtual void ReceiveDiagResults(vector<trDtcCodeResult> ListCyclicDiagResults);
    
#endif //USE_ENABLE_VD_DVM_CLH_DIAGLOG_ICYCLICDIAGRECEIVER


    /*---------------------------------------------------------------------*
         * Handler function declarations used by message map                   *
         *---------------------------------------------------------------------*/

    // Add your CCA message handler function prototypes here.

    /*---------------------------------------------------------------------*
         * Message map definition macro                                        *
         *---------------------------------------------------------------------*/
    DECLARE_MSG_MAP(vd_devicemanager_tclClientHandler_Diaglog)

    private :

    #if 0
        /*!
                 * \brief for debugging if diagnosis sends out ITC-errors or oks this is internally send to History i.e. can be listed  via backtrace command 'VD_DVM_HISTORY_MSGS_SEND2DIAGNOSIS'
                 *
                 * \param [OUT] f_rDiagEvts reference to array to be filled with content of f_oTestResultList to keep History mechanism free of CCA dependent parts
                 * \param [IN] f_oTestResultList this is what will be send to FC_Diagnosis
                 *
                 * \return TRUE if f_rDiagEvts could be filled based on content of f_oTestResultList
                 */
        IN tBool bMapToDiagHistory (OUT trDiagEvt &f_rDiagEvts, IN midw_fi_tcl_TestResultList& f_oTestResultList);
#endif



    /*!
         * \brief Sets the DTC test status to Class variable. Before setting,
         *        checks if results are changed.
         *
         * \param [in] usb        for which USB Host test results are requested
         *             to set.
         * \param [in] enDtcTestType whether test results is for
         *             USB_HOST_OVER_THRERSH, or USB_HOST_OPEN_CIRC or
         *             USB_HOST_ABOVE_MAX_THRESH
         * \param [in] u8Result]  test result for the DTC code
         * \param [in] poTestData pointer to populate the data to be sent for
         *             Method start
         *
         * \return 1 means values changed 0 same value like before
         */
    tU8 u8SetDiagLogDTCCode(
            tenDevManagerUSBHost usb,
            tenUsbTestType enDtcTestType,
            tU8 u8Result
#ifndef USE_DECOUPLE_CYCLICDIAGCCA
            ,midw_diaglogfi_tclMsgSaveTestResultMethodStart   *poTestData
#endif
            );

#ifndef USE_SHIFT_PARTOFDIAG_TO_ADAPTER
 //added this function to ease refactoring see DiagnosisTroubleCoder
  tU8 u8SetDiagLogDTCCode(
            tenDevManagerUSBHost usb,
            tenUsbTestType enDtcTestType,
            tU8 u8Result
#ifndef USE_DECOUPLE_CYCLICDIAGCCA
            ,midw_diaglogfi_tclMsgSaveTestResultMethodStart   *poTestData
#endif
            ,tBool bServiceIsAvailable);


#endif //USE_SHIFT_PARTOFDIAG_TO_ADAPTER
    tU8 u8SetDiagLogItcSdc( tenSlot eSdcSlot, tU8 u8Result
#ifndef USE_DECOUPLE_CYCLICDIAGCCA
            , midw_diaglogfi_tclMsgSaveTestResultMethodStart *poTestData 
#endif
            );

    /*!
         * \brief Does the DTC test
         *
         * Does DTC test of
         * -# VDL_ITC_GMG2_USB_SIGNAL_OVER_THRERSH
         * -# VDL_ITC_GMG2_USB_HUB_OPEN_CIRC
         * -# VDL_ITC_GMG2_USB_HUB_ABOVE_MAX_THRESH
         *  -# enITC_USB1_LINK_DISABLED
         *  -# enITC_USB1_SPEED_REDUCED
         *
         * \param [in]  usb        for which the test is to be done
         * \param [in]  poTestData pointer to populate the data to be sent for
         *              Method start
         * \param [out] u8NumOfChanges tells if values of 'm_rDtc_error[]'have
         *              been changed
         */
         
    tVoid vDoUSBCircuitTest( IN tenDevManagerUSBHost usb,
#ifndef USE_DECOUPLE_CYCLICDIAGCCA
    OUT midw_diaglogfi_tclMsgSaveTestResultMethodStart *poTestData,
#endif
    OUT tU8 &u8NumOfChanges);

    /*!
        * \brief to send quickly first message to diagnosis ITC's are send passed to diaglog.
        *           This helps diagnosis to care for correct handling of timeouts
        *
        * \param [in]  poTestData pointer to populate the data to be sent for
        *              Method start
        *
        */

    tVoid vDoSendFirstMessageToDiagLog(
#ifndef USE_DECOUPLE_CYCLICDIAGCCA
    OUT midw_diaglogfi_tclMsgSaveTestResultMethodStart *poTestData
#endif
    );

    /*!
        * \brief Does the DTC test.
        *
        * Does the DTC test of the SD card slots  This function will take input from Configuration Manager
        * to check whether sending ITCs of SD card slot is enabled
        *  -# VDL_ITC_GMG2_USB_SIGNAL_OVER_THRERSH
         * -# VDL_ITC_GMG2_USB_HUB_OPEN_CIRC
         * -# VDL_ITC_GMG2_USB_HUB_ABOVE_MAX_THRESH
        *  -# enITC_SDC1_SIGNAL_OVERCURRENT
        *  -# enITC_USB1_LINK_DISABLED
        *  -# enITC_USB1_SPEED_REDUCED
        *
        * \param [in]  eSdcSlot        for which SD card slot the test is to be done
        * \param [in]  poTestData pointer to populate the data to be sent for
        *              Method start
        * \param [out] u8NumOfChanges tells if values of 'm_rDtc_error[]'have
        *              been changed
        *
        */

    tVoid vDoSdcTest( IN tenSlot eSdcSlot, 
#ifndef USE_DECOUPLE_CYCLICDIAGCCA
    OUT midw_diaglogfi_tclMsgSaveTestResultMethodStart* poTestData,
#endif
    OUT  tU8& u8NumOfChanges );

    /*!
        * \brief Does all the DTC test and send the results.
        *
        * Does the DTC test of the USB ports and SD card slots enabled and pass the messages to diaglog. This function will take input from Configuration Manager
        * to check whether sending ITCs of SD card slot is enabled
        *  -#  enITC_SDC1_SIGNAL_OVERCURRENT
        *
        *
        * \param [in]  poTestData pointer to populate the data to be sent for
        *              Method start
        * \param [in]  u16TimerId If the Configuration enables the SD card slot Itcs, the timerid will be set to DEVICE_MANAGER_TIMERID_OC_SDC
        *
        *
        */

    tVoid vDoCircuitTestAndSendMessageToDiagLog(
#ifndef USE_DECOUPLE_CYCLICDIAGCCA
    IN midw_diaglogfi_tclMsgSaveTestResultMethodStart *poTestData, 
#endif
IN tU16 u16TimerId);



    /*!
         * \brief Send message to diag
         *
         * \param  [in] ms test result message object
         */
    tVoid  vSendResult(
            OUT midw_diaglogfi_tclMsgSaveTestResultMethodStart &ms);



    /*!
         * \brief Display diagnosis specific info of connected device
         *
         * \param [in] usb       tUSB1 or USB2
         * \param [in] poUSBDiag diagnosis information
         */
    tVoid vTraceInfo(IN tenDevManagerUSBHost usb, IN const CUSBDiagnosis* poUSBDiag) const;


    /*!
         * \brief MethodResult function for CCX methodStart for function ID
         *        MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT
         *
         * \param [in] poMessage received message
         */
    tVoid vHandle_SaveTestResult_MethodResult(amt_tclServiceData* poMessage) const;

    /*!
         * \brief VD_Diaglog Property indicating at Running DTC test needs to
         *        current test result must be sent.
         *
         * \param [in] poMessage received message.
         */
    tVoid vHandle_DiaglogSendNextTestResult_Status( amt_tclServiceData* poMessage);

    //pointer of the device manager main application
    vd_devicemanager_tclApp* m_poMainApp;
    tU8 m_u8UsbOverCurrentCount[ARRAYSIZEFORUSB];  // Holds for how long Current @ USB 1 and USB 2 is in normal range after Overcurrent is detected
    tU8 m_u8SdcOverCurrentCount[ARRAYSIZEFORCARD];   // Holds for how long Current @ SDC 1 (and SDC 2) is in normal range after Overcurrent is detected
    tU32 m_u32CountSecondsFromStartup;  //triggered by cyclic diagnosis which is done every second
    tBool m_bSendFirstMessageToDiagLog; //to give intermediate response to FC_Diaglog at startup values will be send passed first - in this manner FC_diaglog can care for timeouts
    diaglog_rDtc_error m_rDtc_error[NUM_OF_DTC_ERRORS];


private:
   
    ahl_tclTimer                     m_Timer;  //timer to inform about Overcurrent etc. after certain time (used i nNissanLCN2Kai, GM uses cyclic polling every 1 sec)
    ahl_tclTimer                     m_TimerSdcOc;


    tBool                            m_bTimerStarted;
    tBool                            m_bTimerSdcOcStarted; //same but for internal SDCard

    BTAMonitorStates                 m_eBTAMonitorStates;
    bool                             m_bBTAAliveStatus;
    tU32                             m_u32CountSecondsUSBOpen;

    LockDVM                          m_LockDiagFct;
    LockDVM                          m_LockList;

    tBool                            m_bFirstTransmission;

#ifdef USE_SHIFT_PARTOFDIAG_TO_ADAPTER
    DiagnosisTroubleCoder            m_DiagnosisTroubleCoder;
#endif //USE_SHIFT_PARTOFDIAG_TO_ADAPTER
public:
    virtual void  vExecute        ( tVoid );

    //if an overcurrent happens at SD Cardreader this timer is used to send this with delay of e.g. 3sec to diagnosis
    tVoid         vStartUsbOcTimer( tVoid ); 

#ifdef MARKER_UNUSED_CODE
    //koe2hi: this is not used for this reason the above mentioned delay does not make sene I think
    tVoid         vStopUsbOcTimer ( tVoid );
#endif

#ifdef MARKER_UNUSED_CODE
    tVoid         vStartSdcOcTimer( tVoid );
    tVoid         vStopSdcOcTimer ( tVoid );
#endif

};

#endif // _VD_DEVICEMANAGER_CLIENTHANDLER_DIAGLOG_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
