/*-----------------------------------------------------------------------------*
 * AdapterDiagnosisTroubleCode.h                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file AdapterDiagnosisTroubleCode.h
 *
 * \brief to make functions unit testable code parts which belong to VD_DeviceManager_clienthandler_Diaglog.h have been shifted to this class
 *
 * \version 09.02.2016, Christian Koechling version 1.0, Initial version
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH
 */
#ifndef  _ADAPTER_DIAGNOSIS_TROUBLE_CODE_H_
#define  _ADAPTER_DIAGNOSIS_TROUBLE_CODE_H_

/*-----------------------------------------------------------------------------*
 * include declaration                                                         *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include "Enums.h"

/*-----------------------------------------------------------------------------*
 * namespaces                                                                     *
 *-----------------------------------------------------------------------------*/
using namespace dvmDiaglog;
using namespace statetbl;


/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class
 */

class DiagnosisTroubleCoder
{
    public:

          DiagnosisTroubleCoder();

          virtual ~DiagnosisTroubleCoder();
        
           /*!
                 * \brief Sets the DTC test status to Class variable. Before setting,
                 *        checks if results are changed.
                 *
                 * \param [in] usb        for which USB Host test results are requested
                 *             to set.
                 * \param [in] enDtcTestType whether test results is for
                 *             USB_HOST_OVER_THRERSH, or USB_HOST_OPEN_CIRC or
                 *             USB_HOST_ABOVE_MAX_THRESH
                 * \param [in] u8Result]  test result for the DTC code
                 * \param [in] poTestData pointer to populate the data to be sent for
                 *             Method start
                 *
                 * \return 1 means values changed 0 same value like before
                 */
        tU8 u8SetDiagLogDTCCode(tenDevManagerUSBHost usb,tenUsbTestType enDtcTestType, tU8 u8Result, tBool bServiceIsAvailable, INOUT diaglog_rDtc_error (&f_rDtc_error)[NUM_OF_DTC_ERRORS],INOUT vector<trDtcCodeResult> &ListCyclicDiagResults );

        void vStoreResultInVector(IN tU16 u16DtcCode,IN tU8 u8Result, INOUT vector<trDtcCodeResult> &ListCyclicDiagResults);


};

#endif // _ADAPTER_DIAGNOSIS_TROUBLE_CODE_H_


 ////////////////////////////////////////////////////////////////////////////////
 // <EOF>

