/*
 * VD_DeviceManager_rootdaemon_client.cpp
 *
 *  This file implements IClientSharedlib.h (the client side of the root daemon)
 *  it should be compiled as shared library and copied to the sharedlibs loading area to be loadable from the root daemon server side
 *
 *  Created on: Jan 16, 2018
 *      Author: Ganesh Rengasamy
 */

#include "Config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/mount.h>
#include <syslog.h>
#include <errno.h>

#include <glob.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <string>
#include <vector>
#include <istream>
#include <iostream>
#include <fstream>

#include <IClientSharedlib.h>
#include <VD_DeviceManager_rootdaemon_client.h>



//---------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------


#ifdef __cplusplus
extern "C"
{
#endif

    const char * getClientName()
   {
      return "VD_Devicemanager";//TODO put it in header file
   }
   
    const char * getClientGroupName()
   {
       return (char *)"aid_mediaplayer";
   }

   const char * getClientUserName()
   {
       return (char *)"aid_mediaplayer";
   }

    CmdData command(const int cmdNum, std::string args)
   {
      CmdData result;
      string command_str;
      switch(cmdNum)
      {

          /*cmdNum = 0*/
         case CMD_MKDIR: //Call in CHistoryManager::InitDumpHistoryToUSBStick // TraceCmdManager::TTFIScmdSimulateOverCurrentPlatformDTY_USB // TraceCmdManager::TTFIScmdSimulateUndervoltagePlatformDTY_USB
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "mkdir " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 1*/
         case CMD_CP: //Call in TraceCmdManager::TTFIScmdSimulateOverCurrentPlatformDTY_USB // TraceCmdManager::TTFIScmdSimulateUndervoltagePlatformDTY_USB
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "cp " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 2*/
         case CMD_RM: //Call in TraceCmdManager::TTFIScmdSimulateOverCurrentPlatformDTY_USB // TraceCmdManager::TTFIScmdSimulateUndervoltagePlatformDTY_USB
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "rm " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 3*/
         case CMD_RMDIR: //Call in TraceCmdManager::TTFIScmdSimulateOverCurrentPlatformDTY_USB // TraceCmdManager::TTFIScmdSimulateUndervoltagePlatformDTY_USB
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "rmdir " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 4*/
         case CMD_SYNC: //No Call
          {
              if(args.empty()) //Expect EMPTY arguments
              {
                  command_str = "sync";

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 5*/
         case CMD_MV: //No Call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "mv " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 6*/
         case CMD_DF2FILE: //No Call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "df " + args;//prepared at call

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 7*/
         case CMD_MOUNT_RW: //Call in CHistoryManager::InitDumpHistoryToUSBStick
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "mount -o remount,rw " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 8*/
         case CMD_MOUNT: //No Call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "mount " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 9*/
         case CMD_UMOUNT: //No Call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "umount " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 10*/ //? NO COMMAND GIVEN TODO
         case CMD_CATGREPTOFILE: //No Call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = " " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 11*/
         case CMD_LS: //No Call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "ls " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 12*/
         case CMD_FGREP: //No Call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "fgrep " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 13*/
         case CMD_FIND_GREP: //? NO COMMAND GIVEN TODO
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = " " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 14*/
         case CMD_DMESG2FILE: //No call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "dmesg >" + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 15*/
         case CMD_BLKID2FILE: //No call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "blkid " + args;//prepared at call

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 16*/
         case CMD_LD_LR: //? NO COMMAND GIVEN TODO
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = " " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 17*/
         case CMD_LSUSB2FILE: //No call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "lsusb " + args;//prepared at call

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 18*/
         case CMD_DBG_ANALYSIS: //call in CHistoryManager::DumpPlatformHistoryToUSBStick // TraceCmdManager::TTFiscmd_LinuxCmdDbgAnalysis
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command(CMD_RM,string("/tmp/cmd_dbgAnalysis.result"));

                  command(CMD_ECHO2FILE,string("'-----------Begin of CMD-List----------------' >> /tmp/cmd_dbgAnalysis.result"));
                  //command(IRootDaemon::CMD_ECHO2FILE,"date  >> /tmp/cmd_dbgAnalysis.result"); //add info to check if deleting file might have not worked


                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: cat /proc/partitions'             >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_CAT2FILE,string("/proc/partitions >> /tmp/cmd_dbgAnalysis.result")); //command("cat /proc/partition >> /tmp/cmd_dbgAnalysis.result");

                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: mount'                            >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_MOUNT2FILE,string(" >> /tmp/cmd_dbgAnalysis.result"));    //command("/bin/mount >> /tmp/cmd_dbgAnalysis.result");

                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: blkid'                            >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_BLKID2FILE,string(" >>/tmp/cmd_dbgAnalysis.result"));   //command("/sbin/blkid >> /tmp/cmd_dbgAnalysis.result");

                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: df'                                >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================'  >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_DF2FILE  ,string(" >> /tmp/cmd_dbgAnalysis.result"));     //command("/bin/df >> /tmp/cmd_dbgAnalysis.result");

                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: lsusb'                            >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_LSUSB2FILE,string(" >>/tmp/cmd_dbgAnalysis.result"));  //command("/usr/bin/lsusb >> /tmp/cmd_dbgAnalysis.result");

                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: ls -lR /tmp/.automounter'         >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_LS2FILE,string("/tmp/.automounter >>/tmp/cmd_dbgAnalysis.result")); //command("/bin/ls -lR /tmp/.automounter >> /tmp/cmd_dbgAnalysis.result");

                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: /bin/fgrep -R '=' /tmp/.automounter' >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_FGREP2FILE,string("-R '=' /tmp/.automounter >> /tmp/cmd_dbgAnalysis.result"));//command("/bin/fgrep -R '=' /tmp/.automounter >> /tmp/cmd_dbgAnalysis.result");

                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: ls -l /dev/sd*'                   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_LS,       string("-lR /dev/sd* >> /tmp/cmd_dbgAnalysis.result"));

                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: ls -l /dev/mmcblk0*'                   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_LS,       string("-l /dev/mmcblk0* >> /tmp/cmd_dbgAnalysis.result"));

                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: ls -l /dev/sr*'                   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_LS,       string("-l /dev/mmcblk0* >> /tmp/cmd_dbgAnalysis.result"));

                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: ls -lR /dev/char'                   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_LS,       string("-lR /dev/char >> /tmp/cmd_dbgAnalysis.result"));

                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: dmesg '                             >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_DMESG2FILE,string(" >> /tmp/cmd_dbgAnalysis.result"));
/*
                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'CMD: journalctl  '                       >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_ECHO2FILE,string("'================================'   >> /tmp/cmd_dbgAnalysis.result"));
                  command(CMD_JOURNALCTL2FILE,string(" >> /tmp/cmd_dbgAnalysis.result"));
*/
                  //first dmesg output then journal to ease finding the echos - journal also contains the echos  - eases analysis

                  //------------------------------------------------------------------------------
                  //cp /tmp/cmd_dbgAnalysis.result - this is for logging to USB-stick i.e. if no trace is ased
                  //------------------------------------------------------------------------------
                  command(CMD_ECHO2FILE,string("'-----------end of CMD-List----------------' >>/tmp/cmd_dbgAnalysis.result"));
                  string sparameters;
                  sparameters = string("/tmp/cmd_dbgAnalysis.result ") + args;
                  command(CMD_CP,sparameters);

                  result.errorNo = ERR_NONE;
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 19*/
         case CMD_ECHO2FILE: //No call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "echo " + args; //prepared full command at call

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 20*/
         case CMD_MOUNT2FILE: //No call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "mount " + args; //prepared at call

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 21*/
         case CMD_CAT2FILE: //No call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = args; //prepared full command at call

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 22*/
         case CMD_LS2FILE: //No call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "ls -lR " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 23*/
         case CMD_FGREP2FILE: //No call
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "fgrep " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 24*/
         case CMD_CHMODFULL: //call in CHistoryManager::InitDumpHistoryToUSBStick(
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "chmod 777 " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 25*/
         case CMD_UDEVADM: //call in CUDevManager::InitializeUDevMonitor()
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "udevadm " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }

          /*cmdNum = 26*/
         case CMD_DFGETSIZE: //call in CUDevManager::GetSizeMSC_TUF
          {
              if(!args.empty()) //Expect NON-EMPTY arguments
              {
                  command_str = "df " + args;

                  syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),executing[%s]", command_str.c_str());
                  if(0 == system(command_str.c_str()))
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),Successful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_NONE;
                  }
                  else
                  {
                     syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),unsuccessful operation [%s]", command_str.c_str());
                     result.errorNo = ERR_CANNOT_EXEC_CMD;
                  }
              }
              else
                 result.errorNo = ERR_INVALID_CMD_ARGS;

              break;
          }



         default:
            syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:command(),default");
            result.errorNo = ERR_UNKNOWN_CMD;
      }

      return result;
   }

   #ifdef __cplusplus
}
#endif


CmdData execRootCommand(const char * clientName, const int cmdNum, const char * args)
{
   uid_t euid = geteuid();

   if(0 == euid)
   {
      //User is root: execute root operation directly
      syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:execRootCommand() calling command(), clientname[%s],cmdnum[%d], args[%s]",clientName, cmdNum, args);
      return command(cmdNum, std::string(args));
   }
   else
   {
      //use root daemon to perform root operation
      syslog(LOG_INFO, "VD_DeviceManager_rootdaemon_client:execRootCommand() calling calling performRootOp(), clientname[%s],cmdnum[%d], args[%s]",clientName, cmdNum, args);
      return RootDaemonHelper::performRootOp(clientName, cmdNum, std::string(args));
   }
}
