/*
 * MediaPlayerStartupTest.h
 *
 *  Created on: 2014
 *      Author: tghm3hi
 */

#ifndef MEDIAENGINEOPERATIONTEST_H_
#define MEDIAENGINEOPERATIONTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TimeTrace.h"
#include "TypeDefinitions.h"

class MediaEngineOperationTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MediaEngineOperationTest );

    /* suite for null codec */
    CPPUNIT_TEST( Ping );
    CPPUNIT_TEST( SwitchObserver );
#if 0
    CPPUNIT_TEST( EndurancePing );
#endif
#if 1
    CPPUNIT_TEST( Play_null );
    CPPUNIT_TEST( Pause_null );
    CPPUNIT_TEST( Play_null );
    CPPUNIT_TEST( Buffer_null );
    CPPUNIT_TEST( FF_null );
    CPPUNIT_TEST( Flush );
    CPPUNIT_TEST( Play_null );
    CPPUNIT_TEST( Buffer_null );
    CPPUNIT_TEST( Buffer_null );
    CPPUNIT_TEST( Stop );
    CPPUNIT_TEST( Pause_null );
    CPPUNIT_TEST( Pause_null );
    CPPUNIT_TEST( Flush );
    CPPUNIT_TEST( Stop );
    CPPUNIT_TEST( Stop );
    CPPUNIT_TEST( Pause_null );
    CPPUNIT_TEST( Play_null );
    CPPUNIT_TEST( Buffer_null );
    CPPUNIT_TEST( Play_null );
    CPPUNIT_TEST( FRev_null );
    CPPUNIT_TEST( Stop );
#endif
#if 1
    CPPUNIT_TEST( PrepareAVTests );

    /* suite for av codec, testing mp3 */
    //CPPUNIT_TEST( Ping );
    CPPUNIT_TEST( Play_mp3 );
    CPPUNIT_TEST( Pause_mp3 );
    CPPUNIT_TEST( Play_mp3 );
    CPPUNIT_TEST( Buffer_mp3 );
    CPPUNIT_TEST( FF_mp3 );
    CPPUNIT_TEST( Flush );
    CPPUNIT_TEST( Play_mp3 );
    CPPUNIT_TEST( Buffer_mp3 );
    CPPUNIT_TEST( Buffer_mp3 );
    CPPUNIT_TEST( Stop );
    CPPUNIT_TEST( Pause_mp3 );
    CPPUNIT_TEST( Pause_mp3 );
    CPPUNIT_TEST( Flush );
    CPPUNIT_TEST( Stop );
    CPPUNIT_TEST( Stop );
    CPPUNIT_TEST( Pause_mp3 );
    CPPUNIT_TEST( Play_mp3 );
    CPPUNIT_TEST( Buffer_mp3 );
    CPPUNIT_TEST( Play_mp3 );
    CPPUNIT_TEST( FRev_mp3 );
    CPPUNIT_TEST( Stop );
#endif
    CPPUNIT_TEST_SUITE_END(); //lint -e578

public:

    /* test cases*/
    void Ping();
    void EndurancePing();
    void Flush();
    void Stop();
    void SwitchObserver();

    void Play_null();
    void Buffer_null();
    void Pause_null();
    void FF_null();
    void FRev_null();

    void Play_mp3();
    void Buffer_mp3();
    void Pause_mp3();
    void FF_mp3();
    void FRev_mp3();

    void PrepareAVTests();

    /* common to all test cases triggered before and after each test case */
    void setUp();
    void tearDown();

private:

    void Play(char *url);
    void Buffer(char *url);
    void Pause(char *url);
    void FF(char *url);
    void FRev(char *url);

    void CreateMp3FileName(tPath fileName);

    TimeTrace        ticks;         /**< time object to trace the time taken by testcases*/
};

#endif /* MEDIAENGINEOPERATIONTEST_H_ */
