////////////////////////////////////////////////////////////////////////////////
/*
 * MediaEngineOperationTest.cpp
 *
 *  Created on: 2014
 *      Author: thm3hi
 */
////////////////////////////////////////////////////////////////////////////////

#include "3_server/gmp/MediaEngineServerIF.h"
#include "3_server/gmp/MediaEngineServer.h"
#include "RequestResponseSM.h"

#include "Dispatcher.h"

#include "5_test/MediaEngineOperationTest.h"

////////////////////////////////////////////////////////////////////////////////

// #define NULL_FILE "/url/folder1/folder2/filename.null"
#define NULL_FILE "/url/folder1/folder2/filenäme.null"

////////////////////////////////////////////////////////////////////////////////

#if !defined(VARIANT_S_FTR_ENABLE_BUILD_ME_TEST_AS_PROCESS)

   #include "LocalSPM.h"

   // access project specific usage flag for MediaEngine in DataProvider only for
   // cppunit newmediaplayer test not for cppunit product mediaenginetest

   #define RETURN_ON_MEDIAENGINE_OFF   if(0 == LocalSPM::GetDataProvider().UseMediaEngine()) { \
                                          return; \
                                       }
#else
   #define RETURN_ON_MEDIAENGINE_OFF
#endif

////////////////////////////////////////////////////////////////////////////////

tPath mTestFilesPath;

////////////////////////////////////////////////////////////////////////////////

void MediaEngineOperationTest::setUp() {
	
	traces("MediaEngineOperationTest");
   ticks.begin();
}

void MediaEngineOperationTest::tearDown() {
	
	traces("MediaEngineOperationTest");	
   ticks.elapsed();
}

////////////////////////////////////////////////////////////////////////////////

void MediaEngineOperationTest::Ping()
{
   RETURN_ON_MEDIAENGINE_OFF
 	traces("MediaEngineOperationTest");	 

   tResult res = MP_NO_ERROR;

   RequestResponseSM rrPing;

   res = rrPing.DoEventAnswer("MediaEngineSM::PING", NULL, NULL, 5000);
   CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaEngineOperationTest::EndurancePing()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   tResult res = MP_NO_ERROR;

   class rrEndurancePing : public RequestResponseSM
   {
      int HandleInitRequest() {
         return 0;
      }

      int HandleSuccessRequest(const char *allParameters) {
			
         /* is a parameter added (no timeout) */
         if(allParameters && strlen_r(allParameters)) {

         int iParam = 1;
         UnMarshal((char *)allParameters, "i", &iParam);

         /* param value correct? */
         if(iParam == 0) {

            /* we have got an correct ping answer */
            gotAnswer = 1;
            pingCounter++;
         }
      }

      return 0;
   }

   public:
      int gotAnswer;
      int pingCounter;
   };

   rrEndurancePing rrEndurancePing;
   rrEndurancePing.pingCounter = 0;

   /* endurance test loop */
   enum {runs = 10000};
   for(int run=runs; run; run--) {

      rrEndurancePing.gotAnswer = 0;

      res = rrEndurancePing.DoEventAnswer("MediaEngineSM::PING", NULL, NULL, 5000);
      CPPUNIT_ASSERT(MP_NO_ERROR == res);

      /* check answer */
      CPPUNIT_ASSERT(rrEndurancePing.gotAnswer != 0);
   }

   /* check count */
	me::trace("MediaEngineOperationTest:EndurancePing:pingCounter", rrEndurancePing.pingCounter, " runs:", runs);
   CPPUNIT_ASSERT(rrEndurancePing.pingCounter == runs);
}

////////////////////////////////////////////////////////////////////////////////

enum rrResultType {
   RR_RESULT_NORMAL,
   RR_RESULT_BUFFER,
   RR_RESULT_SWITCH_OBSERVER
};

class rrTest : public RequestResponseSM
{
   int HandleInitRequest() {
      return 0;
   }

   int HandleSuccessRequest(const char *allParameters) {
		
      if(allParameters && strlen_r(allParameters)) {
          me::trace("MediaEngineOperationTest:HandleSuccessRequest:", allParameters);
      } else {
         me::trace("MediaEngineOperationTest:HandleSuccessRequest:timeout");
         return -1;
      }

      if(RR_RESULT_NORMAL == expectedType) {
         me::trace("MediaEngineOperationTest:HandleSuccessRequest:type:result_normal");                           
         tU64 handle;
         int playbackState;
         UnMarshal((char *)allParameters, "li", &handle, &playbackState);
         if(playbackState != expectedState) {
            return -1;
         }

      } else if(RR_RESULT_BUFFER == expectedType) {
         me::trace("MediaEngineOperationTest:HandleSuccessRequest:type:result_buffer");                  
         int success;
         UnMarshal((char *)allParameters, "i", &success);

         //printf("buffer:success:%d expected state:%d\n", success, expectedState);
         if(success != expectedState) {
            return -1;
         }

      } else if(RR_RESULT_SWITCH_OBSERVER == expectedType) {
         me::trace("MediaEngineOperationTest:HandleSuccessRequest:type:switch_observer");         
         int returnValue;
         UnMarshal((char *)allParameters, "i", &returnValue);

         //printf("switch observer:returnValue:%d expected state:%d\n", returnValue, expectedState);
         if(returnValue != expectedState) {
            return -1;
         }

      } else {
         me::trace("MediaEngineOperationTest:HandleSuccessRequest:type:unknown");
         return -1;
      }
      return 0;
   }

public:
   rrResultType expectedType;
   int          expectedState;
};

////////////////////////////////////////////////////////////////////////////////
// null;

void MediaEngineOperationTest::Play_null()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");	

   Play((char *)NULL_FILE);
}

void MediaEngineOperationTest::Buffer_null()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   Buffer((char *)"/url/folder1/folder2/filename_2.null");
}

void MediaEngineOperationTest::Pause_null()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   Pause((char *)NULL_FILE);
}

void MediaEngineOperationTest::FRev_null()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   FRev((char *)NULL_FILE);
}

void MediaEngineOperationTest::FF_null()
{
   RETURN_ON_MEDIAENGINE_OFF
   traces("MediaEngineOperationTest");

   FF((char *)NULL_FILE);
}

////////////////////////////////////////////////////////////////////////////////
// mp3;

void MediaEngineOperationTest::Play_mp3()
{
   RETURN_ON_MEDIAENGINE_OFF
   traces("MediaEngineOperationTest");

   tPath fileName;

   CreateMp3FileName(fileName);
   Play(fileName);
}

void MediaEngineOperationTest::Buffer_mp3()
{
   RETURN_ON_MEDIAENGINE_OFF
   traces("MediaEngineOperationTest");

   tPath fileName;

   CreateMp3FileName(fileName);
   Buffer(fileName);
}

void MediaEngineOperationTest::Pause_mp3()
{
   RETURN_ON_MEDIAENGINE_OFF
   traces("MediaEngineOperationTest");

   tPath fileName;

   CreateMp3FileName(fileName);
   Pause(fileName);
}

void MediaEngineOperationTest::FRev_mp3()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   tPath fileName;

   CreateMp3FileName(fileName);
   FRev(fileName);
}

void MediaEngineOperationTest::FF_mp3()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");
   tPath fileName;

   CreateMp3FileName(fileName);
   FF(fileName);
}

////////////////////////////////////////////////////////////////////////////////
// test operators;

void MediaEngineOperationTest::PrepareAVTests()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   #if !defined(TARGET_BUILD) // run in ubuntu
      std::string basepath0(get_current_dir_name());
      int pos = basepath0.find(string("ai_mediaplayer"));
      std::string basepath1(basepath0, 0, pos + 14);
      strncpy_r(OUT mTestFilesPath, IN basepath1.c_str(), IN sizeof(mTestFilesPath));
      strncat_r(OUT mTestFilesPath, IN "/components/Customer/Simulation/CustomControl/test", IN sizeof(mTestFilesPath));
   #else // run in target with data stored in view
      strncpy_r(OUT mTestFilesPath, IN "/opt/bosch/test/data/GMP/test", IN sizeof(mTestFilesPath));
   #endif
}

void MediaEngineOperationTest::CreateMp3FileName(tPath fileName)
{
	traces("MediaEngineOperationTest");	
   strncpy_r(OUT fileName, IN mTestFilesPath, IN sizeof(tPath));
   // strncat_r(OUT fileName, IN "/Garbage-Garbage-01-Supervixen.MP3", IN sizeof(tPath));
   strncat_r(OUT fileName, IN "/music/Grönemeyer_-_Anders/Herbert_Grönemeyer_-_Bleibt_Alles_Anders.mp3", IN sizeof(tPath));

   me::trace("MediaEngineOperationTest:CreateMp3FileName:", fileName);
}

void MediaEngineOperationTest::SwitchObserver()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   tResult res = MP_NO_ERROR;

   /* switch the observer */
   rrTest rrSwitchObserver;
   rrSwitchObserver.expectedState = 1;
   rrSwitchObserver.expectedType  = RR_RESULT_SWITCH_OBSERVER;

   me::state_t m_DefaultPEState;
   //memset(&m_DefaultPEState, 0, sizeof(m_DefaultPEState));

   res = rrSwitchObserver.DoEventAnswer("MediaEngineSM::SWITCH_OBSERVER", "TestStateMachine", NULL, 10000);
   CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaEngineOperationTest::Play(char *url)
{
   RETURN_ON_MEDIAENGINE_OFF
   traces("MediaEngineOperationTest");

   tResult res = MP_NO_ERROR;

   /* start play */
   rrTest rrPlay;
   rrPlay.expectedState = PE_PBS_PLAYINGSTATE;
   rrPlay.expectedType  = RR_RESULT_NORMAL;

   me::state_t m_DefaultPEState;
   //memset(&m_DefaultPEState, 0, sizeof(m_DefaultPEState));

   tPEStateString args;
   SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", url, 1 /* speed */, -1 /* position */, HANDLE_NONE, m_DefaultPEState.dev().at());
   res = rrPlay.DoEventAnswer("MediaEngineSM::PLAY", args, NULL, 10000);
   CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaEngineOperationTest::Buffer(char *url)
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   tResult res = MP_NO_ERROR;

   /* start buffer */
   rrTest rrBuffer;
   rrBuffer.expectedState = SC_YES;
   rrBuffer.expectedType  = RR_RESULT_BUFFER;

   res = rrBuffer.DoEventAnswer("MediaEngineSM::BUFFER", url, NULL, 10000);
   CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaEngineOperationTest::Flush()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   tResult res = MP_NO_ERROR;

   /* start flush */
   rrTest rrFlush;
   rrFlush.expectedState = PE_PBS_UNKNOWN;
   rrFlush.expectedType  = RR_RESULT_NORMAL;

   res = rrFlush.DoEventAnswer("MediaEngineSM::FLUSH", NULL, NULL, 10000);
   CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaEngineOperationTest::Pause(char *url)
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   tResult res = MP_NO_ERROR;

   rrTest rrPause;
   rrPause.expectedState = PE_PBS_PAUSEDSTATE;
   rrPause.expectedType  = RR_RESULT_NORMAL;

   tPEStateString args;
   SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiil", url, 0, 0, HANDLE_NONE);
   res = rrPause.DoEventAnswer("MediaEngineSM::PAUSE", args, NULL, 10000);
   CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaEngineOperationTest::Stop()
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   tResult res = MP_NO_ERROR;

	rrTest rrStop;
   rrStop.expectedState = PE_PBS_STOPPEDSTATE;
   rrStop.expectedType  = RR_RESULT_NORMAL;

   res = rrStop.DoEventAnswer("MediaEngineSM::STOP", NULL, NULL, 10000);
   CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaEngineOperationTest::FF(char *url)
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   tResult res = MP_NO_ERROR;

   rrTest rrFF;
   rrFF.expectedState = PE_PBS_PLAYINGSTATE;
   rrFF.expectedType  = RR_RESULT_NORMAL;

   me::state_t m_DefaultPEState;
   //memset(&m_DefaultPEState, 0, sizeof(m_DefaultPEState));

   tPEStateString args;
   SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", url, +5 /* speed */, -1 /* position */, HANDLE_NONE, m_DefaultPEState.dev().at());
   res = rrFF.DoEventAnswer("MediaEngineSM::PLAY", args, NULL, 10000);
   CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaEngineOperationTest::FRev(char *url)
{
   RETURN_ON_MEDIAENGINE_OFF
	traces("MediaEngineOperationTest");

   tResult res = MP_NO_ERROR;

   rrTest rrFRev;
   rrFRev.expectedState = PE_PBS_PLAYINGSTATE;
   rrFRev.expectedType  = RR_RESULT_NORMAL;

   me::state_t m_DefaultPEState;
   //memset(&m_DefaultPEState, 0, sizeof(m_DefaultPEState));

   tPEStateString args;
   SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", url, -5  /* speed */, -1 /* position */, HANDLE_NONE, m_DefaultPEState.dev().at());
   res = rrFRev.DoEventAnswer("MediaEngineSM::PLAY", args, NULL, 10000);
   CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

////////////////////////////////////////////////////////////////////////////////
