/* -------------------------------------------------------------------------- */
/**
 *   @defgroup meengine mecodec_wma.hpp
 *   @ingroup  MEngine
 *   @author   Stephan Pieper, 2013
 *
 *   WMA streaming codec.
 */
/* -------------------------------------------------------------------------- */

#if !defined(ME_CODEC_WMA_HPP_INCLUDED)
#define ME_CODEC_WMA_HPP_INCLUDED

/* -------------------------------------------------------------------------- */

#include "1_common/mebase.hpp"

/* -------------------------------------------------------------------------- */

namespace me {

/* -------------------------------------------------------------------------- */

struct codec_wma_t : public codec_t,
                     public single_t<codec_wma_t> {

   /* ----------------------------------------------------------------------- */

   friend class single_t<codec_wma_t>;

   /* ----------------------------------------------------------------------- */

   virtual strings_t onexts() const {
      trace("codec_wma:onexts()");
      static strings_t fts;
      if(fts.empty()) {
         //fts.append(string_t("wma"));
      }
      return fts;
   }

   virtual int_t onisaudio(string_t const &ext0) const {
      if(0 == onexts().find_f(ext0)) return -1;
      return 1; // file extension *.wma always supports audio;
   }
   virtual int_t onisvideo(string_t const &ext0) const {
      if(0 == onexts().find_f(ext0)) return -1;
      return 0; // file extension *.wma never supports video;
   }

   /* ----------------------------------------------------------------------- */

   codec_wma_t() {

       pump = true;
   }

   /* ----------------------------------------------------------------------- */

   virtual void_t oninit() {
      trace("me:codec_wma:oninit");
   }
   virtual void_t mainloop() {
     trace("me:codec_wma:mainloop");
   }
   virtual void_t onfini() {
      trace("me:codec_wma:onfini");
   }

   /* ----------------------------------------------------------------------- */

   virtual int_t onctrl(state_t const &state) {

      playstate_e const ps = state.playstate;

      trace("me:codec_wma:onctrl:", estr2(ps));

      // sim4hi 180629: inserted the following code as fix for Coverity CID-184522
      trace("me:codec_wma:onctrl:exit");
      // sim4hi 180629: inserted return 1; as codec_wma_t seems not to be implemented like codec_null_t
      return 1;
   }

   /* ----------------------------------------------------------------------- */

   virtual int_t read(file_t &file, int_t const& space, buffer_t &buf) {

      trace("me:codec_wma:read:buf:", buf.str());
      thr_t::wait(1000);
      return 0;
   }
   virtual int_t write(buffer_t const &buf) {

      trace("me:codec_wma:write:buf:", buf.str());
      thr_t::wait(1000);
      return 0;
   }

   /* ----------------------------------------------------------------------- */
};

/* -------------------------------------------------------------------------- */

#ifdef __cplusplus
   extern "C" {
#endif

codec_t *instance() {
   return &codec_wma_t::inst();
}

#ifdef __cplusplus
   }
#endif

/* -------------------------------------------------------------------------- */

} // me;

/* -------------------------------------------------------------------------- */

#include "1_common/mecodecif.hpp"

/* -------------------------------------------------------------------------- */

 #endif // ME_CODEC_WMA_HPP_INCLUDED

/* -------------------------------------------------------------------------- */
