/* -------------------------------------------------------------------------- */
/**
 *   @defgroup meengine mecodec_v4l.hpp
 *   @ingroup  MEngine
 *   @author   Vignesh Kumar, 2017
 *
 *   V4L streaming codec.
 */
/* -------------------------------------------------------------------------- */

#if !defined(ME_CODEC_V4L_HPP_INCLUDED)
#define ME_CODEC_V4L_HPP_INCLUDED

/* -------------------------------------------------------------------------- */

#include "1_common/megstcodec.hpp"

/* Added for feature 16015 - Internal DVD support*/
#include <linux/videodev2.h>
#include <linux/v4l2-controls.h>
#include <sys/ioctl.h>
/* end of 16015 - Internal DVD support*/

/* -------------------------------------------------------------------------- */

namespace me {

/* -------------------------------------------------------------------------- */

struct codec_v4l_t : public gstcodec_t,
                     public single_t<codec_v4l_t> {

   /* ----------------------------------------------------------------------- */

   friend class single_t<codec_v4l_t>;

   /* ----------------------------------------------------------------------- */

   virtual strings_t onexts() const {
      trace("codec_v4l:onexts()");
      static strings_t fts;
      if(fts.empty()) {
         fts.append(string_t("dvd"));
         fts.append(string_t("cdda"));
      }
      return fts;
   }

   virtual int_t onisaudio(string_t const &ext0) const {
      strings_t const exts = onexts();
      if(0 == exts.find_f(ext0)) return -1;
      trace("codec_v4l:onisaudio:found ext id : ",exts.id(exts.find_f(ext0)));
      return 1 == exts.id(exts.find_f(ext0)) ? 1 : 0;
   }

   virtual int_t onisvideo(string_t const &ext0) const {
      strings_t const exts = onexts();
      if(0 == exts.find_f(ext0)) return -1;
      trace("codec_v4l:onisvideo:found ext id : ",exts.id(exts.find_f(ext0)));
      return exts.id(exts.find_f(ext0)) >= 0 ? 1 : 0;
   }

   /* ----------------------------------------------------------------------- */

   codec_v4l_t() : loop(0), line(0), v4lsrc(0), sink(0), v4lcsc(0), vqueue(0) {

      pump = false;
   }

   /* ----------------------------------------------------------------------- */

   virtual void_t oninit() {

      trace("me:codec_v4l:oninit");

      /* -------------------------------------------------------------------- */
       /*gst_init() call is moved to mediaengineserver::init  to avoid the multiple calls to platform  
         Fix for NCG3D-118451*/
      // setup pipeline;

      // mainloop;
      loop = g_main_loop_new(0, false); asrt(NULL != loop);

      // pipeline;
      line = gst_pipeline_new("line"); asrt(NULL != line);

      trace("me:codec_v4l:oninit:pipeline");

      // elements;
      v4lsrc = gst_element_factory_make("mfw_v4lsrc", "v4lsrc"); asrt(NULL != v4lsrc);
      if(0 == v4lsrc) {
              trace("me:codec_v4l:oninit:new:mfw_v4lsrc:failed");
      }

      sink = gst_element_factory_make("gst_apx_sink", "video sink" ); asrt(NULL != sink);
      if(0 == sink) {
         trace("me:codec_v4l:oninit:new:gst_apx_sink:failed");
      }

      /* -------------------------------------------------------------------- */
      // add and link;

      gst_bin_add_many(GST_BIN(line), v4lsrc, sink, NULL);
      gst_element_link_many(v4lsrc, sink, NULL);

      /* -------------------------------------------------------------------- */
      // callbacks;

      GstBus *bus = gst_pipeline_get_bus(GST_PIPELINE(line));
      gst_bus_add_watch(bus, cb_bus_call, this);
#if defined (ENABLE_GSTREAMER_1_0)
      gst_bus_set_sync_handler(bus, cb_bus_sync, this ,NULL);//gst_bus_set_sync_handler(bus, cb_bus_sync, this) is modified to gst_bus_set_sync_handler(bus, cb_bus_sync, this, NULL)
#else
      gst_bus_set_sync_handler(bus, cb_bus_sync, this);
#endif
      gst_object_unref(bus);

      /* -------------------------------------------------------------------- */

      trace("me:codec_v4l:oninit:finished");
   }

   /* ----------------------------------------------------------------------- */

   virtual void_t mainloop() {

      /* -------------------------------------------------------------------- */

      trace("me:codec_v4l:mainloop");

      if(NULL != loop)
      {  
         g_main_loop_run(loop); // main routine;
      }

      trace("me:codec_v4l:mainloop:finished");

      /* -------------------------------------------------------------------- */

      GstBus *bus = gst_pipeline_get_bus(GST_PIPELINE(line));
#if defined (ENABLE_GSTREAMER_1_0)
      gst_bus_set_sync_handler(bus, 0, 0, NULL);//gst_bus_set_sync_handler(bus, 0, 0) is modified tp gst_bus_set_sync_handler(bus, 0, 0, NULL)
#else
      gst_bus_set_sync_handler(bus, 0, 0);
#endif
      gst_object_unref(bus);

      /* -------------------------------------------------------------------- */

      GstStateChangeReturn res = gst_element_set_state(line, GST_STATE_NULL);

      trace("me:codec_v4l:mainloop:GST_STATE_NULL:res:", res);

      /* -------------------------------------------------------------------- */
      // handle async statechange;

      int_t seconds = 0;
      while(GST_STATE_CHANGE_ASYNC == res) {

         GstState st0, st1;
         st1 = st0 = GST_STATE_NULL;
         GstClockTime const timeout = 1000000000ull; // nanoseconds (1 second);

         trace("me:codec_v4l:state:async:wait:", (int_t)timeout);

         res = gst_element_get_state(line, &st0, &st1, timeout);

         trace("me:codec_v4l:state:async:", st0, " -> ", st1, " res:", res);

         if(GST_STATE_CHANGE_ASYNC == res) {

            trace("me:codec_v4l:state:still:async:seconds:", ++seconds);
         }
      }

      /* -------------------------------------------------------------------- */
      // cleanup;

      if(v4lcsc)
      {
         gst_element_unlink_many((GstElement*)v4lsrc, (GstElement*)v4lcsc, (GstElement*)vqueue, sink, NULL);
      }
      else
      {
         gst_element_unlink_many((GstElement*)v4lsrc, sink, NULL);
      }

      if(line) {
         gst_object_unref(line);
         v4lcsc = v4lsrc = vqueue = sink = line = NULL;
      }
      if(loop) {
         g_main_loop_unref(loop);
         loop = NULL;
      }
   }

   /* ----------------------------------------------------------------------- */

   virtual void_t onfini() {

      trace("me:codec_v4l:onfini");

      if(loop) {

         trace("me:codec_v4l:onfini:mainloop:quit");

         g_main_loop_quit(loop);
      }

      trace("me:codec_v4l:onfini:gst:deinit");
      //gst_deinit();
   }

   /* ----------------------------------------------------------------------- */

   virtual int_t onctrl(state_t const &state) {

      playstate_e const ps = state.playstate;

      trace("me:codec_v4l:onctrl:", estr2(ps));

      /* -------------------------------------------------------------------- */

      int_t const res = gstcodec_t::configlog(state.logconfig);

      trace("me:codec_v4l:onctrl:configlog:res:", res);

      /* -------------------------------------------------------------------- */

      switch(ps) {
         case PLAYSTATE_STOP:
            gst_element_set_state(line, GST_STATE_NULL);
            break;
         case PLAYSTATE_PAUSE:
            gst_element_set_state(line, GST_STATE_PAUSED);
            break;
         case PLAYSTATE_PLAY: {

            /* -------------------------------------------------------------------- */

            GstState st0 = GST_STATE_NULL;
            gst_element_get_state(line, &st0, 0, GST_CLOCK_TIME_NONE);
            if(GST_STATE_PLAYING == st0) {
               gst_element_set_state(line, GST_STATE_NULL);
            }

            /* -------------------------------------------------------------- */
            // url -> input device;

            string_t url = in.url; // e.g.: url=/dev/video2.dvd
            string_t ext = url.ext();

            trace("codec_v4l:onctrl:play:extension:",ext);

            if((!onisaudio(ext)) && (0 == v4lcsc)) {

             v4lcsc = gst_element_factory_make("v4l_csc", "v4lcsc");
             if(v4lcsc) {

                 trace("codec_v4l:onctrl:play:creating v4lcsc");
                 /* set all the video properties of the current video object*/
                 g_object_set(G_OBJECT(v4lcsc),        "brightness", (gint)out.vprops().brightness(),       NULL);
                 g_object_set(G_OBJECT(v4lcsc),               "hue", (gint)out.vprops().hue(),              NULL);
                 g_object_set(G_OBJECT(v4lcsc),        "saturation", (gint)out.vprops().saturation(),       NULL);
                 g_object_set(G_OBJECT(v4lcsc),          "contrast", (gint)out.vprops().contrast(),         NULL);
                 g_object_set(G_OBJECT(v4lcsc), "brightness-offset", (gint)out.vprops().brightnessoffset(), NULL);
                 g_object_set(G_OBJECT(v4lcsc), "saturation-offset", (gint)out.vprops().saturationoffset(), NULL);
                 g_object_set(G_OBJECT(v4lcsc),        "hue-offset", (gint)out.vprops().hueoffset(),        NULL);

                 gchar  videosource[] = "/sys/class/video4linux/video";
                 for(int count = 0; count <= 4 ; count++)
                 {
                    gchar devicepath[80]= {0};
                    snprintf(devicepath, sizeof(devicepath), "%s%d/name",videosource,count);
                    FILE* fp = NULL;
                    fp = fopen(devicepath, "r");
                    if(0 != fp)
                    {
                        string_t videodevicename;
                        fgets(videodevicename.at(0), 30, fp);
                        videodevicename = videodevicename.at(0);
                        trace("video device name: ", videodevicename);
                        fclose(fp);
                        int_t res = 0;
                        res = videodevicename.contains(video_memory_mapping_device);
                        if (0 == res)
                        {
                            gchar devicename [30]={0};
                            snprintf(devicename, sizeof(devicename), "%s%d",v4l_device_node,count);
                            trace("me:codec_v4l:onctrl:play:devicename:",devicename);
                            g_object_set(G_OBJECT(v4lcsc), "devicename", devicename, NULL);
                            break;
                        }
                    }
                    else{
                       break;
                    }
                 }

                 if(0 == vqueue) {
                      vqueue = gst_element_factory_make("queue",  "video queue");
                 }

                 gst_bin_add_many(GST_BIN(line), v4lcsc, vqueue, (GstElement*)NULL);
                 gst_element_unlink_many((GstElement*)v4lsrc, sink, NULL);
                 gst_element_link_many(v4lsrc, v4lcsc, vqueue, sink, NULL);
             }

            }
            /* -------------------------------------------------------------- */

            string_t dev = url.upto(url.find_f('.') - 1);

            trace("me:codec_v4l:onctrl:play:url:", url, " input:device:", dev);

            g_object_set(v4lsrc, "device", dev.at(), NULL);

            /* -------------------------------------------------------------- */

            int_t fd = -1;
            fd = open(dev.at(), O_RDONLY);

            if(-1 != fd) {
                struct v4l2_input vin;
                string_t input = out.v4lprop().v4linput;
                trace("me:codec_v4l:onctrl:play:input:", input);
                memset(&vin, 0, sizeof(v4l2_input));
                for (int_t index = 0; index <= max_v4l_input; index++ )
                {
                    vin.index = index;
                    if (ioctl(fd, VIDIOC_ENUMINPUT, &vin) < 0) {
                        trace("me:codec_v4l:onctrl:play:input:failed to read VIDIOC_ENUMINPUT with errno: ",errno);
                    }
                    else {
                        if (0 == strcmp(input.at(), reinterpret_cast<char*>(vin.name))) {
                            trace("me:codec_v4l:onctrl:play:input channel found: ", vin.index);
                            g_object_set(v4lsrc, "input", (gint)vin.index, NULL);
                            g_object_set(v4lsrc, "stream-good-buf-only", (gboolean)1, NULL);

                            if(-1 != out.v4lprop().capturewidth()) {
                                g_object_set(v4lsrc, "capture-width", (gint)out.v4lprop().capturewidth(), NULL);
                            }

                            if(-1 != out.v4lprop().captureheight()) {
                                g_object_set(v4lsrc, "capture-height", (gint)out.v4lprop().captureheight(), NULL);
                            }

                            if(-1 != out.v4lprop().fpsnumerator()) {
                                g_object_set(v4lsrc, "fps-n", (gint)out.v4lprop().fpsnumerator(), NULL);
                            }

                            if(-1 != out.v4lprop().fpsdenominator()) {
                                g_object_set(v4lsrc, "fps-d", (gint)out.v4lprop().fpsdenominator(), NULL);
                            }

                            if(-1 != out.v4lprop().motion()) {
                                g_object_set(v4lsrc, "motion", (gint)out.v4lprop().motion(), NULL);
                            }

                            if(10 > out.v4lprop().pixformat()) {
                                g_object_set(v4lsrc, "pix-fmt", (unsigned int)out.v4lprop().pixformat(), NULL);
                            }
                            break;
                        }
                    }
                }

                /* -------------------------------------------------------------- */
                // video sink;

                screen_t const& screen0 = out.display().screens()[0];
                trace("pe:codec_v4l:onctrl:play:apx:sink:", screen0.str(), " numscreens:", out.display().screens().size());

                g_object_set(G_OBJECT(sink), "display-width",  screen0.rsl().width(), NULL);
                g_object_set(G_OBJECT(sink), "display-height", screen0.rsl().height(), NULL);
                g_object_set(G_OBJECT(sink), "layer-id",       screen0.layer(), NULL);
                g_object_set(G_OBJECT(sink), "surface-id",     screen0.srf(), NULL);

                /* ----------------------------------------------------------- */
               // if(0 == vin.status) {
                    gst_element_set_state(line, GST_STATE_PLAYING);
                //}
                close(fd);
            }
            else
            {
                trace("pe:codec_v4l:onctrl:play: fail to open v4l device:",dev);
            }

            /* -------------------------------------------------------------- */

            break;
         }
         case PLAYSTATE_SET: {

             if(v4lcsc) {
                 /* set all the video properties of the current video object*/
                 g_object_set(G_OBJECT(v4lcsc), "brightness",  (gint)out.vprops().brightness(), NULL);
                 g_object_set(G_OBJECT(v4lcsc), "hue", (gint)out.vprops().hue(), NULL);
                 g_object_set(G_OBJECT(v4lcsc), "saturation", (gint)out.vprops().saturation(), NULL);
                 g_object_set(G_OBJECT(v4lcsc), "contrast", (gint)out.vprops().contrast(), NULL);
                 g_object_set(G_OBJECT(v4lcsc), "brightness-offset", (gint)out.vprops().brightnessoffset(), NULL);
                 g_object_set(G_OBJECT(v4lcsc), "saturation-offset", (gint)out.vprops().saturationoffset(), NULL);
                 g_object_set(G_OBJECT(v4lcsc), "hue-offset", (gint)out.vprops().hueoffset(), NULL);

             }
         }
         default:break;
      }
      if(PLAYSTATE_SET != ps)
      {
          trace("me:codec_v4l:onctrl:pos:", in.pos().str());

          GstState st0, st1;
          st1 = st0 = GST_STATE_NULL;
          GstClockTime const timeout = 1000000000ull; // nanoseconds (1 second);
          gst_element_get_state(line, &st0, &st1, timeout);

          trace("me:codec_v4l:onctrl:st0:", st0, " st:", st1);
      }

      return 0;
   }

   /* ----------------------------------------------------------------------- */

   static gboolean cb_bus_call(GstBus *bus, GstMessage *msg, gpointer that) {

      trace("me:codec_v4l:cb_bus_call");

      asrt(NULL != that);
      codec_v4l_t &codec = *(codec_v4l_t*)that;

      GstMessageType const type = GST_MESSAGE_TYPE(msg);

      trace("me:codec_v4l:cb_bus_call:type:", gst_message_type_get_name(type));

      switch(type) {
         case GST_MESSAGE_STATE_CHANGED: {

            GstState state0, state1;
            gst_message_parse_state_changed(msg, &state0, &state1, 0);

            trace("me:codec_v4l:cb_bus_call:", GST_OBJECT_NAME(msg->src),
                                          " state:", gst_element_state_get_name(state0),
                                             " -> ", gst_element_state_get_name(state1));
            break;
         }
         case GST_MESSAGE_STREAM_STATUS: {

            GstStreamStatusType status;
            gst_message_parse_stream_status(msg, &status, 0);

            trace("me:codec_v4l:cb_bus_call:", GST_OBJECT_NAME(msg->src), " status:", status, ":", streamstatus(status));
            break;
         }
         case GST_MESSAGE_INFO: {

            GError *info = 0;
            gchar  *txt  = 0;
            gst_message_parse_info(msg, &info, &txt);
            gchar  *str  = gst_error_get_message(info->domain, info->code);

            trace("me:codec_v4l:cb_bus_call:INFO:element:name:", GST_OBJECT_NAME(msg->src));
            trace("me:codec_v4l:cb_bus_call:msg0:", info->message);
            trace("me:codec_v4l:cb_bus_call:msg1:", (str ? str : "none"));
            trace("me:codec_v4l:cb_bus_call:msg2:", (txt ? txt : "none"));

            g_error_free(info);
            g_free(str);
            g_free(txt);
            break;
         }
         case GST_MESSAGE_WARNING: {

            GError *warntxt = 0;
            gchar  *txt  = 0;
            gst_message_parse_warning(msg, &warntxt, &txt);
            gchar  *str  = gst_error_get_message(warntxt->domain, warntxt->code);

            trace("me:codec_v4l:cb_bus_call:WARN:element:name:", GST_OBJECT_NAME(msg->src));
            trace("me:codec_v4l:cb_bus_call:msg0:", warntxt->message);
            trace("me:codec_v4l:cb_bus_call:msg1:", (str ? str : "none"));
            trace("me:codec_v4l:cb_bus_call:msg2:", (txt ? txt : "none"));

            g_error_free(warntxt);
            g_free(str);
            g_free(txt);
            break;
         }
         case GST_MESSAGE_ERROR: {

            GError *error = 0;
            gchar  *txt   = 0;
            gst_message_parse_error(msg, &error, &txt);
            gchar  *str   = gst_error_get_message(error->domain, error->code);

            trace("me:codec_v4l:cb_bus_call:ERR:element:name:", GST_OBJECT_NAME(msg->src), " domain:", gstdomain(error->domain), " code:", error->code);
            trace("me:codec_v4l:cb_bus_call:msg0:", error->message);
            trace("me:codec_v4l:cb_bus_call:msg1:", (str ? str : "none"));
            trace("me:codec_v4l:cb_bus_call:msg2:", (txt ? txt : "none"));

            if(GST_RESOURCE_ERROR == error->domain &&
               GST_RESOURCE_ERROR_OPEN_WRITE == error->code) {

               codec.out.reason = REASON_DEVICE_ERROR;
               codec.forward(codec.out); // signal owner;
            }
            g_error_free(error);
            g_free(str);
            g_free(txt);
            break;
         }
         default: break;
      }
      return true;
   }

   /* ----------------------------------------------------------------------- */

   GMainLoop  *loop;
   // pipeline;
   GstElement *line, *v4lsrc, *sink, *v4lcsc, *vqueue;

   const int max_v4l_input = 5;

   const char* v4l_device_node = "/dev/video";

   string_t video_memory_mapping_device = "m2m";
   /* ----------------------------------------------------------------------- */
};

/* -------------------------------------------------------------------------- */

#ifdef __cplusplus
   extern "C" {
#endif

codec_t *instance() {
   return &codec_v4l_t::inst();
}

#ifdef __cplusplus
   }
#endif

/* -------------------------------------------------------------------------- */

} // me;

/* -------------------------------------------------------------------------- */

#include "1_common/mecodecif.hpp"

/* -------------------------------------------------------------------------- */

 #endif // ME_CODEC_v4l_HPP_INCLUDED

/* -------------------------------------------------------------------------- */
