/* -------------------------------------------------------------------------- */
/*
 * MediaEngineMain.cpp
 *
 *  Created on: Mar 25, 2014
 *      Author: thm3hi
 */
/* -------------------------------------------------------------------------- */

#include <unistd.h>
#include <signal.h>
#include <semaphore.h>


/* -------------------------------------------------------------------------- */

#include "BaseTypes.h"
#include "MediaEngineServerIF.h"
#include "1_common/metrace.hpp"

/* -------------------------------------------------------------------------- */

//extern "C" tBool exh_bInitExceptionHandling(void);
extern "C" void OSAL_trace_callstack(tBool);

/* -------------------------------------------------------------------------- */

#ifdef TARGET_BUILD

   static void_t CatchSEGVforMediaEngine(int_t sig, int_t pid, int_t uid) {

      me::trace("server:signal_cb:sig:", estr2((signal_e)sig), " pid:", pid, " uid:", uid);

      // trace callstack;
      //NORMAL_M_ASSERT_ALWAYS();
      OSAL_trace_callstack(1);

      // end process;
      _exit(0);
   }

#endif

/* -------------------------------------------------------------------------- */

int main(int argc, char **argv)
{
   me::traces("main:enter");

   org_t::inst().save(argc, argv);

   #ifdef TARGET_BUILD

      // open trace channel;
      et_vTraceOpen();

      /* -------------------------------------------------------------------- */
      // register for signals;

      //#define MEDIAENGINE_INSTALL_SIGNALHANDLER
      #if defined(MEDIAENGINE_INSTALL_SIGNALHANDLER)

         me::trace("main:signals:install");

         signal_t &sig = signal_t::inst();

         int_t const res = sig.reg(M1_SIGSEGV, CatchSEGVforMediaEngine) ||
                           sig.reg(M1_SIGABRT, CatchSEGVforMediaEngine);

         me::trace("main:signals:", 0 == res ? "good" : "bad");
      #endif

   #endif

    for(int_t i = 0; i < argc; ++i) {

      me::trace("main:run:arg:", i, ":", argv[i]);
   }

   // run media engine:
   RunMediaEngine();

   me::trace("main:exit");

   // end process;
   #ifndef TARGET_BUILD
      return 0;
   #else
      _exit(1);
   #endif
}

/* -------------------------------------------------------------------------- */
