/* ----------------------------------------------------------------------- */
/*
 * MediaEngineServer.cpp
 *
 *  Created on: Mar 25, 2014
 *      Author: thm3hi
 */
/* ----------------------------------------------------------------------- */

#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
#ifndef _MEDIAENGINE_ROOTDAEMON_CLIENT_H_
#include "MediaEngine_rootdaemon_client.h"
#endif
#else
#include "3_server/rootdaemon/merdclient.hpp"
#endif

#if defined(TARGET_BUILD)
   #include "1_common/meterminal.hpp"
#endif

/* ----------------------------------------------------------------------- */

#include "MediaEngineServer.h"
#include "MediaEngineRipper.h"

#include "generated/MediaEngineSM.h"
#include "gst/gst.h"
/* ----------------------------------------------------------------------- */

MediaEngineRipper MediaEngineripper;
extern ThreadFactory ThreadFactory;

/* ----------------------------------------------------------------------- */

#if defined(TARGET_BUILD)

   static void_t terminal(byte_t* data, void_t *that) {

      if(0 == that) {
         me::trace("server:terminal:that:0");
         return;
      }

      MediaEngineServer& mes = *(MediaEngineServer*)that;

       //log_t logger("/var/opt/bosch/dynamic/media/me.txt");
      //logger.open();
      //logger.writel("test");
      //logger.writel("test");

      if(0 == data) {
         me::trace("server:terminal:data:0");
         return;
      }

      // byte 0 = length;
      int_t const length = data[0];

      string_t str;
      for(int_t i = 1; i <= length; ++i) {
         str << (int_t)data[i] << " ";
      }
      me::trace("server:terminal:input:", str.at());

      int_t const has_command = (0 < length);

      if(false == has_command) {

         me::trace("server:terminal:command:0");
         return;
      }
      if(me::TERMCMD_LAST <= data[1]) {

         me::trace("server:terminal:cmd:", data[1], " invalid");
         return;
      }

      me::termcmd_e const cmd = (me::termcmd_e)data[1];

      me::trace("server:terminal:length:", length, " cmd:", me::estr2(cmd));

      static me::logconfig_t lc;

      switch(cmd) {
         case me::TERMCMD_HELP: {
            me::trace("server:terminal:help:------------------------------------------------------------");
            for(int_t i = 0; i < me::TERMCMD_LAST; ++i) {
               string_t line("cmd:", me::estr2((termcmd_e)i).pad(21), " ");
               switch(i) {
                  case me::TERMCMD_GST_LOG_OFF:         line << "                  - Dectivate gst logging"; break;
                  case me::TERMCMD_GST_LOG_ON:          line << "                  - Activate gst logging"; break;
                  case me::TERMCMD_GST_LOG_LS:          line << "                  - List gst log patterns"; break;
                  case me::TERMCMD_GST_LOG_CLR:         line << "                  - Clear gst log patterns"; break;
                  case me::TERMCMD_GST_LOG_LVL:         line << "<level>           - Set gst default log level"; break;
                  case me::TERMCMD_GST_LOG_RM:          line << "<id>              - Remove gst log pattern by id"; break;
                  case me::TERMCMD_GST_LOG_ADD:         line << "<level> <pattern> - Set gst log level for pattern"; break;
                  case me::TERMCMD_GST_LOG_FILE_TOGGLE: line << "                  - Activate gst file logging"; break;
                  case me::TERMCMD_GST_LOG_FILE_URL:    line << "<url>             - Set url for gst file logging"; break;
                  case me::TERMCMD_GST_LOG_FILE_LIMIT:  line << "<limit>           - Set file size limit for gst logfile"; break;
               }
               me::trace("server:terminal:help:", line);
            }
            me::trace("server:terminal:help:------------------------------------------------------------");
            break;
         }
         case me::TERMCMD_GST_LOG_ON: {
            lc.tog = me::TOGGLE_ON;
            me::trace("server:terminal:tog:", me::estr2(lc.tog));
            break;
         }
         case me::TERMCMD_GST_LOG_OFF: {
            lc.tog = me::TOGGLE_OFF;
            me::trace("server:terminal:tog:", me::estr2(lc.tog));
            break;
         }
         case me::TERMCMD_GST_LOG_LS: {
            break;
         }
         case me::TERMCMD_GST_LOG_CLR: {
            lc.pats().clear();
            break;
         }
         case me::TERMCMD_GST_LOG_LVL: {
            if(2 != length) {
               me::trace("server:terminal:lvl:length:", length, " missing level value");
               break;
            }
            lc.lvl = data[2];
            break;
         }
         case me::TERMCMD_GST_LOG_RM: {
            if(length < 2) {
               me::trace("server:terminal:rm:length:", length, " missing pattern id");
               break;
            }
            int_t const id = data[2];
            if(id < 0 || lc.pats().size() <= id) {
               me::trace("server:terminal:rm:id:", id, " invalid");
               break;
            }
            auto pats = lc.pats;
            auto dels = lc.dels;
            // add pats[id] to dels if not existing
            // and enough space in fixed array
            // and remove it from pats;
            auto p = dels().find_f(pats()[id]);
            if(p) {
               me::trace("server:terminal:rm:dels:", pats()[id].str(), " already removed");
               pats().remove(id);
            } else {
               dels().append(pats()[id]);
               pats().remove(id);
            }
            lc.pats() = pats;
            lc.dels() = dels;
            break;
         }
         case me::TERMCMD_GST_LOG_ADD: {
            me::logpattern_t logpat;
            logpat().lvl   =  data[2];
            logpat().pat() = &data[3];
            auto pats = lc.pats;
            auto dels = lc.dels;
            // remove logpat from dels if existing
            // or add to pats if enough space and not double;
            auto d = dels().find_f(logpat);
            if(d) {
               me::trace("server:terminal:add:dels:", logpat().str(), " already added");
               dels().remove(d);
            } else {
               auto p = pats().find_f(logpat);
               if(p) {
                  me::trace("server:terminal:add:pats:", logpat().str(), " already added");
               } else {
                  pats().append(logpat);
               }
            }
            lc.pats() = pats;
            lc.dels() = dels;
            break;
         }
         case me::TERMCMD_GST_LOG_FILE_TOGGLE: {
            int_t const tog = data[2];
            me::trace("server:terminal:file:toggle:", tog);
            lc.file().tog = (me::toggle_e)tog;
            break;
         }
         case me::TERMCMD_GST_LOG_FILE_URL: {
            string_t const url = data[2];
            me::trace("server:terminal:file:url:", url);
            lc.file().url = url;
            break;
         }
         case me::TERMCMD_GST_LOG_FILE_LIMIT: {
            int_t const limit = data[2];
            me::trace("server:terminal:file:limit:", limit);
            lc.file().limit = limit;
            break;
         }
         default: {
            me::trace("server:terminal:cmd:", me::estr2(cmd));
            break;
         }
      }

      me::trace("server:terminal:logconfig:----------------------------------------", me::estr2(lc.tog));
      me::trace("server:terminal:logconfig:toggle:", me::estr2(lc.tog));
      me::trace("server:terminal:logconfig:level:", me::estr2((gstlevel_e)lc.lvl()));
      for(int_t i = 0; i < lc.pats().size(); ++i) {
         me::trace("server:terminal:logconfig:pats[", i, "]:", lc.pats()[i].str());
      }
      if(0 == lc.pats().size()) {
         me::trace("server:terminal:logconfig:pats:empty");
      }
      for(int_t i = 0; i < lc.dels().size(); ++i) {
         me::trace("server:terminal:logconfig:dels[", i, "]:", lc.dels()[i].str());
      }
      if(0 == lc.dels().size()) {
         me::trace("server:terminal:logconfig:dels:empty");
      }
      me::trace("server:terminal:logconfig:file:toggle:", me::estr2(lc.file().tog()));
      me::trace("server:terminal:logconfig:file:limit:", lc.file().limit());
      me::trace("server:terminal:logconfig:file:url:", 0 == lc.file().url().empty() ? "none" : lc.file().url());
      me::trace("server:terminal:logconfig:----------------------------------------", me::estr2(lc.tog));

      if(mes.mCodec && mes.mCodec != &mes.mNULLCodec) {

         me::trace("server:terminal:logconfig:forward:codec:", mes.mCodec->soName);

         me::state_t state;
         state.logconfig = lc;

         (mes.mCodec->ctrl(&state));

      } else {

         me::trace("server:terminal:logconfig:suspend:no codec loaded");

         mes.mPEState.logconfig = lc;
      }
   }
#endif

////////////////////////////////////////////////////////////////////////////////

static int defaultCodecFn()
{
    me::traces("server");
    return -1;
}

void MediaEngineServer::SaveContext()
{
    me::traces("server");

    FILE *fp = fopen("/tmp/MediaEngineServer.context", "w");
    if (fp) {
        fprintf(fp, "%s\n", mObservingStateMachineName);
        fclose(fp);
    }
}

void MediaEngineServer::LoadContext()
{
   me::traces("server");

   FILE *fp = fopen("/tmp/MediaEngineServer.context", "r");
   if(fp) {
      int_t const res = fscanf(fp, "%s", mObservingStateMachineName);
      me::trace("server:LoadContext:fscanf:res:", res);
      fclose(fp);
   } else {
      mObservingStateMachineName[0] = 0;
   }
}

int MediaEngineServer::GetTargetPlaybackState(tPEPlaybackState& playbackState)
{
    me::traces("server");

    int res = 0;

    /* get the target state in state machine */
    tState state;
    res = GetTargetState(OUT state);
    if (res) {
        me::trace("server:GetTargetState failed:", res);
    }

    /* map state machine state to playback state */
    if (!strcmp(state.name, "stop")) {
        playbackState = PE_PBS_STOPPEDSTATE;
    }
    else if (!strcmp(state.name, "pause")) {
        playbackState = PE_PBS_PAUSEDSTATE;
    }
    else if (!strcmp(state.name, "play")) {

        playbackState = PE_PBS_PLAYINGSTATE;
    }
    else {
        me::trace("server:GetTargetState unknown state:", state.name);
        playbackState = PE_PBS_UNKNOWN;
    }

    return res;
}

MediaEngineServer::MediaEngineServer() {

   me::traces("server");

   mPEState = me::state_t();

   mPEState.handle = HANDLE_NONE;
   mCodec = NULL;
   mComponentId = 0;
   mNULLCodec.exts   = (tFnExts *)defaultCodecFn;
   mNULLCodec.config = (tFnConfig *)defaultCodecFn;
   mNULLCodec.init   = (tFnInit *)defaultCodecFn;
   mNULLCodec.fini   = (tFnFini *)defaultCodecFn;
   mNULLCodec.ctrl   = (tFnCtrl *)defaultCodecFn;
   strncpy(mNULLCodec.soName, "noCodec", sizeof(mNULLCodec.soName));
   mNULLCodec.soHandle = NULL;
   memset(&mNotificationState, 0, sizeof(mNotificationState));
   mResendPlaybackStatus   = 0;
   mResendNowPlayingStatus = 0;
   mOutputDevice[0] = 0;


   /* restore last observer (if possible) */
   LoadContext();

    #if defined(TARGET_BUILD)

      int_t res = 0;

       // TR_TTFIS_SYSMANAGER; TR_TTFIS_IPODAUTH;
      #if defined(TR_TTFIS_MEDIAENGINE)
         me::trace("server:MediaEngine:terminal:setup:TR_TTFIS_MEDIAENGINE");
         res = me::terminal_t::inst().setup(TR_TTFIS_MEDIAENGINE, &terminal, this);
            if(0 != res) {
            me::trace("server:MediaEngine:terminal:setup:TR_TTFIS_MC_MEDIAPLAYER");
            res = me::terminal_t::inst().setup(TR_TTFIS_MC_MEDIAPLAYER, &terminal, this);
            }
       #else
         me::trace("server:MediaEngine:terminal:setup:TR_TTFIS_MC_MEDIAPLAYER");
         res = me::terminal_t::inst().setup(TR_TTFIS_MC_MEDIAPLAYER, &terminal, this);
      #endif

      if(0 != res) {

         me::trace("server:MediaEngine:terminal:setup:failed:", res);
      }

   #endif
}

MediaEngineServer::~MediaEngineServer() {

   me::traces("server");
}

int MediaEngineServer::Init()
{
    me::traces("server");
    /*gst_init is void and success/failure can be decided based on is_initialized which is done in individual codecs.*/
    if(false == gst_is_initialized())
    {
       int_t mRetryCount = 0;
       const int_t maxRetryCount = 3;
       /*retry for gst_init() on initialization failure for max of 3 times including one previously, then go for reset on failure even after 3 retrails */
       do
       {
           gst_init(0,0);
           ++mRetryCount; //2
           if(false == gst_is_initialized())
           {
              trace("mediaengineserver:init:gst_initialization failure !! retry count : ",mRetryCount);
              if(maxRetryCount == mRetryCount)
              {
                  trace("mediaengineserver:init:gst_initialization failure after 2 retrails and system going for reboot");
                  asrt(false);
              }
           }
           else
           {
              trace("mediaengineserver:init:gst_initialization Successful");
              mRetryCount = 0;
              break;
           }
       }while(mRetryCount< maxRetryCount);
    }
    /* Init the state machine */
    MediaEngineSM::Init();

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);

    return 0;
}

int MediaEngineServer::InitSM()
{
   me::traces("server");

   /* scan directory for files with prefix: "libmenginecodec" */
   DIR *dir = 0;
   string_t searchDirectory;

   #ifdef TARGET_BUILD

      #if defined(MENGINE_CODEC_PATH)

         searchDirectory = (char *)M1_EXPAND_AND_QUOTE(MENGINE_CODEC_PATH);

      #else
         me::trace("server:InitSM:err:missing codec path");

         //searchDirectory = (char *)getenv("GMP_LIBS");
         //searchDirectory = (char *)getenv("MEDIAENGINE_PATH");  // /opt/bosch/mediaplayer/bin;
      #endif
   #else

      #if defined(MENGINE_CODEC_PATH)

         searchDirectory = (char *)M1_EXPAND_AND_QUOTE(MENGINE_CODEC_PATH);

      #else

         searchDirectory = "./MediaEngine/4_codecs";

         //searchDirectory = (char *)".";
      #endif

   #endif

   me::trace("server:InitSM:searchDirectory:", searchDirectory);

   dir = opendir(searchDirectory.at());
   if(!dir) {
      me::trace("server:InitSM:could not open directory:err:", err_str());
      return -1;
   }

   /* read out all entries in the directory */
   while(1) {

      /* read one me::trace("server"); */
      struct dirent *directory;
      directory = readdir(dir);
      if(!directory) {
         me::trace("server:InitSM:searchDirectory:done");
         break; // end of directory
      }

      /* is the name matching? */
      me::trace("server:InitSM:readdir:", directory->d_name);
        if ((strstr(directory->d_name, "libmenginecodec")) &&
           (!strstr(directory->d_name, "libmenginecodec_rip"))) {

         me::trace("server:InitSM:found codec:", directory->d_name);

         tCodecStorage codec;
         codec.closed = 0;

         /* create a working path */
         strncpy(codec.soName, searchDirectory.at(), 256);
         strcat(codec.soName, "/");
         strcat(codec.soName, directory->d_name);
         // sim4hi 180629: placed null character at the very end of soName as fix for Coverity CID-148172
         codec.soName[255]=0;

         me::trace("server:InitSM: dlopen:", codec.soName);

         /* open the shared object */
         codec.soHandle = dlopen(codec.soName, RTLD_LAZY);
         if(!codec.soHandle) {
            me::trace("server:InitSM:dlopen:", codec.soName, " err:", dlerror());
            continue;
         }

         /*lint -save -e611 */

         /* get symbol references */
         codec.exts = (tFnExts *)dlsym(codec.soHandle, "exts");
         if(!codec.exts) {
            me::trace("server:InitSM:codec:", codec.soName, " exts() not defined");
            continue;
         }
         codec.config = (tFnConfig *)dlsym(codec.soHandle, "config");
         if(!codec.config) {
            me::trace("server:InitSM:codec:", codec.soName, " config() not defined");
            continue;
         }
         codec.init = (tFnInit *)dlsym(codec.soHandle, "init");
         if(!codec.init) {
            me::trace("server:InitSM:codec:", codec.soName, " init() not defined");
            continue;
         }
         codec.fini = (tFnFini *)dlsym(codec.soHandle, "fini");
         if(!codec.fini) {
            me::trace("server:InitSM:codec:", codec.soName, " fini() not defined");
            continue;
         }
         codec.ctrl = (tFnCtrl *)dlsym(codec.soHandle, "ctrl");
         if(!codec.ctrl) {
            me::trace("server:InitSM:codec:", codec.soName, " ctrl() not defined");
            continue;
         }

         /*lint –restore */

         /* get the supported extensions from the codec */
         char extensions[512];
         int res;
         res = (codec.exts)(OUT extensions, IN (int_t)sizeof(extensions));
         if(res) {
            me::trace("server:InitSM:codec:", codec.soName, " error in extensions query");
            continue;
         }

         me::trace("server:InitSM:codec for extensions:", extensions);

         /* add codec to the codec map */
         char *cptr = extensions;
         char *ext = extensions;
         int notEnd = 0;
         while(1) {
            switch(*cptr) {
               case ';': // extensions are delimited with ;
               case ',': // extensions are delimited with ;
                  *cptr = 0;
                  notEnd = 1;

                  // fall thru...

               case 0: // end of string

                  /* add codec object to codec map */
                  mCodecs[(string)ext] = codec;

                  /* if null codec, save this pointer */
                  if (!strcmp(ext, "null")) {
                     mNULLCodec = codec;
                  }

                  /* set start for next extension string */
                  cptr++;
                  ext = cptr;
                  break;

               default: // next character (no end of string and no delimiter)
                  cptr++;
                  notEnd = 1;
            }

            /* end of string? */
            if(notEnd == 0) {
               break;
            }

            /* search continues */
            notEnd = 0;
         }

         me::trace("server:InitSM:codec loaded:", codec.soName);
      }
   }

   /* close the directory */
   closedir(dir);

   /* set the NULL codec as current cudec */
   mCodec = &mNULLCodec;
   return 0;
}

void MediaEngineServer::Create()
{
    me::traces("server");
    MediaEngineSM::Create();
}

void MediaEngineServer::Do(int functionID, void *ptr)
{
    me::traces("server");
    (void)ptr;
    (void)functionID;

#if 0
    // close inherited handles from forked parent process
    #if defined (TARGET_BUILD)
        dir_t procdir(string_t("/proc/") << curpid() << "/fd/");
        strings_t handles;
        int_t const num = procdir.list(handles);
        for(int_t i = 0; i < num; ++i) {
           int_t const inode = string_t(handles[i].from(handles[i].find_b('/') + 1)).atoi();
           me::trace(me::warn, "me:server:Do:", i, ":", handles[i], " inode:", inode);
           if(3 < inode) close(inode);
        }
    #endif
#endif

    ThreadFactory::SetName(string_t("me_sm_srv").at());
    while((MediaEngineSM::STATE_MACHINE_FINISHED != MediaEngineSM::StateMachine_Main())){}
}

int MediaEngineServer::StopEventProcessed()
{
   me::traces("server");
   int res;

   /* call fini for current codec */
   if (mCodec) {
      res = (mCodec->fini)();
      if (res) {
         me::trace("server:codec:", mCodec->str(), " fini() failed:", res);
      }
   } else {
      me::trace("server:no codec defined");
   }

   /* send back desired answer */
   tAllParameters parameter;
   Marshal((char *)parameter, sizeof(parameter)-1, "i", mComponentId);
   Dispatcher::GetInstance().SendMessage("LocalSPMStopSM::STOP_READY", parameter);

   /* no errors */
   return 0;
}

int MediaEngineServer::DoneEventProcessed()
{
   me::traces("server");

   /* close all loaded shared objects / codecs */
   for(tCodecsMapIt it=mCodecs.begin(); it != mCodecs.end(); ++it) {

      /* is codec already closed? */
      if (it->second.closed) continue;

      me::trace("server:dlclose:", it->second.soName);

      /* close the codec shared object */
      dlclose(it->second.soHandle);

      /* mark all entries for that codec as done */
      for(tCodecsMapIt it2=mCodecs.begin(); it2 != mCodecs.end(); ++it2) {
         if (it2->second.soHandle == it->second.soHandle) {
            it2->second.closed = 1;
         }
      }
   }

   /* erase the complete codec map */
   mCodecs.clear();

   /* de-register state machine from dispatcher */
   Dispatcher::GetInstance().DeRegister(IN this);

   /* no errors */
   return 0;
}

int MediaEngineServer::Configure(const tConfigString ConfigString)
{
   me::traces("server");

   tGeneralString MediaEngineProcessPriority;
   tGeneralString MediaEngineProcessNiceness;
   tGeneralString V4LInput;
   int            MediaEngineProcessUseFork = 0;
   int            CDRippingSupported = 0;
   int_t          sourceswitchramp = 0 ;
   int_t          VideoSupport = 0;
   int_t          VideoPropertyControl = 0;
   string sparameters;

   mPEState.ramp().steps().resize(16);
   //int_t stepssize;
   mPEState.display().screens().resize(8);
   int_t screenssize;

   /* unmarshal the config values */
   UnMarshal(IN ConfigString, DOUBLE_MARSHAL_SEPARATOR,
     "i\
      llllllll\
      llllllll\
      llllllll\
      llllllll\
      l\
      llllllll\
      llllllll\
      llllllll\
      llllllll\
      l\
      tt\
      ll\
      lllllltlll",
      &mComponentId,
      //&stepssize,
      &mPEState.ramp().steps() [0].lvl(), &mPEState.ramp().steps() [0].dur().ms(), &mPEState.ramp().steps() [1].lvl(), &mPEState.ramp().steps() [1].dur().ms(),
      &mPEState.ramp().steps() [2].lvl(), &mPEState.ramp().steps() [2].dur().ms(), &mPEState.ramp().steps() [3].lvl(), &mPEState.ramp().steps() [3].dur().ms(),
      &mPEState.ramp().steps() [4].lvl(), &mPEState.ramp().steps() [4].dur().ms(), &mPEState.ramp().steps() [5].lvl(), &mPEState.ramp().steps() [5].dur().ms(),
      &mPEState.ramp().steps() [6].lvl(), &mPEState.ramp().steps() [6].dur().ms(), &mPEState.ramp().steps() [7].lvl(), &mPEState.ramp().steps() [7].dur().ms(),
      &mPEState.ramp().steps() [8].lvl(), &mPEState.ramp().steps() [8].dur().ms(), &mPEState.ramp().steps() [9].lvl(), &mPEState.ramp().steps() [9].dur().ms(),
      &mPEState.ramp().steps()[10].lvl(), &mPEState.ramp().steps()[10].dur().ms(), &mPEState.ramp().steps()[11].lvl(), &mPEState.ramp().steps()[11].dur().ms(),
      &mPEState.ramp().steps()[12].lvl(), &mPEState.ramp().steps()[12].dur().ms(), &mPEState.ramp().steps()[13].lvl(), &mPEState.ramp().steps()[13].dur().ms(),
      &mPEState.ramp().steps()[14].lvl(), &mPEState.ramp().steps()[14].dur().ms(), &mPEState.ramp().steps()[15].lvl(), &mPEState.ramp().steps()[15].dur().ms(),
      &screenssize,
      &mPEState.display().screens()[0].rsl().width(), &mPEState.display().screens()[0].rsl().height(), &mPEState.display().screens()[0].layer(), &mPEState.display().screens()[0].srf(),
      &mPEState.display().screens()[1].rsl().width(), &mPEState.display().screens()[1].rsl().height(), &mPEState.display().screens()[1].layer(), &mPEState.display().screens()[1].srf(),
      &mPEState.display().screens()[2].rsl().width(), &mPEState.display().screens()[2].rsl().height(), &mPEState.display().screens()[2].layer(), &mPEState.display().screens()[2].srf(),
      &mPEState.display().screens()[3].rsl().width(), &mPEState.display().screens()[3].rsl().height(), &mPEState.display().screens()[3].layer(), &mPEState.display().screens()[3].srf(),
      &mPEState.display().screens()[4].rsl().width(), &mPEState.display().screens()[4].rsl().height(), &mPEState.display().screens()[4].layer(), &mPEState.display().screens()[4].srf(),
      &mPEState.display().screens()[5].rsl().width(), &mPEState.display().screens()[5].rsl().height(), &mPEState.display().screens()[5].layer(), &mPEState.display().screens()[5].srf(),
      &mPEState.display().screens()[6].rsl().width(), &mPEState.display().screens()[6].rsl().height(), &mPEState.display().screens()[6].layer(), &mPEState.display().screens()[6].srf(),
      &mPEState.display().screens()[7].rsl().width(), &mPEState.display().screens()[7].rsl().height(), &mPEState.display().screens()[7].layer(), &mPEState.display().screens()[7].srf(),
      &mPEState.local(),
      MediaEngineProcessPriority,
      MediaEngineProcessNiceness,
      &MediaEngineProcessUseFork,
      &CDRippingSupported,
      &mPEState.v4lprop().capturewidth(),&mPEState.v4lprop().captureheight(),&mPEState.v4lprop().fpsnumerator(),&mPEState.v4lprop().fpsdenominator(),&mPEState.v4lprop().motion(),&mPEState.v4lprop().pixformat(),V4LInput, &sourceswitchramp,&VideoSupport, &VideoPropertyControl);


   ////TODO: this is temporary; as soon as (Un)Marshal functions
   ////      support nif_t serialisation only significant vector
   ////      entries will be transfered;
   me::trace("server:Configure:ramp0:", mPEState.ramp().str());

   // remove emtpy step_t entries from vector;
   while(mPEState.ramp().steps().z->empty()) {
      mPEState.ramp().steps().remove(mPEState.ramp().steps().z);
   }

   me::trace("server:Configure:ramp1:", mPEState.ramp().str());

   //mPEState.ramp().steps().resize(stepssize);
   //mPEState.ramp().num() = stepssize;
   //mPEState.display().screens().resize(screenssize);
   mPEState.display().num = screenssize;

   for(int_t i = 0; i < mPEState.display().screens().size(); ++i) {

      me::trace("server:Configure:screen:", i, ":", mPEState.display().screens()[i].str());
   }

   // configure process priority, niceness and scheduling policy;

   string_t const prio = string_t(MediaEngineProcessPriority);
   string_t const nice = string_t(MediaEngineProcessNiceness);

   me::trace("server:Configure:MediaEngineProcessPriority:", prio);
   me::trace("server:Configure:MediaEngineProcessNiceness:", nice);

   me::trace("server:Configure:MediaEngineLocalRoot:", mPEState.local());
   me::trace("server:Configure:MediaEngineUseFork:",   MediaEngineProcessUseFork);
   me::trace("server:Configure:CDRippingSupported:",   CDRippingSupported);

   mPEState.v4lprop().v4linput = string_t(V4LInput);
   me::trace("server:Configure:v4linput prop:", mPEState.v4lprop().str());

   mPEState.sourceswitchramp = sourceswitchramp;
   mPEState.videosupport = VideoSupport; // Used to check whether the video support is enabled for partivular variant or not
   mPEState.videopropertycontrol = VideoPropertyControl;
   // set priority, niceness and scheduling policy of this process;

   #ifdef TARGET_BUILD
       // gen3armmake, gen3x86make (LSIM)

      string_t const username = curuname();
      me::trace("server:Configure:username:", username);
      if(username == string_t("aid_mediaplayer")) {

         mPEState.local() = false;
      }

      me::trace("server:Configure:local:", mPEState.local());
      sparameters = to_string(curpid());

      CmdData result;
      if(MediaEngineProcessUseFork)
      {
          result = execRootCommand(MEDIAENGINE_CLIENT_NAME,rpcs_chrt,sparameters.c_str());
          me::trace("server:Configure:chrt:",result.errorNo," pid:",sparameters.c_str()," message:",result.message);
      }

      result = execRootCommand(MEDIAENGINE_CLIENT_NAME,rpcs_renice,sparameters.c_str());
      me::trace("server:Configure:renice:",result.errorNo," pid:",sparameters.c_str()," message:",result.message);

   #else //TARGET_BUILD
       // linuxx86make;
       string command_str;
       command_str = string("chrt -r -p ") + string(MediaEngineProcessPriority) + string(" ") + to_string(curpid());
       system(command_str.c_str());

       command_str = string("renice ") + string(MediaEngineProcessNiceness) + string(" -p ") + to_string(curpid());
       system(command_str.c_str());
       //Use direct system calls instead of below implementation
/*
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
      sparameters = string(MediaEngineProcessPriority) + string(" ") + to_string(curpid());
      execRootCommand(MEDIAENGINE_CLIENT_NAME,rpcs_chrt,sparameters.c_str());
      sparameters = string(MediaEngineProcessNiceness) + string(" -p ") + to_string(curpid());
      execRootCommand(MEDIAENGINE_CLIENT_NAME,rpcs_renice,sparameters.c_str());
#else
      rdc.run(me::rpcs_chrt,   string_t(curpid(), ":", prio), 1);
      rdc.run(me::rpcs_renice, string_t(curpid(), ":", nice), 1);
#endif // VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
*/
   #endif //TARGET_BUILD


    if(1 == CDRippingSupported) {

        /* create state machine */
        MediaEngineripper.Create();

        /* init state machine */
        MediaEngineripper.Init();

        ThreadFactory.Do(&MediaEngineripper, 0, NULL);
    }

   /* send back the desired answer and its own PID for the supervision */
   AnswerSetConfig();

   /* no errors */
   return 0;
}

int MediaEngineServer::AnswerSetConfig()
{
   me::traces("server");

   /* send back the desired answer and its own PID for the supervision */
   tAllParameters param;
   snprintf(param, sizeof(param), "%d", getpid());
   SendAnswer(param);

   /* no errors */
   return 0;
}

int MediaEngineServer::AnswerPing()
{
   me::traces("server");

   /* send back the desired answer */
   SendAnswer("0");

   /* no errors */
   return 0;
}

int MediaEngineServer::Setup(const tPEStateString PEStateString)
{
   me::traces("server");
   int res;

   // get extension from url;
   byte_t url0[1024];
   SMF::UnMarshal(IN PEStateString, DOUBLE_MARSHAL_SEPARATOR, "t", (unsigned char*)url0);

   string_t url = url0;

   me::trace("server:Setup:url:", url);

   string_t ext = url.ext();
   if(ext.empty()) {
      ext = "null";
   }
   ext.lower();

   // search codec;
   tCodecStorage *codec0 = mCodec;
   tCodecsMapIt it = mCodecs.find(ext.at());
   if(it != mCodecs.end()) {
      mCodec = &(it->second);
   } else {
      me::trace("server:Setup:codec not found");
   }

   //same codec ? do nothing;
   if(codec0 == mCodec) {
      me::trace("server:Setup:same codec");
      return 1;
   }

   /* configure the codec */
   res = (mCodec->config)(IN mCodec->soName, IN NULL, IN &Callback, IN this, IN mPEState.local());
   if(res) {
      me::trace("server:Setup:codec:", mCodec->str(), " config() failed:", res);
      return 0; // setup not ok
   }

   /* init the codec */
   res = (mCodec->init());
   if (res) {
      me::trace("server:Setup:mCodec->soNameinit() failed:", res);
      mPEState.reason = (me::reason_e)res;
      return 0; // setup not ok
   }

   me::trace("server:Setup:ramp:", mPEState.ramp().str());

   /* send the ramp data */
   mPEState.playstate = me::PLAYSTATE_STOP;
   res = (mCodec->ctrl(&mPEState));
   if (res) {
      me::trace("server:Setup:codec:", mCodec->str(), " ctrl(PLAYSTATE_NOP) for ramp data failed:", res);
   }

   return 1; // setup ok
}

int MediaEngineServer::SetupOk(const tPEStateString PEStateString)
{
    me::traces("server");
    int res;

    /* send myself a PLAY to continue in state machien */
    res = SendEvent(PLAY, PEStateString);
    if (res) {
        me::trace("server:SetupOk:SendMessage failed:", res);
        return 1; // setup not ok
    }

    return 0;
}

int MediaEngineServer::ActionFailed(const tPEStateString PEStateString)
{
    me::traces("server");
    int res;

    /* get the target playback state */
    tPEPlaybackState playbackState = PE_PBS_UNKNOWN;
    res = GetTargetPlaybackState(OUT playbackState);
    if (res) {
        me::trace("server:ActionFailed:GetTargetPlaybackState failed:", res);
    }

    me::reason_e reason = me::REASON_ACTION_ERROR;

    tURL url;
    int speed;
    int position;
    tU64 handle;
    UnMarshal((char *)PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiil", url, &speed, &position, &handle);

    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "lill",
            handle,
            (int)playbackState,
            reason,
            speed);

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:ActionFailed:SendAnswer failed:", res);
    }

    return 0;
}

int MediaEngineServer::Play(const tPEStateString PEStateString)
{
    me::traces("server");
    int res;

    /* send play command */
    me::state_t PEState;

    tURL url;
    int speed;
    int position;
    tU64 handle;
    tAudioOutputDevice dev;
    tU64 samplerate;

   tU32        brightness;
   tS32              hue;
   tU32        saturation;
   tU32          contrast;
   tS32 brightnessoffset;
   tS32 saturationoffset;
   tU32         hueoffset;

   speedstate_e speedstate = ME_SPEEDSTATE_OFF;

        UnMarshal((char *)PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", url, &speed, &position,
           &handle, dev, &samplerate, &brightness, &hue, &saturation, &contrast, &brightnessoffset,
           &saturationoffset, &hueoffset, &speedstate);

        PEState.vprops().brightness       = brightness;
        PEState.vprops().hue              = hue;
        PEState.vprops().saturation       = saturation;
        PEState.vprops().contrast         = contrast;
        PEState.vprops().brightnessoffset = brightnessoffset;
        PEState.vprops().saturationoffset = saturationoffset;
        PEState.vprops().hueoffset        = hueoffset;

    if(speedstate && (1 == speed || -1 == speed ))
    {
        PEState.speed = (speed_e)(speed * 100);
    }
    PEState.speed = speed;
    PEState.speedstate = speedstate;
    PEState.speed = (me::speed_e)speed;
    PEState.pos().ms = position;
    PEState.handle = handle;
    PEState.url() = url;
    PEState.dev() = dev;
    PEState.fmt().samplerate = samplerate;

    PEState.sourceswitchramp = mPEState.sourceswitchramp;
    PEState.videosupport = mPEState.videosupport;
    PEState.videopropertycontrol = mPEState.videopropertycontrol;
    PEState.playstate = me::PLAYSTATE_PLAY;
    res = (mCodec->ctrl(&PEState));
    if (res) {
        me::trace("server:Play:codec:", mCodec->str(), " ctrl(PLAYSTATE_PLAY) failed:", res);
        mPEState.reason = PEState.reason;
        return 0; // control failed
    }

    /* force sending a new playback status and now playing status */
    mResendPlaybackStatus   = 1;
    mResendNowPlayingStatus = 1;

    return 1; // control worked
}

int MediaEngineServer::FatalError(const tPEStateString PEStateString)
{
    me::traces("server");
    (void)PEStateString;
    int res;

    /* discard the current codec */
    res = (mCodec->fini)();
    if (res) {
        me::trace("server:FatalError:codec:", mCodec->str(), " fini() failed:", res);
    }

    /* set NULL codec as current one */
    mCodec = &mNULLCodec;

    /* get the target playback state */
    tPEPlaybackState playbackState = PE_PBS_UNKNOWN;
    res = GetTargetPlaybackState(OUT playbackState);
    if (res) {
        me::trace("server:FatalError:GetTargetPlaybackState failed:", res);
    }

    tURL url;
    int speed;
    int position;
    tU64 handle;
    speedstate_e speedstate;
    UnMarshal((char *)PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiill", url, &speed, &position, &handle, &speedstate);

    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "lilll",
            handle,
            (int)playbackState,
            (tS64)me::REASON_ERROR,
            speed,
            speedstate);

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:FatalError:SendAnswer failed:", res);
    }
    return 0;
}

int MediaEngineServer::ActionOk(const tPEStateString PEStateString)
{
    me::traces("server");
    (void)PEStateString;
    int res;

    /* get the target playback state */
    tPEPlaybackState playbackState = PE_PBS_UNKNOWN;
    res = GetTargetPlaybackState(OUT playbackState);
    if (res) {
        me::trace("server:ActionOk:GetTargetPlaybackState failed:", res);
    }

    tURL url;
    int speed;
    int position;
    tU64 handle;
    speedstate_e speedstate;
    UnMarshal((char *)PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiill",
       url, &speed, &position, &handle, &speedstate);

    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "lilll",
            handle,
            (int)playbackState,
            (tS64)REASON_OK,
            (tS64)speed,
            (tU8)speedstate);

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:ActionOk:SendAnswer failed:", res);
    }

    return 0;
}

void_t MediaEngineServer::Callback(IN me::state_t const& state, IN void *context)
{
    me::traces("server");

    MediaEngineServer *mediaEngine = (MediaEngineServer *)context;

    tPEStateString args;
    Marshal(args, sizeof(args)-1, DOUBLE_MARSHAL_SEPARATOR, "lltlllllltll",
            state.playstate(), state.reason(),
            state.url().at(),
            state.handle(),
            state.pos().bytes(), state.pos().pct(), state.pos().ms(),
            state.dur().bytes(), state.dur().ms(),
            state.dev().at(),
            state.speed(),
            state.speedstate());

    /* send event to my state machine to initiate the ForwardPlaybackStatus */
    int_t const res = mediaEngine->SendEventByName("PLAYBACK_STATUS", args);
    //res = MediaEngineServer::inst().SendEventByName("PLAYBACK_STATUS", args);
    if(res) {
       me::trace("server:Callback:SendEvent failed:", res);
    }
}

int MediaEngineServer::SeekTo(const tPEStateString PEStateString)
{
    me::traces("server");
    int res;

    /* send nop command but with a new position*/
    me::state_t PEState = me::state_t();

    tURL url;
    int speed;
    int position;
    tS64 handle;
    UnMarshal(PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiil", url, &speed, &position, &handle);
    PEState.speed = (me::speed_e)speed;
    PEState.pos().ms = position;
    PEState.handle = handle;
    PEState.url() = url;

    PEState.sourceswitchramp = mPEState.sourceswitchramp;
    PEState.videosupport = mPEState.videosupport;
    PEState.videopropertycontrol = mPEState.videopropertycontrol;
    PEState.playstate = me::PLAYSTATE_PLAY;
    res = (mCodec->ctrl(&PEState));
    if (res) {
        me::trace("server:SeekTo:codec:", mCodec->str(), " ctrl(PLAYSTATE_PLAY) failed:", res);
        mPEState.reason = PEState.reason;
        return 0; // control failed
    }

    tPETimeInfo timeInfoString;
    SMF::Marshal(OUT timeInfoString, IN sizeof(timeInfoString)-1, IN DOUBLE_MARSHAL_SEPARATOR, "lllll",
            IN mPEState.pos().bytes(),
            IN mPEState.pos().pct(),
            IN mPEState.pos().ms(),
            IN mPEState.dur().bytes(),
            IN mPEState.dur().ms());

    me::trace("server:SeekTo:timeInfoString:", timeInfoString);

    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "lt", handle, IN timeInfoString);

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:SeekTo:SendAnswer failed:", res);
    }
    return 0;
}

int MediaEngineServer::PlayToStop(const tPEStateString PEStateString)
{
    me::traces("server");
    int res;

    /* send stop command */
    me::state_t PEState = me::state_t();
    PEState.videosupport = mPEState.videosupport;
    PEState.videopropertycontrol = mPEState.videopropertycontrol;
    PEState.playstate = me::PLAYSTATE_STOP;
    res = (mCodec->ctrl(&PEState));
    if (res) {
        me::trace("server:PlayToStop:codec:", mCodec->str(), " ctrl(PLAYSTATE_STOP) failed:", res);
        mPEState.reason = PEState.reason;
    }

    /* send the STOP event to myself to advance the current state to stop */
    res = SendEvent(STOP, PEStateString);
    if (res) {
        me::trace("server:PlayToStop:SendEvent(STOP) failed:", res);
    }
    return 0;
}

int MediaEngineServer::Stop(const tPEStateString PEStateString)
{
    me::traces("server");
    (void)PEStateString;
    int res;

    /* discard the current codec */
    res = (mCodec->fini)();
    if (res) {
        me::trace("server:Stop:codec:", mCodec->str(), " fini() failed:", res);
        mPEState.reason = (me::reason_e)res;
    }

    /* set NULL codec as current one */
    mCodec = &mNULLCodec;

    /* get the target playback state */
    tPEPlaybackState playbackState = PE_PBS_UNKNOWN;
    res = GetTargetPlaybackState(OUT playbackState);
    if (res) {
        me::trace("server:Stop:GetTargetPlaybackState failed:", res);
    }

    tURL url;
    int speed;
    int position;
    tS64 handle;
    UnMarshal(PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiil", url, &speed, &position, &handle);

    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "lill",
            handle,
            (int)playbackState,
            (tS64)me::REASON_OK,
            speed);

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:Stop:SendAnswer failed:", res);
    }
    return 0;
}

int MediaEngineServer::Pause(const tPEStateString PEStateString)
{
    me::trace("server");
    int res;

    /* send pause command */
    me::state_t PEState = me::state_t();
    PEState.videosupport = mPEState.videosupport;
    PEState.videopropertycontrol = mPEState.videopropertycontrol;
    PEState.playstate = me::PLAYSTATE_PAUSE;
    res = (mCodec->ctrl(&PEState));
    if (res) {
        me::trace("server:Pause:codec:", mCodec->str(), " ctrl(PLAYSTATE_PAUSE) failed:", res);
        mPEState.reason = PEState.reason;
    }
    return 1; // no error
}

int MediaEngineServer::RePlay(const tPEStateString PEStateString)
{
    me::traces("server");
    int res;

    /* send play command */
    me::state_t PEState = me::state_t();

    /* in the case the media engine was restarted and the current state is play,
     * the current codec is set to null codec.
     * try to set the correct one for the new file */
    me::trace("server:RePlay:codec:", mCodec->str());

    if(mCodec->soHandle == mNULLCodec.soHandle) {
       Setup(PEStateString);
    }

    /* do the replay */
    tURL url;
    int speed;
    int position;
    tU64 handle;
    tAudioOutputDevice dev;
    tU64 samplerate;
    speedstate_e speedstate;
    vprops_t vprops;

    UnMarshal((char *)PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", url, &speed, &position,
        &handle, dev, &samplerate, &vprops.brightness(),&vprops.hue(), &vprops.saturation(),
        &vprops.contrast(), &vprops.brightnessoffset(),&vprops.saturationoffset(), &vprops.hueoffset(), &speedstate);

    PEState.vprops = vprops;
    PEState.speed = (me::speed_e)speed;
    PEState.pos().ms = position;
    PEState.handle() = handle;
    PEState.url() = url;
    PEState.dev() = dev;
    PEState.fmt().samplerate = samplerate;
    PEState.speedstate() = speedstate;

    PEState.sourceswitchramp = mPEState.sourceswitchramp;
    PEState.videosupport = mPEState.videosupport;
    PEState.videopropertycontrol = mPEState.videopropertycontrol;
    PEState.playstate = me::PLAYSTATE_PLAY;
    res = (mCodec->ctrl(&PEState));
    if (res) {
        me::trace("server:RePlay:codec:", mCodec->str(), " ctrl(PLAYSTATE_PLAY) failed:", res);
        mPEState.reason = PEState.reason;
        return 0; // control failed
    }

    /* force sending a new playback status and now playing status */
    mResendPlaybackStatus   = 1;
    mResendNowPlayingStatus = 1;

    /* go back to play state */
    return 1;
}

int MediaEngineServer::PlayToPause(const tPEStateString PEStateString)
{
    me::traces("server");
    int res;

    /* send stop command; codec if finalized implicitly */
    me::state_t PEState = me::state_t();
    PEState.playstate = me::PLAYSTATE_STOP;
    PEState.videosupport = mPEState.videosupport;
    PEState.videopropertycontrol = mPEState.videopropertycontrol;
    res = (mCodec->ctrl(&PEState));
    if (res) {
        me::trace("server:PlayToPause:codec:", mCodec->str(), " ctrl(PLAYSTATE_STOP) failed:", res);
    }

    /* start playing of next song */
    res = SendEvent(PLAY, PEStateString);
    if (res) {
        me::trace("server:PlayToPause:SendEventAnswerByName failed:", res);
    }
    return 0;
}

int MediaEngineServer::ReStop(const tPEStateString PEStateString)
{
    me::traces("server");
    (void)PEStateString;
    int res;

    /* get the target playback state */
    tPEPlaybackState playbackState = PE_PBS_UNKNOWN;
    res = GetTargetPlaybackState(OUT playbackState);
    if (res) {
        me::trace("server:ReStop:GetTargetPlaybackState failed:", res);
    }

    tURL url;
    int speed;
    int position;
    tU64 handle;
    UnMarshal(PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiil", url, &speed, &position, &handle);

    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "lill",
            handle,
            (int)playbackState,
            (tS64)me::REASON_OK,
            mPEState.speed());

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:ReStop:SendAnswer failed:", res);
    }
    return 0;
}

int MediaEngineServer::RePause(const tPEStateString PEStateString)
{
    me::traces("server");
    (void)PEStateString;
    int res;

    /* get the target playback state */
    tPEPlaybackState playbackState = PE_PBS_UNKNOWN;

    res = Pause(PEStateString);
    if(!res)
    {
       me::trace("server:RePause:pause failed:", res);
    }
    res = GetTargetPlaybackState(OUT playbackState);
    if (res) {
        me::trace("server:RePause:GetTargetPlaybackState failed:", res);
    }

    tURL url;
    int speed;
    int position;
    tU64 handle;
    UnMarshal(PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiil", url, &speed, &position, &handle);

    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "lill",
            handle,
            (int)playbackState,
            (tS64)me::REASON_OK,
            speed);

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:RePause:SendAnswer failed:", res);
    }
    return 0;
}

int MediaEngineServer::Buffer(const tPEStateString PEStateString)
{
    me::traces("server");
    int res;
    me::state_t PEState = me::state_t();

    PEState.url() = PEStateString;

    /* send buffer command */
    PEState.playstate = me::PLAYSTATE_PLAY;
    PEState.reason = me::REASON_BUFFER;
    res = (mCodec->ctrl(&PEState));
    if (res) {
        me::trace("server:Buffer:codec:", mCodec->str(), " ctrl(PLAYSTATE_PLAY) failed:", res);
        mPEState.reason = PEState.reason;
    }

    tSuccess success = SC_YES;
    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "i", (int)success);

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:Buffer:SendAnswer failed:", res);
    }
    return 0;
}

int MediaEngineServer::BufferFailed(const tPEStateString PEStateString)
{
    me::traces("server");
    int res;

    /* get the target playback state */
    tPEPlaybackState playbackState = PE_PBS_UNKNOWN;
    res = GetTargetPlaybackState(OUT playbackState);
    if (res) {
        me::trace("server:BufferFailed:GetTargetPlaybackState failed:", res);
    }

    tSuccess success = SC_NO;
    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "i", (int)success);

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:BufferFailed:SendAnswer failed:", res);
    }
    return 0;
}

int MediaEngineServer::SetFlush(const tPEStateString PEStateString)
{
    me::traces("server");
    (void)PEStateString;
    int res;
    me::state_t PEState =  me::state_t();

    /* send buffer command */
    PEState.playstate = me::PLAYSTATE_PLAY;
    PEState.reason = me::REASON_FLUSH;
    res = (mCodec->ctrl(&PEState));
    if (res) {
        me::trace("server:SetFlush:codec:", mCodec->str(), " ctrl(PLAYSTATE_PLAY) failed:", res);
    }

    /* get the target playback state */
    tPEPlaybackState playbackState = PE_PBS_UNKNOWN;
    res = GetTargetPlaybackState(OUT playbackState);
    if (res) {
        me::trace("server:SetFlush:GetTargetPlaybackState failed:", res);
    }

    tURL url;
    int speed;
    int position;
    tU64 handle;
    UnMarshal(PEStateString, DOUBLE_MARSHAL_SEPARATOR, "tiil", url, &speed, &position, &handle);

    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "lill",
            handle,
            (int)playbackState,
            (tS64)me::REASON_OK,
            mPEState.speed());

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:SetFlush:SendAnswer failed:", res);
    }
    return 0;
}

int MediaEngineServer::ForwardPlaybackStatus(const tPEStateString PEStateString)
{
   {{

   me::traces("server");

   /* no observer registered -> do not send status updates */
   if(mObservingStateMachineName[0] == 0) {
      me::trace("server:ForwardPlaybackStatus:no observer");
      return 0;
   }

   me::state_t &state0 = mNotificationState;
   me::state_t  state1;

   tGeneralString url, dev;

   UnMarshal(PEStateString, DOUBLE_MARSHAL_SEPARATOR, "lltlllllltll",
         &state1.playstate(), &state1.reason(),
         url,
         &state1.handle(),
         &state1.pos().bytes(), &state1.pos().pct(), &state1.pos().ms(),
         &state1.dur().bytes(), &state1.dur().ms(),
         dev,
         &state1.speed(),
         &state1.speedstate());

   state1.url() = url;
   state1.dev() = dev;

   me::trace("server:ForwardPlaybackStatus:state0:", state0.str());
   me::trace("server:ForwardPlaybackStatus:state1:", state1.str());

   me::trace("server:ForwardPlaybackStatus:pos_comp:", state0.pos().ms() != state1.pos().ms(), " dur_comp:", state0.dur().ms() != state1.dur().ms());

   // finish logconfig;
   if(state1.reason() == me::REASON_ACK_LOGCONFIG) {

      mPEState.logconfig = me::logconfig_t();
   }

   bool update = false;

   /* check the contents of the notification to figure out what event to send */

   // PLAYBACK_STATUS;
   if(state0.playstate != state1.playstate ||
      state0.speed     != state1.speed     ||
      state0.reason    != state1.reason    ||
      mResendPlaybackStatus) {

      me::trace("server:ForwardPlaybackStatus:PLAYBACK_STATUS");

      tPEPlaybackState playbackState;
      switch(state1.playstate()) {
         case me::PLAYSTATE_STOP:
            playbackState = PE_PBS_STOPPEDSTATE;
            break;
         case me::PLAYSTATE_PAUSE:
            playbackState = PE_PBS_PAUSEDSTATE;
            break;
        case me::PLAYSTATE_PLAY:
            if(0 > state1.speed()) {
               playbackState = PE_PBS_FASTREVERSESTATE;
            } else if(1 < state1.speed()) {
               playbackState = PE_PBS_FASTFORWARDSTATE;
            } else {
               playbackState = PE_PBS_PLAYINGSTATE;
            }
            break;
         case me::PLAYSTATE_NOP:
            playbackState = PE_PBS_LOADINGSTATE;
            break;
         default:
            playbackState = PE_PBS_ERRORSTATE;
            break;
      }

      tGeneralString messageName;
      strncpy_r(OUT messageName, IN mObservingStateMachineName, IN sizeof(messageName));
      strncat_r(OUT messageName, "::PLAYBACK_STATUS", IN sizeof(messageName));

      tAllParameters args;
      Marshal((char *)args, sizeof(args)-1, "lill",
               state1.handle(),
               (int)playbackState,
               state1.reason(),
               state1.speed());

      /* send the PLAYBACK_STATUS to observer */
      Dispatcher::GetInstance().SendMessage(messageName, args);

      /* reset the extra trigger for sending playback status */
      mResendPlaybackStatus = 0;

      update = true; // save notification state as current;
   }

   // NOW_PLAYING_STATUS;
   if(state1.playstate() == me::PLAYSTATE_PLAY &&
     (state0.url() != state1.url() || mResendNowPlayingStatus)) {

      me::trace("server::ForwardPlaybackStatus:NOW_PLAYING_STATUS");

      tGeneralString messageName;
      strncpy_r(OUT messageName, IN mObservingStateMachineName, IN sizeof(messageName));
      strncat_r(OUT messageName, "::NOW_PLAYING_STATUS", IN sizeof(messageName));

      tAllParameters args;
      Marshal((char *)args, sizeof(args)-1, "lt", state1.handle(), state1.url().at());

      /* send the NOW_PLAYING_STATUS to observer */
      Dispatcher::GetInstance().SendMessage(messageName, args);

      /* reset the extra trigger for sending now playing status */
      mResendNowPlayingStatus = 0;

      update = true; // save notification state as current;
   }

    // PLAYTIME_STATUS;
    if(state0.pos().ms() != state1.pos().ms() ||
       state0.dur().ms() != state1.dur().ms()) {

      me::trace("server:ForwardPlaybackStatus:PLAYTIME_STATUS:pos:", state0.pos().str(), " -> ", state1.pos().str());

      //#define MEDIA_ENGINE_USE_PLAYTIME_FILTER

      #if defined(MEDIA_ENGINE_USE_PLAYTIME_FILTER)
         /* reduce the event rate */
         if (llabs(state1.pos().ms()  - state0.pos().ms())  >  500 || // for every 500 ms change in current position or
             llabs(state1.pos().pct() - state0.pos().pct()) >=   2 || // for every 2 percent change in current position or
             state1.pos().ms()                              <  500 || // if the current position is near the beginning or
             llabs(state1.dur().ms() - state1.pos().ms())   <  500 || // if the current position is near the end of file or
             state0.dur != state1.dur) // for every duration changes
         {
      #endif
            tGeneralString messageName;
            strncpy_r(OUT messageName, IN mObservingStateMachineName, IN sizeof(messageName));
            strncat_r(OUT messageName, "::PLAYTIME_STATUS", IN sizeof(messageName));

            tPETimeInfo timeInfoString;
            SMF::Marshal(OUT timeInfoString, IN sizeof(timeInfoString)-1, IN DOUBLE_MARSHAL_SEPARATOR, "lllll",
               IN state1.pos().bytes(),
               IN state1.pos().pct(),
               IN state1.pos().ms(),
               IN state1.dur().bytes(),
               IN state1.dur().ms());

            //me::trace("timeInfoString=%s", timeInfoString));

            tAllParameters args;
            Marshal((char *)args, sizeof(args)-1, "lt", state1.handle(), IN timeInfoString);

            /* send the PLAYTIME_STATUS to observer */
            Dispatcher::GetInstance().SendMessage(messageName, args);

            update = true; // save notification state as current;

      #if defined(MEDIA_ENGINE_USE_PLAYTIME_FILTER)
         } else {// reduce event rate
            me::trace("server:ForwardPlaybackStatus:PLAYTIME_STATUS filtered out"));
         }
      #endif
   }

   if(update) {
      //me::trace("server:ForwardPlaybackStatus:update");
      state0 = state1;
   }

   /* TODO: ACTIVITY_STATUS? */
   /* there is no activity status in the state */

   }}
   return 0;
}

int MediaEngineServer::switchObserver(const tStateMachineName stateMachineName)
{
    me::traces("server");
    int res;

    /* remember the state machine name which will get the status updates from now on (see ForwardPlaybackStatus) */
    strncpy_r(OUT mObservingStateMachineName, IN stateMachineName, IN sizeof(mObservingStateMachineName));

    /* store current observer to temp file */
    SaveContext();

    tReturnValue returnValue = true;
    tAllParameters args;
    Marshal((char *)args, sizeof(args)-1, "i", (int)returnValue);

    /* send the answer to the caller */
    res = SendAnswer(args);
    if (res) {
        me::trace("server:switchObserver:SendAnswer failed:", res);
    }
    return 0;
}

int MediaEngineServer::SetOutputDevice(const tAudioOutputDevice outputDevice)
{
    me::traces("server");

#ifdef TARGET_BUILD
    /* remember it */
    me::trace("set mOutputDevice to %s", outputDevice);
    strncpy_r(OUT mOutputDevice, IN outputDevice, IN sizeof(mOutputDevice));
#else
    me::trace("server:SetOutputDevice:SuBuntu tests: mOutputDevice not set to %s", outputDevice);
#endif

    return 0;
}

int MediaEngineServer::SetVideoProperties(const tPEStateString PEStateString)
{
   me::traces("server");

   int res = 0;

   tU32        brightness;
   tS32              hue;
   tU32        saturation;
   tU32          contrast;
   tS32 brightnessoffset;
   tS32 saturationoffset;
   tU32         hueoffset;

   UnMarshal((char *)PEStateString, DOUBLE_MARSHAL_SEPARATOR, "iiiiiii", &brightness, &hue, &saturation, &contrast, &brightnessoffset, &saturationoffset, &hueoffset);

   me::state_t state;

   state.vprops().brightness = brightness;
   state.vprops().hue = hue;
   state.vprops().saturation = saturation;
   state.vprops().contrast = contrast;
   state.vprops().brightnessoffset = brightnessoffset;
   state.vprops().saturationoffset = saturationoffset;
   state.vprops().hueoffset = hueoffset;

   me::trace("server:SetVideoProperties:brightness:",       state.vprops().brightness());
   me::trace("server:SetVideoProperties:hue:",              state.vprops().hue());
   me::trace("server:SetVideoProperties:saturation:",       state.vprops().saturation());
   me::trace("server:SetVideoProperties:contrast:",         state.vprops().contrast());
   me::trace("server:SetVideoProperties:brightnessoffset:", state.vprops().brightnessoffset());
   me::trace("server:SetVideoProperties:saturationoffset:", state.vprops().saturationoffset());
   me::trace("server:SetVideoProperties:hueoffset:",        state.vprops().hueoffset());

   state.playstate = PLAYSTATE_SET;
   res = (mCodec->ctrl(&state));

   if(res) {
      me::trace("server:SetVideoProperties:ctrl:codec:", mCodec->soName, " res:", res, " failed");
      mPEState.reason = state.reason;
      return 0; // control failed
   }
   return 0;
}
