/* -------------------------------------------------------------------------- */
/**
 *   @defgroup metrace metrace.hpp
 *   @ingroup  MEngine
 *   @author   Stephan Pieper, 2013
 *
 *   MEngine Trace.
 */
/* -------------------------------------------------------------------------- */

#if !defined(ME_TRACE_HPP_INCLUDED)
#define ME_TRACE_HPP_INCLUDED

/* -------------------------------------------------------------------------- */

#if defined(MENGINE_ET_TRACE)

   #define OSAL_S_DISABLE_OVERLOAD_NEW
   #define ETRACE_S_IMPORT_INTERFACE_GENERIC
   #define ET_TRACE_INFO_ON
   #include "etrace_if.h"
	
	// #define TR_COMP_AUDIOPLAYER (256 * 57) // 0x3900;
   // enum TR_CLASS_MEDIAENGINE TR_COMP_AUDIOPLAYER + (1 << 8) + 1 // 0x3ff;

   #include "TraceDefinitions.h"
	
#endif

/* -------------------------------------------------------------------------- */

#include "meprotocol.hpp"

/* -------------------------------------------------------------------------- */

#if defined(MENGINE_ET_TRACE)
   extern OSAL_tIODescriptor et_gfdTrace;
#endif
	
/* -------------------------------------------------------------------------- */

namespace me {

/* -------------------------------------------------------------------------- */
// trace arbitrary number of arbitrarily typed arguments (variadic template);

// forward;
static void_t tracecall(byte_t const*, int_t const);

static void_t tracefunc(byte_t const* buf, int_t const size) {

   #if defined(MENGINE_ET_TRACE)

      static struct td_t {
         td_t() {
            et_vTraceOpen();
				tracereg(tracecall);
         }  
         ~td_t() {
            et_vTraceClose();
         }
      } td;
		
      #define MEGINE_MACRO_TRACE		

      #if defined(MEGINE_MACRO_TRACE)
		
         if(true == et_bIsTraceActive(TR_CLASS_MEDIAENGINE, 1)) { 
			
            ET_TRACE_INFO_BIN(TR_CLASS_MEDIAENGINE, \
				   ET_EN_T16 _ 0 _ \
				   ET_EN_T8  _ 0 _ \
					ET_EN_STRING _ buf _ ET_EN_DONE);
         }
			
      #else
		
         static OSAL_trIOWriteTrace tr = { TR_CLASS_MEDIAENGINE, 1, 0, 0 };

         if(0 != et_gfdTrace && -1 != et_gfdTrace) {													 
													 
            tr.pcos8Buffer = (tPCS8)buf;
            tr.u32Length   =        size;
      
            OSAL_s32IOWrite(et_gfdTrace, (tPCS8)&tr, sizeof(OSAL_trIOWriteTrace));
		   }
      #endif		

   #endif

   #if defined(MENGINE_PRINTF_TRACE)
	
      printf("%s\n", buf);
		
   #endif
}


template<typename ... Ts>
static void_t trace(Ts ... ts) {

   static int_t const pid = curpid();
   string_t s(pid, ":", heap_t::used(), ":me:", ts ...); // prepend process id;

   tracefunc(s.at(), s.size());
}

/* -------------------------------------------------------------------------- */

static void_t tracecall(byte_t const* buf, int_t const size) {
	tracefunc(buf, size);
}

/* -------------------------------------------------------------------------- */
// decorated trace;

#define traced(prefix) trace(prefix, " file:", string_t(__FILE__).name(), \
                                     " func:", __FUNCTION__,              \
			                               " l.", __LINE__)

#define tracev(prefix, ...) trace(prefix, " file:", string_t(__FILE__).name(), \
                                          " func:", __FUNCTION__,              \
                                             " l.", __LINE__,                  \
                                               " ", __VA_ARGS__)

/* -------------------------------------------------------------------------- */
// scoped trace;

struct tracer_t {
   tracer_t(string_t const prefix0, string_t const func0, int_t const line0) : 
	   prefix(prefix0), func(func0) {
      trace(prefix, ":", func, ":entry l.", line0);
   }
   ~tracer_t() {
      trace(prefix, ":", func, ":exit");
   }
   string_t prefix, func;
};

#define traces(prefix) tracer_t t(prefix, __FUNCTION__, __LINE__) 

/* -------------------------------------------------------------------------- */

} // me;

/* -------------------------------------------------------------------------- */

#endif // ME_TRACE_HPP_INCLUDED

/* -------------------------------------------------------------------------- */




