/* -------------------------------------------------------------------------- */
/**
 *   @defgroup meclientif meclientif.h
 *   @ingroup  MEngine
 *   @author   Stephan Pieper, 2016
 *
 *   MEngine client interface.
 *
 *   Clients implement this pure virtual interface.
 *
 */
/* -------------------------------------------------------------------------- */

/*lint -save -e19 */

/* -------------------------------------------------------------------------- */

#if !defined(ME_CLIENTIF_H_INCLUDED)
#define ME_CLIENTIF_H_INCLUDED

/* -------------------------------------------------------------------------- */

#include "meprotocol.hpp"
#include "metrace.hpp"

/* -------------------------------------------------------------------------- */

namespace me {

/* -------------------------------------------------------------------------- */

struct clientif_t {

   /* ----------------------------------------------------------------------- */

   virtual void_t init() = 0;
   virtual void_t fini() = 0;

   /* ----------------------------------------------------------------------- */

   virtual int_t action(state_t &state) = 0;

   /* ----------------------------------------------------------------------- */

   virtual void_t answer_state(state_t const& state) = 0;
   virtual void_t answer_codecs(codecs_t& codecs) = 0;

   /* ----------------------------------------------------------------------- */
};

/* -------------------------------------------------------------------------- */

} // me;

/* -------------------------------------------------------------------------- */

#endif // ME_CLIENTIF_H_INCLUDED

/* -------------------------------------------------------------------------- */
